/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.taskplanner;

import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.Engine;
import com.inet.report.FormulaField;
import com.inet.report.Trigger;
import com.inet.report.adhoc.AdHocServerPlugin;
import com.inet.report.adhoc.server.api.model.AdHocReport;
import com.inet.report.adhoc.server.b;
import com.inet.report.adhoc.server.taskplanner.c;
import com.inet.report.adhoc.server.taskplanner.d;
import com.inet.report.adhoc.server.theming.AdHocTheme;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.renderer.api.RendererFactory;
import com.inet.report.renderer.api.RendererFactoryManager;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.fileservice.FileServiceForTaskPlanner;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.Job;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.job.ResultContainer;
import com.inet.taskplanner.server.api.result.Result;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
extends Job {
    @Nonnull
    private String mS;
    @Nonnull
    private String mT;
    @Nullable
    private String mU;
    private Trigger mV;
    private boolean mW = true;

    public a(@Nonnull String string, @Nonnull String string2, @Nullable ConditionDefinition conditionDefinition) {
        super(conditionDefinition);
        this.mS = string;
        this.mT = string2;
        this.mU = conditionDefinition != null ? conditionDefinition.getProperty("job.adhoc.condition") : null;
    }

    protected JobResultContainer run() throws TaskExecutionException {
        ResultContainer resultContainer;
        block16: {
            FileServiceForTaskPlanner fileServiceForTaskPlanner = FileServiceForTaskPlanner.getServiceFor((String)this.mS);
            if (fileServiceForTaskPlanner == null || !SystemPermissionChecker.checkAccess((Permission)fileServiceForTaskPlanner.getRequiredPermission())) {
                throw new TaskExecutionException((Throwable)new RuntimeException(AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.path.cannotReadFile", new Object[0])));
            }
            InputStream inputStream = fileServiceForTaskPlanner.readFile(this.mS);
            try {
                if (inputStream == null) {
                    throw new TaskExecutionException((Throwable)new RuntimeException(AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.path.fileDoesNotExist", new Object[0])));
                }
                @Nonnull AdHocReport adHocReport = (AdHocReport)new Json().fromJson(inputStream, AdHocReport.class);
                String string = this.bC();
                Result result = switch (this.mT) {
                    case "AdHocHTML" -> this.a(string, adHocReport);
                    default -> this.b(string, adHocReport);
                };
                Object object = new ArrayList();
                object.add(result);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("adhoc.reportname", string);
                resultContainer = new ResultContainer((List)object, hashMap);
                if (inputStream == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new TaskExecutionException((Throwable)exception);
                }
            }
            inputStream.close();
        }
        return resultContainer;
    }

    private Result a(@Nonnull String string, @Nonnull AdHocReport adHocReport) throws Exception {
        com.inet.report.adhoc.server.api.a a2 = (com.inet.report.adhoc.server.api.a)ServerPluginManager.getInstance().getSingleInstance(com.inet.report.adhoc.server.api.a.class);
        String string2 = AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.name", new Object[0]) + " " + string;
        CompletableFuture<@Nonnull List<@Nonnull com.inet.report.adhoc.server.api.renderer.c>> completableFuture = a2.a(string2, adHocReport, 1000);
        AdHocTheme adHocTheme = com.inet.report.adhoc.server.theming.b.bI().G(adHocReport.getTheme());
        List<@Nonnull com.inet.report.adhoc.server.api.renderer.c> list = completableFuture.get();
        if ("job.adhoc.condition.emptyReport".equals(this.mU)) {
            this.mW = list.stream().filter(c2 -> !"pageheader".equals(c2.getExtensionName())).allMatch(c2 -> c2.isEmpty());
        } else if ("job.adhoc.condition.notEmptyReport".equals(this.mU)) {
            this.mW = list.stream().filter(c2 -> !"pageheader".equals(c2.getExtensionName())).anyMatch(c2 -> !c2.isEmpty());
        }
        return new d(string, adHocTheme, list);
    }

    private Result b(@Nonnull String string, @Nonnull AdHocReport adHocReport) throws Exception {
        Cache cache;
        Object object;
        Engine engine = b.a(string, adHocReport, this.mT);
        RendererFactory rendererFactory = RendererFactoryManager.getInstance().getDocumentRenderer(this.mT);
        String string2 = rendererFactory.getEngineExportFormat(this.mT);
        engine = b.a(engine, string2, string, adHocReport);
        String string3 = null;
        if ("job.adhoc.condition.emptyReport".equals(this.mU)) {
            string3 = "RecordCount = 0";
        } else if ("job.adhoc.condition.notEmptyReport".equals(this.mU)) {
            string3 = "RecordCount > 0";
        }
        if (string3 != null) {
            object = engine.getFields();
            cache = object.addFormulaField("trigger", string3, 3);
            this.mV = engine.getTrigger();
            this.mV.setFormula((FormulaField)cache);
        }
        object = GUID.generateNew().toString();
        cache = Cache.getCache();
        Objects.requireNonNull(cache);
        Properties properties = new Properties();
        properties.put("report", string);
        properties.put("export_fmt", this.mT);
        properties.put("exportreportid", object);
        ReportCacheKey reportCacheKey = cache.createKey(properties, Cache.getPropertiesChecker(), null);
        cache.addEngine(engine, reportCacheKey);
        cache.getPageCountAndWait(reportCacheKey);
        return new c(reportCacheKey, string);
    }

    @Nonnull
    private String bC() {
        String string = this.mS;
        int n2 = (string = string.replace('\\', '/')).lastIndexOf(47);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        try {
            string = URLDecoder.decode(string, StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return com.inet.report.adhoc.server.renderer.a.z(string);
    }

    protected boolean evaluateCondition(ConditionDefinition conditionDef) {
        if (this.mV != null) {
            Boolean bl = this.mV.getValue();
            return bl != null && bl != false;
        }
        return this.mW;
    }
}

