/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.renderer.chart.model;

import com.inet.annotations.JsonData;
import com.inet.report.adhoc.server.renderer.chart.j;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class DoughnutAndPieChartDataset {
    @Nonnull
    private String name;
    @Nonnull
    private String type = "pie";
    private Map<String, Object> label = Map.of("show", Boolean.FALSE);
    private Map<String, Object> labelLine = Map.of("show", Boolean.FALSE);
    private List<String> radius = new ArrayList<String>();
    private Map<String, Object> emphasis = new HashMap<String, Object>();
    private List<Object> data = new ArrayList<Object>();

    public DoughnutAndPieChartDataset(boolean doughnut, @Nonnull String name, @Nonnull @Nonnull List<@Nonnull String> labels, @Nullable Double @Nonnull [] values, @Nullable String @Nonnull [] formattedValues, @Nonnull @Nonnull List<@Nonnull Color> colors) {
        this.name = name;
        if (doughnut) {
            this.radius.add("40%");
            this.radius.add("70%");
        } else {
            this.radius.add("70%");
        }
        for (int i2 = 0; i2 < values.length; ++i2) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", labels.get(i2));
            hashMap.put("value", new Object[]{values[i2], formattedValues[i2]});
            Color color = colors.get(i2 % colors.size());
            hashMap.put("itemStyle", Map.of("color", j.a(color)));
            this.data.add(hashMap);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("shadowBlur", 10);
        hashMap.put("shadowOffsetX", 0);
        hashMap.put("shadowColor", "rgba(0, 0, 0, 0.5)");
        this.emphasis.put("itemStyle", hashMap);
    }
}

