/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.dataview;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.common.ValidationException;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.adhoc.server.api.dataview.DataViewAccessList;
import com.inet.report.adhoc.server.api.dataview.DataViewDefinition;
import com.inet.report.adhoc.server.api.dataview.SimpleDataView;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.renderer.AdHocRendererFactory;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.dataview.datasource.a;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DataFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@PublicApi
public class PersistenceTemplateDataViewDefaults
implements TemplateDataViewDefaults {
    @Nonnull
    private GUID id;
    @Nonnull
    private String name;
    private String description;
    private DataViewAccessList accessList;
    private Map<RendererPropertyKey<?>, String> properties;

    private PersistenceTemplateDataViewDefaults() {
    }

    public PersistenceTemplateDataViewDefaults(@Nonnull GUID id, @Nonnull String name, String description, @Nonnull DataViewAccessList accessList, @Nonnull Map<RendererPropertyKey<?>, String> properties) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.accessList = accessList;
        this.properties = properties;
    }

    @Override
    @Nonnull
    public GUID getID() {
        return this.id;
    }

    @Nonnull
    public Map<RendererPropertyKey<?>, String> getProperties() {
        HashMap hashMap = this.properties;
        return hashMap != null ? hashMap : new HashMap();
    }

    @Nonnull
    public String getExtensionName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public <T> String getString(@Nonnull RendererPropertyKey<T> key) {
        return this.properties.get(key);
    }

    @Override
    @Nonnull
    public DataViewAccessList getAccessList() {
        DataViewAccessList dataViewAccessList = this.accessList;
        if (dataViewAccessList == null) {
            dataViewAccessList = new DataViewAccessList(Collections.emptySet(), Collections.emptySet());
        }
        return dataViewAccessList;
    }

    @Override
    @Nonnull
    public @Nonnull List<@Nonnull TemplateDataViewDefaults.Column> getAvailableColumns() {
        try {
            Engine engine = RDC.createEmptyEngine((String)"java");
            DataViewDefinition dataViewDefinition = (DataViewDefinition)this.get(TEMPLATESOURCE_KEY);
            return this.getFields(engine, dataViewDefinition);
        }
        catch (ReportException reportException) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)reportException);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @Nonnull
    public DataView createDataView(@Nonnull Engine engine, @Nullable DataFilter filter) {
        try {
            DataViewDefinition dataViewDefinition = (DataViewDefinition)this.get(TEMPLATESOURCE_KEY);
            List<@Nonnull LocalizedKey> list = this.getFields(engine, dataViewDefinition);
            String string = dataViewDefinition.getProperties().get(TEMPLATESOURCE_JOINS_KEY);
            if (string != null) {
                @Nonnull @Nonnull List list2 = (List)new Json().fromJson(string, (Type)new JsonParameterizedType(List.class, new Type[]{Join.class}));
                DatabaseTables databaseTables = engine.getDatabaseTables();
                for (Join join : list2) {
                    TableSource tableSource;
                    DatabaseField databaseField;
                    TableSource tableSource2 = databaseTables.getTablesource(join.fromTableAlias);
                    DatabaseField databaseField2 = tableSource2.getDatabaseField(join.fromColumn);
                    if (databaseField2 == null) {
                        tableSource2.addColumn(join.fromColumn, 11);
                        databaseField2 = tableSource2.getDatabaseField(join.fromColumn);
                    }
                    if ((databaseField = (tableSource = databaseTables.getTablesource(join.toTableAlias)).getDatabaseField(join.toColumn)) == null) {
                        tableSource.addColumn(join.toColumn, 11);
                        databaseField = tableSource.getDatabaseField(join.toColumn);
                    }
                    databaseTables.addJoin(tableSource2, databaseField2, tableSource, databaseField, join.joinType, join.linkType);
                }
            }
            this.setSelectionFormula(engine, filter);
            return new SimpleDataView(list, engine);
        }
        catch (ReportException reportException) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)reportException);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nonnull
    private @Nonnull List<@Nonnull TemplateDataViewDefaults.Column> getFields(@Nonnull Engine engine, DataViewDefinition dataViewDefinition) throws ReportException {
        Object object;
        String string;
        if (dataViewDefinition == null) {
            throw new ValidationException(AdHocRendererFactory.DATA_DEFINITION.getName(), com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.template.noDataSource", new Object[0]));
        }
        Map map = dataViewDefinition.getProperties();
        String string2 = map.get(a.cm);
        if (string2 == null) {
            throw new ValidationException(AdHocRendererFactory.DATA_DEFINITION.getName(), com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.template.noDataSource", new Object[]{string2}));
        }
        String string3 = map.get(TEMPLATESOURCE_TABLES_KEY);
        if (string3 == null) {
            throw new ValidationException(AdHocRendererFactory.DATA_DEFINITION.getName(), com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.template.noTable", new Object[0]));
        }
        Json json = new Json();
        List list = (List)json.fromJson(string3, (Type)new JsonParameterizedType(List.class, new Type[]{LocalizedKey.class}));
        DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSource((String)string2);
        if (dataSourceConfiguration == null) {
            throw new ValidationException(AdHocRendererFactory.DATA_DEFINITION.getName(), com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.template.nonExistingDataSource", new Object[]{string2}));
        }
        string3 = map.get(TEMPLATESOURCE_COLUMNS_KEY);
        if (string3 == null) {
            throw new ValidationException(AdHocRendererFactory.DATA_DEFINITION.getName(), com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.template.noTableColumn", new Object[0]));
        }
        List list2 = (List)json.fromJson(string3, (Type)new JsonParameterizedType(List.class, new Type[]{LocalizedKey.class}));
        DatabaseTables databaseTables = engine.getDatabaseTables();
        Datasource datasource = databaseTables.getDatasource(0);
        datasource.setDataSourceConfiguration(dataSourceConfiguration);
        DataFactory dataFactory = datasource.getDataFactory();
        HashMap<String, TableSource> hashMap = new HashMap<String, TableSource>();
        HashMap<String, Map<@Nonnull String, Integer>> hashMap2 = new HashMap<String, Map<String, Integer>>();
        for (Object object2 : list) {
            String string4 = object2.getKey();
            string = object2.getDisplayName();
            if (string == null) {
                string = string4;
            }
            TableSource tableSource = datasource.createTableSource(string, string4);
            hashMap.put(string4, tableSource);
            object = dataFactory.getColumns(tableSource);
            hashMap2.put(string4, object.stream().collect(Collectors.toMap(ColumnInfo::getName, ColumnInfo::getDataType)));
        }
        ArrayList arrayList = new ArrayList();
        for (String string4 : list2) {
            string = string4.getKey();
            int n2 = string.indexOf(46);
            object = string.substring(n2 + 1);
            String string5 = string.substring(0, n2);
            TableSource tableSource = (TableSource)hashMap.get(string5);
            @Nonnull Map map2 = (Map)hashMap2.get(string5);
            if (tableSource == null || map2 == null) continue;
            int n3 = map2.getOrDefault(object, 11);
            tableSource.addColumn((String)object, n3);
            arrayList.add(new TemplateDataViewDefaults.Column(string, string4.getDisplayName(), n3));
        }
        return arrayList;
    }

    public int hashCode() {
        return Objects.hash(this.accessList, this.description, this.id, this.name, this.properties);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistenceTemplateDataViewDefaults persistenceTemplateDataViewDefaults = (PersistenceTemplateDataViewDefaults)obj;
        return Objects.equals(this.accessList, persistenceTemplateDataViewDefaults.accessList) && Objects.equals(this.description, persistenceTemplateDataViewDefaults.description) && Objects.equals(this.id, persistenceTemplateDataViewDefaults.id) && Objects.equals(this.name, persistenceTemplateDataViewDefaults.name) && Objects.equals(this.properties, persistenceTemplateDataViewDefaults.properties);
    }

    @JsonData
    @PublicApi
    public static class Join {
        private String fromTableAlias;
        private String fromColumn;
        private String toTableAlias;
        private String toColumn;
        private int joinType;
        private int linkType;

        private Join() {
        }

        public Join(String fromTableAlias, String fromColumn, String toTableAlias, String toColumn) {
            this(fromTableAlias, fromColumn, toTableAlias, toColumn, 21, 1);
        }

        public Join(String fromTableAlias, String fromColumn, String toTableAlias, String toColumn, int joinType, int linkType) {
            this.fromTableAlias = fromTableAlias;
            this.fromColumn = fromColumn;
            this.toTableAlias = toTableAlias;
            this.toColumn = toColumn;
            this.joinType = joinType;
            this.linkType = linkType;
        }

        public String getFromTableAlias() {
            return this.fromTableAlias;
        }

        public String getFromColumn() {
            return this.fromColumn;
        }

        public String getToTableAlias() {
            return this.toTableAlias;
        }

        public String getToColumn() {
            return this.toColumn;
        }

        public int getJoinType() {
            return this.joinType;
        }

        public int getLinkType() {
            return this.linkType;
        }
    }
}

