/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.layouts;

import com.inet.html.InetHtmlFactory;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.ListPositionValue;
import com.inet.html.utils.CSSRules;
import com.inet.html.utils.DOMUtils;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.html.utils.ViewUtils;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.ContentView;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.RenderContext;
import com.inet.html.views.VariableSpaceView;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.BlockLayout;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import com.inet.html.views.layouts.StackManager;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class InlineLayout
extends Layout {
    private static final double DEFAULT_LINE_HEIGHT = 1.15;
    private static final char[] BREAK_CHARS = new char[]{'#', '&', '/', '@', '\\'};
    private static final char SPACE = ' ';
    private static final char NBSP = '\u00a0';
    private int preferredBaseline;
    private BlockView blockView;
    private boolean reflowed = false;
    private boolean hasMarker = false;
    private int contentHeight;
    private Rectangle span = new Rectangle();
    private LevelList bidiList;
    private int lastSyncLen = -1;
    private boolean rtl;
    private boolean canWrapOnOverflow;
    private boolean collapseWhitespaces;
    private int listPos = 0;

    public InlineLayout(BlockView view) {
        super(view);
        ListPositionValue listPosValue;
        this.blockView = view;
        int whiteSpace = view.getWhiteSpace();
        this.canWrapOnOverflow = whiteSpace == 0 || whiteSpace == 5 || whiteSpace == 4 || whiteSpace == 3;
        this.collapseWhitespaces = whiteSpace == 1 || whiteSpace == 3;
        this.hasMarker = view.isListItemWithMarker();
        if (this.hasMarker && (listPosValue = StyleResolver.getAttributeValue(view.getElement(), AttributeFinder.LIST_STYLE_POSITION)) != null) {
            this.listPos = listPosValue.getType();
        }
        this.childPositions = new ArrayList(view.getViewCount());
    }

    @Override
    protected void calculateCollapsedMargins() {
        if (this.view.isFloating()) {
            return;
        }
        View parent = this.view.getParent();
        Insets margins = this.blockView.getMargins();
        if (parent != null && parent instanceof BoxView && !(parent instanceof HtmlRootView)) {
            Layout layout;
            BoxView boxParent = (BoxView)parent;
            if (parent instanceof ILayouted && (layout = ((ILayouted)((Object)parent)).getLayout()) instanceof BlockLayout) {
                if (boxParent.getTopInset() == 0 && this.getChild(boxParent, true) == this.view) {
                    margins.top = 0;
                }
                if (boxParent.getBottomInset() == 0 && this.getChild(boxParent, false) == this.view) {
                    margins.bottom = 0;
                }
            }
        }
    }

    @Override
    public Rectangle layout(boolean hard) {
        Dimension size = this.applyMinMaxValue(true, this.width, 0);
        if (size != null) {
            this.width = size.width;
        }
        Point reference = this.blockView.getLeftUpperCorner(this.view);
        this.span.setBounds(0, 0, this.width, 0);
        Rectangle bounds = new Rectangle(reference.x, reference.y, this.width, 0);
        Rectangle minRequired = new Rectangle();
        StackManager posManager = this.blockView.getPositionManager(false);
        int n = this.view.getViewCount();
        StackManager.LineSpaceInfo line = null;
        int startOffset = 0;
        int currentX = 0;
        int currentY = 0;
        int currentLineHeight = 0;
        int currentLineEnd = this.width;
        this.preferredBaseline = 0;
        this.contentHeight = 0;
        this.setPreferredHeight(0);
        this.childPositions.clear();
        boolean prevWasBR = false;
        int breakMode = this.blockView.getRenderContext().getBreakMode();
        int firstInLine = 0;
        int firstInTabBlock = 0;
        ViewIterator iterator = new ViewIterator();
        boolean isNotImpliedOnBodyLevel = this.view.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.IMPLIED || this.view.getParent() == null || this.view.getParent().getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY;
        int cssHeight = this.adjustHeight();
        if (cssHeight != Integer.MIN_VALUE) {
            this.setCurrentHeight(cssHeight);
        }
        if (this.hasMarker && this.listPos == 0 && n != 1) {
            startOffset = 1;
            firstInLine = 1;
            iterator.step();
        }
        boolean firstPositioningPassed = false;
        for (int j = 0; j < n; ++j) {
            View v = this.view.getView(j);
            if (!(v instanceof VariableSpaceView)) continue;
            VariableSpaceView spaceView = (VariableSpaceView)v;
            spaceView.setWidth(-1);
        }
        View nextUpdate = null;
        SegmentInfo requiredBox = null;
        boolean breakRequiredByWordSplit = false;
        boolean requireBreakForNextElement = false;
        boolean breakAllowedBySegment = false;
        while (iterator.hasNext()) {
            BoxView[] result;
            boolean isLineBreak;
            BoxView next;
            VariableSpaceView varSpace;
            BoxView currentView = iterator.peek();
            breakRequiredByWordSplit = false;
            if (nextUpdate == null || currentView == nextUpdate) {
                requiredBox = this.getSegmentSize(iterator, false);
                nextUpdate = requiredBox.next;
                breakAllowedBySegment = true;
                if (requireBreakForNextElement) {
                    requireBreakForNextElement = false;
                    breakRequiredByWordSplit = true;
                } else {
                    breakRequiredByWordSplit = false;
                }
            } else {
                if (requireBreakForNextElement) {
                    requireBreakForNextElement = false;
                    breakRequiredByWordSplit = true;
                } else {
                    breakRequiredByWordSplit = false;
                }
                breakAllowedBySegment = false;
            }
            if (currentView == null || requiredBox == null) {
                iterator.step();
                continue;
            }
            if ((prevWasBR || !firstPositioningPassed) && currentView instanceof VariableSpaceView && !(varSpace = (VariableSpaceView)currentView).isBreak() && varSpace.isBreakable() && !varSpace.isFixed() && (next = this.getNextVisibleView(iterator)) != null && next.isFloating()) {
                iterator.step();
                continue;
            }
            iterator.step();
            Element currentElement = currentView.getElement();
            Layout.PositionInfo currentPos = new Layout.PositionInfo(currentView);
            int flowIndex = this.childPositions.size();
            if (currentView.isAbsolutePositioned() && (posManager = this.blockView.getPositionManager(true)) != null) {
                posManager.addView(currentView, 0, currentY);
                continue;
            }
            currentView.performLayoutWidth();
            currentView.performLayout(hard);
            if (!currentView.isInFlow() && (posManager = this.blockView.getPositionManager(true)) != null) {
                StackManager.FloatChange change = posManager.addView(currentView, currentX, currentY);
                if (change == null) continue;
                if (change.isLeft()) {
                    for (int i = firstInLine; i < this.childPositions.size(); ++i) {
                        Layout.PositionInfo child = (Layout.PositionInfo)this.childPositions.get(i);
                        child.x += change.getOffsetChange();
                    }
                    currentX += change.getOffsetChange();
                }
                currentLineEnd -= change.getOffsetChange();
                continue;
            }
            currentPos.width = currentView.getOuterWidth();
            if (CSSRules.isBlock(currentView) && posManager == null) {
                posManager = this.blockView.getPositionManager(false);
            }
            Insets margins = currentView.getMargins();
            int marginTopBottom = margins.top + margins.bottom;
            int viewWidth = currentView.getOuterWidth() + margins.left + margins.right;
            int viewHeight = currentView.getOuterHeight() + marginTopBottom;
            currentPos.baseline = (short)(currentView.getPreferredSpan(2) + (float)marginTopBottom);
            int originalViewHeight = viewHeight;
            if (currentView instanceof ContentView) {
                viewHeight = currentView.getLineHeight() > 0 ? currentView.getLineHeight() : Math.max(viewHeight, (int)Math.round(1.15 * (double)currentView.getFontSize()));
            }
            int lineHeightOffset = (viewHeight - originalViewHeight) / 2;
            int baseline = currentPos.baseline + lineHeightOffset;
            viewHeight = Math.max(currentLineHeight - this.preferredBaseline, viewHeight - baseline) + Math.max(baseline, this.preferredBaseline);
            int textIndent = 0;
            if (!firstPositioningPassed) {
                textIndent = this.blockView.getTextIndent();
                if (posManager != null) {
                    posManager.notifyNewLine(currentY);
                    minRequired.width = requiredBox.width;
                    minRequired.height = requiredBox.height;
                    Rectangle localBounds = bounds;
                    if (textIndent != 0) {
                        localBounds = (Rectangle)bounds.clone();
                        localBounds.x += textIndent;
                        localBounds.width -= textIndent;
                    }
                    line = posManager.findLineSpace(minRequired, localBounds, currentView.getClear(), this.view.getJustification());
                    currentX = line.getX() - reference.x;
                    currentY = line.getY() - reference.y;
                    currentLineEnd = line.getMaxWidth() + currentX;
                    this.preferredBaseline = 0;
                } else {
                    currentX += textIndent;
                }
                if (this.hasMarker && this.listPos == 0) {
                    currentLineHeight = this.placeOutsideMarker(hard, currentX, currentY, currentLineHeight, lineHeightOffset, baseline);
                    ++flowIndex;
                }
                firstPositioningPassed = true;
            }
            if (isLineBreak = currentView.isBreak()) {
                VariableSpaceView varSpace2;
                prevWasBR = true;
                BoxView next2 = iterator.peek();
                if (next2 != null && iterator.getRemainingCount() == 1 && next2 instanceof VariableSpaceView && (varSpace2 = (VariableSpaceView)next2).isCRmarker()) {
                    isLineBreak = false;
                    prevWasBR = false;
                }
            }
            boolean breakAllowed = (!currentPos.isVarSpace || requiredBox.segmentLen > 1) && this.canWrapOnOverflow && breakAllowedBySegment;
            boolean cjkBreak = currentView instanceof ContentView && ((ContentView)currentView).getCJKType() == 2;
            boolean isCR = ElementUtils.isEndMarker(currentElement);
            breakAllowed &= !isCR;
            if (breakMode != 0 || cjkBreak) {
                if (breakAllowed && cjkBreak) {
                    if (breakMode == 2) {
                        breakAllowed &= breakRequiredByWordSplit || requiredBox.width <= currentLineEnd;
                    } else if (cjkBreak) {
                        breakAllowed &= breakRequiredByWordSplit;
                    }
                } else {
                    breakAllowed |= breakRequiredByWordSplit;
                    breakAllowed |= !currentPos.isVarSpace && currentX + viewWidth > currentLineEnd && currentX > 0 && currentView.getEndOffset() - currentView.getStartOffset() == 1;
                }
            }
            if (breakAllowed && currentX + requiredBox.width > currentLineEnd && currentX > 0 || breakAllowed && line != null && line.getMaxHeightOnMaxWidth() < requiredBox.height || isLineBreak) {
                this.span.width = Math.max(this.span.width, currentX);
                if (currentView.getViewCount() > 0) {
                    isLineBreak = true;
                }
                if (isLineBreak) {
                    prevWasBR = false;
                    if (this.addChild(currentPos)) {
                        ++flowIndex;
                    }
                    currentLineHeight = Math.max(currentLineHeight, viewHeight);
                    currentPos.x = currentX;
                    currentPos.y = currentY;
                    currentPos.vAlign = (byte)currentView.getAlignment(1);
                    this.preferredBaseline = Math.max(this.preferredBaseline, baseline);
                }
                if (firstInLine == startOffset) {
                    this.view.setFirstLineBaseLine((short)this.preferredBaseline);
                }
                flowIndex = this.justification(firstInLine, firstInTabBlock, flowIndex, currentLineEnd, currentX, isLineBreak, this.collapseWhitespaces);
                this.verticalAlign(firstInLine == startOffset ? 0 : firstInLine, flowIndex, this.childPositions);
                firstInLine = flowIndex;
                firstInTabBlock = flowIndex;
                currentX = textIndent;
                currentY += currentLineHeight;
                if (isLineBreak) {
                    requiredBox = this.getSegmentSize(iterator, false);
                    nextUpdate = requiredBox.next;
                }
                if (posManager != null) {
                    posManager.notifyNewLine(currentY);
                    minRequired.width = requiredBox.width;
                    minRequired.height = requiredBox.height;
                    bounds.y = currentY + reference.y;
                    line = posManager.findLineSpace(minRequired, bounds, currentView.getClear(), this.view.getJustification());
                    currentX = line.getX() - reference.x;
                    currentY = line.getY() - reference.y;
                    currentLineEnd = line.getMaxWidth() + currentX;
                }
                viewHeight = originalViewHeight;
                currentLineHeight = 0;
                this.preferredBaseline = 0;
                if (isLineBreak) continue;
                iterator.push(currentView);
                continue;
            }
            if (!isLineBreak) {
                if (prevWasBR) {
                    int index = this.childPositions.size() - 1;
                    currentX = ((Layout.PositionInfo)this.childPositions.get((int)index)).x;
                }
                prevWasBR = false;
            }
            if (currentX + viewWidth > currentLineEnd && this.view.getOverflow() != 2 && (breakMode != 0 && currentView.getEndOffset() - currentView.getStartOffset() > 1 || cjkBreak) && (result = this.breakInline(currentView, currentLineEnd - currentX, firstInLine == flowIndex)) != null) {
                if (result.length == 1) {
                    if (!breakRequiredByWordSplit) {
                        iterator.push(result[0]);
                        requireBreakForNextElement = true;
                        breakRequiredByWordSplit = false;
                        continue;
                    }
                } else {
                    currentView = result[0];
                    iterator.push(result[1]);
                    currentView.performLayoutWidth();
                    currentView.performLayout(hard);
                    currentPos.width = currentView.getOuterWidth();
                    int diff = viewWidth - result[1].getOuterWidth() - margins.left + margins.right;
                    viewWidth = currentPos.width + margins.left + margins.right;
                    currentPos.view = currentView;
                    requiredBox.width -= diff;
                    requireBreakForNextElement = true;
                }
            }
            if (!this.addChild(currentPos)) {
                viewWidth = 0;
            }
            currentPos.setLocation(currentX + margins.left, currentY + margins.top);
            if (currentView instanceof VariableSpaceView && ((VariableSpaceView)currentView).isTab()) {
                viewWidth = this.view.getRenderContext().getTabSize(currentX, viewWidth);
                ((VariableSpaceView)currentView).setWidth(viewWidth);
                firstInTabBlock = flowIndex;
            }
            currentX += viewWidth;
            if (!isCR || !this.getView().getRenderContext().collapseEmptyBlocks()) {
                if (this.getView().getRenderContext().collapseEmptyBlocks()) {
                    if (!isCR) {
                        currentLineHeight = Math.max(currentLineHeight, viewHeight);
                        this.preferredBaseline = Math.max(this.preferredBaseline, baseline);
                    }
                } else {
                    BoxView next3 = iterator.peek();
                    if (!(isCR && next3 == null && !isNotImpliedOnBodyLevel || isCR && currentLineHeight > 0)) {
                        currentLineHeight = Math.max(currentLineHeight, viewHeight);
                        this.preferredBaseline = Math.max(this.preferredBaseline, baseline);
                    }
                }
            }
            currentPos.vAlign = (byte)currentView.getAlignment(1);
            if (currentView.getPosition() != 1) continue;
            InlineLayout.offsetRelative(currentPos);
            Layout.union(this.span, currentPos.x, currentPos.y, currentPos.view.getOuterWidth(), currentPos.view.getOuterHeight());
            posManager = ((BlockView)this.view).getPositionManager(true);
            if (posManager == null) continue;
            posManager.addView(currentView, currentPos.x, currentPos.y);
            currentPos.paintInFlow = false;
        }
        this.span.width = Math.max(this.span.width, currentX - this.span.x);
        if (posManager != null) {
            posManager.notifyNewLine(currentY + currentLineHeight);
        }
        if (!firstPositioningPassed) {
            if (this.hasMarker && this.listPos == 0) {
                currentLineHeight = this.placeOutsideMarker(hard, currentX, currentY, currentLineHeight, 0, this.preferredBaseline);
            }
            this.view.setFirstLineBaseLine((short)this.preferredBaseline);
        } else if (firstInLine == startOffset) {
            this.view.setFirstLineBaseLine((short)this.preferredBaseline);
        }
        int childCount = this.childPositions.size();
        this.justification(firstInLine, firstInTabBlock, childCount, currentLineEnd, currentX, true, this.collapseWhitespaces);
        this.verticalAlign(firstInLine == startOffset ? 0 : firstInLine, childCount, this.childPositions);
        this.span.height = this.contentHeight = currentY + currentLineHeight;
        for (Layout.PositionInfo info : this.childPositions) {
            Rectangle childSpan = info.view.getSpan();
            if (childSpan == null) {
                childSpan = info.getBounds();
            }
            if (childSpan.x + info.x >= this.span.x && childSpan.y + info.y >= this.span.y && childSpan.x + info.x + childSpan.width <= this.span.x + this.span.width && childSpan.y + info.y + childSpan.height <= this.span.y + this.span.height) continue;
            childSpan = childSpan.getBounds();
            childSpan.x += info.x;
            childSpan.y += info.y;
            this.span = this.span.union(childSpan);
        }
        if (!this.view.isInFlow() || CSSRules.isBlock(this.view)) {
            this.setFinalHight(cssHeight, currentY + currentLineHeight, this.span);
        } else {
            this.setCurrentHeight(currentY + currentLineHeight);
        }
        size = this.applyMinMaxValue(false, this.getCurrentWidth(), this.getCurrentHeight());
        if (size != null) {
            this.setCurrentWidth(size.width);
            this.setCurrentHeight(size.height);
        }
        this.view.setSizeContent(this.getCurrentWidth(), this.getCurrentHeight());
        return this.span;
    }

    private boolean addChild(Layout.PositionInfo pos) {
        if (pos.isVarSpace && !pos.isFixed && this.childPositions.size() > 0) {
            Layout.PositionInfo last = (Layout.PositionInfo)this.childPositions.get(this.childPositions.size() - 1);
            if (last.isVarSpace && !last.isFixed && last.view.getEndOffset() - last.view.getStartOffset() == 1) {
                return false;
            }
        }
        this.childPositions.add(pos);
        return true;
    }

    private int placeOutsideMarker(boolean hard, int currentX, int currentY, int currentLineHeight, int lineHeightOffset, int baseline) {
        BoxView marker = (BoxView)this.view.getView(0);
        marker.performLayoutWidth();
        marker.performLayout(hard);
        Layout.PositionInfo markerPos = new Layout.PositionInfo(marker);
        this.addChild(markerPos);
        markerPos.baseline = (short)marker.getPreferredSpan(2);
        int markerBaseline = markerPos.baseline + lineHeightOffset;
        markerPos.x = this.view.isLTR() ? currentX - marker.getOuterWidth() - MARKER_OFFSET : this.width + MARKER_OFFSET;
        markerPos.y = currentY;
        Layout.union(this.span, markerPos.x, markerPos.y, markerPos.view.getOuterWidth(), markerPos.view.getOuterHeight());
        currentLineHeight = Math.max(currentLineHeight, marker.getOuterHeight());
        markerPos.vAlign = (byte)marker.getAlignment(1);
        this.preferredBaseline = Math.max(baseline, markerBaseline);
        return currentLineHeight;
    }

    private BoxView[] breakInline(BoxView view, int xOffset, boolean lineStart) {
        ContentView content;
        float[] offsets;
        if (view instanceof ContentView && !(view instanceof VariableSpaceView) && (offsets = (content = (ContentView)view).getContentPainter().getCharOffsets()) != null && offsets.length > 1) {
            int offset;
            for (offset = 0; offset < offsets.length && !(offsets[offset] > (float)xOffset); ++offset) {
            }
            if (offset <= 1 && !lineStart) {
                return new BoxView[]{view};
            }
            offset = offset <= 1 ? 1 : offset - 1;
            int start = view.getStartOffset();
            if (offset > view.getEndOffset() - start) {
                return null;
            }
            BoxView[] result = new BoxView[]{(BoxView)view.createFragment(start, start + offset), (BoxView)view.createFragment(start + offset, view.getEndOffset())};
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BoxView getNextVisibleView(ViewIterator iterator) {
        iterator.freeze();
        try {
            iterator.next();
            while (iterator.hasNext()) {
                BoxView v = iterator.next();
                if (!v.isVisible()) continue;
                BoxView boxView = v;
                return boxView;
            }
            BoxView boxView = null;
            return boxView;
        }
        finally {
            iterator.unfreeze();
        }
    }

    private int justification(int start, int startTab, int end, int width, int currentWidth, boolean isLastLine, boolean isPre) {
        if (end == 0) {
            return end;
        }
        if (this.bidiList != null) {
            this.bidiList.reorder(this.childPositions, start, end - start);
        }
        Layout.PositionInfo endPosInfo = (Layout.PositionInfo)this.childPositions.get(end - 1);
        if (endPosInfo.isVarSpace && endPosInfo.view != null && this.view.getJustification() != 1 && this.view.getJustification() != 2 && endPosInfo.view.isBreak()) {
            VariableSpaceView spaceView = (VariableSpaceView)endPosInfo.view;
            spaceView.setWidth(1);
        }
        if (width == currentWidth) {
            return end;
        }
        endPosInfo = null;
        switch (this.view.getJustification()) {
            case 2: {
                Layout.PositionInfo positionInfo;
                int i;
                int offset = width - currentWidth - 1;
                int alignEnd = end;
                if (this.view.isLTR()) {
                    for (i = alignEnd - 1; i >= start; --i) {
                        positionInfo = (Layout.PositionInfo)this.childPositions.get(i);
                        if (!positionInfo.isVarSpace || positionInfo.isFixed) break;
                        if (positionInfo.view == null) continue;
                        --alignEnd;
                        positionInfo.x = width;
                        if (positionInfo.view.isBreak()) {
                            ((VariableSpaceView)positionInfo.view).setWidth(0);
                            continue;
                        }
                        offset += positionInfo.view.getContentWidth();
                        ((VariableSpaceView)positionInfo.view).setWidth(0);
                    }
                }
                for (i = start; i < alignEnd; ++i) {
                    positionInfo = (Layout.PositionInfo)this.childPositions.get(i);
                    positionInfo.x += offset;
                    if (positionInfo.x >= 0) continue;
                    positionInfo.x = 0;
                }
                return end;
            }
            case 1: {
                int offset = (width - currentWidth) / 2;
                if (offset > 0) {
                    for (int i = start; i < end; ++i) {
                        ((Layout.PositionInfo)this.childPositions.get((int)i)).x += offset;
                    }
                }
                return end;
            }
            case 3: {
                if (!isLastLine) {
                    return this.justify(startTab, end, width, currentWidth);
                }
                return end;
            }
        }
        return end;
    }

    private int justify(int start, int end, int width, int currentWidth) {
        int spaces = 0;
        for (int i = start; i < end - 1; ++i) {
            Layout.PositionInfo pos = (Layout.PositionInfo)this.childPositions.get(i);
            if (!pos.isVarSpace || pos.isFixed || pos.view == null) continue;
            ++spaces;
        }
        float portion = spaces > 0 ? (float)(width - currentWidth) / (float)spaces : 0.0f;
        float offset = 0.0f;
        float offsetBefore = 0.0f;
        for (int i = start; i < end - 1; ++i) {
            Layout.PositionInfo pos = (Layout.PositionInfo)this.childPositions.get(i);
            pos.x = (int)((float)pos.x + offset);
            if (!pos.isVarSpace || pos.isFixed || pos.view == null) continue;
            VariableSpaceView space = (VariableSpaceView)pos.view;
            space.setWidth(space.getContentWidth() + (int)(offset += portion) - (int)offsetBefore);
            offsetBefore = offset;
        }
        ((Layout.PositionInfo)this.childPositions.get((int)(end - 1))).x = (int)((float)((Layout.PositionInfo)this.childPositions.get((int)(end - 1))).x + offset);
        return end;
    }

    private void verticalAlign(int start, int end, List<Layout.PositionInfo> positions) {
        Layout.PositionInfo pos;
        int i;
        block11: for (i = start; i < end; ++i) {
            pos = positions.get(i);
            switch (pos.vAlign) {
                case 5: 
                case 7: {
                    continue block11;
                }
                case 6: 
                case 8: {
                    this.setPreferredHeight(Math.max(this.getPreferredHeight(), pos.y + pos.view.getContentHeight()));
                    continue block11;
                }
                case 2: {
                    continue block11;
                }
                case 4: {
                    if (pos.view == null) continue block11;
                    pos.y = (int)((float)pos.y + ((float)(this.preferredBaseline - pos.baseline) - pos.view.getFontSize() / 3.0f));
                    this.setPreferredHeight(Math.max(this.getPreferredHeight(), pos.y + pos.view.getContentHeight()));
                    continue block11;
                }
                case 3: {
                    if (pos.view == null) continue block11;
                    pos.y = (int)((float)pos.y + ((float)(this.preferredBaseline - pos.baseline) + pos.view.getFontSize() / 3.0f));
                    this.setPreferredHeight(Math.max(this.getPreferredHeight(), pos.y + pos.view.getContentHeight()));
                    continue block11;
                }
                default: {
                    pos.y += this.preferredBaseline - pos.baseline;
                    if (pos.view == null) continue block11;
                    this.setPreferredHeight(Math.max(this.getPreferredHeight(), pos.y + pos.view.getContentHeight()));
                }
            }
        }
        block12: for (i = start; i < end; ++i) {
            pos = positions.get(i);
            switch (pos.vAlign) {
                case 6: 
                case 8: {
                    pos.y = this.getPreferredHeight() - pos.view.getOuterHeight();
                    continue block12;
                }
                case 2: {
                    if (pos.view == null) continue block12;
                    pos.y = (this.getPreferredHeight() - pos.view.getOuterHeight()) / 2;
                }
            }
        }
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        int i;
        Rectangle rect = a.getBounds();
        if (this.view.getVisibility() != 0) {
            throw new BadLocationException("Location is within a unvisible Element", pos);
        }
        int boxX = rect.x + this.view.getLeftInset();
        int boxY = rect.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        Shape returnValue = null;
        StackManager floatManager = ((BlockView)this.view).getPositionManager(false);
        if (floatManager != null && (returnValue = floatManager.modelToView(pos, a, b, 5)) != null) {
            return returnValue;
        }
        boolean childIsBR = false;
        boolean isListMarker = this.blockView.isListItemWithMarker();
        List<Layout.PositionInfo> children = this.getChildren();
        int n = i = isListMarker ? 1 : 0;
        while (i < children.size()) {
            Layout.PositionInfo child = children.get(i);
            if (child.view != null) {
                boolean upperEndCondition;
                int startOffset = child.view.getStartOffset();
                int endOffset = child.view.getEndOffset();
                childIsBR = child.view.isBreak();
                boolean bl = upperEndCondition = !childIsBR && endOffset > pos || childIsBR && startOffset == pos || (i == children.size() - 1 || b == Position.Bias.Backward) && endOffset >= pos && !childIsBR;
                if (startOffset < endOffset && startOffset <= pos && upperEndCondition) {
                    rect.x = child.x + boxX;
                    rect.y = child.y + boxY;
                    rect.width = child.view.getOuterWidth();
                    rect.height = child.view.getOuterHeight();
                    returnValue = child.view.modelToView(pos, rect, b);
                    break;
                }
            }
            ++i;
        }
        if (floatManager != null && returnValue == null) {
            return floatManager.modelToView(pos, a, b, 0);
        }
        return returnValue;
    }

    private int getDistance(int point, int refPoint, int refLen) {
        if (refPoint <= point && refPoint + refLen >= point) {
            return 0;
        }
        if (point < refPoint) {
            return refPoint - point;
        }
        return point - refPoint - refLen;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        StackManager floatManager;
        Rectangle rect = a.getBounds();
        if (this.view.getVisibility() != 0) {
            return -1;
        }
        int boxX = rect.x + this.view.getLeftInset();
        int boxY = rect.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        int returnValue = -1;
        Layout.PositionInfo nearest = null;
        int nearestDistance = Integer.MAX_VALUE;
        int nearestDistanceY = Integer.MAX_VALUE;
        StackManager stackManager = floatManager = ((BlockView)this.view).isPositionRoot() ? ((BlockView)this.view).getPositionManager(false) : null;
        if (floatManager != null && (returnValue = floatManager.viewToModel(x, y, a, biasReturn, 5)) >= 0) {
            return returnValue;
        }
        boolean skipFirst = this.hasMarker;
        for (Layout.PositionInfo pos : this.getChildren()) {
            if (skipFirst || pos.view == null) {
                skipFirst = false;
                continue;
            }
            rect.setBounds(pos.x + boxX, pos.y + boxY, pos.view.getOuterWidth(), pos.view.getOuterHeight());
            if (rect.contains(new Point2D.Float(x, y))) {
                returnValue = pos.view.viewToModel(x, y, rect, biasReturn);
                break;
            }
            int newYdistance = this.getDistance((int)y, rect.y, rect.height);
            int newDist = this.getDistance((int)x, rect.x, rect.width);
            if ((newDist >= nearestDistance || newYdistance != nearestDistanceY) && newYdistance >= nearestDistanceY) continue;
            nearestDistance = newDist;
            nearestDistanceY = newYdistance;
            nearest = pos;
        }
        if (returnValue == -1 && floatManager != null) {
            returnValue = floatManager.viewToModel(x, y, a, biasReturn, 0);
        }
        if (returnValue == -1 && nearest != null && nearest.view != null) {
            rect.setBounds(nearest.x + boxX, nearest.y + boxY, nearest.view.getOuterWidth(), nearest.view.getOuterHeight());
            x = ViewUtils.mapPositionToArea((int)x, rect.x, rect.width);
            y = ViewUtils.mapPositionToArea((int)y, rect.y, rect.height);
            returnValue = nearest.view.viewToModel(x, y, rect, biasReturn);
        }
        return returnValue;
    }

    @Override
    public void preLayout() {
        this.updateBidi();
        try {
            if (!this.reflowed) {
                boolean[] keepViewArray = new boolean[this.blockView.getViewCount()];
                List<BoxView> replaced = InlineLayout.reflow(new ChildIterator(this.blockView), this.blockView, this.view.getRenderContext().allowTabs(), keepViewArray);
                this.blockView.replace(0, this.blockView.getViewCount(), replaced.toArray(new View[replaced.size()]), keepViewArray);
                this.reflowed = true;
            }
        }
        catch (Throwable th) {
            Logger.critical(th);
        }
        if (this.bidiList != null) {
            this.setBidiOnChildren();
        }
        this.preferredWidth = 0;
        this.setPreferredHeight(0);
        this.preferredBaseline = 0;
        this.minimumWidth = 0;
        this.minimumHeight = 0;
        this.width = 2146483647;
        LengthUnit l = this.view.getWidthUnit();
        boolean fixedWidth = false;
        if (l != null && !l.isAuto() && l.isAbsolute()) {
            this.width = this.preferredWidth = Math.round(l.calculateValue(0.0f, this.blockView));
            fixedWidth = true;
        }
        int currentX = 0;
        int currentY = 0;
        int whiteSpace = this.blockView.getWhiteSpace();
        boolean canWrapOnOverflow = whiteSpace == 0 || whiteSpace == 5 || whiteSpace == 3 || whiteSpace == 4;
        ViewIterator i = new ViewIterator();
        if (this.blockView.isListItemWithMarker()) {
            i.step();
        }
        while (i.hasNext()) {
            int prefX;
            SegmentInfo size = this.getSegmentSize(i, true);
            if (size.segmentLen == 1) {
                BoxView v = i.peek();
                if (v == null || v.isBreak()) {
                    currentX = 0;
                    currentY = this.getPreferredHeight();
                    i.step();
                    continue;
                }
                if (v.isBlock() && v.isFloating()) {
                    size.width++;
                }
            }
            if (currentX + (prefX = size.width) > this.width && currentX > 0 && canWrapOnOverflow) {
                currentX = 0;
                currentY = this.getPreferredHeight();
            }
            if (!fixedWidth) {
                int n = prefX > 0 ? prefX : 0;
                this.minimumWidth = Math.max(this.minimumWidth, size.minWidth);
                int gainX = this.view.getBox().getTotalWidthGain();
                this.minimumOuterWidth = this.minimumWidth + gainX;
                this.preferredWidth = Math.max(this.preferredWidth, currentX += n);
            }
            int prefY = size.height;
            this.setPreferredHeight(Math.max(this.getPreferredHeight(), currentY + prefY));
            this.minimumHeight = Math.max(this.minimumHeight, prefY);
            i.step(size.segmentLen);
        }
        this.setPreLayouted();
    }

    private void updateBidi() {
        if (this.view.getRenderContext().requiresBidiCheck()) {
            ParagraphIterator paragraph = new ParagraphIterator((BlockView)this.getView());
            int startIdx = paragraph.getContentStart();
            int endIdx = paragraph.getContentEnd();
            if (this.lastSyncLen == endIdx - startIdx) {
                return;
            }
            this.lastSyncLen = endIdx - startIdx;
            int pStart = paragraph.start;
            int pEnd = paragraph.end;
            int offset = startIdx - pStart;
            paragraph = new ParagraphIterator((BlockView)this.getView(), startIdx, endIdx);
            if (startIdx < endIdx && (Bidi.requiresBidi(paragraph.array, paragraph.offset, paragraph.offset + paragraph.count) || this.isBidiByAttributes())) {
                Bidi bidi = new Bidi(paragraph);
                this.rtl = bidi.isRightToLeft();
                boolean mixed = bidi.isMixed();
                if (mixed) {
                    int runs = bidi.getRunCount();
                    this.bidiList = new LevelList(this.view.getStartOffset());
                    for (int run = 0; run < runs; ++run) {
                        this.bidiList.add(new LevelInfo(bidi.getRunLevel(run), bidi.getRunStart(run) + offset, bidi.getRunLimit(run) + offset, this.bidiList));
                    }
                    this.view.setIsNativeLTR(this.bidiList.isPrimaryLTR());
                    this.bidiList.compile();
                    if (this.view.getDirection() == 1) {
                        if (pStart < startIdx) {
                            this.bidiList.add(0, new LevelInfo(1, 0, offset, this.bidiList));
                        }
                        if (pEnd > endIdx) {
                            this.bidiList.add(new LevelInfo(1, endIdx - pStart, pEnd - pStart, this.bidiList));
                        }
                        this.bidiList.compile();
                    }
                } else {
                    this.bidiList = new LevelList(this.view.getStartOffset());
                    this.bidiList.add(new LevelInfo(1, 0, pEnd - pStart, this.bidiList));
                    this.view.setIsNativeLTR(!this.rtl);
                }
            }
        }
    }

    private boolean isBidiByAttributes() {
        int pos = this.view.getStartOffset();
        int end = this.view.getEndOffset();
        while (pos < end) {
            BoxView leaf = ViewUtils.getLeafView((BlockView)this.view, pos, true);
            if (leaf == null) {
                ++pos;
                continue;
            }
            if (leaf.getDirection() == 1 && leaf.getUnicodeBidi() != 0) {
                return true;
            }
            pos = leaf.getEndOffset();
        }
        return false;
    }

    private void setBidiOnChildren() {
        if (this.bidiList == null && !this.rtl) {
            return;
        }
        int count = this.view.getViewCount();
        for (int i = 0; i < count; ++i) {
            BoxView child = (BoxView)this.view.getView(i);
            if (this.bidiList != null) {
                child.setIsNativeLTR(this.bidiList.getLevel(child) % 2 == 0);
                continue;
            }
            child.setIsNativeLTR(false);
        }
    }

    @Override
    public void predictWidth(int width) {
        this.width = width;
        this.currentWidth = width;
    }

    @Override
    public void layoutVerticalAlign(int align, int baselineOffset) {
        int availableHight = this.view.getContentHeight();
        int diff = availableHight - this.contentHeight;
        if (diff > 0) {
            switch (align) {
                case 8: {
                    this.view.setContentVerticalOffset(diff);
                    break;
                }
                case 2: {
                    this.view.setContentVerticalOffset(diff / 2);
                    break;
                }
                case 7: {
                    this.view.setContentVerticalOffset(0);
                    break;
                }
            }
        } else {
            this.view.setContentVerticalOffset(0);
        }
    }

    public void resetPreLayouted() {
        this.reflowed = false;
    }

    public static List<BoxView> reflow(Iterator<BoxView> children, BlockView parentView, boolean checkTabs, boolean[] keepViewArray) throws BadLocationException {
        LevelList bidiList = null;
        if (parentView.getLayout() instanceof InlineLayout) {
            InlineLayout layout = (InlineLayout)parentView.getLayout();
            layout.updateBidi();
            bidiList = layout.bidiList;
        }
        int parentStart = parentView.getStartOffset();
        int parentEnd = parentView.getEndOffset();
        Segment segment = new Segment();
        parentView.getDocument().getText(parentStart, parentEnd - parentStart, segment);
        RenderContext rc = parentView.getRenderContext();
        Locale wordBreakLocale = rc.getLocale();
        BreakIterator line = BreakIterator.getWordInstance(wordBreakLocale);
        line.setText(segment);
        if (bidiList != null) {
            line = new BidiDualIterator(line, bidiList, parentStart, parentEnd - parentStart);
        }
        int idx1 = line.first();
        int diff = parentStart - idx1;
        InetHtmlFactory viewFactory = (InetHtmlFactory)parentView.getViewFactory();
        Element parentElement = parentView.getElement();
        if (parentElement.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) {
            parentElement = parentElement.getParentElement();
        }
        int idx2 = line.next();
        ArrayList<BoxView> newChildren = new ArrayList<BoxView>();
        int childIndex = -1;
        int idxLastBreak = idx1;
        while (children.hasNext()) {
            ++childIndex;
            BoxView child = children.next();
            Object tag = child.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (child.getClass() == ContentView.class && tag == HTML.Tag.CONTENT) {
                int start = child.getStartOffset();
                int end = child.getEndOffset();
                while (idx2 != -1 && idx2 + diff <= start) {
                    idxLastBreak = idx1 = idx2;
                    idx2 = line.next();
                }
                idx1 = Math.max(idx1, start - diff);
                InlineLayout.addInlineBorders(parentView, viewFactory, parentElement, newChildren, (ContentView)child, start, true);
                if (idx2 + diff >= end || idx2 == -1) {
                    char startChar = segment.array[start - diff];
                    char endChar = segment.array[end - diff - 1];
                    if (!(startChar == ' ' || endChar == ' ' || startChar == '\u00a0' || endChar == '\u00a0' || rc.allowTabs() && InlineLayout.hasTab(segment, idx1, idx2))) {
                        if (InlineLayout.requiresFontReplace((ContentView)child)) {
                            child = (BoxView)child.createFragment(start, end);
                        }
                        ((ContentView)child).setCJKType(InlineLayout.getCJKType(segment.array, start - diff));
                        newChildren.add(child);
                        if (keepViewArray != null) {
                            keepViewArray[childIndex] = true;
                        }
                        if (end == idx2 + diff) {
                            idxLastBreak = idx1 = idx2;
                            idx2 = line.next();
                        }
                        InlineLayout.addInlineBorders(parentView, viewFactory, parentElement, newChildren, (ContentView)child, end, false);
                        continue;
                    }
                }
                while (idx2 != -1 && idx1 + diff < end) {
                    int idx2local = Math.min(idx2, end - diff);
                    char startChar = segment.array[idx1];
                    char endChar = segment.array[idx2local - 1];
                    int stringLength = InlineLayout.getContentLength(segment.array, idx1, idx2local);
                    if (stringLength > 0) {
                        BoxView view;
                        if (startChar == ' ' && endChar == ' ' && idx2local - idx1 > 1) {
                            char prevChar = startChar;
                            int startIndex = idx1;
                            for (int index = idx1 + 1; index < idx2local; ++index) {
                                char chr = segment.array[index];
                                if (prevChar == '\u00a0' && chr == ' ') {
                                    newChildren.add(InlineLayout.createVarSpace(child, parentView, viewFactory, startIndex, diff, index, true));
                                    startIndex = index;
                                }
                                prevChar = chr;
                            }
                            view = InlineLayout.createVarSpace(child, parentView, viewFactory, startIndex, diff, idx2local, prevChar != '\u00a0');
                        } else if (startChar == '\u00a0' || endChar == '\u00a0') {
                            view = InlineLayout.createVarSpace(child, parentView, viewFactory, idx1, diff, idx2local, startChar != '\u00a0' || endChar != '\u00a0');
                        } else {
                            BoxView newFragment;
                            if (child.getParent() == null) {
                                child.setParent(parentView);
                            }
                            if ((newFragment = (BoxView)child.createFragment(idx1 + diff, idx1 + stringLength + diff)).getClass() == ContentView.class) {
                                if (stringLength == 1 && Arrays.binarySearch(BREAK_CHARS, startChar) >= 0) {
                                    ((ContentView)newFragment).setBreakable(true);
                                } else {
                                    if (idx2local + diff < parentEnd && idx2local == idx2) {
                                        char nextChar = segment.array[idx2local];
                                        if (Character.isLetterOrDigit(endChar) && Character.getType(endChar) == Character.getType(nextChar)) {
                                            ((ContentView)newFragment).setBreakable(true);
                                        }
                                    }
                                    if (idx1 + diff > parentStart && idxLastBreak == idx1) {
                                        char prevChar = segment.array[idx1 - 1];
                                        if (Character.isLetterOrDigit(startChar) && Character.getType(startChar) == Character.getType(prevChar)) {
                                            ((ContentView)newFragment).setBreakable(true);
                                        }
                                    }
                                }
                            }
                            ((ContentView)newFragment).setCJKType(InlineLayout.getCJKType(segment.array, idx1));
                            view = newFragment;
                        }
                        newChildren.add(view);
                    } else {
                        boolean isWrap;
                        boolean bl = isWrap = endChar == '\n' || endChar == '\r';
                        if (isWrap && idx2local - idx1 > 1) {
                            VariableSpaceView space = InlineLayout.createVarSpace(child, parentView, viewFactory, idx1, diff, idx2local - 1, false);
                            newChildren.add(space);
                            space = viewFactory.createSpace(child.getElement(), true);
                            space.setParent(parentView);
                            space.setStartAndEndOffset(idx2local + diff - 1, idx2local + diff);
                            newChildren.add(space);
                        } else {
                            boolean isPre;
                            int spaceStart = idx1;
                            boolean bl2 = isPre = idx2local - idx1 > 1;
                            if (checkTabs) {
                                while (idx1 < idx2local) {
                                    char ch = segment.array[idx1];
                                    ++idx1;
                                    if (ch != '\t') continue;
                                    if (idx1 - spaceStart > 1) {
                                        VariableSpaceView space = InlineLayout.createSpace(child, parentView, viewFactory, spaceStart + diff, idx1 - 1 + diff, isPre, isWrap);
                                        space.setBreakable(true);
                                        newChildren.add(space);
                                    }
                                    VariableSpaceView tab = InlineLayout.createSpace(child, parentView, viewFactory, idx1 - 1 + diff, idx1 + diff, isPre, isWrap);
                                    tab.setTab(true);
                                    newChildren.add(tab);
                                    spaceStart = idx1;
                                }
                            }
                            if (spaceStart < idx2local) {
                                newChildren.add(InlineLayout.createSpace(child, parentView, viewFactory, spaceStart + diff, idx2local + diff, isPre, isWrap));
                            }
                        }
                    }
                    if (idx2local < idx2) {
                        idx1 = idx2local;
                        break;
                    }
                    idx1 = idx2;
                    idx2 = line.next();
                }
                if (idx1 + diff < parentEnd && !children.hasNext()) {
                    idx2 = Math.min(line.last(), end - diff);
                    int length = idx2 - idx1;
                    int contentLength = InlineLayout.getContentLength(segment.array, idx1 + diff, idx2 + diff);
                    if (contentLength > 0) {
                        if (child.getParent() == null) {
                            child.setParent(parentView);
                        }
                        BoxView newFragment = (BoxView)child.createFragment(idx1 + diff, idx1 + contentLength + diff);
                        newChildren.add(newFragment);
                    }
                    if (contentLength != length) {
                        VariableSpaceView space = viewFactory.createSpace(child.getElement(), false);
                        space.setParent(parentView);
                        space.setStartAndEndOffset(idx1 + diff + contentLength, idx2 + diff);
                        newChildren.add(space);
                    }
                }
                InlineLayout.addInlineBorders(parentView, viewFactory, parentElement, newChildren, (ContentView)child, end, false);
                continue;
            }
            if (childIndex > 0 && newChildren.size() > 0 && child.getClass() == VariableSpaceView.class && child.isBreak()) {
                BoxView prev = (BoxView)newChildren.get(newChildren.size() - 1);
                if (parentView.getRenderContext().collapseTailingBreak() && prev.getClass() == VariableSpaceView.class && !prev.isBreak() && prev.isBreakable() && prev.getEndOffset() - prev.getStartOffset() == 1) {
                    ((VariableSpaceView)prev).setWidth(0);
                }
                ((VariableSpaceView)child).setWidth(0);
            }
            if (keepViewArray != null) {
                keepViewArray[childIndex] = true;
            }
            newChildren.add(child);
        }
        return newChildren;
    }

    private static boolean hasTab(Segment s, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (s.array[i] != '\t') continue;
            return true;
        }
        return false;
    }

    private static boolean requiresFontReplace(ContentView child) {
        RenderContext rc = child.getRenderContext();
        if (rc != null && rc.isRefreshFontRequiredOnSplit()) {
            return true;
        }
        Segment s = new Segment();
        try {
            child.getDocument().getText(child.getStartOffset(), child.getTextLength(), s);
            if (s.count > 0 && (child.isUseSymbolTransform() || rc != null && rc.isFontFallbackAllowed() && child.getFont().canDisplayUpTo(s, s.offset, s.offset + s.count) >= 0)) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    protected static void addInlineBorders(BlockView parentView, InetHtmlFactory viewFactory, Element parentElement, List<BoxView> newChildren, ContentView child, int index, boolean left) {
        int paintMode = left ? 1 : 3;
        ArrayList<VariableSpaceView> borders = null;
        for (Element node = child.getElement(); node != parentElement && (left ? node.getStartOffset() : node.getEndOffset()) == index; node = node.getParentElement()) {
            if (!BoxPainter.createBoxPainter(child, node).isRelevant()) continue;
            VariableSpaceView space = viewFactory.createSpace(node, paintMode);
            space.setParent(parentView);
            space.setStartAndEndOffset(index, index);
            if (space.getContentWidth() <= 0) continue;
            if (borders == null) {
                borders = new ArrayList<VariableSpaceView>();
            }
            borders.add(space);
        }
        if (borders != null) {
            if (left) {
                Collections.reverse(borders);
            }
            newChildren.addAll(borders);
        }
    }

    protected static VariableSpaceView createVarSpace(BoxView child, BlockView parentView, InetHtmlFactory viewFactory, int idx1, int diff, int idx2, boolean breakable) {
        VariableSpaceView space = viewFactory.createSpace(child.getElement(), false);
        space.setParent(parentView);
        space.setStartAndEndOffset(idx1 + diff, idx2 + diff);
        space.setPre(true);
        space.setBreakable(breakable);
        return space;
    }

    private static int getCJKType(char[] c, int index) {
        int codePoint = Character.codePointAt(c, index);
        if (codePoint < 4352) {
            return 0;
        }
        if (codePoint >= 12288 && codePoint <= 12351 || codePoint == 65292) {
            return 1;
        }
        if (codePoint >= 4352 && codePoint <= 4607) {
            return 2;
        }
        if (codePoint >= 12352 && codePoint <= 12687) {
            return 2;
        }
        if (codePoint >= 13312 && codePoint <= 19903) {
            return 2;
        }
        if (codePoint >= 19456 && codePoint <= 55215) {
            return 2;
        }
        if (codePoint >= 131072 && codePoint <= 173791) {
            return 2;
        }
        if (codePoint >= 173824 && codePoint <= 177983) {
            return 2;
        }
        if (codePoint >= 177984 && codePoint <= 178207) {
            return 2;
        }
        if (codePoint >= 178208 && codePoint <= 194559) {
            return 2;
        }
        return 0;
    }

    private static VariableSpaceView createSpace(BoxView child, BoxView boxView, InetHtmlFactory viewFactory, int start, int end, boolean pre, boolean isWrap) {
        VariableSpaceView tab = viewFactory.createSpace(child.getElement(), isWrap);
        tab.setBreakable(true);
        tab.setParent(boxView);
        tab.setPre(pre);
        tab.setStartAndEndOffset(start, pre ? end : start + 1);
        return tab;
    }

    private static int getContentLength(char[] text, int start, int end) {
        if (start >= end) {
            return 0;
        }
        end = end > text.length ? text.length : end;
        char c = text[start];
        while (c <= ' ' && ++start < end) {
            c = text[start];
        }
        c = text[end - 1];
        while (start < end && c <= ' ') {
            c = text[--end - 1];
        }
        return end - start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentInfo getSegmentSize(ViewIterator iterator, boolean preLayout) {
        int maxHeight = 0;
        int width = 0;
        int minwidth = 0;
        int offset = 0;
        iterator.freeze();
        try {
            boolean isNotABreakable;
            if (!iterator.hasNext()) {
                SegmentInfo segmentInfo = new SegmentInfo(1, 0, 0, 0, null);
                return segmentInfo;
            }
            BoxView v = iterator.next();
            boolean isContentInFlow = v == null || v.isInFlow();
            boolean bl = isNotABreakable = v == null || !(v instanceof ContentView) || !((ContentView)v).isBreakable();
            if (v != null && (preLayout && v.isAbsolutePositioned() || !preLayout && !v.isInFlow())) {
                SegmentInfo segmentInfo = new SegmentInfo(1, 0, 0, 0, null);
                return segmentInfo;
            }
            do {
                int minX;
                int prefX;
                int cjkTpye;
                if (v == null) {
                    ++offset;
                    if (!iterator.hasNext()) break;
                    continue;
                }
                int n = cjkTpye = v instanceof ContentView ? ((ContentView)v).getCJKType() : 0;
                if (cjkTpye >= 2 && offset > 0) break;
                maxHeight = Math.max(maxHeight, (int)Math.ceil(v.getPreferredSpan(1)));
                if (v instanceof ILayouted) {
                    Layout layout = ((ILayouted)((Object)v)).getLayout();
                    prefX = (int)Math.ceil(layout.getPreferredSpan(0));
                    minX = (int)Math.ceil(layout.getMinimumSpan(0));
                } else {
                    prefX = (int)Math.ceil(v.getPreferredSpan(0));
                    minX = (int)Math.ceil(v.getMinimumSpan(0));
                }
                Insets margins = v.getBox().getMargins();
                int hInsets = v.getLeftInset() + v.getRightInset() + margins.left + margins.right;
                minwidth += (minX += hInsets);
                width += (prefX += hInsets);
                if (++offset == 1 && v instanceof ContentView && ((ContentView)v).isBreakable()) {
                    v = null;
                    break;
                }
                if (!iterator.hasNext()) {
                    v = null;
                    break;
                }
                v = iterator.next();
                if (cjkTpye == 1) break;
                if (cjkTpye == 2) {
                    int n2 = cjkTpye = v instanceof ContentView ? ((ContentView)v).getCJKType() : 0;
                    if (cjkTpye != 1) break;
                }
                isContentInFlow = v == null || v.isInFlow();
                boolean bl2 = isNotABreakable = v == null || !v.isBreakable();
            } while (iterator.hasNext() && isContentInFlow && isNotABreakable);
            SegmentInfo segmentInfo = new SegmentInfo(offset, width, minwidth, maxHeight, v);
            return segmentInfo;
        }
        finally {
            iterator.unfreeze();
        }
    }

    @Override
    public ViewPositionInfo getViewForPosition(Point position, Rectangle a) {
        StackManager floatManager;
        Rectangle rect = a.getBounds();
        if (this.view.getVisibility() != 0) {
            return null;
        }
        int boxX = rect.x + this.view.getLeftInset();
        int boxY = rect.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        ViewPositionInfo returnValue = null;
        StackManager stackManager = floatManager = ((BlockView)this.view).isPositionRoot() ? ((BlockView)this.view).getPositionManager(false) : null;
        if (floatManager != null && (returnValue = floatManager.getViewForPosition(position, a, 5)) != null) {
            return returnValue;
        }
        ViewPositionInfo fallback = null;
        for (Layout.PositionInfo pos : this.getChildren()) {
            if (pos.view == null) continue;
            rect.setBounds(pos.x + boxX, pos.y + boxY, pos.view.getOuterWidth(), pos.view.getOuterHeight());
            if (!rect.contains(position)) continue;
            returnValue = pos.view.getViewForPosition(position, rect);
            if (returnValue == null) {
                return new ViewPositionInfo(rect, pos.view, pos.view.getViewCount() != 0);
            }
            if (returnValue.isFallback()) {
                fallback = returnValue;
                continue;
            }
            return returnValue;
        }
        if (fallback != null) {
            return fallback;
        }
        if (floatManager != null && (returnValue = floatManager.getViewForPosition(position, a, 0)) != null) {
            return returnValue;
        }
        return null;
    }

    @Override
    protected boolean getVisibileNormalFlowElements(Rectangle2D clip, DOMUtils.ResultMap result) {
        int currentX = 0;
        int startY = 0;
        int currentY = 0;
        int lineHeight = 0;
        Layout.PositionInfo recentInfo = null;
        boolean hasVisibleElements = false;
        boolean wholeLineVisible = true;
        boolean wasBreak = false;
        DOMUtils.ResultMap lineElements = new DOMUtils.ResultMap(result.getBaseClip());
        boolean isFirstLine = !Boolean.TRUE.equals(result.getProperty(DOMUtils.ClippingProperty.FirstLineRendered));
        for (DOMUtils.ClippingProperty p : DOMUtils.ClippingProperty.values()) {
            if (!result.isSet(p)) continue;
            lineElements.setProperty(p, Boolean.TRUE);
        }
        List positionsToCheck = this.childPositions;
        if (this.view.isListItemWithMarker()) {
            positionsToCheck = this.childPositions.subList(1, this.childPositions.size());
        }
        for (Layout.PositionInfo info : positionsToCheck) {
            if (!info.paintInFlow) continue;
            Rectangle2D.Double subClip = new Rectangle2D.Double(clip.getX() - info.getX(), clip.getY() - info.getY(), clip.getWidth(), clip.getHeight());
            Rectangle span = info.view.getSpan();
            int elementY = info.y + info.view.getContentHeight();
            Element element = info.view.getElement();
            DOMUtils.DOMVisibilityResult viewResult = (DOMUtils.DOMVisibilityResult)lineElements.get(element);
            if (viewResult == null) {
                viewResult = new DOMUtils.DOMVisibilityResult();
                lineElements.put(element, viewResult);
            }
            if ((double)(span.y + span.height) < subClip.getMinY() || this.skippedByPainter(info.view)) {
                if (recentInfo == null) {
                    startY = info.y;
                    currentY = Math.max(elementY, currentY);
                    lineHeight = this.getViewLineHeight(info.view);
                    recentInfo = info;
                    wasBreak = info.view.isBreak();
                    continue;
                }
                if (currentY >= elementY || info.view.isBreak() && !wasBreak) {
                    startY = Math.min(info.y, startY);
                    lineHeight = Math.max(this.getViewLineHeight(info.view), lineHeight);
                } else {
                    this.addFillLine(Math.max(lineHeight, currentY - startY), recentInfo, lineElements, element, viewResult);
                    if (info.view instanceof VariableSpaceView && ((VariableSpaceView)info.view).isCRmarker()) {
                        recentInfo = null;
                        continue;
                    }
                    startY = info.y;
                    currentY = Math.max(elementY, currentY);
                    lineHeight = this.getViewLineHeight(info.view);
                }
                wasBreak = info.view.isBreak();
                recentInfo = info;
                continue;
            }
            if (recentInfo != null && currentY < elementY) {
                this.addFillLine(lineHeight, recentInfo, lineElements, element, viewResult);
                recentInfo = null;
            }
            boolean isTransparent = this.isTransparentContent(info.view);
            boolean isBRonContentLine = info.view.isBreak() && !wasBreak;
            int checkY = (int)(result.isSet(DOMUtils.ClippingProperty.WholeContentOnly) && !isBRonContentLine ? span.getMaxY() : (double)span.y);
            if (info.x < currentX || info.x == currentX && info.y > currentY || (double)checkY > subClip.getMaxY() && !isTransparent && !isFirstLine) {
                if (wholeLineVisible) {
                    if (hasVisibleElements) {
                        result.setProperty(DOMUtils.ClippingProperty.FirstLineRendered, Boolean.TRUE);
                        lineElements.setProperty(DOMUtils.ClippingProperty.FirstLineRendered, Boolean.TRUE);
                        isFirstLine = false;
                    }
                    result.merge(lineElements);
                }
                lineElements.clear();
                viewResult = new DOMUtils.DOMVisibilityResult();
                lineElements.put(element, viewResult);
                wholeLineVisible = true;
            }
            currentX = info.x;
            currentY = info.y;
            boolean visible = false;
            wasBreak = info.view.isBreak();
            if ((double)checkY <= subClip.getMaxY() || isFirstLine || isTransparent) {
                visible = info.view.getVisibleDOM(subClip, lineElements);
            } else {
                result.setFirstClippedContentLocation(-((RectangularShape)subClip).getY());
            }
            if (isBRonContentLine) continue;
            wholeLineVisible &= visible;
            hasVisibleElements |= visible;
        }
        if (recentInfo != null && !hasVisibleElements) {
            result.put(recentInfo.view.getElement(), new DOMUtils.DOMVisibilityResult().addFillLine(recentInfo.view, lineHeight));
        }
        if (lineElements.size() > 0 && wholeLineVisible) {
            result.merge(lineElements);
        }
        if (hasVisibleElements) {
            result.setProperty(DOMUtils.ClippingProperty.FirstLineRendered, Boolean.TRUE);
            lineElements.setProperty(DOMUtils.ClippingProperty.FirstLineRendered, Boolean.TRUE);
        }
        return hasVisibleElements;
    }

    private void addFillLine(int lineHeight, Layout.PositionInfo recentInfo, DOMUtils.ResultMap lineElements, Element element, DOMUtils.DOMVisibilityResult viewResult) {
        DOMUtils.DOMVisibilityResult partResult;
        Element recentElement = recentInfo.view.getElement();
        if (recentElement == element) {
            partResult = viewResult;
        } else {
            partResult = (DOMUtils.DOMVisibilityResult)lineElements.get(recentElement);
            if (partResult == null) {
                partResult = new DOMUtils.DOMVisibilityResult();
                lineElements.put(recentElement, partResult);
            }
        }
        partResult.addFillLine(recentInfo.view, lineHeight);
    }

    private int getViewLineHeight(BoxView view) {
        Insets margins = view.getMargins();
        int marginTopBottom = margins.top + margins.bottom;
        int viewHeight = view.getOuterHeight() + marginTopBottom;
        if (view instanceof ContentView) {
            viewHeight = view.getLineHeight() > 0 ? view.getLineHeight() : Math.max(viewHeight, (int)Math.round(1.15 * (double)view.getFontSize()));
        }
        return viewHeight;
    }

    private boolean skippedByPainter(BoxView view) {
        return view.getPainter() != null && view.getPainter().wasPainted();
    }

    private boolean isTransparentContent(BoxView view) {
        return view instanceof VariableSpaceView && !view.isBreak();
    }

    @Override
    public Rectangle getSpan() {
        return this.span;
    }

    private class ViewIterator {
        private int position;
        private BoxView stack;
        private int positionFreeze;
        private BoxView stackFreeze;

        private ViewIterator() {
        }

        public boolean hasNext() {
            return this.stack != null || this.position < InlineLayout.this.view.getViewCount();
        }

        public int getRemainingCount() {
            return InlineLayout.this.view.getViewCount() - this.position + (this.stack != null ? 1 : 0);
        }

        public BoxView next() {
            if (this.stack != null) {
                BoxView temp = this.stack;
                this.stack = null;
                return temp;
            }
            return (BoxView)InlineLayout.this.view.getView(this.position++);
        }

        public BoxView peek() {
            return this.stack != null ? this.stack : (this.position < InlineLayout.this.view.getViewCount() ? (BoxView)InlineLayout.this.view.getView(this.position) : null);
        }

        public void step() {
            if (this.stack != null) {
                this.stack = null;
            } else {
                ++this.position;
            }
        }

        public void step(int steps) {
            if (this.stack != null) {
                --steps;
                this.stack = null;
            }
            this.position += steps;
        }

        public void freeze() {
            this.positionFreeze = this.position;
            this.stackFreeze = this.stack;
        }

        public void unfreeze() {
            this.position = this.positionFreeze;
            this.stack = this.stackFreeze;
        }

        public void push(BoxView view) {
            this.stack = view;
        }
    }

    private class SegmentInfo {
        private int width;
        private int height;
        private int segmentLen;
        private View next;
        private int minWidth;

        public SegmentInfo(int segmentLen, int width, int minWidth, int height, View next) {
            this.width = width;
            this.minWidth = minWidth;
            this.height = height;
            this.segmentLen = segmentLen;
            this.next = next;
        }
    }

    private static class LevelList
    extends ArrayList<LevelInfo> {
        private static final long serialVersionUID = 1L;
        private int maxLevel = 0;
        private boolean[] levelUsed;
        private final int offset;

        public LevelList(int offset) {
            this.offset = offset;
        }

        public void reorder(List<Layout.PositionInfo> positions, int start, int length) {
            if (length <= 1) {
                return;
            }
            if (positions.get((int)(start + length - 1)).view.getAttributes().isDefined("CR")) {
                --length;
            }
            int startX = Integer.MAX_VALUE;
            int endX = Integer.MIN_VALUE;
            byte[] levels = new byte[length];
            for (int i = 0; i < length; ++i) {
                Layout.PositionInfo child = positions.get(start + i);
                startX = Math.min(child.x, startX);
                endX = Math.max(child.x + child.width, endX);
                levels[i] = (byte)this.getLevel(child.view);
            }
            Object[] children = positions.subList(start, start + length).toArray(new Layout.PositionInfo[length]);
            Bidi.reorderVisually(levels, 0, children, 0, length);
            int position = startX;
            for (int i = 0; i < length; ++i) {
                Object info = children[i];
                ((Layout.PositionInfo)info).x = position;
                position += ((Layout.PositionInfo)info).width;
                positions.set(start + i, (Layout.PositionInfo)info);
            }
        }

        @Override
        public boolean add(LevelInfo o) {
            this.maxLevel = Math.max(this.maxLevel, o.level);
            return super.add(o);
        }

        public void compile() {
            if (this.levelUsed == null) {
                this.levelUsed = new boolean[this.maxLevel + 1];
                for (LevelInfo info : this) {
                    this.levelUsed[((LevelInfo)info).level] = true;
                }
            }
            boolean allUsed = true;
            for (int i = 0; i < this.levelUsed.length; ++i) {
                allUsed = allUsed && this.levelUsed[i];
            }
            if (allUsed) {
                return;
            }
            boolean changedLevel = false;
            for (int level = this.maxLevel; level > 1; --level) {
                if (this.levelUsed[level - 1]) continue;
                for (LevelInfo info : this) {
                    if (info.level != level) continue;
                    info.level -= 2;
                    changedLevel = true;
                }
            }
            if (!changedLevel) {
                int last = -1;
                boolean mergePossible = false;
                for (LevelInfo info : this) {
                    if (last == info.level) {
                        mergePossible = true;
                        break;
                    }
                    last = info.level;
                }
                if (!mergePossible) {
                    return;
                }
            } else {
                this.levelUsed = new boolean[this.maxLevel + 1];
                for (LevelInfo info : this) {
                    this.levelUsed[((LevelInfo)info).level] = true;
                }
            }
            ArrayList<LevelInfo> compiled = new ArrayList<LevelInfo>(this.size());
            LevelInfo last = null;
            for (LevelInfo info : this) {
                if (last == null) {
                    last = info;
                    compiled.add(info);
                    continue;
                }
                if (last.level == info.level) {
                    last.end = info.end;
                    continue;
                }
                compiled.add(info);
                last = info;
            }
            this.clear();
            this.addAll(compiled);
        }

        public boolean isPrimaryLTR() {
            if (this.levelUsed == null) {
                this.levelUsed = new boolean[this.maxLevel + 1];
                for (LevelInfo info : this) {
                    this.levelUsed[((LevelInfo)info).level] = true;
                }
            }
            for (int i = 0; i < this.maxLevel; ++i) {
                if (!this.levelUsed[i]) continue;
                return i % 2 == 0;
            }
            return true;
        }

        public int getLevel(View child) {
            int start = child.getStartOffset() - this.offset;
            for (LevelInfo info : this) {
                if (info.start > start || info.end <= start) continue;
                return info.level;
            }
            return this.isPrimaryLTR() ? 0 : 1;
        }
    }

    private static class ChildIterator
    implements Iterator<BoxView> {
        private BlockView parent;
        private int index;

        public ChildIterator(BlockView parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.parent.getViewCount();
        }

        @Override
        public BoxView next() {
            if (this.index < this.parent.getViewCount()) {
                return (BoxView)this.parent.getView(this.index++);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ParagraphIterator
    extends Segment
    implements AttributedCharacterIterator {
        private final BlockView block;
        private Set<AttributedCharacterIterator.Attribute> set;
        private int start;
        private int end;
        private Document doc;
        private static final NumericShaper SHAPER = NumericShaper.getShaper(1);

        public ParagraphIterator(BlockView block) {
            this(block, block.getStartOffset(), block.getEndOffset());
        }

        public ParagraphIterator(BlockView view, int startIdx, int endIdx) {
            this.block = view;
            this.start = startIdx;
            this.end = endIdx;
            try {
                this.doc = this.block.getDocument();
                this.doc.getText(this.start, Math.max(0, this.end - this.start), this);
            }
            catch (BadLocationException e) {
                Logger.error(e);
            }
        }

        public int getContentStart() {
            int startIdx;
            for (startIdx = this.offset; startIdx < this.array.length - 1 && Character.isWhitespace(this.array[startIdx]); ++startIdx) {
            }
            return startIdx + (this.start - this.offset);
        }

        public int getContentEnd() {
            int endIdx;
            for (endIdx = this.offset + this.count; endIdx > 0 && Character.isWhitespace(this.array[endIdx - 1]); --endIdx) {
            }
            return endIdx + (this.start - this.offset);
        }

        private Set<AttributedCharacterIterator.Attribute> getSet() {
            if (this.set == null) {
                this.set = new HashSet<AttributedCharacterIterator.Attribute>();
                this.set.add(TextAttribute.BIDI_EMBEDDING);
                this.set.add(TextAttribute.RUN_DIRECTION);
            }
            return this.set;
        }

        @Override
        public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
            return this.getSet();
        }

        @Override
        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            AtomicInteger level = new AtomicInteger();
            Element leaf = this.getLeafView(this.block, this.getIndex(), level);
            if (attribute == TextAttribute.BIDI_EMBEDDING) {
                return level.get();
            }
            if (attribute == TextAttribute.NUMERIC_SHAPING) {
                return SHAPER;
            }
            if (attribute == TextAttribute.RUN_DIRECTION) {
                return StyleResolver.getAttributeValue(leaf, AttributeFinder.DIRECTION).getValue() == 0 ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL;
            }
            return null;
        }

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
            HashMap<AttributedCharacterIterator.Attribute, Object> map = new HashMap<AttributedCharacterIterator.Attribute, Object>(2);
            for (AttributedCharacterIterator.Attribute att : this.getSet()) {
                map.put(att, this.getAttribute(att));
            }
            return map;
        }

        private Element getLeafView(BlockView parent, int position, AtomicInteger level) {
            int index;
            Element elem;
            int lvl = 0;
            for (elem = parent.getElement(); elem != null && !elem.isLeaf(); elem = elem.getElement(index)) {
                byte bidi = StyleResolver.getAttributeValue(elem, AttributeFinder.UNICODEBIDI).getValue();
                byte dir = StyleResolver.getAttributeValue(elem, AttributeFinder.DIRECTION).getValue();
                lvl = Math.abs(lvl);
                if (bidi != 0) {
                    lvl = dir == 0 ? lvl + 2 - lvl % 2 : lvl + 1 + lvl % 2;
                    if (bidi == 2) {
                        lvl = -lvl;
                    }
                }
                if ((index = elem.getElementIndex(position)) >= 0) {
                    continue;
                }
                return elem;
            }
            if (level != null) {
                level.set(lvl);
            }
            return elem;
        }

        private int getBidiStatus(int position) {
            AtomicInteger level = new AtomicInteger();
            this.getLeafView(this.block, position, level);
            return level.get();
        }

        @Override
        public int getRunLimit() {
            int startLevel;
            int end = this.getEndIndex();
            int localPosition = this.getIndex();
            int currentLevel = startLevel = this.getBidiStatus(localPosition);
            while (startLevel == currentLevel && localPosition < end) {
                currentLevel = this.getBidiStatus(++localPosition);
            }
            return localPosition;
        }

        @Override
        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            return this.getRunLimit();
        }

        @Override
        public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
            return this.getRunLimit();
        }

        @Override
        public int getRunStart() {
            int startLevel;
            int start = this.block.getStartOffset();
            int localPosition = this.getIndex();
            int currentLevel = startLevel = this.getBidiStatus(localPosition);
            while (startLevel == currentLevel && localPosition > start) {
                currentLevel = this.getBidiStatus(--localPosition);
            }
            return localPosition;
        }

        @Override
        public Object clone() {
            return new ParagraphIterator(this.block);
        }

        @Override
        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            return this.getRunStart();
        }

        @Override
        public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
            return this.getRunStart();
        }
    }

    private static class LevelInfo {
        private int level;
        private int start;
        private int end;

        public LevelInfo(int level, int start, int end, LevelList parent) {
            this.level = level;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "Bidi-level " + this.level + ", location(" + this.start + ":" + this.end + ")";
        }
    }

    private static class BidiDualIterator
    extends BreakIterator {
        private int currentBase;
        private int currentLevel;
        private int currentIndex;
        private int offset;
        private int startIndex;
        private final LevelList levels;
        private final BreakIterator base;
        private final int length;
        private int baseOffset = 0;

        public BidiDualIterator(BreakIterator base, LevelList levels, int offset, int length) {
            this.base = base;
            this.levels = levels;
            this.length = length;
            this.startIndex = 0;
            while (this.startIndex < levels.size() && offset >= ((LevelInfo)levels.get(this.startIndex)).end + levels.offset) {
                ++this.startIndex;
            }
            this.offset = offset;
            if (base.getText().getBeginIndex() == 0) {
                this.baseOffset = offset;
                this.offset = 0;
            }
        }

        @Override
        public int first() {
            this.currentBase = this.base.first();
            this.currentIndex = this.startIndex - 1;
            this.nextLevel();
            return this.current();
        }

        @Override
        public int last() {
            this.currentBase = this.base.last();
            this.currentLevel = -1;
            this.currentIndex = this.levels.size() - 1;
            while (this.currentIndex >= 0) {
                int pos = ((LevelInfo)this.levels.get(this.currentIndex)).end + this.levels.offset - this.baseOffset;
                if (pos > this.offset && pos < this.offset + this.length) {
                    this.currentLevel = pos;
                    break;
                }
                --this.currentIndex;
            }
            return Math.max(this.currentBase, this.currentLevel);
        }

        @Override
        public int next(int n) {
            int result = -1;
            for (int i = 0; i < n; ++i) {
                result = this.next();
                if (result != -1) continue;
                return result;
            }
            return result;
        }

        @Override
        public int next() {
            if (this.currentBase == -1) {
                return this.nextLevel();
            }
            if (this.currentBase == this.currentLevel) {
                this.nextBase();
                this.nextLevel();
            } else if (this.currentBase < this.currentLevel || this.currentLevel == -1) {
                this.nextBase();
            } else if (this.currentLevel != -1) {
                this.nextLevel();
            }
            return this.current();
        }

        private int nextBase() {
            this.currentBase = this.base.next();
            return this.currentBase;
        }

        private int nextLevel() {
            if (this.currentLevel != -1) {
                ++this.currentIndex;
                if (this.currentIndex < this.levels.size()) {
                    this.currentLevel = ((LevelInfo)this.levels.get(this.currentIndex)).end + this.levels.offset - this.baseOffset;
                    if (this.currentLevel >= this.length + this.offset) {
                        this.currentLevel = -1;
                    }
                } else {
                    this.currentLevel = -1;
                }
            }
            return this.currentLevel;
        }

        @Override
        public int previous() {
            throw new IllegalStateException("previous cannot be used on the dual iterator");
        }

        @Override
        public int following(int offset) {
            throw new IllegalStateException("following cannot be used on the dual iterator");
        }

        @Override
        public int current() {
            if (this.currentBase == -1) {
                return this.currentLevel;
            }
            if (this.currentLevel == -1) {
                return this.currentBase;
            }
            return Math.min(this.currentBase, this.currentLevel);
        }

        @Override
        public CharacterIterator getText() {
            return this.base.getText();
        }

        @Override
        public void setText(CharacterIterator newText) {
            throw new IllegalStateException("setText cannot be used on the dual iterator");
        }
    }
}

