/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.form;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxView;
import com.inet.html.views.ControlView;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.text.Element;

public class Form
implements ActionListener,
KeyListener {
    private boolean methodPOST = false;
    private Object target;
    private HashMap<Element, BoxView> controls = new HashMap(3);
    private HashMap<String, ButtonGroup> radios;
    private final Element formElement;
    private ControlView defaultSubmit = null;
    private static final String POST_DATA_PROPERTY = "javax.swing.JEditorPane.postdata";
    private static final ViewSorter VIEW_SORTER = new ViewSorter();

    public Form(Element formElement) {
        this.formElement = formElement;
        if (formElement != null) {
            if (formElement.getAttributes().isDefined((Object)HTML.Attribute.METHOD) && "post".equalsIgnoreCase(formElement.getAttributes().getAttribute((Object)HTML.Attribute.METHOD).toString())) {
                this.methodPOST = true;
            }
            this.target = formElement.getAttributes().getAttribute((Object)HTML.Attribute.ACTION);
        }
    }

    public void addControl(BoxView control) {
        this.controls.put(control.getElement(), control);
        if (control instanceof ControlView) {
            ControlView cv = (ControlView)control;
            JComponent comp = cv.getControl();
            if (cv.getType() == 3) {
                this.addRadioButton(comp, control.getElement());
            }
            if (comp != null) {
                if (comp instanceof JButton) {
                    ((AbstractButton)comp).addActionListener(this);
                } else if (!(comp instanceof JTextArea)) {
                    comp.addKeyListener(this);
                }
            }
            if (cv.isSubmit() && !cv.isReset()) {
                this.updateDefaultControl();
            }
        }
    }

    public void removeControl(BoxView control) {
        if (control == null || this.controls == null) {
            return;
        }
        this.controls.remove(control.getElement());
        if (control instanceof ControlView) {
            ControlView cv = (ControlView)control;
            JComponent comp = cv.getControl();
            if (comp != null && comp instanceof AbstractButton && this.radios != null) {
                for (ButtonGroup group : this.radios.values()) {
                    group.remove((AbstractButton)comp);
                }
            }
            if (cv.isSubmit() && !cv.isReset()) {
                this.updateDefaultControl();
            }
        }
    }

    private void updateDefaultControl() {
        this.defaultSubmit = null;
        for (BoxView control : this.controls.values()) {
            if (!(control instanceof ControlView) || !((ControlView)control).isSubmit() || ((ControlView)control).isReset() || this.defaultSubmit != null && control.getStartOffset() >= this.defaultSubmit.getStartOffset()) continue;
            this.defaultSubmit = (ControlView)control;
        }
    }

    public boolean isEmpty() {
        return this.controls == null || this.controls.size() <= 0;
    }

    private void addRadioButton(JComponent comp, Element model) {
        ButtonGroup group;
        if (!(comp instanceof JRadioButton)) {
            return;
        }
        if (!model.getAttributes().isDefined((Object)HTML.Attribute.NAME)) {
            return;
        }
        String name = model.getAttributes().getAttribute((Object)HTML.Attribute.NAME).toString().toLowerCase();
        if (this.radios == null) {
            this.radios = new HashMap();
        }
        if ((group = this.radios.get(name)) == null) {
            group = new ButtonGroup();
            ((JRadioButton)comp).setSelected(true);
            this.radios.put(name, group);
        }
        group.add((JRadioButton)comp);
        if (model.getAttributes().isDefined((Object)HTML.Attribute.CHECKED)) {
            ((JRadioButton)comp).setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != null && e.getSource() instanceof JComponent) {
            JComponent source = (JComponent)e.getSource();
            ControlView control = this.getViewForControl(source);
            JEditorPane editor = this.getEditor(control, source);
            if (control.isSubmit()) {
                if (control.isReset()) {
                    this.resetForm(control);
                } else {
                    this.submitForm(control, editor);
                }
            }
        }
    }

    private void submitForm(ControlView activator, JEditorPane editor) {
        block6: {
            if (editor == null) {
                if (Logger.doesLog(1)) {
                    Logger.error("Could no submit " + this.formElement + " because no parent editor could be found");
                }
                return;
            }
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Object> values = new ArrayList<Object>();
            TreeSet<String> nameIdent = new TreeSet<String>();
            ArrayList<BoxView> views = new ArrayList<BoxView>(this.controls.size());
            views.addAll(this.controls.values());
            Collections.sort(views, VIEW_SORTER);
            for (BoxView view : views) {
                if (!(view instanceof ControlView)) continue;
                ControlView cv = (ControlView)view;
                Object value = cv.getValue();
                String name = cv.getName();
                if (!cv.isSuccessful(activator) || nameIdent.contains(name)) continue;
                nameIdent.add(name);
                names.add(name);
                values.add(value);
            }
            String data = this.createData(names, values);
            if (data != null && this.methodPOST) {
                this.getDocument().putProperty(POST_DATA_PROPERTY, data);
                data = null;
            }
            String string = data = data != null ? "?" + data : "";
            this.target = this.target == null || "_self".equals(this.target.toString()) ? data : (this.target instanceof UrlValue ? ((UrlValue)this.target).getResolver().getOriginalURI() + data : this.target.toString() + data);
            try {
                URL location = new URL(this.getDocument().getBase(), this.target.toString());
                editor.setPage(location);
            }
            catch (IOException e) {
                if (!Logger.doesLog(1)) break block6;
                Logger.error(e);
            }
        }
    }

    private JEditorPane getEditor(ControlView activator, JComponent source) {
        Container c;
        if (activator == null && source == null) {
            return null;
        }
        if (activator != null) {
            for (c = activator.getContainer(); c != null && !(c instanceof JEditorPane); c = c.getParent()) {
            }
            if (c != null) {
                return (JEditorPane)c;
            }
        }
        if (source != null) {
            for (c = source; c != null && !(c instanceof JEditorPane); c = c.getParent()) {
            }
            if (c != null) {
                return (JEditorPane)c;
            }
        }
        return null;
    }

    private InetHtmlDocument getDocument() {
        return (InetHtmlDocument)this.formElement.getDocument();
    }

    private String createData(ArrayList<String> names, ArrayList<Object> values) {
        StringBuilder buf = new StringBuilder();
        if (values != null && values.size() > 0) {
            for (int i = 0; i < names.size(); ++i) {
                if (buf.length() > 0) {
                    buf.append('&');
                }
                String key = names.get(i);
                Object value = values.get(i);
                if (value == null || !(value instanceof Object[])) {
                    try {
                        buf.append(URLEncoder.encode(key, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e1) {
                        buf.append(key);
                    }
                    if (value == null) continue;
                    buf.append("=");
                    try {
                        buf.append(URLEncoder.encode(value.toString(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        buf.append(value);
                    }
                    continue;
                }
                buf.append(this.buildMultiValueString(key, (Object[])value));
            }
            return buf.toString();
        }
        return null;
    }

    private String buildMultiValueString(String name, Object[] values) {
        StringBuilder buf;
        block6: {
            buf = new StringBuilder();
            try {
                name = URLEncoder.encode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if (!Logger.doesLog(1)) break block6;
                Logger.error("Could not encode the URL parameter key '" + name + "'");
            }
        }
        for (Object entry : values) {
            String value;
            block7: {
                if (buf.length() > 0) {
                    buf.append('&');
                }
                value = entry.toString();
                try {
                    value = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    if (!Logger.doesLog(1)) break block7;
                    Logger.error("Could not encode the URL parameter value '" + value + "'");
                }
            }
            buf.append(name).append('=').append(value);
        }
        return buf.toString();
    }

    private void resetForm(ControlView activator) {
    }

    private ControlView getViewForControl(JComponent comp) {
        if (comp == null) {
            return null;
        }
        for (BoxView view : this.controls.values()) {
            ControlView cView;
            if (view == null || !(view instanceof ControlView) || (cView = (ControlView)view).getControl() != comp) continue;
            return cView;
        }
        return null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n' && e.getSource() != null && e.getSource() instanceof JComponent) {
            JComponent source = (JComponent)e.getSource();
            ControlView control = this.getViewForControl(source);
            JEditorPane editor = this.getEditor(control, source);
            this.submitForm(this.defaultSubmit, editor);
        }
    }

    private static class ViewSorter
    implements Comparator<BoxView> {
        private ViewSorter() {
        }

        @Override
        public int compare(BoxView o1, BoxView o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getStartOffset() - o2.getStartOffset();
        }
    }
}

