/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.CssDocument;
import com.inet.html.InetHtmlDocument;
import com.inet.html.ViewPainter;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.OverflowWrap;
import com.inet.html.utils.ColorUtils;
import com.inet.html.utils.DOMUtils;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.html.utils.ViewUtils;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.InlineView;
import com.inet.html.views.TableBoxPainter;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import com.inet.html.views.layouts.TableLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class TableView
extends BoxView
implements ILayouted {
    private BoxView caption;
    private TableLayout layout = new TableLayout(this);
    private TableContainer container;
    private Appendable insertPosition;
    private int borderValue = -1;
    private boolean hardLayout;
    private Rectangle p;

    public TableView(Element elem) {
        this(elem, null);
    }

    public TableView(Element elem, ViewPainter viewPainter) {
        super(elem, viewPainter);
        this.container = new TableContainer(elem);
    }

    @Override
    public void setParent(View parent) {
        if (this.getParent() != null && this.getParent() == parent) {
            return;
        }
        if (parent == null) {
            if (this.layout != null && this.layout.getChildren() != null) {
                List<Layout.PositionInfo> list = this.layout.getChildren();
                for (Layout.PositionInfo pos : list) {
                    if (pos.view == null) continue;
                    pos.view.setParent(null);
                }
                this.layout.getChildren().clear();
            }
            super.setParent(null);
            return;
        }
        super.setParent(parent);
        this.insertPosition = this.container;
        if (this.layout.isBorderCollapse()) {
            this.getBox().setPadding(new Insets(0, 0, 0, 0));
        }
        this.appendChildElements(this.getElement());
    }

    @Override
    protected void setPropertiesFromAttributes(boolean inline) {
        IntegerValue border;
        super.setPropertiesFromAttributes(inline);
        FloatValue floatValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.FLOAT_ALIGN);
        if (floatValue != null && floatValue.getFloat() == 1) {
            this.setJustification((byte)1);
        }
        if ((border = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.BORDER)) == null && this.getElement().getAttributes().isDefined((Object)HTML.Attribute.BORDER)) {
            border = new IntegerValue(1);
        }
        if (border != null) {
            int collapseOffset;
            this.borderValue = border.getInt();
            Insets borderInsets = this.getBox().getBorderInsets();
            boolean singleLine = this.getLayout().isBorderCollapse() && this.getHTMLBorderValue() == 1;
            int n = collapseOffset = this.getLayout().isBorderCollapse() ? 1 : 0;
            if (borderInsets.left == 0) {
                this.getBox().setBorderStyles().left = 7;
                this.getBox().setBorderInsets().left = Math.max(0, this.borderValue - collapseOffset);
            }
            if (borderInsets.right == 0) {
                this.getBox().setBorderStyles().right = 7;
                this.getBox().setBorderInsets().right = Math.max(0, this.borderValue - collapseOffset);
            }
            if (borderInsets.top == 0) {
                this.getBox().setBorderStyles().top = 7;
                this.getBox().setBorderInsets().top = Math.max(0, this.borderValue - collapseOffset);
            }
            if (borderInsets.bottom == 0) {
                this.getBox().setBorderStyles().bottom = 7;
                this.getBox().setBorderInsets().bottom = Math.max(0, this.borderValue - collapseOffset);
            }
            ColorValue topColor = this.getAttributeNonDefault(AttributeFinder.BORDER_TOP_COLOR);
            ColorValue bottomColor = this.getAttributeNonDefault(AttributeFinder.BORDER_BOTTOM_COLOR);
            ColorValue leftColor = this.getAttributeNonDefault(AttributeFinder.BORDER_LEFT_COLOR);
            ColorValue rightColor = this.getAttributeNonDefault(AttributeFinder.BORDER_RIGHT_COLOR);
            if (topColor == null) {
                this.setBorderTopColor(new ColorValue(singleLine ? ColorUtils.get3DDark() : ColorUtils.get3DLight()));
            } else {
                this.setBorderTopColor(new ColorValue(singleLine ? topColor.getValue().darker() : topColor.getValue().brighter()));
            }
            if (leftColor == null) {
                this.setBorderLeftColor(new ColorValue(singleLine ? ColorUtils.get3DDark() : ColorUtils.get3DLight()));
            } else {
                this.setBorderLeftColor(new ColorValue(singleLine ? leftColor.getValue().darker() : leftColor.getValue().brighter()));
            }
            if (bottomColor == null) {
                this.setBorderBottomColor(new ColorValue(ColorUtils.get3DDark()));
            } else {
                this.setBorderBottomColor(new ColorValue(bottomColor.getValue().darker()));
            }
            if (rightColor == null) {
                this.setBorderRightColor(new ColorValue(ColorUtils.get3DDark()));
            } else {
                this.setBorderRightColor(new ColorValue(rightColor.getValue().darker()));
            }
            this.getBox().updateRelevance();
        }
    }

    private <T> T getAttributeNonDefault(AttributeFinder<T> finder) {
        MutableAttributeSet defaultSet = ((CssDocument)this.getDocument()).getStyleResolver().getDefaultSet((Object)HTML.Tag.TABLE);
        TemporaryStyle.Attribute att = TemporaryStyle.getAttribute(finder.getCSSAttribute());
        T value = StyleResolver.getAttributeValue(this.getElement(), finder);
        if (defaultSet.getAttribute((Object)att) == value) {
            return null;
        }
        return value;
    }

    @Override
    protected IBoxPainter createBoxPainter() {
        return BoxPainter.createRootPainter(this);
    }

    private void appendChildElements(Element root) {
        int n = root.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element elem = root.getElement(i);
            if (this.getName(elem) == HTML.Tag.FORM) {
                this.appendChildElements(elem);
                continue;
            }
            Appendable newPosition = this.insertPosition.append(elem);
            if (newPosition == null) {
                newPosition = this.appendFallBack(this.insertPosition, elem);
                if (newPosition != null) {
                    this.insertPosition = newPosition;
                }
            } else {
                this.insertPosition = newPosition;
            }
            if (!TableView.isTableContainerElement(elem)) continue;
            this.appendChildElements(elem);
        }
        if (this.insertPosition.getParent() != null) {
            this.insertPosition = this.insertPosition.getParent();
        }
    }

    private Appendable appendFallBack(Appendable insertPosition2, Element elem) {
        if (ElementUtils.isEndMarker(elem)) {
            return null;
        }
        Object name = this.getName(elem);
        if (name != null && !(name instanceof HTML.Tag) && name.toString().startsWith("![")) {
            return null;
        }
        if (name == HTML.Tag.CONTENT && elem.getEndOffset() == elem.getStartOffset()) {
            return null;
        }
        TableRowInfo row = null;
        if (insertPosition2 instanceof TableColumnInfo) {
            insertPosition2 = insertPosition2.getParent();
        }
        if (insertPosition2 instanceof TableColumnGroupInfo) {
            if (name == HTML.Tag.CONTENT) {
                return null;
            }
            if (name == HTML.Tag.TABLE) {
                return insertPosition2.getParent();
            }
            insertPosition2 = insertPosition2.getParent();
        }
        if (insertPosition2 instanceof TableRowInfo) {
            row = (TableRowInfo)insertPosition2;
        }
        if (insertPosition2 instanceof TableContainer) {
            TableContainer tableContainer = (TableContainer)insertPosition2;
            if (tableContainer.body == null) {
                tableContainer.body = new TableRowGroup(elem, tableContainer, 13);
            }
            insertPosition2 = tableContainer.body;
        }
        if (insertPosition2 instanceof TableRowGroup) {
            List<TableRowInfo> rows = ((TableRowGroup)insertPosition2).getRows();
            if (rows.size() > 0) {
                row = rows.get(rows.size() - 1);
            } else {
                row = new TableRowInfo(elem, (TableRowGroup)insertPosition2);
                rows.add(row);
            }
        }
        if (row != null) {
            row.forcedAdd(elem);
        } else {
            int startOffset = elem.getStartOffset();
            try {
                String content = this.getDocument().getText(startOffset, elem.getEndOffset() - startOffset);
                Logger.warning("Table malformed, content may be hidden: '" + content + "'");
            }
            catch (BadLocationException e) {
                Logger.warning("Table malformed, content may be hidden: '" + elem.toString() + "'");
            }
        }
        return null;
    }

    public void appendElement(Element elem) {
        this.container.append(elem);
    }

    public static boolean isTableContainerElement(Element elem) {
        if (elem.isLeaf()) {
            return false;
        }
        int display = TableView.getDisplayType(elem);
        switch (display) {
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private static int getDisplayType(Element elem) {
        DisplayValue display = StyleResolver.getAttributeValue(elem, AttributeFinder.DISPLAY);
        if (display != null) {
            return display.getDisplay();
        }
        return 3;
    }

    @Override
    public Rectangle performLayout(boolean hard) {
        if (this.layout != null) {
            if (hard || this.getStatus() != 0) {
                this.p = this.layout.layout(this.hardLayout || hard);
            }
            this.hardLayout = false;
            this.setStatusLocal(0);
        }
        return this.p != null ? this.p : new Rectangle();
    }

    @Override
    public void performLayoutWidth() {
        int before = this.layout.getCurrentWidth();
        if (this.layout != null) {
            this.layout.layoutWidth();
        }
        if (before != this.layout.getCurrentWidth()) {
            this.setStatus(1);
            this.hardLayout = true;
        }
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (this.layout != null) {
            return this.layout.getPreferredSpan(axis);
        }
        return 0.0f;
    }

    @Override
    public float getMinimumSpan(int axis) {
        if (this.layout != null) {
            return this.layout.getMinimumSpan(axis);
        }
        return 0.0f;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        return this.layout.modelToView(pos, a, b);
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        return this.layout.viewToModel(x, y, a, biasReturn);
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        if (this.layout == null) {
            return;
        }
        if (this.getVisibility() != 0) {
            return;
        }
        Rectangle rect = allocation.getBounds();
        this.getBox().paintBackground(g, rect.x, rect.y, rect.width, rect.height, this);
        int x = rect.x + this.getLeftInset();
        int y = rect.y + this.getTopInset() + this.getContentVerticalOffset();
        Rectangle clip = g.getClipBounds();
        for (Layout.PositionInfo pos : this.layout.getChildren()) {
            IBoxPainter cellBox;
            if (pos.view == null) continue;
            TableLayout.CellPositionInfo cellPos = (TableLayout.CellPositionInfo)pos;
            rect.setBounds(pos.x + x, pos.y + y, pos.view.getOuterWidth(), pos.view.getOuterHeight());
            if (cellPos.getColumnPainter() != null) {
                cellPos.getColumnPainter().paintBackground(g, rect.x, rect.y, rect.width, rect.height, pos.view);
            }
            if (cellPos.getRowPainter() != null) {
                cellPos.getRowPainter().paintBackground(g, rect.x, rect.y, rect.width, rect.height, pos.view);
            }
            if (!((cellBox = pos.view.getBox()) instanceof TableBoxPainter) || clip != null && !rect.intersects(clip)) continue;
            ((TableBoxPainter)cellBox).paintBackground(g, rect.x, rect.y, rect.width, rect.height, pos.view);
        }
        for (Layout.PositionInfo pos : this.layout.getChildren()) {
            if (pos.view == null) continue;
            rect.setBounds(pos.x + x, pos.y + y, pos.view.getOuterWidth(), pos.view.getOuterHeight());
            IBoxPainter cellBox = pos.view.getBox();
            if (!(cellBox instanceof TableBoxPainter) || clip != null && !rect.intersects(clip)) continue;
            TableBoxPainter tableBoxPainter = (TableBoxPainter)cellBox;
            tableBoxPainter.setCollapseMode(this.layout.isBorderCollapse());
            tableBoxPainter.paintBorders(g, rect.x, rect.y, rect.width, rect.height);
        }
        for (Layout.PositionInfo pos : this.layout.getChildren()) {
            if (pos.view == null) continue;
            rect.setBounds(pos.x + x, pos.y + y, pos.view.getOuterWidth(), pos.view.getOuterHeight());
            pos.view.paint(g, rect);
        }
        if (!this.getLayout().isBorderCollapse()) {
            this.getBox().paint(g, allocation.getBounds(), 4, this);
        }
    }

    public TableContainer getTableContainer() {
        return this.container;
    }

    @Override
    public void performPreLayout() {
        if (this.layout != null && this.getStatus() != 0) {
            this.hardLayout = true;
            this.layout.preLayout();
            this.setStatusLocal(1);
            this.setStatus(1);
        }
    }

    @Override
    public TableLayout getLayout() {
        return this.layout;
    }

    @Override
    public void predictWidth(int width) {
        if (this.layout != null) {
            this.layout.predictWidth(width);
        }
    }

    public String toString() {
        return "Table " + this.getElement();
    }

    @Override
    public void performLayoutVAlign(int baseline) {
        this.layout.layoutVerticalAlign((int)this.getAlignment(1), baseline);
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        int start = ViewUtils.getOffset(e);
        int end = start + ViewUtils.getLength(e);
        if (Logger.doesLog(4)) {
            Logger.debug("TableView:insertUpdate");
        }
        if (start <= this.getEndOffset() && end >= this.getStartOffset()) {
            for (Layout.PositionInfo pos : this.layout.getChildren()) {
                int contentStart = pos.view.getStartOffset();
                int contentEnd = pos.view.getEndOffset();
                if (start >= contentEnd || end < contentStart) continue;
                pos.view.insertUpdate(e, a, f);
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        int start = ViewUtils.getOffset(e);
        int end = start + ViewUtils.getLength(e);
        if (Logger.doesLog(4)) {
            Logger.debug("TableView:insertUpdate");
        }
        if (start <= this.getEndOffset() && end >= this.getStartOffset()) {
            for (Layout.PositionInfo pos : this.layout.getChildren()) {
                int contentStart = pos.view.getStartOffset();
                int contentEnd = pos.view.getEndOffset();
                if (start >= contentEnd || end < contentStart) continue;
                pos.view.removeUpdate(e, a, f);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        int start = ViewUtils.getOffset(e);
        int end = start + ViewUtils.getLength(e);
        if (Logger.doesLog(4)) {
            Logger.debug("TableView:insertUpdate");
        }
        if (start <= this.getEndOffset() && end >= this.getStartOffset()) {
            for (Layout.PositionInfo pos : this.layout.getChildren()) {
                int contentStart = pos.view.getStartOffset();
                int contentEnd = pos.view.getEndOffset();
                if (start >= contentEnd || end < contentStart) continue;
                pos.view.changedUpdate(e, a, f);
            }
        }
    }

    public int getHTMLBorderValue() {
        return this.borderValue;
    }

    @Override
    protected boolean isCanceledByPainter(Graphics g, Shape allocation) {
        return false;
    }

    @Override
    public int getViewCount() {
        if (this.layout != null) {
            return this.layout.getViewCount();
        }
        return super.getViewCount();
    }

    @Override
    public View getView(int n) {
        if (this.layout != null) {
            return this.layout.getChildren().get((int)n).view;
        }
        return super.getView(n);
    }

    @Override
    public Rectangle getSpan() {
        return this.layout.getSpan();
    }

    @Override
    public boolean getVisibleDOM(Rectangle2D clip, DOMUtils.ResultMap result) {
        DOMUtils.ResultMap checkMap = new DOMUtils.ResultMap(result.getBaseClip());
        boolean hasViews = this.getLayout().getVisibleElements(clip, checkMap);
        DOMUtils.DOMVisibilityResult entry = (DOMUtils.DOMVisibilityResult)result.get(this.getElement());
        if (entry == null) {
            entry = new DOMUtils.DOMVisibilityResult(this, hasViews ? DOMUtils.Visibility.visible : DOMUtils.Visibility.dummy);
            result.put(this.getElement(), entry);
        }
        entry.setAttribute((Object)CSS.Attribute.WIDTH, new LengthUnit(this.getContentWidth()));
        entry.setAttribute((Object)HTML.Attribute.WIDTH, null);
        if ((double)this.getMinimumSpan(0) > clip.getWidth()) {
            entry.setAttribute((Object)CSS.Attribute.OVERFLOW_WRAP, OverflowWrap.getOverflow((byte)1));
        }
        if (hasViews) {
            this.findRowHeights(this.getElement(), result);
            result.merge(checkMap);
        } else {
            entry.setAttribute((Object)HTML.Attribute.HEIGHT, new LengthUnit(this.getOuterHeight()));
        }
        return hasViews;
    }

    public void findRowHeights(Element root, DOMUtils.ResultMap cellMap) {
        if (root.isLeaf()) {
            return;
        }
        int lineHeight = -1;
        TableRowInfo rowInfo = null;
        byte rootDisplay = StyleResolver.getAttributeValue(root, AttributeFinder.DISPLAY).getDisplay();
        if (rootDisplay == 10) {
            rowInfo = this.findRow(root);
        }
        boolean rowVisible = false;
        for (int i = 0; i < root.getElementCount(); ++i) {
            int display;
            Element e = root.getElement(i);
            DisplayValue displayValue = StyleResolver.getAttributeValue(e, AttributeFinder.DISPLAY);
            int n = display = displayValue != null ? (int)displayValue.getDisplay() : 3;
            if (rowInfo != null && display == 12) {
                TableCellInfo cellInfo = rowInfo.getCell(e);
                if (cellInfo == null) continue;
                DOMUtils.DOMVisibilityResult cellResult = (DOMUtils.DOMVisibilityResult)cellMap.get(e);
                if (cellResult != null) {
                    rowVisible |= cellResult.getVisibility() == DOMUtils.Visibility.visible;
                    cellResult.setAttribute((Object)CSS.Attribute.HEIGHT, new LengthUnit("auto"));
                    if (cellInfo.getColspan() > 1) {
                        cellResult.setAttribute((Object)CSS.Attribute.WIDTH, new LengthUnit("auto"));
                    }
                }
                if (cellInfo.getRowspan() != 1) continue;
                int cellHeight = cellInfo.getContent().getOuterHeight();
                lineHeight = Math.max(lineHeight, cellHeight);
                continue;
            }
            if (display == 11 || display == 16) {
                DOMUtils.markAllVisible(e, cellMap);
                continue;
            }
            if (display == 12) continue;
            this.findRowHeights(e, cellMap);
        }
        if (rowInfo != null) {
            if (rowVisible) {
                for (TableCellInfo cell : rowInfo.cells) {
                    Element e = cell.getContent().getElement();
                    DOMUtils.DOMVisibilityResult cellResult = (DOMUtils.DOMVisibilityResult)cellMap.get(e);
                    if (cellResult != null) continue;
                    cellMap.put(e, new DOMUtils.DOMVisibilityResult(cell.getContent(), DOMUtils.Visibility.dummy));
                }
            }
            if (lineHeight > 0) {
                DOMUtils.DOMVisibilityResult rowResult = new DOMUtils.DOMVisibilityResult(rowInfo.elem, DOMUtils.Visibility.visible);
                cellMap.put(root, rowResult);
                for (TableCellInfo cell : rowInfo.cells) {
                    Element e = cell.getContent().getElement();
                    DOMUtils.DOMVisibilityResult cellResult = (DOMUtils.DOMVisibilityResult)cellMap.get(e);
                    if (cellResult == null || cell.getRowspan() != 1) continue;
                    IBoxPainter cellBox = cell.content.getBox();
                    int padBorder = cellBox.getTotalHeightGain() + cell.content.getContentVerticalOffset();
                    cellResult.setAttribute((Object)CSS.Attribute.HEIGHT, new LengthUnit(lineHeight - padBorder));
                }
            }
        }
    }

    private TableRowInfo findRow(Element rowElement) {
        TableRowInfo row;
        TableRowInfo tableRowInfo = row = this.container.body != null ? this.container.body.getRow(rowElement) : null;
        if (row != null) {
            return row;
        }
        TableRowInfo tableRowInfo2 = row = this.container.header != null ? this.container.header.getRow(rowElement) : null;
        if (row != null) {
            return row;
        }
        return this.container.footer != null ? this.container.footer.getRow(rowElement) : null;
    }

    private Object getName(Element e) {
        return e.getAttributes().getAttribute(StyleConstants.NameAttribute);
    }

    public class TableContainer
    extends Appendable {
        private TableRowGroup header;
        private TableRowGroup footer;
        private TableRowGroup body;
        private List<TableColumnGroupInfo> colDescriptions;

        public TableContainer(Element elem) {
            super(null);
        }

        @Override
        Appendable appendHere(Element elem) {
            int display = TableView.getDisplayType(elem);
            switch (display) {
                case 15: {
                    if (this.footer == null) {
                        this.footer = new TableRowGroup(elem, this, display);
                    }
                    return this.footer;
                }
                case 14: {
                    if (this.header == null) {
                        this.header = new TableRowGroup(elem, this, display);
                    }
                    return this.header;
                }
                case 13: {
                    if (this.body == null) {
                        this.body = new TableRowGroup(elem, this, display);
                    }
                    return this.body;
                }
                case 17: {
                    TableView.this.caption = (BoxView)TableView.this.getViewFactory().create(elem);
                    return this;
                }
                case 10: {
                    if (this.body == null) {
                        this.body = new TableRowGroup(elem, this, display);
                    }
                    return this.body.append(elem);
                }
                case 12: {
                    if (this.body == null) {
                        this.body = new TableRowGroup(null, this, display);
                    }
                    this.body.append(elem);
                    return this;
                }
                case 11: {
                    if (this.colDescriptions == null) {
                        this.colDescriptions = new ArrayList<TableColumnGroupInfo>();
                    }
                    TableColumnGroupInfo info = new TableColumnGroupInfo(elem, this);
                    this.colDescriptions.add(info);
                    info.appendHere(elem);
                    return info;
                }
                case 16: {
                    if (this.colDescriptions == null) {
                        this.colDescriptions = new ArrayList<TableColumnGroupInfo>();
                    }
                    this.colDescriptions.add(new TableColumnGroupInfo(elem, this));
                    return this.colDescriptions.get(this.colDescriptions.size() - 1);
                }
            }
            return null;
        }

        public TableRowGroup getHeader() {
            return this.header;
        }

        public TableRowGroup getFooter() {
            return this.footer;
        }

        public TableRowGroup getBody() {
            return this.body;
        }

        public List<TableColumnGroupInfo> getColDescription() {
            return this.colDescriptions;
        }
    }

    private abstract class Appendable {
        private Appendable parent;

        public Appendable(Appendable parent) {
            this.parent = parent;
        }

        abstract Appendable appendHere(Element var1);

        public Appendable getParent() {
            return this.parent;
        }

        Appendable append(Element elem) {
            Appendable app = this.appendHere(elem);
            if (app == null) {
                if (this.getParent() != null) {
                    return this.getParent().append(elem);
                }
                return null;
            }
            return app;
        }
    }

    public class TableColumnInfo
    extends Appendable {
        private Element source;

        public TableColumnInfo(Element elem, TableColumnGroupInfo parent) {
            super(parent);
            this.source = elem;
        }

        @Override
        Appendable appendHere(Element elem) {
            return null;
        }

        public Element getSource() {
            return this.source;
        }
    }

    public class TableColumnGroupInfo
    extends Appendable {
        private List<TableColumnInfo> columns;
        private Element source;

        public TableColumnGroupInfo(Element elem, TableContainer parent) {
            super(parent);
            this.source = elem;
            this.columns = new ArrayList<TableColumnInfo>();
        }

        @Override
        Appendable appendHere(Element elem) {
            int display = TableView.getDisplayType(elem);
            switch (display) {
                case 11: {
                    TableColumnInfo column = new TableColumnInfo(elem, this);
                    this.columns.add(column);
                    return this;
                }
            }
            return null;
        }

        public Element getSource() {
            return this.source;
        }

        public List<TableColumnInfo> getColumns() {
            return this.columns;
        }
    }

    public class TableRowInfo
    extends Appendable {
        private List<TableCellInfo> cells;
        private List<TableCellInfo> errorCells;
        private Element elem;

        public TableRowInfo(Element elem, TableRowGroup parent) {
            super(parent);
            this.elem = elem;
            this.cells = new ArrayList<TableCellInfo>();
        }

        public TableCellInfo getCell(Element cellElement) {
            TableCellInfo info = this.cells.stream().filter(c -> ((TableCellInfo)c).content.getElement() == cellElement).findFirst().orElse(null);
            if (info != null) {
                return info;
            }
            return this.errorCells.stream().filter(c -> ((TableCellInfo)c).content.getElement() == cellElement).findFirst().orElse(null);
        }

        public List<TableCellInfo> getCells() {
            if (this.errorCells != null) {
                ArrayList<TableCellInfo> allCells = new ArrayList<TableCellInfo>(this.cells);
                allCells.addAll(this.errorCells);
                return allCells;
            }
            return this.cells;
        }

        public int countValidCells() {
            return this.cells.size();
        }

        public int countErrorCells() {
            return this.errorCells != null ? this.errorCells.size() : 0;
        }

        @Override
        Appendable appendHere(Element elem) {
            int display = TableView.getDisplayType(elem);
            switch (display) {
                case 1: {
                    break;
                }
                case 12: {
                    TableCellInfo cell = new TableCellInfo(elem, this);
                    this.cells.add(cell);
                    return this;
                }
            }
            return null;
        }

        void forcedAdd(Element elem) {
            TableCellInfo cellInfo;
            if (elem.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT) {
                int startOffset = elem.getStartOffset();
                try {
                    if (" ".equals(TableView.this.getDocument().getText(startOffset, elem.getEndOffset() - startOffset))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (this.errorCells == null) {
                this.errorCells = new ArrayList<TableCellInfo>();
            }
            if ((cellInfo = new TableCellInfo(elem, this)).content != null) {
                this.errorCells.add(cellInfo);
            }
        }

        public String toString() {
            return "Table row with " + this.cells.size() + " cells: " + this.cells.toString();
        }

        public Element getSource() {
            return this.elem;
        }
    }

    public class TableRowGroup
    extends Appendable {
        public static final int TYPE_THEAD = 1;
        public static final int TYPE_TBODY = 2;
        public static final int TYPE_TFOOT = 3;
        private List<TableRowInfo> rows;
        private int type;
        private Element elem;

        public TableRowGroup(Element elem, TableContainer parent, int displayType) {
            super(parent);
            this.elem = elem;
            this.rows = new ArrayList<TableRowInfo>();
            this.type = displayType;
        }

        public TableRowInfo getRow(Element rowElement) {
            return this.rows.stream().filter(r -> ((TableRowInfo)r).elem == rowElement).findFirst().orElse(null);
        }

        public List<TableRowInfo> getRows() {
            return this.rows;
        }

        @Override
        Appendable appendHere(Element elem) {
            int display = TableView.getDisplayType(elem);
            switch (display) {
                case 1: {
                    Object name = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
                    if (name != HTML.Tag.TR) break;
                }
                case 10: {
                    TableRowInfo row = new TableRowInfo(elem, this);
                    this.rows.add(row);
                    return row;
                }
                case 12: {
                    TableRowInfo row;
                    if (this.rows.size() > 0) {
                        row = this.rows.get(this.rows.size() - 1);
                    } else {
                        row = new TableRowInfo(elem, this);
                        this.rows.add(row);
                    }
                    return row.append(elem);
                }
            }
            return null;
        }

        public String toString() {
            String result = "";
            switch (this.type) {
                case 1: {
                    result = "THEAD";
                    break;
                }
                case 2: {
                    result = "TBODY";
                    break;
                }
                case 3: {
                    result = "TFOOT";
                }
            }
            return result + " with " + this.rows.size() + " rows";
        }
    }

    public class TableCellInfo
    extends Appendable {
        private int rowspan;
        private int colspan;
        private BoxView content;

        public TableCellInfo(Element elem, TableRowInfo parent) {
            IntegerValue colSpanUnit;
            IntegerValue rowSpanUnit;
            super(parent);
            this.rowspan = 1;
            this.colspan = 1;
            this.content = (BoxView)TableView.this.getViewFactory().create(elem);
            if (this.content != null) {
                if (this.content instanceof InlineView && elem.getDocument() instanceof InetHtmlDocument) {
                    InetHtmlDocument doc;
                    InetHtmlDocument inetHtmlDocument = doc = (InetHtmlDocument)elem.getDocument();
                    Objects.requireNonNull(inetHtmlDocument);
                    InetHtmlDocument.ImpliedElement impl = new InetHtmlDocument.ImpliedElement(inetHtmlDocument, elem.getParentElement());
                    impl.replace(0, 0, new Element[]{elem});
                    this.content = (BoxView)TableView.this.getViewFactory().create(impl);
                }
                this.content.setParent(TableView.this);
            }
            if (this.content != null) {
                TableView.this.replace(TableView.this.getViewCount(), 0, new View[]{this.content});
            }
            if ((rowSpanUnit = StyleResolver.getAttributeValue(elem, AttributeFinder.ROW_SPAN)) != null) {
                this.rowspan = Math.max(rowSpanUnit.getInt(), 1);
            }
            if ((colSpanUnit = StyleResolver.getAttributeValue(elem, AttributeFinder.COL_SPAN)) != null) {
                this.colspan = Math.max(colSpanUnit.getInt(), 1);
            }
        }

        @Override
        Appendable appendHere(Element elem) {
            return null;
        }

        public int getColspan() {
            return this.colspan;
        }

        public void setColspan(int span) {
            this.colspan = span;
        }

        public int getRowspan() {
            return this.rowspan;
        }

        public BoxView getContent() {
            return this.content;
        }

        public String toString() {
            return "CellInfo for " + this.content;
        }
    }
}

