/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.CssDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.InetHtmlFontFactory;
import com.inet.html.ViewPainter;
import com.inet.html.actions.BeginEndLineAction;
import com.inet.html.edit.EditPainter;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.html.utils.ViewUtils;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.RenderContext;
import com.inet.html.views.form.FormRegistry;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class HtmlRootView
extends BlockView
implements Cloneable {
    private boolean mustRebuild = true;
    private boolean initiated = false;
    private boolean layouted = false;
    private float oldWidth;
    private float oldHeight;
    private long nextLayout;
    private Shape lastCursor;
    private int lastCursorPos = Integer.MAX_VALUE;
    private Position.Bias lastCursorBias;
    private boolean updateCaret = false;
    private final Object update_sync_lock = new Object();
    private boolean widthSet;
    private Insets containerInsets = new Insets(0, 0, 0, 0);
    public static final int IMAGE_LOAD_TIMEOUT = 30000;
    private final RenderContext renderContext;
    private boolean layoutRunning;
    private Thread layoutThread;
    private Rectangle span;
    private boolean isForcedReloadPending = false;
    private boolean throwAsRuntime = false;
    private List<EditPainter> overlayPainters;

    public HtmlRootView(Element elem) {
        super(elem);
        this.renderContext = new RenderContext(elem != null ? elem.getDocument() : null, new FormRegistry(), null);
    }

    public HtmlRootView(Element elem, ViewPainter painter, InetHtmlFontFactory fontFactory) {
        super(elem, painter);
        this.renderContext = new RenderContext(elem != null ? elem.getDocument() : null, new FormRegistry(), fontFactory);
    }

    @Override
    public void forceLayout() {
        this.forceLayout(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceLayout(long timeout) {
        if (this.renderContext.isBlockOnImageLoad()) {
            if (Logger.doesLog(4)) {
                Logger.debug("Forcelayout blocked, cause: blocking render mode.");
            }
            return;
        }
        if (Logger.doesLog(4)) {
            Logger.debug("Forcelayout in " + timeout + "ms");
        }
        if (timeout == 0L) {
            this.initLayout(true, true);
            return;
        }
        long now = System.currentTimeMillis();
        HtmlRootView htmlRootView = this;
        synchronized (htmlRootView) {
            if (now > this.nextLayout && !this.isForcedReloadPending) {
                this.isForcedReloadPending = true;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (System.currentTimeMillis() < HtmlRootView.this.nextLayout) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        if (HtmlRootView.this.initiated) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (!HtmlRootView.this.isForcedReloadPending) {
                                        return;
                                    }
                                    HtmlRootView.this.isForcedReloadPending = false;
                                    HtmlRootView.this.initLayout(true, false);
                                    Container container = HtmlRootView.this.getContainer();
                                    if (container != null) {
                                        container.repaint(100L);
                                    }
                                }
                            });
                        }
                    }
                }).start();
            }
        }
        this.nextLayout = now + timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParent(View parent) {
        Object object = this.update_sync_lock;
        synchronized (object) {
            block13: {
                CssDocument doc = (CssDocument)this.getDocument();
                int initalRevision = doc.getRevision();
                int initalSite = doc.getSiteCount();
                try {
                    super.setParent(parent);
                    if (parent == null) {
                        if (this.getViewCount() > 0) {
                            for (int i = 0; i < this.getViewCount(); ++i) {
                                this.getView(i).setParent(null);
                            }
                            this.removeAll();
                        }
                        this.initiated = false;
                        this.layouted = false;
                        this.mustRebuild = true;
                        this.renderContext.resetImageTimeout();
                        return;
                    }
                    if (parent instanceof BoxView) {
                        throw new IllegalArgumentException("The tag HTML must not be used within the pages content!");
                    }
                }
                catch (Exception e) {
                    this.checkPublishException(e);
                    EditorKit editorKit = this.renderContext.getTextContainerKit();
                    if (!(editorKit == null || initalRevision == doc.getRevision() && initalSite == doc.getSiteCount() && editorKit instanceof InetHtmlEditorKit)) {
                        this.getContainer().invalidate();
                        if (Logger.doesLog(1)) {
                            Logger.error(e);
                        }
                    }
                    if (this.renderContext.getTextContainerDocument() != null && this.renderContext.getTextContainerDocument() != doc) {
                        return;
                    }
                    if (!Logger.doesLog(1)) break block13;
                    Logger.error(e);
                }
            }
        }
        if ((this.getBackgroundValue() == null || this.getBackgroundValue().isTransparent()) && this.getViewCount() > 0) {
            BoxView body = (BoxView)this.getView(0);
            this.getBox().setBackgroundValue(body.getBackgroundValue());
            this.getBox().updateRelevance();
        }
        this.checkForBidiContent();
        this.setStatus(2);
        this.mustRebuild = false;
    }

    private void checkPublishException(Exception e) {
        if (this.throwAsRuntime) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    protected IBoxPainter createBoxPainter() {
        return BoxPainter.createRootPainter(this);
    }

    private void checkForBidiContent() {
        if (this.getUnicodeBidi() == 2) {
            this.renderContext.notifiyBidi(this.getDirection() == 0 ? 0 : 1, true);
        }
        if (this.getViewCount() > 0) {
            int start = this.getView(0).getStartOffset();
            int end = this.getView(this.getViewCount() - 1).getEndOffset();
            Segment seg = new Segment();
            try {
                this.getDocument().getText(start, end - start, seg);
            }
            catch (BadLocationException e) {
                Logger.error(e);
            }
            if (Bidi.requiresBidi(seg.array, seg.getBeginIndex(), seg.getEndIndex())) {
                this.renderContext.notifiyBidi(2, true);
            } else {
                this.renderContext.notifiyBidi(0, true);
            }
        }
    }

    protected Rectangle getVisibleRect() {
        Container container = this.getContainer();
        if (container instanceof JComponent) {
            return ((JComponent)container).getVisibleRect();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSize(float newWidth, float newHeight) {
        boolean widthChanged;
        Container container;
        block23: {
            int min;
            block22: {
                int refHeight;
                container = this.getContainer();
                Rectangle visibleRect = this.getVisibleRect();
                if (container instanceof JComponent && visibleRect != null) {
                    float containerWidth = visibleRect.width;
                    Insets insets = ((JComponent)container).getInsets();
                    if (insets != null) {
                        this.containerInsets = insets;
                        containerWidth -= (float)(insets.left + insets.right);
                    }
                    if (container instanceof JEditorPane) {
                        this.renderContext.setTextContainer((JEditorPane)container);
                    }
                    if (containerWidth <= 0.0f) {
                        if (this.oldWidth != 0.0f) {
                            newWidth = this.oldWidth;
                        }
                    } else {
                        newWidth = containerWidth;
                    }
                }
                if ((refHeight = this.getRenderContext().getViewportHeight()) > 0) {
                    newHeight = refHeight;
                }
                min = 0;
                try {
                    if (this.getLayout() != null) {
                        min = (int)this.getMinimumSpan(0);
                    }
                }
                catch (Exception e) {
                    this.checkPublishException(e);
                    if (!Logger.doesLog(1)) break block22;
                    Logger.error(e.getMessage());
                }
            }
            if (Logger.doesLog(4) && newWidth != this.oldWidth) {
                Logger.debug("" + newWidth + " : " + min);
            }
            this.checkReBuild();
            if (!this.initiated) {
                Object e = this.update_sync_lock;
                synchronized (e) {
                    this.performPreLayout();
                }
                this.initiated = true;
            }
            if ((int)newWidth == Integer.MAX_VALUE) {
                try {
                    newWidth = this.getPreferredSpan(0);
                }
                catch (Exception e) {
                    this.checkPublishException(e);
                    if (!Logger.doesLog(1)) break block23;
                    Logger.error(e);
                }
            }
        }
        final boolean heightChanged = this.getRenderContext().isLayoutOnHeightChange() && this.oldHeight != newHeight;
        boolean bl = widthChanged = this.oldWidth != newWidth;
        if (widthChanged || heightChanged) {
            super.setSize(newWidth, newHeight);
            this.layouted = false;
            this.widthSet = true;
            this.initLayout(false, heightChanged);
            if (this.getParent() != null) {
                final View parent = this.getParent();
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        if (parent != null) {
                            parent.preferenceChanged(HtmlRootView.this, widthChanged, heightChanged);
                            if (container != null) {
                                container.invalidate();
                            }
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    action.run();
                } else {
                    SwingUtilities.invokeLater(action);
                }
            }
            this.oldWidth = newWidth;
            this.oldHeight = newHeight;
        }
    }

    private void resetAllStatus(BoxView view) {
        view.setStatus(2);
        if (view.getViewCount() > 0) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                this.resetAllStatus((BoxView)view.getView(i));
            }
        }
    }

    @Override
    public void performPreLayout() {
        if (Logger.doesLog(4)) {
            Logger.debug("RootView: PreLayout requested");
        }
        this.renderContext.checkImageLoading();
        this.layoutThread = Thread.currentThread();
        this.layoutRunning = true;
        try {
            if (Logger.doesLog(4)) {
                Logger.debug("RootView: PreLayout starting");
            }
            super.performPreLayout();
        }
        finally {
            this.layoutThread = null;
            this.layoutRunning = false;
        }
        if (Logger.doesLog(4)) {
            Logger.debug("RootView: PreLayout done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle performLayout(boolean hard) {
        Rectangle r;
        if (Logger.doesLog(4)) {
            Logger.debug("RootView: Layout starting");
        }
        this.layoutRunning = true;
        this.layoutThread = Thread.currentThread();
        Object object = this.update_sync_lock;
        synchronized (object) {
            try {
                r = super.performLayout(hard);
            }
            finally {
                this.layoutThread = null;
                this.layoutRunning = false;
            }
        }
        this.layouted = true;
        if (Logger.doesLog(4)) {
            Logger.debug("RootView: Layout done");
        }
        this.span = r != null ? r : new Rectangle();
        return this.span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performLayoutWidth() {
        Object object = this.update_sync_lock;
        synchronized (object) {
            this.layoutThread = Thread.currentThread();
            this.layoutRunning = true;
            try {
                super.performLayoutWidth();
            }
            finally {
                this.layoutThread = null;
                this.layoutRunning = false;
            }
        }
        this.layouted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReBuild() {
        if (this.mustRebuild && !this.layoutRunning && this.getParent() != null) {
            if (Logger.doesLog(4)) {
                Logger.debug("HtmlRootView:reBuild");
            }
            this.mustRebuild = false;
            View parent = this.getParent();
            Object object = this.update_sync_lock;
            synchronized (object) {
                CssDocument doc = this.getCssDocument();
                int initalRevision = doc.getRevision();
                int initalSite = doc.getSiteCount();
                try {
                    this.setParent(null);
                    this.renderContext.clearForms();
                    this.setParent(parent);
                }
                catch (Exception e) {
                    this.checkPublishException(e);
                    if (initalRevision != doc.getRevision() || initalSite != doc.getSiteCount()) {
                        this.getContainer().invalidate();
                    }
                    if (this.renderContext.getTextContainerDocument() != doc) {
                        return;
                    }
                    if (Logger.doesLog(1)) {
                        Logger.error(e);
                    }
                    this.mustRebuild = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLayout(boolean doPreLayout, boolean forceLayout) {
        Object object = this.update_sync_lock;
        synchronized (object) {
            block10: {
                CssDocument doc = this.getCssDocument();
                int initalRevision = doc.getRevision();
                int initalSite = doc.getSiteCount();
                try {
                    if (this.getStatus() == 2 || doPreLayout) {
                        this.performPreLayout();
                        this.initiated = true;
                    }
                    if (!this.widthSet) {
                        return;
                    }
                    this.performLayoutWidth();
                    this.span = this.performLayout(forceLayout);
                    this.updateCaret = true;
                    int newWidth = this.getOuterWidth();
                    int newHeight = this.getOuterHeight();
                    if (this.oldWidth != (float)newWidth || this.oldHeight != (float)newHeight) {
                        super.setSize(newWidth, newHeight);
                        if (this.getParent() != null) {
                            final boolean heightChanged = this.oldHeight != (float)newHeight;
                            final boolean widthChanged = this.oldWidth != (float)newWidth;
                            final View parent = this.getParent();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (parent != null) {
                                        parent.preferenceChanged(HtmlRootView.this, widthChanged, heightChanged);
                                    } else if (HtmlRootView.this.getParent() != null) {
                                        HtmlRootView.this.getParent().preferenceChanged(HtmlRootView.this, widthChanged, heightChanged);
                                    }
                                }
                            });
                        }
                        this.oldWidth = newWidth;
                        this.oldHeight = newHeight;
                    }
                }
                catch (Exception e) {
                    if (initalRevision != doc.getRevision() || initalSite != doc.getSiteCount()) break block10;
                    this.checkPublishException(e);
                    if (this.renderContext.getTextContainerDocument() != doc || !(this.renderContext.getTextContainerKit() instanceof InetHtmlEditorKit)) {
                        return;
                    }
                    if (!Logger.doesLog(1)) break block10;
                    Logger.error(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLayout() {
        if (!this.layouted) {
            this.renderContext.checkImageLoading();
            this.initLayout(false, false);
        } else {
            this.renderContext.checkImageLoading();
            if (this.layoutRunning && this.renderContext.isBlockOnImageLoad()) {
                Object object = this.update_sync_lock;
                synchronized (object) {
                }
            }
            if (this.renderContext.isBlockOnImageLoad() && this.getStatus() != 0) {
                this.initLayout(false, false);
            }
        }
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.checkReBuild();
        this.checkLayout();
        if (axis == 0) {
            return this.span != null ? (float)((int)this.span.getMaxX()) : (float)this.getOuterWidth();
        }
        return this.span != null ? (float)((int)this.span.getMaxY()) : (float)this.getOuterHeight();
    }

    @Override
    public float getMinimumSpan(int axis) {
        this.checkReBuild();
        this.checkLayout();
        if (axis == 0) {
            Insets insets;
            int diff = 0;
            JEditorPane textContainer = this.renderContext.getTextContainer();
            if (textContainer != null && (insets = textContainer.getInsets()) != null) {
                diff += insets.left + textContainer.getInsets().right;
            }
            float f = (float)(this.span != null ? this.span.getMaxX() - 2.0 : (double)(super.getMinimumSpan(axis) - (float)diff));
            return f;
        }
        return (float)(this.span != null ? this.span.getMaxY() : (double)this.getOuterHeight());
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        if (g instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)g;
            this.renderContext.updateTargetDevice(graphics2D.getDeviceConfiguration().getDevice());
            FontRenderContext newFrc = graphics2D.getFontRenderContext();
            if (newFrc.getAntiAliasingHint() == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                newFrc = new FontRenderContext(newFrc.getTransform(), this.renderContext.getTextAntiAliasHint(true), newFrc.getFractionalMetricsHint());
            }
            if (!this.renderContext.getFontRenderContext().equals(newFrc) && ViewUtils.isFRCChangeRelevantToFontSizes(this.renderContext.getFontRenderContext(), newFrc)) {
                this.renderContext.setFontRenderContext(newFrc);
                if (this.initiated) {
                    this.resetAllStatus(this);
                    this.initiated = false;
                    this.layouted = false;
                    this.initLayout(true, false);
                }
            }
        }
        if (this.layouted) {
            boolean clipSet;
            Rectangle clip;
            Object previousInterpolationHint;
            Object previousRenderHint;
            block16: {
                this.checkLayout();
                previousRenderHint = null;
                previousInterpolationHint = null;
                if (g instanceof Graphics2D) {
                    Graphics2D graphics2D = (Graphics2D)g;
                    previousRenderHint = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    previousInterpolationHint = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.renderContext.getFontRenderContext().getAntiAliasingHint());
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                }
                Rectangle bounds = allocation.getBounds();
                clip = g.getClip() != null ? g.getClip().getBounds() : bounds;
                Rectangle visbileRect = this.getVisibleRect();
                if (visbileRect != null) {
                    allocation = visbileRect;
                }
                clipSet = false;
                if (!bounds.contains(clip)) {
                    g.setClip(clip.intersection(bounds));
                    clipSet = true;
                }
                int width = Math.max(this.getOuterWidth(), allocation.getBounds().width + allocation.getBounds().x);
                int height = Math.max(this.getOuterHeight(), allocation.getBounds().height + allocation.getBounds().y);
                Rectangle pageAlloc = new Rectangle(this.containerInsets.left, this.containerInsets.top, width, height);
                CssDocument doc = this.getCssDocument();
                int initalRevision = doc.getRevision();
                int initalSite = doc.getSiteCount();
                try {
                    super.paint(g, pageAlloc);
                }
                catch (Exception e) {
                    this.checkPublishException(e);
                    if (initalRevision != doc.getRevision() || initalSite != doc.getSiteCount() || this.renderContext.getTextContainerKit() instanceof InetHtmlEditorKit) {
                        this.getContainer().invalidate();
                    }
                    if (!Logger.doesLog(1)) break block16;
                    Logger.error(e);
                }
            }
            if (clipSet) {
                g.setClip(clip);
            }
            if (previousRenderHint != null && previousRenderHint != this.renderContext.getTextAntiAliasHint()) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, previousRenderHint);
            }
            if (previousInterpolationHint != null) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, previousInterpolationHint);
            }
        }
        if (this.overlayPainters != null) {
            for (int i = 0; i < this.overlayPainters.size(); ++i) {
                this.overlayPainters.get(i).paint(g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        int start = ViewUtils.getOffset(e);
        int length = ViewUtils.getLength(e);
        if (Logger.doesLog(4)) {
            Logger.debug("HtmlRootView:changedUpdate(" + start + ":" + length + ")");
        }
        this.oldHeight = this.getOuterHeight();
        this.oldWidth = this.getOuterWidth();
        if (start == 0 && length >= this.getDocument().getLength() && e.getChange(this.getElement()) != null) {
            this.mustRebuild = true;
            this.checkReBuild();
        } else {
            try {
                Object object = this.update_sync_lock;
                synchronized (object) {
                    super.changedUpdate(e, a, f);
                }
                this.initLayout(false, false);
            }
            catch (Exception ex) {
                this.mustRebuild = true;
                this.checkReBuild();
            }
        }
        Container container = this.getContainer();
        if (container != null) {
            container.repaint();
        }
        this.updateCaret = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        if (Logger.doesLog(4)) {
            Logger.debug("HtmlRootView:insertUpdate");
        }
        this.oldHeight = this.getOuterHeight();
        this.oldWidth = this.getOuterWidth();
        try {
            Object object = this.update_sync_lock;
            synchronized (object) {
                if (e.getChange(this.getElement()) != null) {
                    this.setPropertiesFromAttributes(false);
                }
                super.insertUpdate(e, a, f);
                if (e.getChange(this.getElement()) != null && (this.getBackgroundValue() == null || this.getBackgroundValue().toString().equals("transparent")) && this.getViewCount() > 0) {
                    BoxView body = (BoxView)this.getView(0);
                    this.setBackgroundValue(body.getBackgroundValue());
                }
            }
            this.initLayout(false, false);
        }
        catch (Exception ex) {
            if (Logger.doesLog(1)) {
                Logger.error(ex);
            }
            this.mustRebuild = true;
            this.checkReBuild();
        }
        Container container = this.getContainer();
        if (container != null) {
            container.repaint();
        }
        this.updateCaret = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        if (Logger.doesLog(4)) {
            Logger.debug("HtmlRootView:removeUpdate");
        }
        this.oldHeight = this.getOuterHeight();
        this.oldWidth = this.getOuterWidth();
        try {
            Object object = this.update_sync_lock;
            synchronized (object) {
                super.removeUpdate(e, a, f);
            }
            this.initLayout(false, false);
        }
        catch (Exception ex) {
            if (Logger.doesLog(1)) {
                Logger.error("Exception while updating views:");
            }
            ex.printStackTrace(System.err);
            this.mustRebuild = true;
            this.checkReBuild();
        }
        Container container = this.getContainer();
        if (container != null) {
            container.repaint();
        }
        this.updateCaret = true;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        try {
            return super.viewToModel(x, y, a, biasReturn);
        }
        catch (Exception e) {
            if (Logger.doesLog(2)) {
                Logger.warning("HtmlRootView.viewToModel:" + e.getMessage());
            }
            return 0;
        }
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        return this.nativeModelToView(pos, a, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Shape nativeModelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        try {
            Shape shape;
            boolean isForward;
            ((AbstractDocument)this.getDocument()).readLock();
            boolean bl = isForward = pos > this.lastCursorPos;
            if (this.lastCursorPos != pos || this.lastCursorBias != b || this.updateCaret || this.lastCursor == null) {
                this.updateCaret = false;
                Rectangle rect = a.getBounds();
                this.lastCursorPos = pos;
                this.lastCursorBias = b;
                boolean turnDone = false;
                do {
                    this.lastCursor = super.modelToView(pos, rect, b);
                    if (this.lastCursor != null) continue;
                    if (isForward) {
                        if (++pos <= this.getDocument().getLength()) continue;
                        if (turnDone) {
                            if (this.lastCursor == null) {
                                if (Logger.doesLog(4)) {
                                    Logger.debug("modelToView " + pos + " # " + a + " # " + b + " FAILED");
                                }
                                Shape shape2 = a;
                                return shape2;
                            }
                            Shape shape3 = this.lastCursor;
                            return shape3;
                        }
                        --pos;
                        isForward = false;
                        turnDone = true;
                        continue;
                    }
                    if (--pos > 1) continue;
                    if (turnDone) {
                        if (this.lastCursor == null) {
                            if (Logger.doesLog(4)) {
                                Logger.debug("modelToView " + pos + " # " + a + " # " + b + " FAILED");
                            }
                            Shape shape4 = a;
                            return shape4;
                        }
                        Shape shape5 = this.lastCursor;
                        return shape5;
                    }
                    ++pos;
                    isForward = true;
                    turnDone = true;
                } while (this.lastCursor == null && pos > 1 && pos <= this.getDocument().getLength());
            }
            if (this.lastCursor == null) {
                if (Logger.doesLog(4)) {
                    Logger.debug("modelToView " + pos + " # " + a + " # " + b + " FAILED");
                }
                shape = a;
                return shape;
            }
            shape = this.lastCursor;
            return shape;
        }
        finally {
            ((AbstractDocument)this.getDocument()).readUnlock();
        }
    }

    @Override
    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        switch (direction) {
            case 1: 
            case 5: {
                JTextComponent textComp = (JTextComponent)this.getContainer();
                if (pos == -1 || textComp == null) {
                    return direction == 1 ? Math.max(0, this.getEndOffset() - 1) : this.getStartOffset();
                }
                Shape loc = this.nativeModelToView(pos, a, b);
                int x = loc == null ? 0 : loc.getBounds().x;
                int newPos = this.getPositionAboveBelow(textComp, pos, x, direction == 1);
                if (newPos >= this.getDocument().getLength()) {
                    newPos = super.getNextVisualPositionFrom(newPos, b, a, 3, biasRet);
                }
                if (ElementUtils.isValidEditPosition(newPos, this.getDocument())) {
                    return newPos;
                }
                pos = newPos;
                direction = direction == 1 ? 3 : 7;
            }
            case 3: 
            case 7: {
                int newPos = super.getNextVisualPositionFrom(pos, b, a, direction, biasRet);
                int blockCounter = 0;
                while (!ElementUtils.isValidEditPosition(newPos, this.getDocument())) {
                    if (newPos == 0 || newPos >= this.getDocument().getLength()) {
                        int n = direction = direction == 3 ? 7 : 3;
                    }
                    if (blockCounter++ >= 100000) break;
                    newPos = super.getNextVisualPositionFrom(newPos, b, a, direction, biasRet);
                }
                Shape s = super.modelToView(newPos, a, Position.Bias.Forward);
                if (newPos > this.getDocument().getLength()) {
                    return pos;
                }
                int lastPos = newPos - 1;
                blockCounter = 0;
                while (s == null && newPos >= 0 && newPos < this.getDocument().getLength() && lastPos != newPos) {
                    lastPos = newPos;
                    newPos = super.getNextVisualPositionFrom(newPos, b, a, direction, biasRet);
                    s = super.modelToView(newPos, new Rectangle(0, 0, 0, 0), Position.Bias.Forward);
                    if (blockCounter++ < 100000) continue;
                }
                return newPos;
            }
        }
        return super.getNextVisualPositionFrom(pos, b, a, direction, biasRet);
    }

    private final int getPositionAboveBelow(JTextComponent textComp, int offs, int x, boolean above) throws BadLocationException {
        int length = textComp.getDocument().getLength();
        int blockCounter = 0;
        int diff = above ? -1 : 1;
        if ((offs = BeginEndLineAction.getRowBeginEnd(textComp, offs, above) + diff) < 0) {
            return -1;
        }
        int bestSpan = Integer.MAX_VALUE;
        while (!ElementUtils.isValidEditPosition(offs, this.getDocument()) && offs > 0 && offs < length) {
            offs += diff;
        }
        Rectangle r = textComp.modelToView(offs);
        if (r == null) {
            return -1;
        }
        int y1 = r.y;
        int y2 = y1 + r.height;
        do {
            int span;
            if ((span = Math.abs(x - (r != null ? r.x : 0))) > bestSpan) {
                return offs - diff;
            }
            bestSpan = span;
            offs = above ? --offs : ++offs;
            Rectangle rectangle = r = offs <= length && offs >= 0 ? textComp.modelToView(offs) : null;
        } while (blockCounter++ < 100000 && (r != null && y2 > r.y && y1 < r.y + r.height || r == null && offs <= length && offs >= 0));
        return offs - diff;
    }

    @Override
    public HtmlRootView getHTMLRoot() {
        return this;
    }

    public void setPublishExceptions(boolean throwAsRuntime) {
        this.throwAsRuntime = throwAsRuntime;
    }

    public void setAntiAlias(boolean calculateAntiAlias) {
        this.renderContext.setTextAntiAlias(calculateAntiAlias);
    }

    public void setFraction(boolean useFractional) {
        this.renderContext.setFraction(useFractional);
    }

    private CssDocument getCssDocument() {
        return (CssDocument)this.getDocument();
    }

    @Override
    public RenderContext getRenderContext() {
        return this.renderContext;
    }

    public void blockOnLayoutRunning() {
        if (this.layoutThread == Thread.currentThread() || !this.layoutRunning) {
            return;
        }
        for (int timeout = 1000; this.layoutRunning && timeout > 0; --timeout) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    @Override
    public boolean isPositionRoot() {
        return true;
    }

    public void addOverlayPainter(EditPainter painter) {
        if (this.overlayPainters == null) {
            this.overlayPainters = new ArrayList<EditPainter>();
        }
        if (!this.overlayPainters.contains(painter)) {
            this.overlayPainters.add(painter);
        }
    }

    public void removeOverlayPainter(EditPainter painter) {
        if (this.overlayPainters != null && this.overlayPainters.contains(painter)) {
            this.overlayPainters.remove(painter);
        }
    }
}

