/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.ViewPainter;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.EmptyValue;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.utils.ColorUtils;
import com.inet.html.utils.DOMUtils;
import com.inet.html.views.BoxView;
import com.inet.html.views.layouts.ILayouted;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class HRuleView
extends BoxView
implements Cloneable {
    private Font font;
    private static final FontRenderContext FRC = new FontRenderContext(null, false, false);

    public HRuleView(Element elem) {
        super(elem);
    }

    public HRuleView(Element elem, ViewPainter painter) {
        super(elem, painter);
    }

    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        if (parent == null) {
            return;
        }
    }

    @Override
    protected void setPropertiesFromAttributes(boolean inline) {
        AttributeSet atts;
        if (this.getParent() == null) {
            return;
        }
        super.setPropertiesFromAttributes(true);
        this.font = this.getRenderContext().getFont(this, false);
        float width = this.getPreferredSpan(0);
        float height = this.getPreferredSpan(1);
        this.setSizeContent(width, height);
        EmptyValue shade = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.NOSHADE);
        if (shade == null) {
            this.setBorderTopColor(new ColorValue(ColorUtils.get3DDark()));
            this.setBorderLeftColor(new ColorValue(ColorUtils.get3DDark()));
            this.setBorderBottomColor(new ColorValue(ColorUtils.get3DLight()));
            this.setBorderRightColor(new ColorValue(ColorUtils.get3DLight()));
        }
        if ((atts = this.getElement().getAttributes()).isDefined((Object)TemporaryStyle.Attribute.COLOR)) {
            ColorValue color = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.COLOR);
            this.setBorderTopColor(color);
            this.setBorderLeftColor(color);
            this.setBorderBottomColor(color);
            this.setBorderRightColor(color);
        }
    }

    @Override
    public float getPreferredSpan(int axis) {
        BoxView parent = (BoxView)this.getParent();
        switch (axis) {
            case 0: {
                int parentWidth;
                int n = parentWidth = parent instanceof ILayouted ? ((ILayouted)((Object)parent)).getLayout().getCurrentWidth() : parent.getContentWidth();
                if (this.getWidthUnit() != null && !this.getWidthUnit().isAuto()) {
                    return this.getWidthUnit().calculateValue(parentWidth, this);
                }
                return parentWidth;
            }
            case 2: {
                float size;
                LineMetrics metrics = this.font.getLineMetrics(" ", FRC);
                float ascent = metrics.getAscent();
                float origSize = size = metrics.getHeight();
                return ascent += (size - origSize) / 2.0f;
            }
        }
        LineMetrics metrics = this.font.getLineMetrics(" ", FRC);
        float fontSize = metrics.getHeight();
        return fontSize;
    }

    @Override
    public float getMinimumSpan(int axis) {
        if (axis == 0) {
            return 1.0f;
        }
        return super.getMinimumSpan(axis);
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Rectangle rect = a.getBounds();
        return rect;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        return this.getStartOffset();
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        JTextComponent textComp;
        Highlighter highlighter;
        if (this.getVisibility() != 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Rectangle rect = (Rectangle)allocation;
        if (clip != null && !clip.intersects(rect)) {
            return;
        }
        if (this.isCanceledByPainter(g, allocation)) {
            return;
        }
        int width = (int)this.getPreferredSpan(0);
        LengthUnit widthUnit = this.getWidthUnit();
        if (widthUnit != null && widthUnit.getType() != -1) {
            width = (int)widthUnit.calculateValue(width, this);
        }
        int totalWidth = ((BoxView)this.getParent()).getContentWidth();
        int totalHeight = (int)this.getPreferredSpan(1);
        Container container = this.getContainer();
        if (container instanceof JTextComponent && (highlighter = (textComp = (JTextComponent)container).getHighlighter()) instanceof LayeredHighlighter) {
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            ((LayeredHighlighter)highlighter).paintLayeredHighlights(g, start, end, allocation, textComp, this);
        }
        int height = 2;
        LengthUnit heightCSS = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.HEIGHT);
        IntegerValue heightHTML = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.SIZE);
        if (heightCSS != null && heightCSS.getType() != -1) {
            height = (int)heightCSS.calculateValue(totalHeight, this);
        } else if (heightHTML != null) {
            height = heightHTML.getInt();
        }
        float align = this.getAlignment(0);
        Rectangle paintRect = new Rectangle();
        paintRect.width = width;
        paintRect.height = height;
        paintRect.x = rect.x + (int)((float)(totalWidth - width) * align);
        paintRect.y = rect.y + (int)((float)totalHeight / 2.0f - (float)height / 2.0f);
        this.getBox().paint(g, paintRect, 0, this);
    }

    @Override
    public int getOuterHeight() {
        return (int)this.getPreferredSpan(1);
    }

    @Override
    public int getOuterWidth() {
        return (int)this.getPreferredSpan(0);
    }

    @Override
    public int getLeftInset() {
        return 0;
    }

    @Override
    public boolean isBlock() {
        return true;
    }

    @Override
    public boolean isBreak() {
        return true;
    }

    @Override
    public int getRightInset() {
        return 0;
    }

    @Override
    public int getTopInset() {
        return 0;
    }

    @Override
    public int getBottomInset() {
        return 0;
    }

    @Override
    public Insets getMargins() {
        return this.getBox().getMargins();
    }

    public String paramString() {
        return "HR(" + this.getStartOffset() + "," + this.getEndOffset() + ")";
    }

    @Override
    public Rectangle performLayout(boolean hard) {
        return new Rectangle(0, 0, this.getContentWidth(), this.getContentHeight());
    }

    @Override
    public void performLayoutWidth() {
        float width = this.getPreferredSpan(0);
        float height = this.getPreferredSpan(1);
        this.setSizeContent(width, height);
    }

    @Override
    public void performLayoutVAlign(int baseline) {
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
    }

    @Override
    public int getFirstLineBaseLine() {
        return (int)this.getPreferredSpan(2);
    }

    @Override
    public boolean getVisibleDOM(Rectangle2D clip, DOMUtils.ResultMap result) {
        if (clip.getMaxY() < 0.0) {
            result.setFirstClippedContentLocation(-clip.getY());
            return false;
        }
        result.put(this.getElement(), new DOMUtils.DOMVisibilityResult(this, DOMUtils.Visibility.visible));
        result.setLastVisibleContentLocation(-clip.getY() + (double)this.getContentHeight());
        return true;
    }
}

