/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.URLResolver;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import java.net.MalformedURLException;

public class UriValue
extends HtmlAttribute
implements URLResolver.URLResolverContainer {
    private URLResolver value;
    private boolean isNone = false;
    static final UriValue PARSER = new UriValue();

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        int idx;
        String lower = valueStr.toLowerCase();
        if ("none".equals(lower)) {
            UriValue uri = new UriValue();
            uri.isNone = true;
            uri.value = new URLResolver("none");
            uri.setString("none");
            return uri;
        }
        if (lower.startsWith("url(") && (idx = valueStr.lastIndexOf(41)) > 0) {
            char c2;
            char c1;
            String urlValue = valueStr.substring(4, idx).trim();
            if (urlValue.length() >= 2 && (c1 = urlValue.charAt(0)) == (c2 = urlValue.charAt(urlValue.length() - 1)) && (c1 == '\'' || c1 == '\"')) {
                urlValue = urlValue.substring(1, urlValue.length() - 1);
            }
            UriValue uri = new UriValue();
            uri.value = new URLResolver(urlValue);
            uri.setString(valueStr);
            return uri;
        }
        return null;
    }

    public boolean isNone() {
        return this.isNone;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof UriValue)) {
            return false;
        }
        UriValue otherObj = (UriValue)obj;
        if (this.isNone != otherObj.isNone) {
            return false;
        }
        return this.value != null ? this.value.equals(otherObj.value) : otherObj.value != null;
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String value) {
        this.setString(value);
        UriValue uri = new UriValue();
        uri.value = new URLResolver(value);
        if (doc != null) {
            uri.value.setBase(doc.getBase());
        }
        return uri;
    }

    public String getResolvedValue() {
        if (this.isNone) {
            return "none";
        }
        try {
            return this.value.getFullURL().toString();
        }
        catch (MalformedURLException e) {
            return this.toString();
        }
    }

    @Override
    public URLResolver getResolver() {
        return this.value;
    }

    @Override
    public void setResolver(URLResolver resolver) {
        boolean bl = this.isNone = resolver == null || resolver.getOriginalURI() == null;
        if (this.isNone) {
            this.value = new URLResolver("none");
            this.setString("none");
        } else {
            this.value = resolver;
            String newUri = resolver.getOriginalURI();
            if (!newUri.toLowerCase().startsWith("url(")) {
                this.setString("url(" + newUri + ")");
            } else {
                this.setString(newUri);
            }
        }
    }
}

