/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;
import java.util.Hashtable;

public class Overflow
extends SingleAttributeValue {
    public static final byte AUTO = 0;
    public static final byte VISIBLE = 1;
    public static final byte HIDDEN = 2;
    public static final byte SCROLL = 3;
    private static final Hashtable<String, Overflow> MAP = new Hashtable();
    static final Overflow PARSER;
    private byte value;

    public static Overflow getOverflow(byte overflow) {
        switch (overflow) {
            case 1: {
                return MAP.get("visible");
            }
            case 2: {
                return MAP.get("hidden");
            }
            case 3: {
                return MAP.get("scroll");
            }
        }
        return MAP.get("auto");
    }

    private static void factory(String strValue, byte intValue) {
        Overflow va = new Overflow();
        va.setString(strValue);
        va.value = intValue;
        MAP.put(strValue, va);
    }

    public byte getOverflow() {
        return this.value;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        return MAP.get(valueStr.toLowerCase());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Overflow)) {
            return false;
        }
        Overflow other = (Overflow)obj;
        if (this.isImportant() != other.isImportant()) {
            return false;
        }
        return this.value == other.value;
    }

    static {
        Overflow.factory("auto", (byte)0);
        Overflow.factory("visible", (byte)1);
        Overflow.factory("hidden", (byte)2);
        Overflow.factory("scroll", (byte)3);
        PARSER = MAP.get("auto");
    }
}

