/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.LengthUnit;

public class LineHeight
extends LengthUnit {
    static final LineHeight PARSER = new LineHeight();
    private boolean isNormal;

    public LineHeight() {
    }

    public LineHeight(int lineHeight) {
        super(lineHeight);
    }

    private LineHeight(float value, int type, boolean isAsterisk) {
        super(value, type, isAsterisk);
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        String value = valueStr.toLowerCase().trim();
        if ("inherit".equalsIgnoreCase(value)) {
            return AttributeValue.INHERIT;
        }
        try {
            float size = Float.parseFloat(value);
            value = Integer.toString((int)(size *= 100.0f)) + "%";
        }
        catch (NumberFormatException size) {
            // empty catch block
        }
        if (value.equals("normal")) {
            LineHeight lineHeight = new LineHeight(1.2f, 2, false);
            lineHeight.setString(valueStr);
            lineHeight.isNormal = true;
            return lineHeight;
        }
        AttributeValue parsedValue = super.parseCssValue(value, important);
        if (parsedValue instanceof LengthUnit) {
            LengthUnit lengthUnit = (LengthUnit)parsedValue;
            LineHeight lineHeight = new LineHeight(lengthUnit.getValue(), lengthUnit.getType(), lengthUnit.isAsterisk());
            lineHeight.setString(valueStr);
            return lineHeight;
        }
        return parsedValue;
    }

    public boolean isNormal() {
        return this.isNormal;
    }

    @Override
    public boolean isAuto() {
        return this.isNormal;
    }

    @Override
    public String toString() {
        return this.isNormal ? "normal" : super.toString();
    }
}

