/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.CSS;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import com.inet.html.utils.Logger;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class FontFamily
extends HtmlAttribute {
    private static final HashSet<String> AVAILABLE_FONT_FAMILIY_NAMES = new HashSet();
    private static final HashSet<String> SERIF_FONTS = new HashSet();
    private static final HashSet<String> SANS_SERIF_FONTS = new HashSet();
    private static final HashSet<String> MONOSPACE_FONTS = new HashSet();
    private String family;
    private boolean isSymbolic;
    private static final int START_OF_SYMBOLIC_CHAR_INTERVAL = 61440;

    FontFamily() {
    }

    public FontFamily(String family) {
        this.family = family;
        this.setString(family);
        String firstFamily = null;
        String[] families = family.split(",");
        for (int i = 0; i < families.length; ++i) {
            String fontName = families[i].trim();
            if (fontName.length() == 0) continue;
            char firstChar = fontName.charAt(0);
            if (fontName.length() > 2 && (firstChar == '\'' || firstChar == '\"') && firstChar == fontName.charAt(fontName.length() - 1)) {
                fontName = fontName.substring(1, fontName.length() - 1);
            }
            if (AVAILABLE_FONT_FAMILIY_NAMES.contains(fontName.toLowerCase())) {
                this.setFamily(fontName);
                return;
            }
            if (firstFamily == null) {
                firstFamily = this.getSymbolicFont(fontName);
            }
            if (firstFamily != null) continue;
            firstFamily = fontName;
        }
        if (firstFamily != null) {
            this.setFamily(firstFamily);
            return;
        }
    }

    private String getSymbolicFont(String name) {
        if (name == null) {
            return null;
        }
        String lower = name.toLowerCase();
        if ("serif".equals(lower)) {
            for (String fontName : SERIF_FONTS) {
                if (AVAILABLE_FONT_FAMILIY_NAMES.size() != 0 && !AVAILABLE_FONT_FAMILIY_NAMES.contains(fontName)) continue;
                return fontName;
            }
            return null;
        }
        if ("sans-serif".equals(lower)) {
            for (String fontName : SANS_SERIF_FONTS) {
                if (AVAILABLE_FONT_FAMILIY_NAMES.size() != 0 && !AVAILABLE_FONT_FAMILIY_NAMES.contains(fontName)) continue;
                return fontName;
            }
            return null;
        }
        if ("monospace".equals(lower)) {
            for (String fontName : MONOSPACE_FONTS) {
                if (AVAILABLE_FONT_FAMILIY_NAMES.size() != 0 && !AVAILABLE_FONT_FAMILIY_NAMES.contains(fontName)) continue;
                return fontName;
            }
            return null;
        }
        return null;
    }

    private void setFamily(String fontName) {
        this.family = fontName;
        char[] chs = new char[]{'a', 'b', 'c', 'd', 'e', 'f', '1', '2', '3', '4', '5'};
        this.isSymbolic = false;
        Font f = new Font(fontName, 0, 1);
        if (f.canDisplayUpTo(chs, 0, chs.length) != -1) {
            FontFamily.translateSymbolic(chs);
            if (f.canDisplayUpTo(chs, 0, chs.length) == -1) {
                this.isSymbolic = true;
            }
        }
    }

    public static char[] translateSymbolic(char[] input) {
        if (input == null) {
            return null;
        }
        for (int i = 0; i < input.length; ++i) {
            input[i] = (char)(input[i] | 0xF000);
        }
        return input;
    }

    public String getFamily() {
        return this.family;
    }

    @Override
    protected boolean parseCssValue(MutableAttributeSet attrs, CSS.Attribute attr, String value, boolean important) {
        String firstFamily = null;
        if ("inherit".equalsIgnoreCase(value)) {
            attrs.addAttribute((Object)attr, AttributeValue.INHERIT);
            return true;
        }
        String[] families = value.split(",");
        for (int i = 0; i < families.length; ++i) {
            String fontName = families[i].trim();
            if (fontName.length() == 0) continue;
            char firstChar = fontName.charAt(0);
            if (fontName.length() > 2 && (firstChar == '\'' || firstChar == '\"') && firstChar == fontName.charAt(fontName.length() - 1)) {
                fontName = fontName.substring(1, fontName.length() - 1);
            }
            if (AVAILABLE_FONT_FAMILIY_NAMES.contains(fontName.toLowerCase())) {
                FontFamily fontFamily = new FontFamily();
                fontFamily.setFamily(fontName);
                fontFamily.setString(value);
                fontFamily.setImportant(important);
                attrs.addAttribute((Object)attr, fontFamily);
                return true;
            }
            if (firstFamily == null) {
                firstFamily = this.getSymbolicFont(fontName);
            }
            if (firstFamily != null) continue;
            firstFamily = fontName;
        }
        if (firstFamily != null) {
            FontFamily fontFamily = new FontFamily();
            fontFamily.setFamily(firstFamily);
            fontFamily.setString(value);
            fontFamily.setImportant(important);
            attrs.addAttribute((Object)attr, fontFamily);
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FontFamily) {
            FontFamily other = (FontFamily)obj;
            if (!other.getFamily().equals(this.getFamily())) {
                return false;
            }
            return other.isImportant() == this.isImportant();
        }
        return false;
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String value) {
        return this.parseCssValue(value, false);
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        SimpleAttributeSet set = new SimpleAttributeSet();
        this.parseCssValue(set, CSS.Attribute.FONT_FAMILY, valueStr, important);
        return (AttributeValue)set.getAttribute((Object)CSS.Attribute.FONT_FAMILY);
    }

    public boolean isSymbolic() {
        return this.isSymbolic;
    }

    static {
        try {
            String[] fontFamilies;
            for (String family : fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                AVAILABLE_FONT_FAMILIY_NAMES.add(family.toLowerCase());
            }
        }
        catch (Throwable th) {
            Logger.error("Failed to read the available fonts.");
            Logger.error(th);
        }
        SERIF_FONTS.add("times");
        SERIF_FONTS.add("times new roman");
        SERIF_FONTS.add("ms serif");
        SERIF_FONTS.add("georgia");
        SERIF_FONTS.add("vera serif");
        SANS_SERIF_FONTS.add("arial");
        SANS_SERIF_FONTS.add("verdana");
        SANS_SERIF_FONTS.add("helvetica");
        SANS_SERIF_FONTS.add("calibri");
        SANS_SERIF_FONTS.add("gothic");
        SANS_SERIF_FONTS.add("urw gothic l");
        SANS_SERIF_FONTS.add("lucida sans");
        SANS_SERIF_FONTS.add("dejavu sans");
        MONOSPACE_FONTS.add("courier");
        MONOSPACE_FONTS.add("courier new");
        MONOSPACE_FONTS.add("fixed");
        MONOSPACE_FONTS.add("arial monospaced");
        MONOSPACE_FONTS.add("fixedsys");
        MONOSPACE_FONTS.add("lucide console");
    }
}

