/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import java.util.ArrayList;

public class ClassValue
extends HtmlAttribute {
    private ArrayList<Object> classNames;
    static final ClassValue PARSER = new ClassValue();

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String value) {
        ClassValue classValue = new ClassValue();
        classValue.addClasses(value);
        if (classValue.getClassNames() != null && classValue.getClassNames().size() > 0) {
            classValue.setString(value);
            return classValue;
        }
        return null;
    }

    private void addClasses(String classes) {
        String[] classNames = classes.split("[\\t\\s]+");
        if (classNames.length > 0) {
            this.classNames = new ArrayList();
            for (String name : classNames) {
                this.classNames.add(InetHtmlDocument.getCachedString(name).toLowerCase());
            }
        }
    }

    public ArrayList<Object> getClassNames() {
        return this.classNames;
    }

    public void addClass(Object className) {
        if (className == null) {
            return;
        }
        if (this.classNames == null) {
            this.classNames = new ArrayList();
        } else if (this.classNames.contains(className)) {
            return;
        }
        this.classNames.add(className);
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ClassValue) {
            ClassValue otherClass = (ClassValue)obj;
            boolean result = true;
            for (Object className : this.classNames) {
                result &= otherClass.getClassNames().contains(className);
            }
            return result;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Object className : this.classNames) {
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(className);
        }
        return b.toString();
    }
}

