/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import javax.swing.text.ChangedCharSetException;

public class PushReader
extends BufferedReader {
    public static final String TOKEN_COMMENT = "!--";
    private static final Hashtable<String, Character> HTML_CHARS = new Hashtable();
    private StringBuilder stack = new StringBuilder();
    private StringBuilder rollback = new StringBuilder();
    private boolean transactionActive = false;
    private boolean isShutdown = false;

    public PushReader(Reader in) {
        super(in);
    }

    private static void putNamedChar(String name, int chr) {
        HTML_CHARS.put(name, new Character((char)chr));
    }

    @Override
    public int read() throws IOException {
        int result;
        if (this.isShutdown) {
            return -1;
        }
        if (this.stack.length() > 0) {
            char ch = this.stack.charAt(this.stack.length() - 1);
            this.stack.setLength(this.stack.length() - 1);
            result = ch;
        } else {
            result = super.read();
        }
        if (this.transactionActive && result != -1) {
            this.rollback.append((char)result);
        }
        return result;
    }

    public void push(char ch) {
        this.stack.append(ch);
        if (this.transactionActive && this.rollback.length() > 0) {
            this.rollback.setLength(this.rollback.length() - 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char readQuotedChar() {
        StringBuilder buf = new StringBuilder();
        StringBuilder bufOrig = new StringBuilder();
        int type = 0;
        try {
            block13: while (true) {
                int c;
                if ((c = this.read()) != -1) {
                    bufOrig.append((char)c);
                }
                switch (c) {
                    case -1: {
                        break block13;
                    }
                    case 59: {
                        break block13;
                    }
                    case 120: {
                        if (type == 1 && buf.length() == 0) {
                            type = 2;
                            continue block13;
                        }
                    }
                    case 35: {
                        if (type == 0 && buf.length() == 0) {
                            type = 1;
                            continue block13;
                        }
                    }
                    default: {
                        buf.append((char)c);
                        continue block13;
                    }
                }
                break;
            }
            String s = buf.toString();
            switch (type) {
                case 0: {
                    Character chr = HTML_CHARS.get(s);
                    if (chr != null) {
                        return chr.charValue();
                    }
                    break;
                }
                case 1: {
                    int value = Integer.parseInt(s);
                    if (value > 65535) {
                        this.push((char)(0xDC00 | (value -= 65536) & 0x3FF));
                        return (char)(0xD800 | value >> 10);
                    }
                    return (char)value;
                }
                case 2: {
                    return (char)Integer.parseInt(s, 16);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.transactionActive && this.rollback.length() >= bufOrig.length()) {
            this.rollback.setLength(this.rollback.length() - bufOrig.length());
        }
        this.stack.append((CharSequence)bufOrig.reverse());
        return '&';
    }

    public void checkForUtf8Prefix() throws IOException, ChangedCharSetException {
        int ch1 = this.read();
        switch (ch1) {
            case 239: {
                int ch2 = this.read();
                if (ch2 == 187) {
                    int ch3 = this.read();
                    if (ch3 == 191) {
                        throw new ChangedCharSetException("UTF-8", true);
                    }
                    this.push((char)ch3);
                }
                this.push((char)ch2);
                break;
            }
            case 254: {
                int ch2 = this.read();
                if (ch2 == 255) {
                    throw new ChangedCharSetException("UTF-16BE", true);
                }
                this.push((char)ch2);
                break;
            }
            case 255: {
                int ch2 = this.read();
                if (ch2 == 254) {
                    throw new ChangedCharSetException("UTF-16LE", true);
                }
                this.push((char)ch2);
            }
        }
        if (ch1 != -1) {
            this.push((char)ch1);
        }
    }

    public void startTransaction() {
        this.transactionActive = true;
        if (this.rollback.length() > 0) {
            this.rollback.setLength(0);
        }
    }

    public void rollBack() {
        if (this.transactionActive) {
            this.stack.append((CharSequence)this.rollback.reverse());
        }
        this.commit();
    }

    public void commit() {
        this.rollback.setLength(0);
        this.transactionActive = false;
    }

    public void shutDown() throws IOException {
        this.isShutdown = true;
        this.close();
    }

    public String readKey() throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean isComment = false;
        boolean hasOpenBracket = false;
        boolean hasCloseBracket = false;
        block9: while (true) {
            int ch = this.read();
            switch (ch) {
                case -1: {
                    return null;
                }
                case 60: {
                    if (!(hasOpenBracket || builder.length() >= 3 && builder.substring(0, 3).equals(TOKEN_COMMENT))) {
                        for (int i = 0; i < builder.length(); ++i) {
                            this.push(builder.charAt(i));
                        }
                        this.push('<');
                        return null;
                    }
                }
                case 47: 
                case 61: 
                case 62: {
                    this.push((char)ch);
                    return builder.toString();
                }
                case 33: {
                    if (builder.length() == 0) {
                        isComment = true;
                    }
                    builder.append((char)ch);
                    continue block9;
                }
                case 91: {
                    if (builder.length() == 1) {
                        hasOpenBracket = true;
                    }
                    builder.append((char)ch);
                    continue block9;
                }
                case 93: {
                    if (isComment && hasOpenBracket) {
                        hasCloseBracket = true;
                    }
                    builder.append((char)ch);
                    continue block9;
                }
                case 45: {
                    if (!isComment || builder.length() != 2 || builder.charAt(1) != '-') break;
                    return TOKEN_COMMENT;
                }
            }
            if (Character.isWhitespace(ch)) {
                if (builder.length() <= 0) continue;
                if (!isComment || !hasOpenBracket || hasCloseBracket) {
                    this.push((char)ch);
                    return builder.toString();
                }
                builder.append((char)ch);
                continue;
            }
            builder.append((char)ch);
        }
    }

    public String readValue() throws IOException {
        StringBuilder builder = new StringBuilder();
        int quote = 32;
        block6: while (true) {
            int ch = this.read();
            switch (ch) {
                case 62: {
                    if (quote == 32) {
                        this.push('>');
                        return builder.toString();
                    }
                    builder.append((char)ch);
                    continue block6;
                }
                case -1: {
                    return builder.toString();
                }
                case 34: 
                case 39: {
                    if (quote == ch) {
                        return builder.toString();
                    }
                    if (quote == 32) {
                        quote = ch;
                        continue block6;
                    }
                    builder.append((char)ch);
                    continue block6;
                }
                case 38: {
                    builder.append(this.readQuotedChar());
                    continue block6;
                }
            }
            if (quote == 32 && Character.isWhitespace(ch)) {
                if (builder.length() <= 0) continue;
                return builder.toString();
            }
            builder.append((char)ch);
        }
    }

    public void skipScript() throws IOException {
        int quote = 0;
        int comment = 0;
        block9: while (true) {
            int ch = this.read();
            switch (ch) {
                case -1: {
                    return;
                }
                case 60: {
                    if (quote != 0 || comment >= 2) continue block9;
                    char ch2 = (char)this.read();
                    if (ch2 != '/') continue block9;
                    this.push(ch2);
                    this.push('<');
                    return;
                }
                case 10: {
                    if (comment != true) break;
                    comment = 0;
                    break;
                }
                case 42: {
                    if (comment != 2) break;
                    char ch2 = (char)this.read();
                    if (ch2 != '/') continue block9;
                    comment = 0;
                    break;
                }
                case 47: {
                    if (quote != 0) break;
                    char ch2 = (char)this.read();
                    if (ch2 == '/') {
                        comment = 1;
                        break;
                    }
                    if (ch2 != '*') continue block9;
                    comment = 2;
                    break;
                }
                case 92: {
                    if (quote == 0) break;
                    this.read();
                    break;
                }
                case 34: 
                case 39: {
                    if (comment != 0) break;
                    if (quote == ch) {
                        quote = 0;
                        break;
                    }
                    if (quote != 0) break;
                    quote = ch;
                }
            }
        }
    }

    public boolean skipTag() throws IOException {
        while (true) {
            int ch = this.read();
            switch (ch) {
                case -1: 
                case 62: {
                    return true;
                }
                case 60: {
                    return false;
                }
            }
        }
    }

    public String skipComment() throws IOException {
        int level = 0;
        StringBuilder buffer = new StringBuilder();
        block5: while (true) {
            int ch = this.read();
            buffer.append((char)ch);
            switch (ch) {
                case -1: {
                    break block5;
                }
                case 62: {
                    if (level >= 2) {
                        return buffer.toString();
                    }
                    level = 0;
                    continue block5;
                }
                case 45: {
                    ++level;
                    continue block5;
                }
                default: {
                    level = 0;
                    continue block5;
                }
            }
            break;
        }
        return buffer.toString();
    }

    static {
        PushReader.putNamedChar("quot", 34);
        PushReader.putNamedChar("amp", 38);
        PushReader.putNamedChar("lt", 60);
        PushReader.putNamedChar("gt", 62);
        PushReader.putNamedChar("nbsp", 160);
        PushReader.putNamedChar("iexcl", 161);
        PushReader.putNamedChar("cent", 162);
        PushReader.putNamedChar("pound", 163);
        PushReader.putNamedChar("curren", 164);
        PushReader.putNamedChar("yen", 165);
        PushReader.putNamedChar("brvbar", 166);
        PushReader.putNamedChar("sect", 167);
        PushReader.putNamedChar("uml", 168);
        PushReader.putNamedChar("copy", 169);
        PushReader.putNamedChar("ordf", 170);
        PushReader.putNamedChar("laquo", 171);
        PushReader.putNamedChar("not", 172);
        PushReader.putNamedChar("shy", 173);
        PushReader.putNamedChar("reg", 174);
        PushReader.putNamedChar("macr", 175);
        PushReader.putNamedChar("deg", 176);
        PushReader.putNamedChar("plusmn", 177);
        PushReader.putNamedChar("sup2", 178);
        PushReader.putNamedChar("sup3", 179);
        PushReader.putNamedChar("acute", 180);
        PushReader.putNamedChar("micro", 181);
        PushReader.putNamedChar("para", 182);
        PushReader.putNamedChar("middot", 183);
        PushReader.putNamedChar("cedil", 184);
        PushReader.putNamedChar("sup1", 185);
        PushReader.putNamedChar("ordm", 186);
        PushReader.putNamedChar("raquo", 187);
        PushReader.putNamedChar("frac14", 188);
        PushReader.putNamedChar("frac12", 189);
        PushReader.putNamedChar("frac34", 190);
        PushReader.putNamedChar("iquest", 191);
        PushReader.putNamedChar("Agrave", 192);
        PushReader.putNamedChar("Aacute", 193);
        PushReader.putNamedChar("Acirc", 194);
        PushReader.putNamedChar("Atilde", 195);
        PushReader.putNamedChar("Auml", 196);
        PushReader.putNamedChar("Aring", 197);
        PushReader.putNamedChar("AElig", 198);
        PushReader.putNamedChar("Ccedil", 199);
        PushReader.putNamedChar("Egrave", 200);
        PushReader.putNamedChar("Eacute", 201);
        PushReader.putNamedChar("Ecirc", 202);
        PushReader.putNamedChar("Euml", 203);
        PushReader.putNamedChar("Igrave", 204);
        PushReader.putNamedChar("Iacute", 205);
        PushReader.putNamedChar("Icirc", 206);
        PushReader.putNamedChar("Iuml", 207);
        PushReader.putNamedChar("ETH", 208);
        PushReader.putNamedChar("Ntilde", 209);
        PushReader.putNamedChar("Ograve", 210);
        PushReader.putNamedChar("Oacute", 211);
        PushReader.putNamedChar("Ocirc", 212);
        PushReader.putNamedChar("Otilde", 213);
        PushReader.putNamedChar("Ouml", 214);
        PushReader.putNamedChar("times", 215);
        PushReader.putNamedChar("Oslash", 216);
        PushReader.putNamedChar("Ugrave", 217);
        PushReader.putNamedChar("Uacute", 218);
        PushReader.putNamedChar("Ucirc", 219);
        PushReader.putNamedChar("Uuml", 220);
        PushReader.putNamedChar("Yacute", 221);
        PushReader.putNamedChar("THORN", 222);
        PushReader.putNamedChar("szlig", 223);
        PushReader.putNamedChar("agrave", 224);
        PushReader.putNamedChar("aacute", 225);
        PushReader.putNamedChar("acirc", 226);
        PushReader.putNamedChar("atilde", 227);
        PushReader.putNamedChar("auml", 228);
        PushReader.putNamedChar("aring", 229);
        PushReader.putNamedChar("aelig", 230);
        PushReader.putNamedChar("ccedil", 231);
        PushReader.putNamedChar("egrave", 232);
        PushReader.putNamedChar("eacute", 233);
        PushReader.putNamedChar("ecirc", 234);
        PushReader.putNamedChar("euml", 235);
        PushReader.putNamedChar("igrave", 236);
        PushReader.putNamedChar("iacute", 237);
        PushReader.putNamedChar("icirc", 238);
        PushReader.putNamedChar("iuml", 239);
        PushReader.putNamedChar("eth", 240);
        PushReader.putNamedChar("ntilde", 241);
        PushReader.putNamedChar("ograve", 242);
        PushReader.putNamedChar("oacute", 243);
        PushReader.putNamedChar("ocirc", 244);
        PushReader.putNamedChar("otilde", 245);
        PushReader.putNamedChar("ouml", 246);
        PushReader.putNamedChar("divide", 247);
        PushReader.putNamedChar("oslash", 248);
        PushReader.putNamedChar("ugrave", 249);
        PushReader.putNamedChar("uacute", 250);
        PushReader.putNamedChar("ucirc", 251);
        PushReader.putNamedChar("uuml", 252);
        PushReader.putNamedChar("yacute", 253);
        PushReader.putNamedChar("thorn", 254);
        PushReader.putNamedChar("yuml", 255);
        PushReader.putNamedChar("OElig", 338);
        PushReader.putNamedChar("oelig", 339);
        PushReader.putNamedChar("Scaron", 352);
        PushReader.putNamedChar("scaron", 353);
        PushReader.putNamedChar("Yuml", 376);
        PushReader.putNamedChar("fnof", 402);
        PushReader.putNamedChar("Alpha", 913);
        PushReader.putNamedChar("alpha", 945);
        PushReader.putNamedChar("Beta", 914);
        PushReader.putNamedChar("beta", 946);
        PushReader.putNamedChar("Gamma", 915);
        PushReader.putNamedChar("gamma", 947);
        PushReader.putNamedChar("Delta", 916);
        PushReader.putNamedChar("delta", 948);
        PushReader.putNamedChar("Epsilon", 917);
        PushReader.putNamedChar("epsilon", 949);
        PushReader.putNamedChar("Zeta", 918);
        PushReader.putNamedChar("zeta", 950);
        PushReader.putNamedChar("Eta", 919);
        PushReader.putNamedChar("eta", 951);
        PushReader.putNamedChar("Theta", 920);
        PushReader.putNamedChar("theta", 952);
        PushReader.putNamedChar("Iota", 921);
        PushReader.putNamedChar("iota", 953);
        PushReader.putNamedChar("Kappa", 922);
        PushReader.putNamedChar("kappa", 954);
        PushReader.putNamedChar("Lambda", 923);
        PushReader.putNamedChar("lambda", 955);
        PushReader.putNamedChar("Mu", 924);
        PushReader.putNamedChar("mu", 956);
        PushReader.putNamedChar("Nu", 925);
        PushReader.putNamedChar("nu", 957);
        PushReader.putNamedChar("Xi", 926);
        PushReader.putNamedChar("xi", 958);
        PushReader.putNamedChar("Omicron", 927);
        PushReader.putNamedChar("omicron", 959);
        PushReader.putNamedChar("Pi", 928);
        PushReader.putNamedChar("pi", 960);
        PushReader.putNamedChar("Rho", 929);
        PushReader.putNamedChar("rho", 961);
        PushReader.putNamedChar("Sigma", 931);
        PushReader.putNamedChar("sigmaf", 962);
        PushReader.putNamedChar("sigma", 963);
        PushReader.putNamedChar("Tau", 932);
        PushReader.putNamedChar("tau", 964);
        PushReader.putNamedChar("Upsilon", 933);
        PushReader.putNamedChar("upsilon", 965);
        PushReader.putNamedChar("Phi", 934);
        PushReader.putNamedChar("phi", 966);
        PushReader.putNamedChar("Chi", 935);
        PushReader.putNamedChar("chi", 967);
        PushReader.putNamedChar("Psi", 936);
        PushReader.putNamedChar("psi", 968);
        PushReader.putNamedChar("Omega", 937);
        PushReader.putNamedChar("omega", 969);
        PushReader.putNamedChar("thetasym", 977);
        PushReader.putNamedChar("upsih", 978);
        PushReader.putNamedChar("piv", 982);
        PushReader.putNamedChar("forall", 8704);
        PushReader.putNamedChar("part", 8706);
        PushReader.putNamedChar("exist", 8707);
        PushReader.putNamedChar("empty", 8709);
        PushReader.putNamedChar("nabla", 8711);
        PushReader.putNamedChar("isin", 8712);
        PushReader.putNamedChar("notin", 8713);
        PushReader.putNamedChar("ni", 8715);
        PushReader.putNamedChar("prod", 8719);
        PushReader.putNamedChar("sum", 8721);
        PushReader.putNamedChar("minus", 8722);
        PushReader.putNamedChar("lowast", 8727);
        PushReader.putNamedChar("radic", 8730);
        PushReader.putNamedChar("prop", 8733);
        PushReader.putNamedChar("infin", 8734);
        PushReader.putNamedChar("ang", 8736);
        PushReader.putNamedChar("and", 8869);
        PushReader.putNamedChar("or", 8870);
        PushReader.putNamedChar("cap", 8745);
        PushReader.putNamedChar("cup", 8746);
        PushReader.putNamedChar("int", 8747);
        PushReader.putNamedChar("there4", 8756);
        PushReader.putNamedChar("sim", 8764);
        PushReader.putNamedChar("cong", 8773);
        PushReader.putNamedChar("asymp", 8776);
        PushReader.putNamedChar("ne", 8800);
        PushReader.putNamedChar("equiv", 8801);
        PushReader.putNamedChar("le", 8804);
        PushReader.putNamedChar("ge", 8805);
        PushReader.putNamedChar("sub", 8834);
        PushReader.putNamedChar("sup", 8835);
        PushReader.putNamedChar("nsub", 8836);
        PushReader.putNamedChar("sube", 8838);
        PushReader.putNamedChar("supe", 8839);
        PushReader.putNamedChar("oplus", 8853);
        PushReader.putNamedChar("otimes", 8855);
        PushReader.putNamedChar("perp", 8869);
        PushReader.putNamedChar("sdot", 8901);
        PushReader.putNamedChar("loz", 9674);
        PushReader.putNamedChar("lceil", 8968);
        PushReader.putNamedChar("rceil", 8969);
        PushReader.putNamedChar("lfloor", 8970);
        PushReader.putNamedChar("rfloor", 8971);
        PushReader.putNamedChar("lang", 9001);
        PushReader.putNamedChar("rang", 9002);
        PushReader.putNamedChar("larr", 8592);
        PushReader.putNamedChar("uarr", 8593);
        PushReader.putNamedChar("rarr", 8594);
        PushReader.putNamedChar("darr", 8595);
        PushReader.putNamedChar("harr", 8596);
        PushReader.putNamedChar("crarr", 8629);
        PushReader.putNamedChar("lArr", 8656);
        PushReader.putNamedChar("uArr", 8657);
        PushReader.putNamedChar("rArr", 8658);
        PushReader.putNamedChar("dArr", 8659);
        PushReader.putNamedChar("hArr", 8660);
        PushReader.putNamedChar("bull", 8226);
        PushReader.putNamedChar("hellip", 8230);
        PushReader.putNamedChar("prime", 8242);
        PushReader.putNamedChar("oline", 8254);
        PushReader.putNamedChar("frasl", 8260);
        PushReader.putNamedChar("weierp", 8472);
        PushReader.putNamedChar("image", 8465);
        PushReader.putNamedChar("real", 8476);
        PushReader.putNamedChar("trade", 8482);
        PushReader.putNamedChar("euro", 8364);
        PushReader.putNamedChar("alefsym", 8501);
        PushReader.putNamedChar("spades", 9824);
        PushReader.putNamedChar("clubs", 9827);
        PushReader.putNamedChar("hearts", 9829);
        PushReader.putNamedChar("diams", 9830);
        PushReader.putNamedChar("ensp", 8194);
        PushReader.putNamedChar("emsp", 8195);
        PushReader.putNamedChar("thinsp", 8201);
        PushReader.putNamedChar("zwnj", 8204);
        PushReader.putNamedChar("zwj", 8205);
        PushReader.putNamedChar("lrm", 8206);
        PushReader.putNamedChar("rlm", 8207);
        PushReader.putNamedChar("ndash", 8211);
        PushReader.putNamedChar("mdash", 8212);
        PushReader.putNamedChar("lsquo", 8216);
        PushReader.putNamedChar("rsquo", 8217);
        PushReader.putNamedChar("sbquo", 8218);
        PushReader.putNamedChar("ldquo", 8220);
        PushReader.putNamedChar("rdquo", 8221);
        PushReader.putNamedChar("bdquo", 8222);
        PushReader.putNamedChar("dagger", 8224);
        PushReader.putNamedChar("Dagger", 8225);
        PushReader.putNamedChar("permil", 8240);
        PushReader.putNamedChar("lsaquo", 8249);
        PushReader.putNamedChar("rsaquo", 8250);
        PushReader.putNamedChar("circ", 710);
        PushReader.putNamedChar("tilde", 732);
    }
}

