/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser;

import com.inet.html.css.CSS;
import com.inet.html.css.Styles;
import com.inet.html.parser.PushReader;
import com.inet.html.parser.URLResolver;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.utils.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.SuppressFBWarnings;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class CssParser {
    private PushReader reader;
    private final URL baseURL;
    private final StringBuilder content = new StringBuilder();
    private final Styles styles;
    private final Object sourceID;
    private boolean ignoreUnknown = false;
    private Pattern importPattern = Pattern.compile("@import[\\t\\s]+(?:url\\([\\t\\s]*\"?(.+?)\"?[\\t\\s]*\\)|\"(.+)\")[\\t\\s]*(.*?)[\\t\\s]*", 2);
    private boolean avoidDuplicates;
    private boolean isInline = true;
    private boolean isInStyleElement = false;
    private int timeout = -4242;
    private String charset;

    public CssParser(URL url, Styles styles, boolean ignoreUnknown, Object sourceID) throws IOException {
        this.isInline = false;
        this.styles = styles;
        this.baseURL = url;
        this.sourceID = sourceID;
        this.ignoreUnknown = ignoreUnknown;
    }

    public CssParser(PushReader reader, Styles styles, boolean ignoreUnknown) {
        this.reader = reader;
        this.styles = styles;
        this.baseURL = null;
        this.sourceID = null;
        this.ignoreUnknown = ignoreUnknown;
    }

    public CssParser(URL url, Object sourceID, Styles styles, String charset, boolean ignoreUnknown) throws IOException {
        this.charset = charset;
        this.ignoreUnknown = ignoreUnknown;
        this.isInline = false;
        this.styles = styles;
        this.baseURL = url;
        this.sourceID = sourceID;
    }

    public CssParser(String style, Styles styles, URL baseURL, boolean ignoreUnknown, boolean avoidDuplicates) {
        this(new PushReader(new StringReader(style)), styles, null, baseURL, ignoreUnknown, avoidDuplicates, false);
    }

    public CssParser(PushReader reader, Styles styles, Object sourceID, URL baseURL, boolean ignoreUnknown, boolean avoidDuplicates, boolean isStyleElement) {
        this.reader = reader;
        this.styles = styles;
        this.baseURL = baseURL;
        this.sourceID = sourceID;
        this.ignoreUnknown = ignoreUnknown;
        this.avoidDuplicates = avoidDuplicates;
        this.isInStyleElement = isStyleElement;
    }

    public void parse() throws IOException {
        this.parseWithID();
    }

    private PushReader getReader(URL url, String charset) throws IOException, UnsupportedEncodingException {
        InputStreamReader inputReader;
        if (this.reader != null) {
            return this.reader;
        }
        InputStream input = this.getStream(url);
        BufferedInputStream bufInput = new BufferedInputStream(input, 8192);
        bufInput.mark(8192);
        try {
            inputReader = charset == null ? new InputStreamReader(bufInput) : new InputStreamReader((InputStream)bufInput, charset);
        }
        catch (Throwable th) {
            inputReader = new InputStreamReader(input);
        }
        PushReader rd = new PushReader(inputReader);
        if (!"UTF8".equalsIgnoreCase(charset)) {
            try {
                rd.checkForUtf8Prefix();
            }
            catch (ChangedCharSetException ex) {
                charset = ex.getCharSetSpec();
                bufInput.reset();
                rd = new PushReader(new InputStreamReader((InputStream)bufInput, charset));
            }
        }
        this.reader = rd;
        return rd;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The CSS parser requires access to any location donated in the style-element. But the content will not be displayed but interpreted as CSS to be applied to the local DOM.")
    private InputStream getStream(URL url) throws IOException {
        if (url == null || this.timeout != -4242 && this.timeout < 0) {
            return new ByteArrayInputStream(new byte[0]);
        }
        URLConnection connection = url.openConnection();
        if (this.timeout != -4242) {
            connection.setConnectTimeout(this.timeout);
            connection.setReadTimeout(this.timeout);
        }
        return connection.getInputStream();
    }

    public void setConnectionTimtout(int timeout) {
        this.timeout = timeout;
    }

    public Object parseWithID() throws IOException {
        Object classID = this.styles.register(this.sourceID, this.isInline, this.sourceID != null);
        if (classID == Styles.DONT_PARSE) {
            this.parseLoop(true);
            return this.styles.getClassName(this.sourceID);
        }
        boolean hasGeneratedStyle = this.parseLoop(false);
        if (hasGeneratedStyle) {
            classID = null;
            this.styles.unregister(classID);
        }
        this.styles.updateIndex();
        return classID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseLoop(boolean skipSelectorAdd) throws IOException {
        boolean allGenerated = true;
        boolean wasSlash = false;
        PushReader reader = this.getReader(this.baseURL, this.charset);
        try {
            block16: while (true) {
                int ch = reader.read();
                switch (ch) {
                    case -1: {
                        reader.close();
                        return allGenerated;
                    }
                    case 60: {
                        if (this.skipHTMLCommentStart()) continue block16;
                        reader.push('<');
                        return allGenerated;
                    }
                    case 125: {
                        if (!(this.sourceID instanceof MediaSelector)) continue block16;
                        String remaining = this.content.toString().trim();
                        if (remaining.length() > 0) {
                            allGenerated &= this.styles.addRule(remaining, new SimpleAttributeSet(), this.sourceID, this.avoidDuplicates);
                        }
                        return allGenerated;
                    }
                    case 123: {
                        String selector = this.content.toString().trim();
                        selector = selector.replace("\n", "").replace("\r", "").replaceAll("\\s+", " ");
                        this.content.setLength(0);
                        if (selector.contains("@")) {
                            String lowerSelector = selector.toLowerCase();
                            boolean useSelector = (lowerSelector.contains("screen") || lowerSelector.contains("all")) && !lowerSelector.contains("max-");
                            CssParser subParser = new CssParser(reader, this.styles, new MediaSelector(lowerSelector, useSelector, this.sourceID), this.baseURL, skipSelectorAdd, allGenerated, true);
                            subParser.parseWithID();
                            break;
                        }
                        SimpleAttributeSet attrs = new SimpleAttributeSet();
                        this.parseStyle(attrs);
                        this.applyBaseURL(attrs);
                        if (skipSelectorAdd) continue block16;
                        allGenerated &= this.styles.addRule(selector, attrs, this.sourceID, this.avoidDuplicates);
                        break;
                    }
                    case 65279: {
                        break;
                    }
                    case 59: {
                        String contentString = this.content.toString().trim();
                        Matcher m = this.importPattern.matcher(contentString);
                        if (contentString.length() > 10 && m.matches()) {
                            String media;
                            String url = m.group(1) != null ? m.group(1) : m.group(2);
                            String string = media = m.groupCount() > 2 ? m.group(3) : null;
                            if (media != null && media.length() > 0 && !media.toLowerCase().contains("screen")) continue block16;
                            if (url.length() <= 0) continue block16;
                            try {
                                URL importLink;
                                URL uRL = importLink = this.baseURL != null ? new URL(this.baseURL, url) : new URL(url);
                                if (!skipSelectorAdd) {
                                    importLink.toURI();
                                    CssParser importParser = new CssParser(importLink, this.styles, this.ignoreUnknown, this.sourceID);
                                    importParser.setConnectionTimtout(this.timeout);
                                    importParser.parse();
                                }
                            }
                            catch (MalformedURLException e) {
                                Logger.warning("Invalid CSS @import: " + url);
                            }
                            catch (IOException e) {
                                Logger.warning("Unable to parse CSS @import: " + url);
                                Logger.debug(e.getMessage());
                            }
                            catch (URISyntaxException e) {
                                Logger.warning("Invalid CSS @import: " + url);
                            }
                            this.content.setLength(0);
                            break;
                        }
                        this.content.append((char)ch);
                        break;
                    }
                    case 47: {
                        if (!wasSlash) {
                            wasSlash = true;
                            break;
                        }
                    }
                    case 45: {
                        if (ch == 45 && this.skipHTMLCommentEnd()) continue block16;
                    }
                    default: {
                        if (wasSlash) {
                            if (ch == 42) {
                                this.skipComment();
                            } else {
                                this.content.append('/');
                                this.content.append((char)ch);
                            }
                            wasSlash = false;
                            break;
                        }
                        this.content.append((char)ch);
                    }
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return allGenerated;
        }
    }

    private void applyBaseURL(MutableAttributeSet attrs) {
        if (attrs.getAttributeCount() > 0) {
            Enumeration<?> names = attrs.getAttributeNames();
            while (names.hasMoreElements()) {
                Object attrib = attrs.getAttribute(names.nextElement());
                if (!(attrib instanceof URLResolver.URLResolverContainer)) continue;
                ((URLResolver.URLResolverContainer)attrib).getResolver().setBase(this.baseURL);
            }
        }
    }

    private boolean skipHTMLCommentStart() throws IOException {
        int[] buffer = new int[2];
        int ch = this.reader.read();
        if (ch != 33) {
            this.reader.push((char)ch);
            return false;
        }
        buffer[0] = ch;
        ch = this.reader.read();
        if (ch != 45) {
            this.reader.push((char)ch);
            this.reader.push((char)buffer[0]);
            return false;
        }
        buffer[1] = ch;
        ch = this.reader.read();
        if (ch != 45) {
            this.reader.push((char)ch);
            this.reader.push((char)buffer[1]);
            this.reader.push((char)buffer[0]);
            return false;
        }
        return true;
    }

    private boolean isClosingStyleTag() throws IOException {
        String style = "/style>";
        StringBuilder b = new StringBuilder(7);
        int pos = 0;
        int ch = this.reader.read();
        b.append((char)ch);
        boolean isStyleTag = false;
        while (style.charAt(pos) == Character.toLowerCase((char)ch) && pos < style.length()) {
            if (++pos == style.length()) {
                isStyleTag = true;
                break;
            }
            ch = this.reader.read();
            b.append((char)ch);
        }
        pos = b.length() - 1;
        do {
            this.reader.push(b.charAt(pos--));
        } while (pos >= 0);
        return isStyleTag;
    }

    private boolean skipHTMLCommentEnd() throws IOException {
        int ch = this.reader.read();
        if (ch != 45) {
            this.reader.push((char)ch);
            return false;
        }
        int buf = ch;
        ch = this.reader.read();
        if (ch != 62) {
            this.reader.push((char)ch);
            this.reader.push((char)buf);
            return false;
        }
        return true;
    }

    private void skipComment() throws IOException {
        boolean wasAsterisk = false;
        block5: while (true) {
            int ch = this.reader.read();
            switch (ch) {
                case -1: {
                    return;
                }
                case 42: {
                    wasAsterisk = true;
                    continue block5;
                }
                case 47: {
                    if (!wasAsterisk) break;
                    return;
                }
            }
            wasAsterisk = false;
        }
    }

    public void parseStyle(MutableAttributeSet attrs) throws IOException {
        int delimter = 59;
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        StringBuilder important = null;
        boolean parenthesize = false;
        boolean wasSlash = false;
        block10: while (true) {
            int ch = this.reader.read();
            switch (ch) {
                case -1: 
                case 125: {
                    this.addStyleToSet(attrs, key, value, important);
                    this.applyBaseURL(attrs);
                    return;
                }
                case 58: {
                    if (parenthesize) break;
                    delimter = ch;
                    continue block10;
                }
                case 60: {
                    if (!this.isInStyleElement || !this.isClosingStyleTag()) break;
                    this.addStyleToSet(attrs, key, value, important);
                    this.reader.push('<');
                    return;
                }
                case 59: {
                    if (parenthesize) break;
                    this.addStyleToSet(attrs, key, value, important);
                    important = null;
                    delimter = ch;
                    continue block10;
                }
                case 47: {
                    if (wasSlash) break;
                    wasSlash = true;
                    continue block10;
                }
                case 33: {
                    important = new StringBuilder();
                    delimter = ch;
                    continue block10;
                }
                case 40: {
                    parenthesize = true;
                    break;
                }
                case 41: {
                    parenthesize = false;
                }
            }
            if (wasSlash) {
                if (ch == 42) {
                    this.skipComment();
                } else if (delimter == 59) {
                    key.append('/');
                    key.append((char)ch);
                } else {
                    value.append('/');
                    value.append((char)ch);
                }
                wasSlash = false;
                continue;
            }
            if (delimter == 59) {
                key.append((char)ch);
                continue;
            }
            if (delimter == 33 && important != null) {
                important.append((char)ch);
                continue;
            }
            value.append((char)ch);
        }
    }

    public void addStyleToSet(MutableAttributeSet attrs, StringBuilder key, StringBuilder value, StringBuilder important) {
        boolean importantFlag = important != null && important.toString().trim().equalsIgnoreCase("important");
        this.addAttribute(attrs, key, value, importantFlag);
    }

    private void addAttribute(MutableAttributeSet attrs, StringBuilder key, StringBuilder value, boolean important) {
        String keyStr = key.toString().trim().toLowerCase();
        String valueStr = value.toString().trim();
        key.setLength(0);
        value.setLength(0);
        if (keyStr.length() == 0) {
            return;
        }
        CSS.Attribute attr = CSS.getAttribute(keyStr);
        if (attr != null) {
            try {
                AttributeValue.addCssAtrributes(attrs, attr, valueStr, important);
            }
            catch (Exception e) {
                Logger.error(e);
                if (!this.ignoreUnknown) {
                    attrs.addAttribute(new CSS.UnknownAttribute(keyStr), valueStr);
                }
            }
        } else if (!this.ignoreUnknown) {
            attrs.addAttribute(new CSS.UnknownAttribute(keyStr), valueStr);
        }
    }

    public static class MediaSelector {
        private String selector;
        private boolean useStyles;
        private Object sourceID;

        public MediaSelector(String selector, boolean useStyles, Object sourceID) {
            this.selector = selector;
            this.useStyles = useStyles;
            this.sourceID = sourceID;
        }

        public Object getSourceID() {
            return this.sourceID;
        }

        public boolean isUseStyles() {
            return this.useStyles;
        }

        public String toString() {
            return this.selector;
        }
    }
}

