/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.image;

import com.inet.html.InetHtmlDocument;
import com.inet.html.image.AnimationObserver;
import com.inet.html.image.ImageFetcher;
import com.inet.html.image.RemoteImage;
import com.inet.html.parser.URLResolver;
import com.inet.html.utils.Logger;
import com.inet.html.utils.SoftHashMap;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;

public class ImageCache {
    private static final String CACHE_PREFIX = "CACHE:";
    private ImageFetcher fetcher;
    private SoftHashMap<String, RemoteImage> cache = new SoftHashMap();
    private AtomicLong idCounter = new AtomicLong(1000000L);
    private static ImageCache staticInstance = null;

    public ImageCache(ImageFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public static synchronized ImageCache getStaticInstance() {
        if (staticInstance == null) {
            staticInstance = new ImageCache(new ImageFetcher());
        }
        return staticInstance;
    }

    public RemoteImage getImage(String identifier, URL base, boolean progressive, AnimationObserver observer) {
        return this.getImage(identifier, base, null, progressive, observer);
    }

    public RemoteImage getImage(String identifier, URL base, InetHtmlDocument.TimeoutProvider timeout, boolean progressive, AnimationObserver observer) {
        URLResolver resolver = new URLResolver(identifier);
        resolver.setBase(base);
        return this.getImage(resolver, timeout, progressive, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteImage getImage(URLResolver resolver, InetHtmlDocument.TimeoutProvider timeout, boolean progressive, AnimationObserver observer) {
        RemoteImage cached = null;
        String identifier = resolver.getOriginalURI();
        if (ImageCache.isCacheReference(identifier)) {
            SoftHashMap<String, RemoteImage> softHashMap = this.cache;
            synchronized (softHashMap) {
                cached = this.cache.get(identifier);
            }
            if (cached != null) {
                cached.addObserver(observer);
                return cached;
            }
            this.sendError(observer);
            return null;
        }
        URL location = null;
        try {
            location = resolver.getFullURL();
            identifier = location.toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        SoftHashMap<String, RemoteImage> softHashMap = this.cache;
        synchronized (softHashMap) {
            cached = this.cache.get(identifier);
        }
        if (cached != null) {
            cached.addObserver(observer);
        } else {
            int timeoutMS = -4242;
            if (timeout != null && (timeoutMS = timeout.getTimeout(location)) < 0 && timeoutMS != -4242) {
                return null;
            }
            cached = this.fetcher.getImage(resolver, timeoutMS, progressive, observer);
            SoftHashMap<String, RemoteImage> softHashMap2 = this.cache;
            synchronized (softHashMap2) {
                this.cache.put(identifier, cached);
            }
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(String identifier, URL base, Image content) {
        URL url;
        RemoteImage cached = new RemoteImage(content);
        if (ImageCache.isCacheReference(identifier)) {
            SoftHashMap<String, RemoteImage> softHashMap = this.cache;
            synchronized (softHashMap) {
                cached = this.cache.put(identifier, cached);
            }
        }
        try {
            url = new URLResolver(identifier, base).getFullURL();
        }
        catch (MalformedURLException e) {
            return;
        }
        SoftHashMap<String, RemoteImage> softHashMap = this.cache;
        synchronized (softHashMap) {
            this.cache.put(url.toString(), cached);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKey(String identifier, URL base) {
        URL url;
        if (ImageCache.isCacheReference(identifier)) {
            SoftHashMap<String, RemoteImage> softHashMap = this.cache;
            synchronized (softHashMap) {
                return this.cache.remove(identifier) != null;
            }
        }
        try {
            url = new URLResolver(identifier, base).getFullURL();
        }
        catch (MalformedURLException e) {
            Logger.warning(e);
            return false;
        }
        SoftHashMap<String, RemoteImage> softHashMap = this.cache;
        synchronized (softHashMap) {
            return this.cache.remove(url.toString()) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getCachedImage(String identifier, URL base) {
        RemoteImage cacheContent = null;
        if (ImageCache.isCacheReference(identifier)) {
            SoftHashMap<String, RemoteImage> softHashMap = this.cache;
            synchronized (softHashMap) {
                cacheContent = this.cache.get(identifier);
            }
        }
        try {
            URL url = new URLResolver(identifier, base).getFullURL();
            SoftHashMap<String, RemoteImage> softHashMap = this.cache;
            synchronized (softHashMap) {
                cacheContent = this.cache.get(url.toString());
            }
        }
        catch (MalformedURLException e) {
            Logger.warning(e);
        }
        if (cacheContent != null && cacheContent.getStatus() == 2) {
            return cacheContent.getContent();
        }
        return null;
    }

    private void sendError(ImageObserver observer) {
        if (observer != null) {
            observer.imageUpdate(null, 64, 0, 0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerImage(Image content) {
        String id = CACHE_PREFIX + this.idCounter.incrementAndGet();
        SoftHashMap<String, RemoteImage> softHashMap = this.cache;
        synchronized (softHashMap) {
            this.cache.put(id, new RemoteImage(content));
        }
        return id;
    }

    public static boolean isCacheReference(String identifier) {
        return identifier != null && identifier.startsWith(CACHE_PREFIX);
    }
}

