/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.edit.image;

import com.inet.html.css.CSS;
import com.inet.html.edit.EditDialog;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.TextAlign;
import com.inet.html.views.ImageView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class PanelFloating
implements EditDialog.EditPanel {
    private JPanel pnlFloat = new JPanel();
    private ButtonGroup group = new ButtonGroup();
    private byte floating;

    public PanelFloating(ImageView current) {
        this.floating = (byte)current.getFloat();
        if (current.getDisplay() == 3 && current.getJustification() == 1) {
            this.floating = 1;
        }
    }

    @Override
    public AttributeSet getAttributes() {
        SimpleAttributeSet atts = new SimpleAttributeSet();
        if (this.floating == 1) {
            atts.addAttribute((Object)CSS.Attribute.TEXT_ALIGN, new TextAlign(1));
            atts.addAttribute((Object)CSS.Attribute.DISPLAY, new DisplayValue(3));
            atts.addAttribute((Object)CSS.Attribute.FLOAT, new FloatValue(0));
        } else {
            atts.addAttribute((Object)CSS.Attribute.TEXT_ALIGN, new TextAlign(0));
            atts.addAttribute((Object)CSS.Attribute.FLOAT, new FloatValue(this.floating));
            atts.addAttribute((Object)CSS.Attribute.DISPLAY, new DisplayValue(2));
        }
        return atts;
    }

    @Override
    public JComponent getComponent() {
        this.pnlFloat.setLayout(new BoxLayout(this.pnlFloat, 1));
        this.addButton("None", (byte)0);
        this.addButton("Left", (byte)3);
        this.addButton("Center", (byte)1);
        this.addButton("Right", (byte)2);
        return this.pnlFloat;
    }

    private void addButton(String name, final byte floatConst) {
        JRadioButton btn = new JRadioButton(name);
        this.group.add(btn);
        this.pnlFloat.add(btn);
        btn.setSelected(this.floating == floatConst);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelFloating.this.floating = floatConst;
            }
        });
    }

    @Override
    public String getTabName() {
        return "Floating";
    }
}

