/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.edit;

import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlWriter;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.edit.EditDialog;
import com.inet.html.edit.EditPainter;
import com.inet.html.edit.ElementEditor;
import com.inet.html.edit.image.PanelBoxModel;
import com.inet.html.edit.image.PanelFloating;
import com.inet.html.edit.image.PanelImageProps;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxView;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.ImageView;
import com.inet.html.views.ViewPositionInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;

public class ImageEditor
extends MouseAdapter
implements ElementEditor,
EditPainter {
    private static final int TOLERANCE = 3;
    private JEditorPane editor;
    private State currentState;
    private State pendingState;
    private boolean pressed = false;
    private boolean isDrag = false;
    private Point startPoint;

    @Override
    public HTML.Tag[] getHandledTags() {
        return new HTML.Tag[]{HTML.Tag.IMG};
    }

    @Override
    public MouseAdapter getMouseHandler() {
        return this;
    }

    @Override
    public boolean setSelectedView(BoxView view, Rectangle viewOutline, Element refElement) {
        if (!this.editor.isEditable()) {
            if (this.currentState != null) {
                this.deactivateEditor();
                return true;
            }
            return false;
        }
        if (view instanceof ImageView) {
            Rectangle outline = viewOutline;
            Insets insets = this.editor.getInsets();
            if (insets != null) {
                outline.x += insets.left;
                outline.y += insets.top;
            }
            if (this.currentState == null || !this.pressed) {
                this.currentState = new State((ImageView)view, outline, refElement);
            } else if (this.currentState.current != view && (this.pendingState == null || this.pendingState.current != view)) {
                this.pendingState = new State((ImageView)view, outline, refElement);
            }
            return true;
        }
        if (!this.pressed) {
            this.deactivateEditor();
        }
        return this.currentState == null;
    }

    @Override
    public void setEditor(JEditorPane editor) {
        this.editor = editor;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.currentState == null) {
            return;
        }
        Rectangle outline = this.currentState.outline;
        Rectangle prevOutline = outline.getBounds();
        switch (this.currentState.dragBorder) {
            case N: 
            case NE: 
            case NW: {
                int y1 = outline.y + outline.height;
                outline.y = Math.min(y1 - 1, e.getY());
                outline.height = Math.max(1, y1 - e.getY());
                break;
            }
            case S: 
            case SE: 
            case SW: {
                outline.height = Math.max(1, e.getY() - outline.y);
                break;
            }
        }
        switch (this.currentState.dragBorder) {
            case NW: 
            case SW: 
            case W: {
                int x1 = outline.x + outline.width;
                outline.x = Math.min(x1 - 1, e.getX());
                outline.width = Math.max(1, x1 - e.getX());
                break;
            }
            case NE: 
            case SE: 
            case E: {
                outline.width = Math.max(1, e.getX() - outline.x);
                break;
            }
        }
        int repaintRange = 25;
        if (this.currentState.dragBorder == BORDER.INSIDE) {
            outline.x = this.startPoint.x + e.getX();
            outline.y = this.startPoint.y + e.getY();
            repaintRange = 50;
            int pos = this.editor.getUI().viewToModel(this.editor, e.getPoint());
            this.editor.getCaret().setDot(pos);
        }
        e.consume();
        prevOutline = prevOutline.union(outline);
        this.editor.repaint(this.expand(prevOutline, repaintRange));
        this.isDrag = true;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.pressed) {
            return;
        }
        this.updateLocation(e, this.currentState);
        this.editor.setCursor(this.currentState.dragBorder.getCursor());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.updateLocation(e, this.currentState);
        this.updateLocation(e, this.pendingState);
        if (this.currentState.dragBorder != BORDER.OUTSIDE) {
            this.startPoint = new Point(((State)this.currentState).outline.x - e.getX(), ((State)this.currentState).outline.y - e.getY());
            this.activateEditor(this.currentState);
        } else {
            this.deactivateEditor();
            if (this.pendingState != null && this.pendingState.dragBorder != BORDER.OUTSIDE) {
                this.activateEditor(this.pendingState);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isDrag) {
            this.isDrag = false;
            if (this.currentState == null) {
                return;
            }
            if (this.currentState.dragBorder == BORDER.INSIDE) {
                Element refElement = this.currentState.refElement;
                int pos = this.editor.getUI().viewToModel(this.editor, e.getPoint());
                if (pos < refElement.getStartOffset() || pos > refElement.getEndOffset()) {
                    Document doc = this.editor.getDocument();
                    CharArrayWriter out = new CharArrayWriter();
                    InetHtmlDocument htmlDoc = (InetHtmlDocument)doc;
                    int len = refElement.getEndOffset() - refElement.getStartOffset();
                    InetHtmlWriter writer = new InetHtmlWriter((Writer)out, htmlDoc, refElement.getStartOffset(), len);
                    try {
                        Rectangle r;
                        Point pt;
                        ViewPositionInfo info;
                        writer.write();
                        doc.remove(refElement.getStartOffset(), len);
                        if (pos > refElement.getEndOffset()) {
                            pos -= len;
                        }
                        htmlDoc.pasteHTML(out.toString(), pos, pos);
                        HtmlRootView rootView = (HtmlRootView)this.editor.getUI().getRootView(this.editor).getView(0);
                        Rectangle rootSize = new Rectangle(0, 0, rootView.getOuterWidth(), rootView.getOuterHeight());
                        Shape newOutline = rootView.modelToView(pos, rootSize, Position.Bias.Forward);
                        if (newOutline != null && (info = rootView.getViewForPosition(pt = new Point((int)(r = newOutline.getBounds()).getCenterX(), (int)r.getCenterY()), rootSize)) != null && info.getView() instanceof ImageView) {
                            this.currentState = new State((ImageView)info.getView(), info.getBounds(), info.getView().getElement());
                            this.editor.repaint(this.expand(this.currentState.outline, 5));
                        }
                    }
                    catch (BadLocationException e1) {
                        Logger.error(e1);
                    }
                    catch (IOException e1) {
                        Logger.error(e1);
                    }
                } else {
                    this.editor.repaint(this.expand(this.currentState.outline, 5));
                    this.revertOutline(this.currentState);
                }
            } else {
                InetHtmlDocument doc = (InetHtmlDocument)this.editor.getDocument();
                SimpleAttributeSet attributes = new SimpleAttributeSet();
                attributes.addAttribute((Object)CSS.Attribute.WIDTH, new LengthUnit(((State)this.currentState).outline.width));
                attributes.addAttribute((Object)CSS.Attribute.HEIGHT, new LengthUnit(((State)this.currentState).outline.height));
                doc.setElementAttributes(this.currentState.refElement, attributes, false);
                this.revertOutline(this.currentState);
            }
        }
    }

    public void revertOutline(State state) {
        HtmlRootView rootView = (HtmlRootView)this.editor.getUI().getRootView(this.editor).getView(0);
        Rectangle rootSize = new Rectangle(0, 0, rootView.getOuterWidth(), rootView.getOuterHeight());
        try {
            Rectangle r;
            Point pt;
            ViewPositionInfo info;
            Shape newOutline = rootView.modelToView(state.current.getStartOffset(), rootSize, Position.Bias.Forward);
            if (newOutline != null && (info = rootView.getViewForPosition(pt = new Point((int)(r = newOutline.getBounds()).getCenterX(), (int)r.getCenterY()), rootSize)) != null && info.getView() instanceof ImageView) {
                this.currentState = new State((ImageView)info.getView(), info.getBounds(), info.getView().getElement());
                this.editor.repaint(this.expand(this.currentState.outline, 5));
            }
        }
        catch (BadLocationException e) {
            Logger.error(e);
        }
    }

    public void updateLocation(MouseEvent e, State state) {
        boolean isBottom;
        if (state == null) {
            return;
        }
        Rectangle outline = state.outline;
        boolean isLeft = Math.abs(e.getX() - outline.x) <= 3;
        boolean isRight = Math.abs(e.getX() - outline.x - outline.width) <= 3;
        boolean isTop = Math.abs(e.getY() - outline.y) <= 3;
        boolean bl = isBottom = Math.abs(e.getY() - outline.y - outline.height) <= 3;
        if (isTop) {
            if (isLeft) {
                state.dragBorder = BORDER.NW;
            } else if (isRight) {
                state.dragBorder = BORDER.NE;
            } else {
                state.dragBorder = BORDER.N;
            }
        } else if (isBottom) {
            if (isLeft) {
                state.dragBorder = BORDER.SW;
            } else if (isRight) {
                state.dragBorder = BORDER.SE;
            } else {
                state.dragBorder = BORDER.S;
            }
        } else if (isLeft) {
            state.dragBorder = BORDER.W;
        } else if (isRight) {
            state.dragBorder = BORDER.E;
        } else if (outline.contains(e.getPoint())) {
            state.dragBorder = BORDER.INSIDE;
        } else {
            state.dragBorder = BORDER.OUTSIDE;
        }
    }

    public void deactivateEditor() {
        if (this.pressed) {
            this.editor.setNavigationFilter(null);
        }
        this.pressed = false;
        if (this.currentState != null) {
            this.editor.repaint(this.expand(this.currentState.outline, 4));
        }
        this.currentState = null;
        this.editor.setCursor(Cursor.getDefaultCursor());
    }

    public void activateEditor(State state) {
        this.pressed = true;
        this.editor.setNavigationFilter(new NavigationFilter(){

            @Override
            public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            }
        });
        this.currentState = state;
        this.pendingState = null;
        if (state.current != null) {
            this.editor.repaint(this.expand(state.outline, 4));
        }
    }

    private Rectangle expand(Rectangle source, int amount) {
        return new Rectangle(source.x - amount, source.y - amount, source.width + amount * 2, source.height + amount * 2);
    }

    @Override
    public void paint(Graphics g) {
        if (this.currentState == null) {
            return;
        }
        State s = this.currentState;
        if (s.current.getParent() == null) {
            this.deactivateEditor();
            return;
        }
        if (this.pressed) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.GRAY);
            g2.setStroke(new BasicStroke(1.0f, 2, 2, 1.0f, new float[]{3.0f, 5.0f}, 0.0f));
            Rectangle r = s.outline;
            g2.drawLine(r.x, r.y, r.x, r.y + r.height);
            g2.drawLine(r.x, r.y, r.x + r.width, r.y);
            g2.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + r.height);
            g2.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
            g2.setStroke(new BasicStroke(1.0f));
            this.drawResizeMarker(g2, r.x, r.y);
            this.drawResizeMarker(g2, r.x, r.y + r.height);
            this.drawResizeMarker(g2, r.x + r.width, r.y);
            this.drawResizeMarker(g2, r.x + r.width, r.y + r.height);
            if (r.width > 15) {
                this.drawResizeMarker(g2, r.x + r.width / 2, r.y);
                this.drawResizeMarker(g2, r.x + r.width / 2, r.y + r.height);
            }
            if (r.height > 15) {
                this.drawResizeMarker(g2, r.x, r.y + r.height / 2);
                this.drawResizeMarker(g2, r.x + r.width, r.y + r.height / 2);
            }
        }
    }

    private void drawResizeMarker(Graphics2D g, int x, int y) {
        Rectangle rect = new Rectangle(x - 3, y - 3, 7, 7);
        g.setColor(Color.GREEN);
        g.fill(rect);
        g.setColor(Color.BLACK);
        g.draw(rect);
    }

    @Override
    public EditPainter getPainter() {
        return this;
    }

    @Override
    public List<Action> getMenuEntries() {
        if (this.currentState == null || this.currentState.dragBorder == BORDER.OUTSIDE) {
            return null;
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new AbstractAction("Image Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditDialog dialog = new EditDialog("Image Properties", SwingUtilities.getWindowAncestor(ImageEditor.this.editor), new PanelFloating(ImageEditor.this.currentState.current), new PanelImageProps(ImageEditor.this.currentState.current), new PanelBoxModel(ImageEditor.this.currentState.current));
                dialog.setLocationRelativeTo(ImageEditor.this.editor);
                Point center = new Point((int)ImageEditor.this.currentState.outline.getCenterX(), (int)ImageEditor.this.currentState.outline.getCenterY());
                SwingUtilities.convertPointToScreen(center, ImageEditor.this.editor);
                Rectangle bounds = dialog.getBounds();
                bounds.x = center.x;
                bounds.y = center.y;
                Rectangle screenBounds = ImageEditor.this.editor.getGraphicsConfiguration().getBounds();
                if (bounds.getMaxX() > screenBounds.getMaxX()) {
                    bounds.x -= bounds.x + bounds.width - screenBounds.x - screenBounds.width;
                }
                if (bounds.getMaxY() > screenBounds.getMaxY()) {
                    bounds.y -= bounds.y + bounds.height - screenBounds.y - screenBounds.height;
                }
                dialog.setBounds(bounds);
                dialog.setModal(true);
                dialog.setVisible(true);
                AttributeSet atts = dialog.getAttributes();
                if (atts.getAttributeCount() > 0) {
                    InetHtmlDocument doc = (InetHtmlDocument)ImageEditor.this.editor.getDocument();
                    doc.setElementAttributes(ImageEditor.this.currentState.refElement, atts, false);
                    ImageEditor.this.editor.setDocument(doc);
                    ImageEditor.this.revertOutline(ImageEditor.this.currentState);
                }
            }
        });
        return actions;
    }

    private class State {
        private ImageView current;
        private Rectangle outline;
        private Element refElement;
        private BORDER dragBorder;

        public State(ImageView current, Rectangle outline, Element refElement) {
            this.current = current;
            this.outline = outline;
            this.refElement = refElement;
        }
    }

    static enum BORDER {
        N(8),
        NW(6),
        NE(7),
        E(11),
        W(10),
        S(9),
        SE(5),
        SW(4),
        INSIDE(13),
        OUTSIDE(0);

        private int cursor;

        private BORDER(int cursor) {
            this.cursor = cursor;
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.cursor);
        }
    }
}

