/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.css;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.CSS;
import com.inet.html.css.CSSChangeListener;
import com.inet.html.css.HTML;
import com.inet.html.css.Selector;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.Styles;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.finder.GenericFinder;
import com.inet.html.parser.CssParser;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.utils.Logger;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;

public class NewStyleResolver
implements CSSChangeListener {
    private static final TemporaryStyle.Attribute[] TEMP_ATTRIBUTE_VALUES = TemporaryStyle.Attribute.values();
    private static final TemporaryStyle.Attribute[] TEMP_ATTRIBUTE_VALUES_CONTENT = new TemporaryStyle.Attribute[]{TemporaryStyle.Attribute.DISPLAY, TemporaryStyle.Attribute.COLOR, TemporaryStyle.Attribute.WHITE_SPACE, TemporaryStyle.Attribute.FLOAT, TemporaryStyle.Attribute.LINE_HEIGHT, TemporaryStyle.Attribute.TEXT_DECORATION};
    private static Styles defaultStyles = new Styles("DEFAULT");
    private static Styles userAgentStyles;
    private Styles styles = new Styles("INLINE");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T getAttributeValue(Element elem, AttributeFinder<T> finder) {
        CSS.Attribute cssAttribute = finder.getCSSAttribute();
        if (cssAttribute != null) {
            AttributeSet attributes;
            TemporaryStyle.Attribute att = TemporaryStyle.getAttribute(cssAttribute);
            Object result = null;
            Element currentNode = elem;
            while (currentNode != null && (attributes = currentNode.getAttributes()).isDefined(InetHtmlDocument.FLAG_INIT)) {
                if (attributes.isDefined((Object)att)) {
                    Object value = elem.getAttributes().getAttribute((Object)att);
                    if (value == AttributeValue.INHERIT) {
                        currentNode = currentNode.getParentElement();
                        continue;
                    }
                    result = value;
                    break;
                }
                currentNode = currentNode.getParentElement();
            }
            if (result != null) {
                if (!(result instanceof AttributeValue)) return null;
                return (T)result;
            }
            InetHtmlDocument doc = (InetHtmlDocument)elem.getDocument();
            return doc.getStyleResolver().getAttributeValueInternal(elem, finder);
        }
        if (!elem.getAttributes().isDefined((Object)finder.getHTMLAttribute())) return null;
        return (T)finder.findHtmlAttribute(elem);
    }

    private static <T> T getCSSAttributeValue(Element elem, AttributeFinder<T> finder) {
        if (elem == null) {
            return null;
        }
        CSS.Attribute cssAttribute = finder.getCSSAttribute();
        if (cssAttribute == null) {
            return null;
        }
        TemporaryStyle.Attribute att = TemporaryStyle.getAttribute(cssAttribute);
        if (elem.getAttributes().isDefined((Object)att)) {
            Object value = elem.getAttributes().getAttribute((Object)att);
            if (value == AttributeValue.INHERIT) {
                Element parentElement = elem.getParentElement();
                if (parentElement != null) {
                    return NewStyleResolver.getCSSAttributeValue(parentElement, finder);
                }
                return null;
            }
            return (T)value;
        }
        Element parentElement = elem.getParentElement();
        if (parentElement != null && finder.isInherited()) {
            return NewStyleResolver.getCSSAttributeValue(parentElement, finder);
        }
        return null;
    }

    public static boolean matchesAttributes(Element element, AttributeSet requirements) {
        if (requirements == null) {
            return true;
        }
        Enumeration<?> names = requirements.getAttributeNames();
        while (names.hasMoreElements()) {
            Object elemValue;
            AttributeValue elemValue2;
            AttributeFinder<AttributeValue> finder;
            Object key = names.nextElement();
            Object value = requirements.getAttribute(key);
            if (key == CSS.Attribute.FONT_SIZE) {
                finder = GenericFinder.getFinder((CSS.Attribute)((Object)key));
                elemValue2 = StyleResolver.getAttributeValue(element, finder);
                if (value instanceof FontSize && !(elemValue2 instanceof FontSize)) {
                    value = requirements.getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE);
                }
                if (value != null && value.equals(elemValue2)) continue;
                return false;
            }
            if (key instanceof HTML.Attribute) {
                if (key == HTML.Attribute.STYLE) continue;
                if (!element.getAttributes().isDefined(key)) {
                    return false;
                }
                elemValue = element.getAttributes().getAttribute(key);
                if (!value.equals(elemValue)) {
                    return false;
                }
            }
            if (key instanceof CSS.Attribute && !(key instanceof TemporaryStyle) && !value.equals(elemValue2 = StyleResolver.getAttributeValue(element, finder = GenericFinder.getFinder((CSS.Attribute)((Object)key))))) {
                return false;
            }
            if (key != StyleConstants.NameAttribute || value == (elemValue = element.getAttributes().getAttribute(StyleConstants.NameAttribute))) continue;
            return false;
        }
        return true;
    }

    protected <T> T getAttributeValueInternal(Element element, AttributeFinder<T> finder) {
        Object obj;
        Element e;
        Object tag;
        boolean allowInherit = finder.isInherited();
        while (element != null && allowInherit && ((tag = element.getAttributes().getAttribute(StyleConstants.NameAttribute)) == HTML.Tag.CONTENT || tag == HTML.Tag.IMPLIED)) {
            element = element.getParentElement();
        }
        boolean runOnce = true;
        for (e = element; e != null && allowInherit || runOnce; e = e.getParentElement()) {
            runOnce = false;
            obj = finder.findStyleAttribute(e);
            if (obj != null) {
                if (obj == AttributeValue.INHERIT) continue;
                if (obj instanceof AttributeValue && ((AttributeValue)obj).isImportant()) {
                    return (T)obj;
                }
            }
            if (this.styles != null && (obj = finder.findCssAttribute(this.styles, e, true)) != null) {
                if (obj == AttributeValue.INHERIT) continue;
                return (T)obj;
            }
            if (userAgentStyles != null && (obj = finder.findCssAttribute(userAgentStyles, e, true)) != null) {
                if (obj == AttributeValue.INHERIT) continue;
                return (T)obj;
            }
            obj = finder.findCssAttribute(defaultStyles, e, true);
            if (obj != null) {
                if (obj == AttributeValue.INHERIT) {
                    return null;
                }
                return (T)obj;
            }
            obj = finder.findStyleAttribute(e);
            if (obj != null) {
                if (obj == AttributeValue.INHERIT) continue;
                return (T)obj;
            }
            if (this.styles != null && (obj = finder.findCssAttribute(this.styles, e, false)) != null) {
                if (obj == AttributeValue.INHERIT) continue;
                return (T)obj;
            }
            obj = finder.findHtmlAttribute(e);
            if (obj != null) {
                return (T)obj;
            }
            if (userAgentStyles != null && (obj = finder.findCssAttribute(userAgentStyles, e, false)) != null) {
                if (obj == AttributeValue.INHERIT) continue;
                return (T)obj;
            }
            if (!allowInherit) break;
        }
        runOnce = true;
        for (e = element; e != null && allowInherit || runOnce; e = e.getParentElement()) {
            runOnce = false;
            obj = finder.findCssAttribute(defaultStyles, e, false);
            if (obj != null) {
                if (obj == AttributeValue.INHERIT) {
                    return null;
                }
                return (T)obj;
            }
            if (!allowInherit) break;
        }
        return null;
    }

    private <T> T getAttributeValueNonInherit(Element element, AttributeFinder<T> finder, List<Selector> localMatches, List<Selector> userAgentMatches, List<Selector> defaultMatches) {
        Object styleAttribute = finder.findStyleAttribute(element);
        if (styleAttribute != null && styleAttribute instanceof AttributeValue && ((AttributeValue)styleAttribute).isImportant()) {
            return (T)styleAttribute;
        }
        Object obj = null;
        if (this.styles != null && localMatches != null && (obj = finder.findCssAttribute(this.styles, element, true, localMatches)) != null) {
            return (T)obj;
        }
        if (userAgentStyles != null && userAgentMatches != null && (obj = finder.findCssAttribute(userAgentStyles, element, true, userAgentMatches)) != null) {
            return (T)obj;
        }
        if (styleAttribute != null) {
            return (T)styleAttribute;
        }
        if (this.styles != null && localMatches != null && (obj = finder.findCssAttribute(this.styles, element, false, localMatches)) != null) {
            return (T)obj;
        }
        obj = finder.findHtmlAttribute(element);
        if (obj != null) {
            return (T)obj;
        }
        if (userAgentStyles != null && userAgentMatches != null && (obj = finder.findCssAttribute(userAgentStyles, element, false, userAgentMatches)) != null) {
            return (T)obj;
        }
        obj = finder.findCssAttribute(defaultStyles, element, false, defaultMatches);
        if (obj != null) {
            return (T)obj;
        }
        return null;
    }

    public void fillAttributesNonLocked(Element root) {
        List<Selector> localMatches;
        boolean isContent;
        AttributeSet attrs = root.getAttributes();
        NewStyleResolver.setAttribute(attrs, InetHtmlDocument.FLAG_INIT, Boolean.TRUE);
        Object name = attrs.getAttribute(StyleConstants.NameAttribute);
        HTML.Tag tag = name instanceof HTML.Tag ? (HTML.Tag)((Object)name) : null;
        boolean bl = isContent = name == HTML.Tag.CONTENT;
        if (this.styles != null) {
            localMatches = this.styles.createMatchList(root, tag);
            if (localMatches.size() == 0) {
                localMatches = null;
            }
        } else {
            localMatches = null;
        }
        List<Selector> userAgentMatches = userAgentStyles != null ? userAgentStyles.createMatchList(root, tag) : null;
        List<Selector> defaultMatches = defaultStyles.createMatchList(root, tag);
        FontSize size = this.getAttributeValueNonInherit(root, AttributeFinder.FONT_SIZE, localMatches, userAgentMatches, defaultMatches);
        Float parentSize = null;
        Element parent = root.getParentElement();
        Element parentElement = parent;
        if (parentElement != null) {
            parentSize = (Float)parentElement.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE);
        }
        if (size != null) {
            Float fontSize = new Float(size.getValue((parentSize != null ? parentSize : new Float(16.0f)).floatValue()));
            FontSize fontSize2 = StyleResolver.getAttributeValue(root, AttributeFinder.FONT_SIZE);
            if (fontSize2 == null || !(fontSize2 instanceof Float) || fontSize.floatValue() != ((Float)((Object)fontSize2)).floatValue()) {
                NewStyleResolver.setAttribute(attrs, (Object)TemporaryStyle.Attribute.FONT_SIZE, fontSize);
            }
        }
        TemporaryStyle.Attribute[] fillList = isContent ? TEMP_ATTRIBUTE_VALUES_CONTENT : TEMP_ATTRIBUTE_VALUES;
        for (TemporaryStyle.Attribute cssAttribute : fillList) {
            AttributeFinder<? extends AttributeValue> finder = cssAttribute.getFinder();
            if (finder == null || finder == AttributeFinder.FONT_SIZE || finder.isInherited() && isContent) continue;
            AttributeValue attributeValueInternal = this.getAttributeValueNonInherit(root, finder, localMatches, userAgentMatches, defaultMatches);
            if (attributeValueInternal == AttributeValue.INHERIT) {
                if (finder.isInherited()) continue;
                NewStyleResolver.setAttribute(attrs, (Object)cssAttribute, attributeValueInternal);
                continue;
            }
            AttributeValue inheritValue = parent != null ? StyleResolver.getAttributeValue(parent, finder) : null;
            if (attributeValueInternal == null || attributeValueInternal.equals(inheritValue)) continue;
            NewStyleResolver.setAttribute(attrs, (Object)cssAttribute, attributeValueInternal);
        }
        int n = root.getElementCount();
        for (int i = 0; i < n; ++i) {
            this.fillAttributesNonLocked(root.getElement(i));
        }
    }

    public static void setAttribute(AttributeSet attrs, Object name, Object value) {
        if (value != null && attrs != null && name != null && attrs instanceof MutableAttributeSet) {
            ((MutableAttributeSet)attrs).addAttribute(name, value);
        }
    }

    public Styles getStyles() {
        return this.styles;
    }

    public void setStyles(Styles styles) {
        this.styles = styles;
    }

    public void clearStyles() {
        if (this.styles != null) {
            this.styles.clear();
        }
    }

    public Enumeration<?> getStyleNames() {
        Vector<String> names = new Vector<String>();
        if (defaultStyles != null) {
            names.add(defaultStyles.getName());
        }
        if (userAgentStyles != null && userAgentStyles.getRuleCount() > 0) {
            names.add(defaultStyles.getName());
        }
        if (this.styles != null && this.styles.getRuleCount() > 0) {
            names.add(this.styles.getName());
        }
        return names.elements();
    }

    public Styles getStyleSheet(String nm) {
        if (nm != null) {
            if (defaultStyles != null && nm.equals(defaultStyles.getName())) {
                return defaultStyles;
            }
            if (userAgentStyles != null && nm.equals(userAgentStyles.getName())) {
                return userAgentStyles;
            }
            if (this.styles != null && nm.equals(this.styles.getName())) {
                return this.styles;
            }
        }
        return null;
    }

    @Override
    public void handleNewCSSEntry(Selector selector) {
    }

    public static boolean hasRelevantInlineStyles(Element element) {
        AttributeSet atts = element.getAttributes();
        Enumeration<?> names = atts.getAttributeNames();
        Object name = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (name != HTML.Tag.SPAN) {
            return true;
        }
        while (names.hasMoreElements()) {
            CSS.Attribute cssAtt;
            name = names.nextElement();
            if (!(name instanceof TemporaryStyle.Attribute) || !atts.isDefined((Object)(cssAtt = ((TemporaryStyle.Attribute)((Object)name)).getOrigAttrib()))) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            URL defaultResource = InetHtmlDocument.class.getResource("default.css");
            new CssParser(defaultResource, defaultStyles, false, null).parse();
            if (Logger.doesLog(4)) {
                Logger.debug("Defaul CSS loaded");
            }
        }
        catch (Throwable th) {
            String msg = "The default style sheet cannot be loaded.";
            if (Logger.doesLog(1)) {
                Logger.error(msg);
            }
            Logger.error(th);
            throw new ExceptionInInitializerError(msg);
        }
        try {
            URL url = InetHtmlDocument.class.getResource("userAgent.css");
            if (url != null) {
                userAgentStyles = new Styles("USERAGENT");
                new CssParser(url, userAgentStyles, false, null).parse();
                if (Logger.doesLog(4)) {
                    Logger.debug("User Agent CSS loaded");
                }
                if (userAgentStyles.getRuleCount() == 0) {
                    userAgentStyles = null;
                }
            }
        }
        catch (Throwable th) {
            String msg = "The user agent sytle sheet cannot be loaded.";
            if (Logger.doesLog(1)) {
                Logger.error(msg);
            }
            Logger.error(th);
            throw new ExceptionInInitializerError(msg);
        }
    }
}

