/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.css;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.SuppressFBWarnings;

public class ClassIDGenerator {
    public static final String WEBENGINE_PREFIX = "jwe-style";
    public static final Pattern WEBENGINE_PREFIX_PATTERN = Pattern.compile(".*jwe-style(\\d+).*");
    private Set<Integer> knownIDs;

    public void register(String id) {
        Matcher m = WEBENGINE_PREFIX_PATTERN.matcher(id);
        if (m.matches()) {
            try {
                this.getIDs().add(Integer.valueOf(m.group(1)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void register(int id) {
        this.getIDs().add(id);
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="Method generates a CSS class ID which will be public in the output HTML. So there is no threat if it can be predicted.")
    public void generateID(ClassID classID) {
        if (this.knownIDs == null) {
            this.knownIDs = new TreeSet<Integer>();
        }
        Integer id = null;
        while (this.knownIDs.contains(id = Integer.valueOf((int)(Math.random() * 9999999.0)))) {
        }
        this.knownIDs.add(id);
        classID.setId(id);
    }

    public ClassID getClassID(boolean preset) {
        ClassID id = new ClassID();
        if (preset) {
            this.generateID(id);
        }
        return id;
    }

    private Set<Integer> getIDs() {
        if (this.knownIDs == null) {
            this.knownIDs = new TreeSet<Integer>();
        }
        return this.knownIDs;
    }

    public class ClassID {
        private Integer id;

        public void setId(Integer id) {
            this.id = id;
        }

        public String toString() {
            if (this.id == null) {
                ClassIDGenerator.this.generateID(this);
            }
            return ClassIDGenerator.WEBENGINE_PREFIX + this.id;
        }
    }
}

