/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions.search;

import com.inet.html.actions.search.DefaultSearchDialog;
import com.inet.html.actions.search.DefaultSearchHighlighter;
import com.inet.html.actions.search.ISearchDialog;
import com.inet.html.actions.search.ISearchHighlighter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;

public class SearchControl {
    public static final String CLIENT_PROPERTY_SEARCH_CONTROLLER = "searchController";
    private final ISearchDialog dialog;
    private final ISearchHighlighter highlighter;

    public SearchControl(JEditorPane editor) {
        this(new DefaultSearchDialog(editor), new DefaultSearchHighlighter(editor));
    }

    public SearchControl(ISearchDialog dialog, ISearchHighlighter highlighter) {
        this.dialog = dialog;
        dialog.setController(this);
        this.highlighter = highlighter;
    }

    public void requestSearch(boolean clear, Rectangle parentBounds) {
        this.dialog.requestShow(clear);
        if (this.dialog instanceof Component) {
            Window dComponent = (Window)((Object)this.dialog);
            Point center = new Point((int)parentBounds.getCenterX(), (int)parentBounds.getCenterY());
            Dimension size = dComponent.getSize();
            dComponent.setLocation(center.x - size.width / 2, center.y - size.height / 2);
        }
    }

    public void doSearch(boolean forward, boolean updateSelection) {
        String query = this.dialog.getSearchString();
        boolean caseSensitive = this.dialog.isCaseSensitive();
        int patternType = this.dialog.getPatternType();
        Pattern pattern = this.compilePattern(query, caseSensitive, patternType);
        int matches = this.highlighter.doHighlight(pattern, forward, updateSelection);
        this.dialog.notifyMatches(matches);
    }

    public void clearSearch() {
        this.clearHighlights();
        this.dialog.clear();
    }

    public void clearHighlights() {
        this.highlighter.clearHighlights();
    }

    private Pattern compilePattern(String query, boolean caseSensitive, int type) {
        if (query == null) {
            return Pattern.compile("");
        }
        int flags = caseSensitive ? 0 : 66;
        switch (type) {
            case 0: {
                query = query.replaceAll("(\\[|\\]|\\.|\\(|\\)|\\?|\\*|\\+|\\{|\\}|\\^|\\$|\\|)", "\\$1");
                query = query.replaceAll("\\\\", "\\\\");
                break;
            }
            case 1: {
                query = query.replaceAll("(\\[|\\]|\\.|\\(|\\)|\\+|\\{|\\}|\\^|\\$|\\|)", "\\$1");
                query = query.replace("\\", "\\\\");
                query = query.replace("?", ".");
                query = query.replace("*", ".*?");
                if (!query.endsWith(".*?")) break;
                query = query + "\\s";
            }
        }
        return Pattern.compile(query, flags);
    }
}

