/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.editor.BaseEditor;
import com.inet.html.utils.Logger;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledEditorKit;

public abstract class InetHtmlAction
extends StyledEditorKit.StyledTextAction {
    private static final long serialVersionUID = 1L;

    public InetHtmlAction(String nm) {
        super(nm);
    }

    protected JEditorPane getHtmlEditor(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JEditorPane) {
            return (JEditorPane)source;
        }
        if (source instanceof Container) {
            Container container;
            for (container = (Container)source; container != null && !(container instanceof BaseEditor); container = container.getParent()) {
            }
            if (container != null && container instanceof BaseEditor) {
                return ((BaseEditor)container).getEditor();
            }
            if (container == null) {
                container = (Container)source;
                while (container != null && !(container instanceof BaseEditor)) {
                    if (container instanceof JPopupMenu) {
                        container = (Container)((JPopupMenu)container).getInvoker();
                        continue;
                    }
                    container = container.getParent();
                }
                if (container != null && container instanceof BaseEditor) {
                    return ((BaseEditor)container).getEditor();
                }
            }
        }
        return super.getEditor(e);
    }

    static String getTranslation(String key) {
        block2: {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle("com.inet.editor.i18n.Resources");
                key = bundle.getString(key);
            }
            catch (MissingResourceException ex) {
                if (!Logger.doesLog(2)) break block2;
                Logger.warning("No lokalization for: " + key + " = " + key);
            }
        }
        return key;
    }

    void updateCaretListeners(JTextComponent target) {
        if (target == null) {
            return;
        }
        CaretListener[] listeners = target.getCaretListeners();
        if (listeners != null) {
            for (CaretListener listener : listeners) {
                listener.caretUpdate(new UpdateCaretEvent(target));
            }
        }
    }

    private class UpdateCaretEvent
    extends CaretEvent {
        private static final long serialVersionUID = -563389637932878887L;
        private int dot;
        private int mark;

        public UpdateCaretEvent(JTextComponent target) {
            super(target);
            this.dot = -1;
            this.mark = -1;
            if (target != null) {
                this.dot = target.getCaret().getDot();
                this.mark = target.getCaret().getMark();
            }
        }

        @Override
        public int getDot() {
            return this.dot;
        }

        @Override
        public int getMark() {
            return this.mark;
        }
    }
}

