/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.HtmlConverter;
import com.inet.editor.HtmlEditorUtils;
import com.inet.editor.LineNumTextPane;
import com.inet.html.InetHtmlEditorKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class SourceCodeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextPane textpane;
    private Window window;
    private boolean wordwrap = false;
    private JCheckBox cbWrap;
    private JScrollPane scrollPane;
    private JTextComponent textcomponent = null;
    private JButton btApply;
    private JButton btOK;
    private JButton btCancel;
    private JButton btConvert;
    private JToolBar toolbar;
    private UndoManager undoManager;
    private ActionListener okApplyAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SourceCodeDialog.this.textcomponent != null && SourceCodeDialog.this.btApply.isEnabled() && SourceCodeDialog.this.btApply.isVisible() && e.getSource() != SourceCodeDialog.this.btCancel) {
                String text = SourceCodeDialog.this.textpane.getText();
                SourceCodeDialog.this.textcomponent.setText(text);
                SourceCodeDialog.this.btApply.setEnabled(false);
            }
            if (e.getSource() == SourceCodeDialog.this.btOK || e.getSource() == SourceCodeDialog.this.btCancel) {
                SourceCodeDialog.this.setVisible(false);
            }
        }
    };
    private static final boolean DEBUG_MODE = true;

    public SourceCodeDialog(JFrame frame) {
        super(frame);
        this.window = frame;
        this.initGui();
    }

    public SourceCodeDialog(Frame frame) {
        super(frame);
        this.window = frame;
        this.initGui();
    }

    public SourceCodeDialog(JDialog frame) {
        super(frame);
        this.window = frame;
        this.initGui();
    }

    public void setEditor(JTextComponent textcomponent) {
        this.textcomponent = textcomponent;
        if (textcomponent != null && textcomponent.isEditable()) {
            this.btApply.setVisible(true);
            this.btCancel.setVisible(true);
            this.textpane.setEditable(true);
            try {
                if ("true".equals(System.getProperty("debug"))) {
                    this.btConvert.setVisible(true);
                }
            }
            catch (SecurityException securityException) {}
        } else {
            this.btApply.setVisible(false);
            this.btCancel.setVisible(false);
            this.btConvert.setVisible(false);
            this.textpane.setEditable(false);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (!b) {
            this.textpane.setText("");
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SourceCodeDialog.this.textpane.requestFocus();
                }
            });
        }
        super.setVisible(b);
    }

    private void initGui() {
        this.setTitle(HtmlEditorUtils.getTranslation("sourcecode"));
        this.setModal(true);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.cbWrap = new JCheckBox(HtmlEditorUtils.getTranslation("autowordwrap"), this.wordwrap);
        this.cbWrap.setContentAreaFilled(false);
        this.cbWrap.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceCodeDialog.this.wordwrap = SourceCodeDialog.this.cbWrap.isSelected();
                SourceCodeDialog.this.scrollPane.doLayout();
                SourceCodeDialog.this.textpane.updateUI();
            }
        });
        this.toolbar.add(this.cbWrap);
        this.btConvert = new JButton(HtmlEditorUtils.getTranslation("convertToInline"));
        this.btConvert.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SourceCodeDialog.this.textcomponent != null) {
                    String text = SourceCodeDialog.this.textpane.getText();
                    SourceCodeDialog.this.textpane.setText(HtmlConverter.html2inlinedHtml(text));
                    SourceCodeDialog.this.btApply.setEnabled(true);
                }
            }
        });
        this.btConvert.setVisible(false);
        this.toolbar.add(this.btConvert);
        contentPane.add((Component)this.toolbar, "North");
        this.textpane = new LineNumTextPane(){
            private static final long serialVersionUID = 9134047444951675867L;

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return SourceCodeDialog.this.wordwrap;
            }
        };
        this.textpane.setEditable(true);
        Document document = this.textpane.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SourceCodeDialog.this.btApply.setEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SourceCodeDialog.this.btApply.setEnabled(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SourceCodeDialog.this.btApply.setEnabled(true);
            }
        });
        this.undoManager = new UndoManager(){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized boolean addEdit(UndoableEdit anEdit) {
                AbstractDocument.DefaultDocumentEvent docevent;
                if (anEdit instanceof AbstractDocument.DefaultDocumentEvent && (docevent = (AbstractDocument.DefaultDocumentEvent)anEdit).getType() == DocumentEvent.EventType.CHANGE) {
                    return false;
                }
                return super.addEdit(anEdit);
            }
        };
        document.addUndoableEditListener(this.undoManager);
        this.scrollPane = new JScrollPane(this.textpane);
        contentPane.add(this.scrollPane);
        this.scrollPane.setPreferredSize(new Dimension(600, 400));
        InputMap inputMap = this.textpane.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(90, InetHtmlEditorKit.SHORTCUT_KEY_MASK), "undo");
        inputMap.put(KeyStroke.getKeyStroke(89, InetHtmlEditorKit.SHORTCUT_KEY_MASK), "redo");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        ActionMap actionMap = this.textpane.getActionMap();
        actionMap.put("undo", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SourceCodeDialog.this.undoManager.canUndo()) {
                    SourceCodeDialog.this.undoManager.undo();
                }
            }
        });
        actionMap.put("redo", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SourceCodeDialog.this.undoManager.canRedo()) {
                    SourceCodeDialog.this.undoManager.redo();
                }
            }
        });
        actionMap.put("cancel", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceCodeDialog.this.dispose();
            }
        });
        JPanel pnlControl = new JPanel(new FlowLayout(2, 5, 5));
        this.btCancel = new JButton(HtmlEditorUtils.getTranslation("cancel"));
        this.btCancel.addActionListener(this.okApplyAction);
        pnlControl.add(this.btCancel);
        this.btApply = new JButton(HtmlEditorUtils.getTranslation("applyChanges"));
        this.btApply.addActionListener(this.okApplyAction);
        this.btApply.setEnabled(false);
        pnlControl.add(this.btApply);
        this.btOK = new JButton(HtmlEditorUtils.getTranslation("ok"));
        this.btOK.addActionListener(this.okApplyAction);
        pnlControl.add(this.btOK);
        contentPane.add((Component)pnlControl, "South");
    }

    public void setSourceCode(String code) {
        this.textpane.setText(code);
        this.textpane.setContentType("text/plain");
        this.textpane.setCaretPosition(0);
        this.btApply.setEnabled(false);
        this.undoManager.discardAllEdits();
    }

    public void showDialog() {
        super.pack();
        super.setLocationRelativeTo(this.window);
        this.textpane.updateUI();
        this.setVisible(true);
    }
}

