/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.annotations.PublicApi;
import com.inet.editor.AddImageAction;
import com.inet.editor.BaseEditorToolBar;
import com.inet.editor.DefaultHyperlinkListener;
import com.inet.editor.HtmlConverter;
import com.inet.editor.HtmlEditorUtils;
import com.inet.editor.HyperlinkAction;
import com.inet.editor.HyperlinkActionPopup;
import com.inet.editor.InetTextPane;
import com.inet.editor.SourceCodeAction;
import com.inet.editor.SpellCheckerProxy;
import com.inet.editor.handler.HyperlinkHandler;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.InetHtmlTransferHandler;
import com.inet.html.actions.EnterAction;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.Styles;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.handler.PasteFileHandler;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.EmbeddedImage;
import com.inet.html.utils.Logger;
import java.awt.AWTPermission;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

@PublicApi
public class BaseEditor
extends JPanel {
    public static final String PROPERTY_AUTO_SCROLL = "autoScroll";
    private static final long serialVersionUID = 1L;
    private final InetTextPane text;
    private final UndoAction undoAction = new UndoAction();
    private final RedoAction redoAction = new RedoAction();
    private final UndoManager undoManager = new EditorUndoManager();
    private String compactOriginalText;
    private boolean originalIsHtml;
    private URL base;
    private BaseEditorToolBar tools;
    private final JPopupMenu popup = new JPopupMenu();
    private InetHtmlConfiguration editorHtmlConfig = InetHtmlConfiguration.getMailEditorConfig();
    private Font defaultFont;
    private Dictionary<Object, Object> persistentDocProperties;
    private static Dictionary<Object, Object> defaultProperties;
    private volatile int loadingID;
    private volatile int finishedID;
    private boolean showLinkURL = false;
    private boolean textAntiAlias = true;
    private DefaultHyperlinkListener hyperlinkListener;
    private float fontScale = 1.0f;
    private FocusListener internalFocusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent ev) {
            this.processFocusEvent(ev);
        }

        @Override
        public void focusLost(FocusEvent ev) {
            this.processFocusEvent(ev);
        }

        private void processFocusEvent(FocusEvent ev) {
            ev = new FocusEvent(BaseEditor.this, ev.getID(), ev.isTemporary(), ev.getOppositeComponent());
            BaseEditor.this.processFocusEvent(ev);
        }
    };
    private Set<TextLoadListener> loadListeners = new HashSet<TextLoadListener>();
    private SourceCodeAction sourceCodeAction;
    private boolean fakeMousePosition = false;

    public BaseEditor(boolean hasScrollpane) {
        this(hasScrollpane, true, true, true);
    }

    public BaseEditor(boolean hasScrollpane, boolean editable, boolean hasToolbar, final boolean isHtml) {
        this.setLayout(new BorderLayout());
        Dictionary<Object, Object> properties = this.getDocumentProperties();
        properties.put(InetHtmlDocument.PROPERTY_CONFIGURATION, this.editorHtmlConfig);
        properties.put(InetHtmlDocument.PROPERTY_INDENT_SPACE, 0);
        properties.put("IgnoreCharsetDirective", Boolean.TRUE);
        if (this.defaultFont != null) {
            properties.put(InetHtmlDocument.PROPERTY_DEFAULT_FONT, this.defaultFont);
        }
        if (defaultProperties != null) {
            Enumeration<Object> keys = defaultProperties.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = defaultProperties.get(key);
                this.persistentDocProperties.put(key, value);
            }
        }
        this.text = new InetTextPane(){

            @Override
            protected EditorKit createDefaultEditorKit() {
                return BaseEditor.this.createEditorKit(BaseEditor.this.text != null ? BaseEditor.this.isHtml() : isHtml);
            }

            @Override
            public Point getMousePosition() throws HeadlessException {
                return BaseEditor.this.fakeMousePosition ? null : super.getMousePosition();
            }

            @Override
            public Point getMousePosition(boolean arg0) throws HeadlessException {
                return BaseEditor.this.fakeMousePosition ? null : super.getMousePosition(arg0);
            }
        };
        this.text.setName("BaseEditor.text");
        this.text.setEditable(editable);
        this.text.setEditorKit(this.createEditorKit(true));
        if (hasScrollpane) {
            this.add((Component)new JScrollPane(this.text, 20, 30), "Center");
        } else {
            this.add((Component)this.text, "Center");
        }
        this.text.addFocusListener(this.internalFocusListener);
        this.text.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("editorKit".equals(evt.getPropertyName())) {
                    Class<?> newClass;
                    if (evt.getOldValue() == null) {
                        return;
                    }
                    Class<?> oldClass = evt.getOldValue().getClass();
                    if (oldClass != (newClass = evt.getNewValue().getClass())) {
                        boolean isHtml = evt.getNewValue() instanceof InetHtmlEditorKit;
                        BaseEditor.this.tools.notifyFormat(isHtml);
                        BaseEditor.this.tools.setEnableFormatButtons(isHtml);
                        if (newClass == StyledEditorKit.class) {
                            StyledEditorKit tempKit = new StyledEditorKit();
                            BaseEditor.this.text.setEditorKit(tempKit);
                            BaseEditor.this.text.setDocument(tempKit.createDefaultDocument());
                        }
                        BaseEditor.this.sourceCodeAction.setEnabled(isHtml);
                    }
                }
            }
        });
        ActionMap actionMap = this.text.getActionMap();
        InputMap inputMap = this.text.getInputMap();
        Action softBreak = actionMap.get("insert-softbreak");
        inputMap.put(KeyStroke.getKeyStroke(10, 1), "insert-softbreak");
        actionMap.put("insert-softbreak", softBreak);
        actionMap.put("insert-break", new EnterAction(actionMap.get("insert-break")));
        inputMap.put(KeyStroke.getKeyStroke(90, InetHtmlEditorKit.SHORTCUT_KEY_MASK), "undo");
        actionMap.put("undo", this.undoAction);
        inputMap.put(KeyStroke.getKeyStroke(89, InetHtmlEditorKit.SHORTCUT_KEY_MASK), "redo");
        actionMap.put("redo", this.redoAction);
        inputMap.put(KeyStroke.getKeyStroke(72, InetHtmlEditorKit.SHORTCUT_KEY_MASK + 1), "hyperlink");
        actionMap.put("hyperlink", new HyperlinkAction());
        inputMap.put(KeyStroke.getKeyStroke(85, InetHtmlEditorKit.SHORTCUT_KEY_MASK), "sourcecode");
        this.sourceCodeAction = new SourceCodeAction();
        actionMap.put("sourcecode", this.sourceCodeAction);
        inputMap.put(KeyStroke.getKeyStroke(71, InetHtmlEditorKit.SHORTCUT_KEY_MASK), "addimage");
        actionMap.put("addimage", new AddImageAction());
        inputMap.put(KeyStroke.getKeyStroke(525, 0), "showpopup");
        actionMap.put("showpopup", new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                if (!BaseEditor.this.text.isEditable()) {
                    return;
                }
                try {
                    Caret caret = BaseEditor.this.text.getCaret();
                    Rectangle pos = BaseEditor.this.text.modelToView(caret.getDot());
                    BaseEditor.this.fakeMousePosition = true;
                    BaseEditor.this.popup.removeAll();
                    BaseEditor.this.createPopup(BaseEditor.this.popup);
                    for (Component c : BaseEditor.this.popup.getComponents()) {
                        if (!(c instanceof JMenuItem)) continue;
                        ((JMenuItem)c).setEnabled(BaseEditor.this.isActionEnabled(((JMenuItem)c).getAction()));
                    }
                    BaseEditor.this.popup.show(BaseEditor.this.text, pos.x, pos.y + pos.height);
                }
                catch (BadLocationException e) {
                    e.printStackTrace(System.err);
                }
                finally {
                    BaseEditor.this.fakeMousePosition = false;
                }
            }
        });
        this.tools = new BaseEditorToolBar(this, hasToolbar, editable, isHtml);
        Document doc = this.text.getDocument();
        if (doc instanceof InetHtmlDocument) {
            InetHtmlDocument inetDoc = (InetHtmlDocument)this.text.getDocument();
            inetDoc.setDocumentProperties(this.persistentDocProperties);
            inetDoc.setPreservesUnknownTags(false);
            URL baseURL = this.getBase();
            if (baseURL != null) {
                inetDoc.setBase(baseURL);
            }
            NavigationFilter ignoreFilter = new NavigationFilter(){

                @Override
                public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                }

                @Override
                public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                }
            };
            this.text.setNavigationFilter(ignoreFilter);
            try {
                this.text.getDocument().remove(0, this.text.getDocument().getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.text.setNavigationFilter(null);
        }
        this.text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                BaseEditor.this.text.getCaret().setSelectionVisible(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.hyperlinkListener = new DefaultHyperlinkListener(this);
        this.text.addHyperlinkListener(this.hyperlinkListener);
        this.text.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (!BaseEditor.this.hasFocus()) {
                    BaseEditor.this.text.requestFocusInWindow();
                }
                this.showPopup(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.showPopup(me);
            }

            private void showPopup(MouseEvent me) {
                if (me.isPopupTrigger() && BaseEditor.this.isEnabled()) {
                    BaseEditor.this.popup.removeAll();
                    BaseEditor.this.createPopup(BaseEditor.this.popup);
                    for (Component c : BaseEditor.this.popup.getComponents()) {
                        if (!(c instanceof JMenuItem)) continue;
                        ((JMenuItem)c).setEnabled(BaseEditor.this.isActionEnabled(((JMenuItem)c).getAction()));
                    }
                    BaseEditor.this.popup.show(me.getComponent(), me.getX(), me.getY());
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                BaseEditor.this.text.requestFocusInWindow();
            }
        });
        this.fireCaretUpdateForToolbar();
        this.updateCursor();
        SpellCheckerProxy.enableAutoSpell(this.text, this.isAutoSpellCheck());
        this.undoManager.discardAllEdits();
        doc.addUndoableEditListener(this.undoManager);
        this.undoAction.updateState();
        this.redoAction.updateState();
        this.allowImagePaste(this.editorHtmlConfig.isAllowInternalImages());
        this.setUnChanged();
        this.text.setBackground(Color.WHITE);
        this.createPopup(this.popup);
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                BaseEditor.this.requestFocus();
            }
        });
    }

    @Override
    public void requestFocus() {
        this.text.requestFocusInWindow();
    }

    protected boolean isAutoSpellCheck() {
        return this.tools != null ? this.tools.isAutoSpellCheck() : false;
    }

    protected void setAutoSpellCkeck(boolean enabled) {
        SpellCheckerProxy.enableAutoSpell(this.text, enabled);
        this.tools.setAutoSpellSelected(enabled);
    }

    protected void createPopup(final JPopupMenu popupMenu) {
        EditorKit kit;
        if (SpellCheckerProxy.isSpellCheckerAvailable() && this.isEditable()) {
            SpellCheckerProxy.ActivationCallback callback = new SpellCheckerProxy.ActivationCallback(){

                @Override
                public void setActive(boolean active) {
                    BaseEditor.this.putClientProperty("activator", null);
                    if (active) {
                        JMenu checkMenu = SpellCheckerProxy.createCheckerMenu();
                        JMenu langMenu = SpellCheckerProxy.createLanguagesMenu();
                        JSeparator sep = new JSeparator();
                        popupMenu.add((Component)sep, 0);
                        popupMenu.add((Component)langMenu, 0);
                        popupMenu.add((Component)checkMenu, 0);
                    }
                }
            };
            SpellCheckerProxy.activate(callback);
            this.putClientProperty("activator", callback);
        }
        if (this.isEditable()) {
            this.createActionComponent(new HyperlinkActionPopup(this.text), "hyperlinkpopup", null, this.popup);
        }
        ActionMap editorActionMap = this.text.getActionMap();
        Action copyAction = editorActionMap.get("copy-to-clipboard");
        Action cutAction = editorActionMap.get("cut-to-clipboard");
        Action pasteAction = editorActionMap.get("paste-from-clipboard");
        Action pastePlainAction = editorActionMap.get("paste-from-clipboard-plain");
        Action copyPlainAction = editorActionMap.get("copy-to-clipboard-plain");
        InputMap inputMap = this.text.getInputMap();
        KeyStroke[] allKeys = inputMap.allKeys();
        if (copyAction != null || cutAction != null || pasteAction != null || pastePlainAction != null) {
            if (copyAction != null) {
                this.createActionComponent(copyAction, "copy", this.getAccelerator(allKeys, inputMap, "copy-to-clipboard", 67), this.popup);
            }
            this.addPlainAction(copyPlainAction, false, "copy-to-clipboard", "copycontent", 67, inputMap, allKeys);
            if (cutAction != null && this.isEditable()) {
                this.createActionComponent(cutAction, "cut", this.getAccelerator(allKeys, inputMap, "cut-to-clipboard", 88), this.popup);
            }
            if (pasteAction != null && this.isEditable()) {
                this.createActionComponent(pasteAction, "paste", this.getAccelerator(allKeys, inputMap, "paste-from-clipboard", 86), this.popup);
            }
            this.addPlainAction(pastePlainAction, true, "paste-from-clipboard", "pastecontent", 86, inputMap, allKeys);
            popupMenu.add(new JSeparator());
        }
        if ((kit = this.text.getEditorKit()) instanceof InetHtmlEditorKit) {
            List<Action> actions = ((InetHtmlEditorKit)kit).getCurrentCustomActions();
            for (Action a : actions) {
                popupMenu.add(a);
            }
            if (actions.size() > 0) {
                popupMenu.add(new JSeparator());
            }
        }
        popupMenu.add(editorActionMap.get("sourcecode"));
    }

    private void addPlainAction(Action action, boolean requiresEditable, String key, String name, int keyCode, InputMap inputMap, KeyStroke[] allKeys) {
        block4: {
            if (action != null && (this.isEditable() || !requiresEditable)) {
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard();
                    if (System.getSecurityManager() != null) {
                        System.getSecurityManager().checkPermission(new AWTPermission("accessClipboard"));
                    }
                    KeyStroke acc = this.getAccelerator(allKeys, inputMap, key, keyCode);
                    this.createActionComponent(action, name, KeyStroke.getKeyStroke(acc.getKeyCode(), acc.getModifiers() + 64), this.popup);
                }
                catch (Throwable t) {
                    if (!Logger.doesLog(2)) break block4;
                    Logger.warning("Unable to install Copy/Paste-Plain action due to security restrictions");
                }
            }
        }
    }

    private KeyStroke getAccelerator(KeyStroke[] allKeys, InputMap inputMap, String actionKey, int fallBackKey) {
        KeyStroke keyStroke;
        int i;
        for (i = 0; i < allKeys.length; ++i) {
            keyStroke = allKeys[i];
            if (keyStroke.getKeyCode() != fallBackKey || actionKey != inputMap.get(keyStroke)) continue;
            return keyStroke;
        }
        for (i = 0; i < allKeys.length; ++i) {
            keyStroke = allKeys[i];
            if (actionKey != inputMap.get(keyStroke)) continue;
            return keyStroke;
        }
        return null;
    }

    private void createActionComponent(Action a, String i18nKey, KeyStroke keyStroke, JPopupMenu menu) {
        JMenuItem mi = new JMenuItem(a);
        mi.setText(HtmlEditorUtils.getTranslation("popup." + i18nKey));
        mi.setToolTipText(HtmlEditorUtils.getTranslation("popup." + i18nKey + "Help"));
        mi.setAccelerator(keyStroke);
        mi.setIcon(HtmlEditorUtils.getResourceImage(i18nKey + "image.gif"));
        mi.setHorizontalTextPosition(11);
        mi.setVerticalTextPosition(0);
        menu.add(mi);
    }

    protected void addButtons(List<Component> defaultComponents, List<Component> editComponents, List<Component> formatComponents) {
    }

    private boolean isActionEnabled(Action action) {
        String actionName;
        if (action == null) {
            return true;
        }
        String string = actionName = action.getValue("Name") != null ? action.getValue("Name").toString() : "";
        if (actionName.equals("copy-to-clipboard") || actionName.equals("cut-to-clipboard")) {
            return this.text.getSelectionStart() != this.text.getSelectionEnd();
        }
        return action.isEnabled();
    }

    protected boolean hasFormatButton() {
        return true;
    }

    public void showDocument(URL url, String string) {
        if (url == null) {
            return;
        }
        URL base = this.getBase();
        String basePath = base != null ? base.getPath() : null;
        String urlPath = url.getPath();
        if ((basePath == null && urlPath == null || basePath != null && urlPath != null && basePath.equals(urlPath)) && url.getRef() != null && this.isHtml()) {
            this.scrollToAnchor(url);
        } else {
            this.setPage(url);
        }
    }

    private void scrollToAnchor(URL url) {
        block7: {
            if (url.getRef() == null) {
                return;
            }
            InetHtmlDocument doc = (InetHtmlDocument)this.text.getDocument();
            String anchor = InetHtmlDocument.getCachedString(url.getRef());
            try {
                anchor = URLDecoder.decode(anchor, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            Element scrollTo = this.findAnchorElement(anchor, doc.getRootElements()[0]);
            if (scrollTo != null) {
                try {
                    Rectangle rect = this.text.modelToView(scrollTo.getStartOffset());
                    int visibleHeight = this.text.getVisibleRect().height;
                    if (rect != null) {
                        rect.height = visibleHeight > rect.height ? visibleHeight : rect.height;
                        this.text.scrollRectToVisible(rect);
                    }
                }
                catch (BadLocationException e) {
                    if (!Logger.doesLog(1)) break block7;
                    Logger.error(e);
                }
            }
        }
    }

    private Element findAnchorElement(String anchor, Element root) {
        anchor = InetHtmlDocument.getCachedString(anchor);
        if (root instanceof AbstractDocument.BranchElement) {
            AbstractDocument.BranchElement branch = (AbstractDocument.BranchElement)root;
            for (int i = 0; i < branch.getElementCount(); ++i) {
                Object attribute;
                Element child = branch.getElement(i);
                AttributeSet set = child.getAttributes();
                if (set.isDefined((Object)HTML.Attribute.NAME) && anchor == (attribute = set.getAttribute((Object)HTML.Attribute.NAME))) {
                    return child;
                }
                if (set.isDefined((Object)HTML.Attribute.ID) && anchor == set.getAttribute((Object)HTML.Attribute.ID)) {
                    return child;
                }
                Element node = this.findAnchorElement(anchor, child);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    protected URL getBase() {
        return this.base;
    }

    public void setBase(URL base) {
        if (base != null) {
            try {
                base.toURI();
            }
            catch (URISyntaxException e) {
                try {
                    URI uri = new URI(null, base.toString(), null);
                    this.base = uri.toURL();
                    return;
                }
                catch (Exception e1) {
                    Logger.error(e1);
                }
            }
        }
        this.base = base;
    }

    public void setText(String str, boolean isHtml) {
        this.setText(str, isHtml, true);
    }

    public int setTextWithLoadID(String str, boolean isHtml) {
        return this.setText(str, isHtml, true);
    }

    int setText(final String str, boolean isHtml, boolean external) {
        int thisActionID = ++this.loadingID;
        final LoaderData data = new LoaderData(thisActionID, isHtml, external);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    data.kit = BaseEditor.this.createEditorKit(data.isHtml);
                    data.doc = data.kit.createDefaultDocument();
                    if (data.isHtml) {
                        InetHtmlDocument inetDoc = (InetHtmlDocument)data.doc;
                        inetDoc.setDocumentProperties(BaseEditor.this.persistentDocProperties);
                        inetDoc.setPreservesUnknownTags(false);
                        URL baseURL = BaseEditor.this.getBase();
                        if (baseURL != null) {
                            inetDoc.setBase(baseURL);
                        }
                    }
                    if (Logger.doesLog(4)) {
                        Logger.debug("Set Text: " + str);
                    }
                    Highlighter highlighter = BaseEditor.this.text.getHighlighter();
                    Highlighter.Highlight[] highlights = highlighter.getHighlights();
                    int k = highlights.length;
                    while (--k >= 0) {
                        Highlighter.Highlight highlight = highlights[k];
                        highlighter.removeHighlight(highlight);
                    }
                    data.doc.remove(0, data.doc.getLength());
                    if (str != null && str.length() > 0) {
                        StringReader r = new StringReader(str);
                        data.kit.read(r, data.doc, 0);
                    }
                    EDTLoader loader = new EDTLoader(data);
                    loader.add(new InitKitLoader());
                    loader.add(new ModelLoader());
                    loader.add(new NewModelNotifyLoader());
                    loader.add(new SizeUpdateLoader());
                    loader.add(new UpdatePopupLoader());
                    loader.start();
                }
                catch (Throwable ex) {
                    if (data.thisActionID == BaseEditor.this.loadingID) {
                        BaseEditor.this.finishedID = BaseEditor.this.loadingID;
                    }
                    Logger.error(ex);
                }
            }
        }).start();
        return thisActionID;
    }

    public int getCurrentLoadID() {
        return this.finishedID;
    }

    protected void textLoaded() {
        this.adjustTextpaneBorders(this.isHtml());
        for (TextLoadListener l : this.loadListeners) {
            l.notifyTextLoaded(this.text.getDocument());
        }
    }

    private void adjustTextpaneBorders(boolean isHtml) {
        Insets targetMargin;
        Insets margin = this.text.getBorder().getBorderInsets(this.text);
        Insets insets = targetMargin = isHtml ? new Insets(3, 3, 3, 3) : new Insets(8, 8, 8, 8);
        if (!targetMargin.equals(margin)) {
            this.text.setBorder(new EmptyBorder(targetMargin));
        }
    }

    protected StyledEditorKit createEditorKit(boolean isHtml) {
        EditorKit currentKit;
        EditorKit editorKit = currentKit = this.text != null ? this.text.getEditorKit() : null;
        if (isHtml) {
            InetHtmlEditorKit htmlKit = currentKit instanceof InetHtmlEditorKit && !(currentKit instanceof SetPageEditorKit) ? (InetHtmlEditorKit)currentKit : new InetHtmlEditorKit(this.textAntiAlias);
            htmlKit.setDefaultConfig(this.editorHtmlConfig);
            return htmlKit;
        }
        if (currentKit != null && currentKit.getClass() == StyledEditorKit.class) {
            return (StyledEditorKit)currentKit;
        }
        return new StyledEditorKit();
    }

    public String getText() {
        return this.text.getText();
    }

    public boolean isHtml() {
        return "text/html".equalsIgnoreCase(this.text.getContentType());
    }

    public boolean isChanged() {
        if (this.loadingID != this.finishedID) {
            return false;
        }
        return this.isHtml() != this.originalIsHtml || !this.getText().equals(this.compactOriginalText);
    }

    public boolean isLoading() {
        return this.loadingID != this.finishedID;
    }

    public void setUnChanged() {
        this.compactOriginalText = this.getText();
        this.originalIsHtml = this.isHtml();
    }

    public boolean isEditable() {
        return this.text.isEditable();
    }

    public void setTextShowMode() {
        this.setEditable(false);
        this.tools.setToolbarVisible(false);
    }

    public void setEditable(boolean editable) {
        boolean oldValue = this.isEditable();
        if (oldValue != editable) {
            this.text.setEditable(editable);
            if (this.isEditable() && this.text.isFocusOwner()) {
                this.text.getCaret().setVisible(true);
            } else {
                this.text.getCaret().setVisible(false);
            }
            this.tools.setEditable(editable);
            this.firePropertyChange("editable", oldValue, editable);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseEditor.this.popup.removeAll();
                    BaseEditor.this.createPopup(BaseEditor.this.popup);
                }
            });
        }
        this.updateCursor();
        this.undoAction.updateState();
        this.redoAction.updateState();
    }

    private void updateCursor() {
        if (this.isEditable()) {
            this.text.setCursor(Cursor.getPredefinedCursor(2));
        } else {
            this.text.setCursor(Cursor.getPredefinedCursor(0));
        }
        EditorKit kit = this.text.getEditorKit();
        if (kit instanceof InetHtmlEditorKit) {
            ((InetHtmlEditorKit)kit).setDefaultCursor(this.text.getCursor());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        this.tools.setEnabled(enabled);
        super.setEnabled(enabled);
        this.undoAction.updateState();
        this.redoAction.updateState();
    }

    public JTextPane getEditor() {
        return this.text;
    }

    public JToolBar getToolbar() {
        return this.tools.getToolbar();
    }

    public BaseEditorToolBar getToolBarController() {
        return this.tools;
    }

    boolean isOnlyPlainText() {
        Document doc = this.text.getDocument();
        if (!(doc instanceof InetHtmlDocument)) {
            return true;
        }
        InetHtmlDocument htmlDoc = (InetHtmlDocument)doc;
        Styles inline = htmlDoc.getStyleSheet("INLINE");
        if (inline != null && inline.getRuleCount() > inline.getInitialCount()) {
            return false;
        }
        int len = doc.getLength();
        Element root = doc.getDefaultRootElement();
        if (this.getDefaultFont() != null) {
            for (int i = 0; i < len; ++i) {
                Font font;
                Element element = ElementUtils.getLeafAt(root, i);
                if (element == null || element.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.CONTENT || (font = InetHtmlDocument.getFont(element)).equals(this.getDefaultFont())) continue;
                return false;
            }
        }
        return this.isOnlyPlainTextNode(root);
    }

    private boolean isOnlyPlainTextNode(Element elem) {
        Object tag = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (!(tag instanceof HTML.Tag)) {
            return false;
        }
        switch ((HTML.Tag)((Object)tag)) {
            case HTML: 
            case HEAD: 
            case BODY: 
            case P: 
            case FONT: 
            case SPAN: {
                break;
            }
            case CONTENT: 
            case BR: {
                return true;
            }
            default: {
                return false;
            }
        }
        if (tag != HTML.Tag.FONT) {
            AttributeSet atts = elem.getAttributes();
            Enumeration<?> names = atts.getAttributeNames();
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                if (name instanceof StyleConstants || name instanceof TemporaryStyle.Attribute || name == HTML.Attribute.STYLE || (tag == HTML.Tag.BODY || tag == HTML.Tag.SPAN) && (name == CSS.Attribute.FONT_SIZE || name == CSS.Attribute.FONT_FAMILY)) continue;
                return false;
            }
        }
        int count = elem.getElementCount();
        for (int i = 0; i < count; ++i) {
            if (this.isOnlyPlainTextNode(elem.getElement(i))) continue;
            return false;
        }
        return true;
    }

    public void insertHtml(String htmlText) {
        if (htmlText == null) {
            return;
        }
        try {
            Caret c = this.text.getCaret();
            int start = Math.min(c.getMark(), c.getDot());
            int end = Math.max(c.getMark(), c.getDot());
            boolean isHtml = "text/html".equals(this.text.getContentType());
            if (isHtml && htmlText.indexOf(60) >= 0) {
                Document doc = this.text.getDocument();
                if (doc instanceof InetHtmlDocument) {
                    ((InetHtmlDocument)doc).pasteHTML(htmlText, start, end);
                    c.setDot(Math.min(c.getMark(), c.getDot()));
                } else {
                    this.text.replaceSelection("");
                    EditorKit editorKit = this.text.getEditorKit();
                    editorKit.read(new StringReader(htmlText), doc, this.text.getCaretPosition());
                }
            } else {
                this.text.replaceSelection(HtmlConverter.html2text(htmlText));
            }
        }
        catch (Exception ex) {
            HtmlEditorUtils.printStackTrace(ex);
        }
    }

    public void insertFrom(BaseEditor editor) {
        InetTextPane textFrom = editor.text;
        Caret caret = textFrom.getCaret();
        int p0 = Math.min(caret.getDot(), caret.getMark());
        int p1 = Math.max(caret.getDot(), caret.getMark());
        String html = null;
        try {
            if (p0 != p1) {
                StringWriter buf = new StringWriter();
                textFrom.getEditorKit().write(buf, textFrom.getDocument(), p0, p1 - p0);
                html = buf.toString();
            }
        }
        catch (Exception ex) {
            HtmlEditorUtils.printStackTrace(ex);
        }
        if (html == null) {
            html = textFrom.getText();
        }
        if (!editor.isHtml()) {
            Object defaultClass = this.persistentDocProperties.get(InetHtmlDocument.PROPERTY_DEFAULT_STYLE_CLASS);
            html = HtmlConverter.text2html(html, null, true, defaultClass != null ? defaultClass.toString() : null);
        }
        this.insertHtml(html);
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public EmbeddedImage[] getEmbeddedImages() {
        if (this.text != null && this.text.getDocument() != null && this.text.getDocument() instanceof InetHtmlDocument) {
            return ((InetHtmlDocument)this.text.getDocument()).getEmbeddedImages();
        }
        return null;
    }

    public void allowImagePaste(boolean allowImagePaste) {
        this.editorHtmlConfig.setAllowInternalImages(allowImagePaste);
        Action action = this.tools.getAddImageAction();
        if (action != null) {
            Document doc;
            action.setEnabled(allowImagePaste);
            this.tools.setAddImageEnabled(action.isEnabled());
            if (this.text != null && (doc = this.text.getDocument()) != null && doc instanceof InetHtmlDocument) {
                ((InetHtmlDocument)doc).setAllowInternalImages(allowImagePaste);
            }
        }
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (d.width > 100) {
            d.width = 100;
        }
        return d;
    }

    public void setConfiguration(InetHtmlConfiguration htmlConfiguration) {
        if (this.editorHtmlConfig == htmlConfiguration) {
            return;
        }
        this.editorHtmlConfig = htmlConfiguration;
        if (this.text != null && this.text.getDocument() instanceof InetHtmlDocument) {
            ((InetHtmlDocument)this.text.getDocument()).putProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, this.editorHtmlConfig);
            this.setDocumentProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, this.editorHtmlConfig);
            this.text.setEditorKit(this.createEditorKit(true));
        }
    }

    public void setDefaultFont(Font defaultFont) {
        if (defaultFont != null) {
            Font defaultFontPX;
            float newSizeInPX = LengthUnit.getPXforPT(defaultFont.getSize());
            this.defaultFont = defaultFontPX = defaultFont.deriveFont(newSizeInPX);
            this.setDocumentProperty(InetHtmlDocument.PROPERTY_DEFAULT_FONT, defaultFont);
        } else {
            this.defaultFont = null;
            this.setDocumentProperty(InetHtmlDocument.PROPERTY_DEFAULT_FONT, null);
        }
        if (this.text.getEditorKit() instanceof InetHtmlEditorKit) {
            ((InetHtmlEditorKit)this.text.getEditorKit()).forceUpdateInputAttributes(this.text);
        } else {
            this.text.firePropertyChange("caretUpdate", null, this.text.getDocument());
        }
        this.fireCaretUpdateForToolbar();
    }

    public void setDefaultFontPX(Font defaultFont) {
        if (defaultFont != null) {
            this.setDocumentProperty(InetHtmlDocument.PROPERTY_DEFAULT_FONT, defaultFont.deriveFont(LengthUnit.getPTforPX(defaultFont.getSize())));
            if (this.text.getEditorKit() instanceof InetHtmlEditorKit) {
                ((InetHtmlEditorKit)this.text.getEditorKit()).forceUpdateInputAttributes(this.text);
            } else {
                this.text.firePropertyChange("caretUpdate", null, this.text.getDocument());
            }
            this.fireCaretUpdateForToolbar();
        } else {
            this.setDocumentProperty(InetHtmlDocument.PROPERTY_DEFAULT_FONT, null);
        }
        this.defaultFont = defaultFont;
        this.setFontScaled(defaultFont);
    }

    public void setFontScale(float scale) {
        if ((double)scale < 0.1) {
            scale = 0.1f;
        }
        if (scale > 10.0f) {
            scale = 10.0f;
        }
        this.fontScale = scale;
        if (this.text.getEditorKit() instanceof InetHtmlEditorKit) {
            ((InetHtmlEditorKit)this.text.getEditorKit()).setFontScale(scale);
        }
        if (this.defaultFont == null) {
            this.defaultFont = this.text.getFont();
        }
        this.setFontScaled(this.defaultFont);
    }

    private void setFontScaled(Font font) {
        if (this.fontScale != 1.0f) {
            font = font.deriveFont((float)font.getSize() * this.fontScale);
        }
        this.text.setFont(font);
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setPage(final URL page) {
        try {
            ++this.loadingID;
            this.setBase(page);
            if (!(this.text.getEditorKit() instanceof SetPageEditorKit)) {
                this.text.setEditorKit(new SetPageEditorKit(this));
            }
            this.setFontScale(this.fontScale);
            this.text.addPropertyChangeListener("editorContent", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Document doc = BaseEditor.this.text.getDocument();
                            if (doc instanceof InetHtmlDocument && ((InetHtmlDocument)doc).isLocked()) {
                                SwingUtilities.invokeLater(this);
                                return;
                            }
                            if (page != null && page.getRef() != null) {
                                BaseEditor.this.scrollToAnchor(page);
                            }
                            BaseEditor.this.finishedID = BaseEditor.this.loadingID;
                            BaseEditor.this.notifyNewModel(BaseEditor.this.isHtml(), true, BaseEditor.this.text.getDocument());
                            BaseEditor.this.textLoaded();
                        }
                    });
                    BaseEditor.this.text.removePropertyChangeListener("editorContent", this);
                }
            });
            this.text.setPage(page);
        }
        catch (Throwable ex) {
            if (Logger.doesLog(1)) {
                Logger.error("Unable to open page: " + page);
                Logger.error(ex);
            }
            StringBuilder b = new StringBuilder();
            b.append("<html><head><title>");
            b.append(HtmlEditorUtils.getTranslation("setPageErrorH1"));
            b.append("</title></head><body><h1>");
            b.append(HtmlEditorUtils.getTranslation("setPageErrorH1"));
            b.append("</h1><p>");
            b.append(HtmlEditorUtils.getTranslation("setPageErrorBody1"));
            b.append(page != null ? page.toString() : "<no URL>");
            b.append(HtmlEditorUtils.getTranslation("setPageErrorBody2"));
            b.append("</p></body></html>");
            this.setText(b.toString(), true);
        }
    }

    public Dictionary<Object, Object> getDocumentProperties() {
        Dictionary<Object, Object> props;
        Document doc;
        if (this.persistentDocProperties == null) {
            this.persistentDocProperties = new Hashtable<Object, Object>(2){

                @Override
                public synchronized Object put(Object key, Object value) {
                    if (key == InetHtmlDocument.PROPERTY_CONFIGURATION && value != null && value instanceof InetHtmlConfiguration) {
                        BaseEditor.this.setConfiguration((InetHtmlConfiguration)value);
                    }
                    return super.put(key, value);
                }
            };
        }
        if (this.text != null && this.text.getDocument() != null && (doc = this.text.getDocument()) instanceof InetHtmlDocument && (props = ((AbstractDocument)doc).getDocumentProperties()) != null && props != this.persistentDocProperties) {
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = props.get(key);
                this.persistentDocProperties.put(key, value);
            }
        }
        return this.persistentDocProperties;
    }

    public void setDocumentProperties(Dictionary<Object, Object> properties) {
        this.persistentDocProperties = null;
        this.persistentDocProperties = this.getDocumentProperties();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = properties.get(key);
            this.persistentDocProperties.put(key, value);
        }
    }

    public void setDocumentProperty(Object key, Object value) {
        if (this.persistentDocProperties == null) {
            this.persistentDocProperties = new Hashtable<Object, Object>(2){

                @Override
                public synchronized Object put(Object key, Object value) {
                    if (key == InetHtmlDocument.PROPERTY_CONFIGURATION && value != null && value instanceof InetHtmlConfiguration) {
                        BaseEditor.this.setConfiguration((InetHtmlConfiguration)value);
                    }
                    return super.put(key, value);
                }
            };
        }
        this.persistentDocProperties.put(key, value);
        Document doc = this.text.getDocument();
        if (doc != null && doc instanceof InetHtmlDocument) {
            ((InetHtmlDocument)doc).setDocumentProperty(key, value);
        }
    }

    public void setShowLinkURL(boolean showLinkURL) {
        this.showLinkURL = showLinkURL;
    }

    public boolean isShowLinkURL() {
        return this.showLinkURL;
    }

    public void setCustomHyperlinkHandler(HyperlinkHandler handler) {
        if (this.hyperlinkListener != null) {
            this.hyperlinkListener.setCustomHyperlinkHandler(handler);
        }
    }

    public void setCustomPasteHandler(PasteFileHandler handler) {
        this.text.putClientProperty("PasteFileHandler", handler);
        TransferHandler transferHandler = this.text.getTransferHandler();
        if (transferHandler != null && transferHandler instanceof InetHtmlTransferHandler) {
            ((InetHtmlTransferHandler)transferHandler).updatePasteFileHandler();
        }
    }

    public void setTextAntiAlias(boolean enabled) {
        this.textAntiAlias = enabled;
    }

    public void setSearchVisible(boolean visible) {
        this.tools.setSearchVisible(visible);
    }

    public void addTextLoadListener(TextLoadListener listener) {
        this.loadListeners.add(listener);
    }

    public void removeTextLoadListener(TextLoadListener listener) {
        this.loadListeners.remove(listener);
    }

    private void notifyNewModel(boolean isHtml, boolean external, Document doc) {
        if (!isHtml) {
            this.text.setTransferHandler(new InetHtmlTransferHandler(this.text));
        }
        doc.removeUndoableEditListener(this.undoManager);
        this.text.setCaretPosition(0);
        this.fireCaretUpdateForToolbar();
        this.updateCursor();
        this.tools.notifyFormat(isHtml);
        this.tools.setEnableFormatButtons(isHtml);
        if (external) {
            this.setUnChanged();
        }
        SpellCheckerProxy.enableAutoSpell(this.text, this.isAutoSpellCheck() && this.isEditable());
        this.undoManager.discardAllEdits();
        doc.addUndoableEditListener(this.undoManager);
        this.undoAction.updateState();
        this.redoAction.updateState();
        this.allowImagePaste(this.editorHtmlConfig.isAllowInternalImages());
    }

    private void fireCaretUpdateForToolbar() {
        CaretListener[] listeners = this.text.getCaretListeners();
        if (listeners != null) {
            SimpleCaretEvent event = new SimpleCaretEvent(this.text, 0, 0);
            for (CaretListener l : listeners) {
                l.caretUpdate(event);
            }
        }
    }

    public void setTextSelectionEnabled(boolean enabled) {
        if (enabled) {
            this.text.getUI().installUI(this.text);
        } else {
            this.text.setCaret(new NoSelectionCaret());
        }
    }

    static {
        JEditorPane.registerEditorKitForContentType("text/plain", "javax.swing.text.StyledEditorKit");
        JEditorPane.registerEditorKitForContentType("text/html", "com.inet.html.InetHtmlEditorKit", InetHtmlEditorKit.class.getClassLoader());
        defaultProperties = new DefaultStyledDocument().getDocumentProperties();
    }

    public static class SetPageEditorKit
    extends InetHtmlEditorKit {
        private static final String PROPERTY_EDITOR_CONTENT = "editorContent";
        private final BaseEditor editor;

        public SetPageEditorKit(BaseEditor editor) {
            this.editor = editor;
            if (editor.editorHtmlConfig != null) {
                this.setDefaultConfig(editor.editorHtmlConfig);
            }
        }

        @Override
        public InetHtmlDocument createDefaultDocument() {
            InetHtmlDocument doc = super.createDefaultDocument();
            if (this.editor.persistentDocProperties != null) {
                Dictionary<Object, Object> props = doc.getDocumentProperties();
                Enumeration keys = this.editor.persistentDocProperties.keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    props.put(key, this.editor.persistentDocProperties.get(key));
                }
            }
            return doc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
            try {
                super.read(in, doc, pos);
            }
            catch (Exception e) {
                if (e instanceof ChangedCharSetException) {
                    throw (ChangedCharSetException)e;
                }
                HtmlEditorUtils.printStackTrace(e);
            }
            finally {
                this.editor.text.firePropertyChange(PROPERTY_EDITOR_CONTENT, null, null);
            }
        }
    }

    private class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -338168489010023258L;

        public UndoAction() {
            super("Undo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            try {
                BaseEditor.this.undoManager.undo();
            }
            catch (CannotUndoException ex) {
                HtmlEditorUtils.printStackTrace(ex);
            }
            this.updateState();
            BaseEditor.this.redoAction.updateState();
        }

        public void updateState() {
            this.setEnabled(BaseEditor.this.undoManager.canUndo());
            BaseEditor.this.tools.setUndoButtonEnabled(BaseEditor.this.undoManager.canUndo());
            this.putValue("ShortDescription", BaseEditor.this.undoManager.getUndoPresentationName());
        }

        @Override
        public boolean isEnabled() {
            return BaseEditor.this.text.isEnabled() && BaseEditor.this.text.isEditable() && super.isEnabled();
        }
    }

    private class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 5558159401954793463L;

        public RedoAction() {
            super("Redo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            try {
                BaseEditor.this.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                HtmlEditorUtils.printStackTrace(ex);
            }
            this.updateState();
            BaseEditor.this.undoAction.updateState();
        }

        void updateState() {
            this.setEnabled(BaseEditor.this.undoManager.canRedo());
            BaseEditor.this.tools.setRedoButtonEnabled(BaseEditor.this.undoManager.canRedo());
            this.putValue("ShortDescription", BaseEditor.this.undoManager.getRedoPresentationName());
        }

        @Override
        public boolean isEnabled() {
            return BaseEditor.this.text.isEnabled() && BaseEditor.this.text.isEditable() && super.isEnabled();
        }
    }

    private class EditorUndoManager
    extends UndoManager
    implements Runnable {
        private static final long serialVersionUID = 447739009751130194L;
        private CompoundEdit recent = null;
        private long lastDoTime = 0L;
        private static final int EVENT_LATENCY_TOLERANCE = 10;

        private EditorUndoManager() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent ev) {
            if (this.recent != null && System.currentTimeMillis() - this.lastDoTime < 10L) {
                this.recent.addEdit(ev.getEdit());
            } else {
                if (this.recent != null) {
                    this.recent.end();
                }
                this.recent = new CompoundEdit(){

                    @Override
                    public boolean isInProgress() {
                        return false;
                    }
                };
                this.recent.addEdit(ev.getEdit());
                ev = new UndoableEditEvent(ev.getSource(), this.recent);
                super.undoableEditHappened(ev);
                this.lastDoTime = System.currentTimeMillis();
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public synchronized void undo() throws CannotUndoException {
            if (this.recent != null) {
                this.recent.end();
            }
            super.undo();
            this.recent = null;
        }

        @Override
        public void run() {
            BaseEditor.this.undoAction.updateState();
            BaseEditor.this.redoAction.updateState();
        }
    }

    private class LoaderData {
        private final int thisActionID;
        private final boolean isHtml;
        private final boolean isExternal;
        private EditorKit kit;
        private Document doc;

        private LoaderData(int thisActionID, boolean isHtml, boolean isExternal) {
            this.thisActionID = thisActionID;
            this.isHtml = isHtml;
            this.isExternal = isExternal;
        }
    }

    public static interface TextLoadListener {
        public void notifyTextLoaded(Document var1);
    }

    public static class SimpleCaretEvent
    extends CaretEvent {
        private static final long serialVersionUID = -6561566333480275448L;
        private int dot;
        private int mark;

        public SimpleCaretEvent(Object source, int dot, int mark) {
            super(source);
            this.dot = dot;
            this.mark = mark;
        }

        @Override
        public int getDot() {
            return this.dot;
        }

        @Override
        public int getMark() {
            return this.mark;
        }
    }

    private static class NoSelectionCaret
    extends DefaultCaret {
        private static final long serialVersionUID = -3468079662160318085L;

        private NoSelectionCaret() {
        }

        @Override
        public void setSelectionVisible(boolean vis) {
            super.setSelectionVisible(false);
        }

        @Override
        public void setDot(int dot) {
            super.setDot(0);
        }

        @Override
        public void moveDot(int dot) {
            super.moveDot(0);
        }
    }

    private class UpdatePopupLoader
    extends LoaderStep {
        private UpdatePopupLoader() {
        }

        @Override
        public void execute(LoaderData data) {
            BaseEditor.this.finishedID = data.thisActionID;
            BaseEditor.this.popup.removeAll();
            BaseEditor.this.createPopup(BaseEditor.this.popup);
            BaseEditor.this.textLoaded();
            if (!Boolean.FALSE.equals(BaseEditor.this.getClientProperty(BaseEditor.PROPERTY_AUTO_SCROLL))) {
                BaseEditor.this.text.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
            }
        }
    }

    private class SizeUpdateLoader
    extends LoaderStep {
        private SizeUpdateLoader() {
        }

        @Override
        public void execute(LoaderData data) {
            block2: {
                try {
                    BaseEditor.this.text.getPreferredSize();
                }
                catch (NullPointerException e) {
                    if (!Logger.doesLog(1)) break block2;
                    Logger.error(e);
                }
            }
        }
    }

    private class NewModelNotifyLoader
    extends LoaderStep {
        private NewModelNotifyLoader() {
        }

        @Override
        public void execute(LoaderData data) {
            BaseEditor.this.notifyNewModel(data.isHtml, data.isExternal, data.doc);
        }
    }

    private class ModelLoader
    extends LoaderStep {
        private ModelLoader() {
        }

        @Override
        public void execute(LoaderData data) {
            block2: {
                BaseEditor.this.setFontScale(BaseEditor.this.fontScale);
                BaseEditor.this.adjustTextpaneBorders(data.isHtml);
                try {
                    BaseEditor.this.text.setDocument(data.doc);
                }
                catch (Throwable t) {
                    if (!Logger.doesLog(1)) break block2;
                    Logger.error(t);
                }
            }
        }
    }

    private class InitKitLoader
    extends LoaderStep {
        private InitKitLoader() {
        }

        @Override
        public void execute(LoaderData data) {
            if (!data.isHtml) {
                StyledEditorKit tempKit = BaseEditor.this.createEditorKit(false);
                BaseEditor.this.text.setEditorKit(tempKit);
                BaseEditor.this.text.setDocument(tempKit.createDefaultDocument());
                BaseEditor.this.text.setEditorKit(data.kit);
            } else if (BaseEditor.this.text.getEditorKit().getClass() != data.kit.getClass()) {
                BaseEditor.this.text.setEditorKit(data.kit);
            }
            BaseEditor.this.setFontScale(BaseEditor.this.fontScale);
        }
    }

    private abstract class LoaderStep
    implements Runnable {
        private LoaderData data;
        private EDTLoader edtLoader;

        private LoaderStep() {
        }

        @Override
        public void run() {
            block3: {
                if (this.data.thisActionID != BaseEditor.this.loadingID || this.data.thisActionID <= BaseEditor.this.finishedID) {
                    return;
                }
                try {
                    this.execute(this.data);
                    this.edtLoader.next();
                }
                catch (Throwable th) {
                    BaseEditor.this.popup.removeAll();
                    BaseEditor.this.createPopup(BaseEditor.this.popup);
                    BaseEditor.this.textLoaded();
                    if (!Logger.doesLog(1)) break block3;
                    Logger.error(th);
                }
            }
        }

        public void setLoader(EDTLoader edtLoader) {
            this.edtLoader = edtLoader;
        }

        public void start(LoaderData data) {
            this.data = data;
            if (data.thisActionID != BaseEditor.this.loadingID || data.thisActionID <= BaseEditor.this.finishedID) {
                return;
            }
            SwingUtilities.invokeLater(this);
        }

        public abstract void execute(LoaderData var1);
    }

    private class EDTLoader {
        private LoaderData data;
        private List<LoaderStep> steps = new ArrayList<LoaderStep>();

        public EDTLoader(LoaderData data) {
            this.data = data;
        }

        public void add(LoaderStep step) {
            this.steps.add(step);
            step.setLoader(this);
        }

        public void start() {
            this.next();
        }

        public void next() {
            if (this.steps.size() == 0) {
                return;
            }
            LoaderStep step = this.steps.remove(0);
            step.start(this.data);
        }
    }
}

