'use strict';clearreportsApp.service("ticketProcessFactory",function($rootScope,ticketProcessModel,dataservice,errorservice,dialogservice,modalservice){var $this=this;var updateActivityReferencesInCondition=function(condition,activityIdMap,ticketIdMap){if(condition.type==="activityFinished"||condition.type==="activityVisited"){let conditionData=angular.fromJson(condition.conditionData);if(activityIdMap&&activityIdMap[conditionData.itemId])conditionData.itemId=activityIdMap[conditionData.itemId];condition.conditionData=
angular.toJson(conditionData)}else if(condition.type==="ticketFinished"){let conditionData=angular.fromJson(condition.conditionData);if(ticketIdMap&&ticketIdMap[conditionData.itemId]){conditionData.itemId=ticketIdMap[conditionData.itemId];condition.conditionData=angular.toJson(conditionData)}}};var updateTicketFieldReferences=function(activity,ticketIdMap){if(!activity.ticketDataToReferencedFields||!ticketIdMap)return;for(let fieldKey in activity.ticketDataToReferencedFields){let referencedTicketId=
activity.ticketDataToReferencedFields[fieldKey];if(referencedTicketId==="")continue;if(ticketIdMap[referencedTicketId])activity.ticketDataToReferencedFields[fieldKey]=ticketIdMap[referencedTicketId]}};var updateTransitionConditions=function(transition,activityIdMap,ticketIdMap){if(transition.conditionsForAutoTransition)for(let c=0;c<transition.conditionsForAutoTransition.length;c++)updateActivityReferencesInCondition(transition.conditionsForAutoTransition[c],activityIdMap,ticketIdMap)};var updateActivityTransitions=
function(activity,activityIdMap,ticketIdMap){if(activity.transitions)for(let t=0;t<activity.transitions.length;t++){let transition=activity.transitions[t];transition.nextActivityId=activityIdMap[transition.nextActivityId]||transition.nextActivityId;updateTransitionConditions(transition,activityIdMap,ticketIdMap)}};var generateNewActivityIds=function(process){let idMap={};for(let a=0;a<process.activities.length;a++)idMap[process.activities[a].id]=GUID.createNew();if(process.parallelTickets)for(let t=
0;t<process.parallelTickets.length;t++){let ticket=process.parallelTickets[t];for(let a=0;a<ticket.activities.length;a++)idMap[ticket.activities[a].id]=GUID.createNew()}return idMap};var updateActivitiesWithNewIds=function(activities,activityIdMap,ticketIdMap){for(let a=0;a<activities.length;a++){let activity=activities[a];let oldId=activity.id;activity.id=activityIdMap[oldId];updateActivityTransitions(activity,activityIdMap,ticketIdMap);updateTicketFieldReferences(activity,ticketIdMap)}};this.loadTicketProcessList=
function(searchTerm,processFolderId,alertSelector){errorservice.clearErrorContent(alertSelector);dataservice.execute("ticketprocess.getprocesslist",{alertSelector:alertSelector,data:JSON.stringify({searchTerm:searchTerm,processFolderId:processFolderId}),handleSuccess:function(response){ticketProcessModel.processList=response.processList;ticketProcessModel.foldersList=response.foldersList;ticketProcessModel.folderBreadcrumbs=response.folderBreadcrumbs;ticketProcessModel.defaultSettings=response.defaultSettings}})};
this.loadEditProcessData=function(processId,ticketId,alertSelector,successCallback,processToOverride){errorservice.clearErrorContent(alertSelector);dataservice.execute("ticketprocess.editprocess",{alertSelector:alertSelector,data:JSON.stringify({processId:processId,ticketId:ticketId}),beforeExecute:function(){},afterExecute:function(){},handleSuccess:function(response){ticketProcessModel.currentProcess=processToOverride||response.process;ticketProcessModel.currentProcess.activityMap={};if(modalservice.activemodal&&
modalservice.activemodal.duplicate===true){let activityIdMap=generateNewActivityIds(ticketProcessModel.currentProcess);let ticketIdMap={};if(ticketProcessModel.currentProcess.parallelTickets)for(let t=0;t<ticketProcessModel.currentProcess.parallelTickets.length;t++){let ticket=ticketProcessModel.currentProcess.parallelTickets[t];ticketIdMap[ticket.id]=GUID.createNew()}updateActivitiesWithNewIds(ticketProcessModel.currentProcess.activities,activityIdMap,ticketIdMap);ticketProcessModel.currentProcess.startActivityId=
activityIdMap[ticketProcessModel.currentProcess.startActivityId];if(ticketProcessModel.currentProcess.parallelTickets)for(let t=0;t<ticketProcessModel.currentProcess.parallelTickets.length;t++){let ticket=ticketProcessModel.currentProcess.parallelTickets[t];ticket.id=ticketIdMap[ticket.id];updateActivitiesWithNewIds(ticket.activities,activityIdMap,ticketIdMap);ticket.startActivityId=activityIdMap[ticket.startActivityId];if(ticket.startConditions)for(let sc=0;sc<ticket.startConditions.length;sc++)updateActivityReferencesInCondition(ticket.startConditions[sc],
activityIdMap,ticketIdMap)}}for(let a=0;a<ticketProcessModel.currentProcess.activities.length;a++){let activity=ticketProcessModel.currentProcess.activities[a];restoreActivity(activity);ticketProcessModel.currentProcess.activityMap[activity.id]=activity}if(ticketProcessModel.currentProcess.parallelTickets!=undefined)for(let t=0;t<ticketProcessModel.currentProcess.parallelTickets.length;t++){let ticket=ticketProcessModel.currentProcess.parallelTickets[t];ticket.parallelTicket=true;ticket.activityMap=
{};if(ticket.startConditions!=undefined)for(let sc=0;sc<ticket.startConditions.length;sc++)ticket.startConditions[sc].conditionData=angular.fromJson(ticket.startConditions[sc].conditionData);for(let ta=0;ta<ticket.activities.length;ta++){let activity=ticket.activities[ta];restoreActivity(activity);ticket.activityMap[activity.id]=activity}}ticketProcessModel.editModel={actionsForTransitions:response.actionsForTransitions,actionsForAutoTransitions:response.actionsForAutoTransitions,actionsAllowedInActivity:response.actionsAllowedInActivity,
ticketFields:response.ticketFields,ticketFieldValues:response.ticketFieldValues,defaultAllowedActions:response.defaultAllowedActions,zoomFactor:1};$this.updateMetaInformation();if(typeof successCallback=="function")successCallback()}})};this.prepareProcessForSaving=function(process){var parallelTickets=[];if(process.parallelTickets!=undefined)for(var pt=0;pt<process.parallelTickets.length;pt++){var ticket=process.parallelTickets[pt];var startConditions=[];if(ticket.startConditions!=undefined)for(var sc=
0;sc<ticket.startConditions.length;sc++)startConditions.push({type:ticket.startConditions[sc].type,conditionData:angular.toJson(ticket.startConditions[sc].conditionData)});parallelTickets.push({id:ticket.id,name:ticket.name,startActivityId:ticket.startActivityId,activities:convertActivities(ticket.activities),startConditions:startConditions,deactivated:ticket.deactivated,latestStart:ticket.latestStart})}return{id:process.id,name:process.name,description:process.description,autoResourceAccess:process.autoResourceAccess,
canBeChangedWhenActive:process.canBeChangedWhenActive,startActivityId:process.startActivityId,activities:convertActivities(process.activities),parallelTickets:parallelTickets,parallelTicketLatestStarts:process.parallelTicketLatestStarts}};this.saveProcessData=function(process,processFolderId,alertSelector,successCallback,errorCallback){errorservice.clearErrorContent(alertSelector);dataservice.execute("ticketprocess.saveprocess",{alertSelector:alertSelector,data:JSON.stringify({process:$this.prepareProcessForSaving(process),
processFolderId:processFolderId}),handleSuccess:function(response){if(response.hint==undefined||response.hint.length==0){successCallback(response.processId);return}var answerhandler=function(answer){if(answer==DIALOGSERVICE.OK)successCallback(response.processId)};dialogservice.showMessageBox(".processeditorpanel",$rootScope.getMsg("ticketprocess.save.hint.title"),response.hint,DIALOGSERVICE.INFORMATION_MESSAGE,DIALOGSERVICE.OK_OPTION,answerhandler,$rootScope)},afterError:errorCallback})};this.validateProcessData=
function(process,ticketId,alertSelector,successCallback,errorCallback){errorservice.clearErrorContent(alertSelector);dataservice.execute("ticketprocess.validateprocess",{alertSelector:alertSelector,data:JSON.stringify({process:$this.prepareProcessForSaving(process),ticketId:ticketId}),handleSuccess:successCallback,afterError:errorCallback})};var convertActivities=function(activities){var result=[];if(activities!=undefined)for(var a=0;a<activities.length;a++){var activity=angular.copy(activities[a]);
if(activity.transitions!=undefined)for(var t=0;t<activity.transitions.length;t++){var transition=activity.transitions[t];if(transition.conditionsForAutoTransition!=undefined)for(var c=0;c<transition.conditionsForAutoTransition.length;c++)transition.conditionsForAutoTransition[c].conditionData=angular.toJson(transition.conditionsForAutoTransition[c].conditionData)}result.push(activity)}return result};var restoreActivity=function(activity){if(activity!=undefined)if(activity.transitions!=undefined)for(var t=
0;t<activity.transitions.length;t++){var transition=activity.transitions[t];if(transition.conditionsForAutoTransition!=undefined)for(var c=0;c<transition.conditionsForAutoTransition.length;c++)transition.conditionsForAutoTransition[c].conditionData=angular.fromJson(transition.conditionsForAutoTransition[c].conditionData)}};var updateMetaInformationOfTicket=function(ticket){ticket.incomingTransitionsMap={};let activityKeys=Object.keys(ticket.activityMap);for(let k=0;k<activityKeys.length;k++){let activity=
ticket.activityMap[activityKeys[k]];if(activity.transitions!=undefined)for(let i=0;i<activity.transitions.length;i++){let outgoingTransition=activity.transitions[i];let incomingTransitions=ticket.incomingTransitionsMap[outgoingTransition.nextActivityId];if(incomingTransitions==undefined){incomingTransitions=[];ticket.incomingTransitionsMap[outgoingTransition.nextActivityId]=incomingTransitions}let incomingTransition={previousActivityId:activity.id,actionLabel:outgoingTransition.actionLabel,action:outgoingTransition.action,
conditionsForAutoTransition:outgoingTransition.conditionsForAutoTransition};incomingTransitions.push(incomingTransition)}}ticket.connectedActivities={};if(ticket.startActivityId!=undefined){var collectTransitionActivities=function(startActivityId,path){let startActivity=ticket.activityMap[startActivityId];if(startActivity!=undefined)if(path.indexOf(startActivityId)<0){path.push(startActivityId);ticket.connectedActivities[startActivityId]=true;if(startActivity.transitions!=undefined&&startActivity.transitions.length)for(let t=
0;t<startActivity.transitions.length;t++)collectTransitionActivities(startActivity.transitions[t].nextActivityId,path)}};collectTransitionActivities(ticket.startActivityId,[])}ticket.activitiesWithCloseActions={};for(let k=0;k<activityKeys.length;k++){let activity=ticket.activityMap[activityKeys[k]];ticket.activitiesWithCloseActions[activity.id]=[];if(activity.allowedActions!=undefined&&activity.allowedActions.length>0)for(let a=0;a<activity.allowedActions.length;a++){let action=activity.allowedActions[a];
if(action.statusId>=300)ticket.activitiesWithCloseActions[activity.id].push(action)}}ticket.validationErrors=[];if(ticket.startConditions!=undefined)for(let sc=0;sc<ticket.startConditions.length;sc++){let condition=ticket.startConditions[sc];let error=ticketProcessModel.conditionTypes[condition.type].isValid(condition.conditionData);if(error!=undefined&&error.length){let num=ticket.startConditions.length<=1?0:sc+1;ticket.validationErrors.push($rootScope.getMsg("condition.validate.errorprefix.withcondition",
num,error))}}};this.updateMetaInformation=function(){if(ticketProcessModel.currentProcess==undefined)return;updateMetaInformationOfTicket(ticketProcessModel.currentProcess);if(ticketProcessModel.currentProcess.parallelTickets!=undefined)for(var t=0;t<ticketProcessModel.currentProcess.parallelTickets.length;t++){var ticket=ticketProcessModel.currentProcess.parallelTickets[t];updateMetaInformationOfTicket(ticket)}};this.createFolder=function(folderName,parentFolderId,successCallback,errorCallback){dataservice.execute("ticketprocess.createfolder",
{data:JSON.stringify({folderName:folderName,parentFolderId:parentFolderId}),handleSuccess:function(response){successCallback(response.folder)},handleError:function(error){errorCallback(folderName,error)}})};this.editOrDeleteFolder=function(folderId,newFolderName,parentFolderId,successCallback,errorCallback){dataservice.execute("ticketprocess.editordeletefolder",{data:JSON.stringify({folderId:folderId,newFolderName:newFolderName,parentFolderId:parentFolderId}),handleSuccess:function(response){successCallback()},
handleError:function(error){errorCallback(newFolderName,error)}})};this.getProcessFolderList=function(successCallback){dataservice.execute("ticketprocess.getprocessfolderlist",{data:"{}",handleSuccess:function(response){successCallback(response.options)}})};this.moveProcess=function(processId,folderId,successCallback,errorCallback){dataservice.execute("ticketprocess.moveprocess",{data:JSON.stringify({processId:processId,folderId:folderId}),handleSuccess:function(response){successCallback(response)},
handleError:function(error){errorCallback(error)}})}});