/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessValidationException;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessErrorCodes;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessSettings;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ParallelTicketTimer;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ProcessOperations;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ProcessTicketEventLog;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.validation.ProcessAnalyser;
import com.inet.id.GUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class StartProcessActionExtension
implements TicketActionExtensionFactory {
    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepFields) {
        if (action.getId() == -19) {
            ActiveProcess ticketProcess = (ActiveProcess)arguments.get(TicketProcessManager.EXT_ARG_PROCESS_TO_START);
            if (ticketProcess != null) {
                return new Extension(ticketProcess, (Boolean)arguments.get(TicketProcessManager.EXT_ARG_PROCESS_TO_START_MODIFIED));
            }
            throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.applyProcess.noProcessGiven", new Object[0]));
        }
        return null;
    }

    public Map<? extends TicketField<?>, ? extends String> checkForMandatoryFields(TicketVO ticket, ActionVO action, Consumer<TicketField<?>> checker, ExtensionArguments extensionArgs) {
        ActiveProcess ticketProcess = (ActiveProcess)extensionArgs.get(TicketProcessManager.EXT_ARG_PROCESS_TO_START);
        if (ticketProcess != null && action.getId() == -19) {
            ticketProcess.getProcessDefinition().getStart().getRequiredFieldKeys().stream().map(key -> Tickets.getFieldByKey((String)key)).forEach(f -> checker.accept((TicketField<?>)f));
        }
        return Collections.emptyMap();
    }

    public static String maxlen(String str, int max) {
        if (str.length() > max) {
            return str.substring(0, max - 3) + "...";
        }
        return str;
    }

    private class Extension
    implements TicketActionExtension {
        private ActiveProcess toStart;
        private Boolean modified;

        public Extension(@Nullable ActiveProcess toStart, Boolean modified) {
            this.toStart = toStart;
            this.modified = modified;
        }

        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            TicketProcess processOfTicket = ProcessOperations.getProcessOfTicket(ticket);
            TicketProcess processToStart = this.toStart.getProcessDefinition();
            if (processOfTicket != null) {
                if (processOfTicket.getId().equals((Object)processToStart.getId())) {
                    throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.applyProcess.processAlreadyActive", new Object[0]));
                }
                ActionVO cancel = (ActionVO)ActionManager.getInstance().get(-34);
                operations.applyAction(ticket, ProcessOperations.createGroupingData(ticket, reaStep), ReaStepTextVO.empty(), cancel, ExtensionArguments.create());
            }
            if (!processToStart.canBeChangedWhenActive() && this.modified == Boolean.TRUE) {
                throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.applyProcess.processCannotBeEdited", new Object[0]));
            }
            this.checkProcessTransitionsFitToTicketState(ticket, processToStart);
            Boolean isOriginal = Boolean.TRUE;
            if (this.modified != null && this.modified.booleanValue()) {
                isOriginal = Boolean.FALSE;
            }
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_PROCESS, (Object)processToStart);
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_ORIGINAL_PROCESS, (Object)isOriginal);
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES, new ArrayList());
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_PROCESS_START_DATE, (Object)System.currentTimeMillis());
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS, new HashMap());
            reaStep.getFields().put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)StartProcessActionExtension.maxlen(processToStart.getName(), 255));
            this.applyLatestStartDates(ticket);
            ticket.getAfterWriteOperations().add(() -> ProcessTicketEventLog.ProcessStarted.log(processToStart, ticket.getTicketId()));
            ProcessOperations.onNextActivity(ticket, reaStep, processToStart.getStart(), action);
            ticket.getAfterWriteOperations().add(() -> ParallelTicketTimer.getInstance().startTimersFor(TicketManager.getReader().getTicket(ticket.getTicketId())));
        }

        private void applyLatestStartDates(OperationChangedTicket ticket) {
            this.toStart.validateAdditionalSettings(new ProcessTickets(ticket, this.toStart.getProcessDefinition()));
            HashMap<GUID, Long> latestStarts = new HashMap<GUID, Long>(this.toStart.getSettings().getParallelTicketLatestStarts());
            for (ParallelTicket pt : this.toStart.getProcessDefinition().getParallelTickets()) {
                Long relative;
                if (latestStarts.containsKey(pt.getId()) || (relative = pt.getRelativeLatestStart()) == null || relative <= 0L) continue;
                latestStarts.put(pt.getId(), System.currentTimeMillis() + relative);
            }
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_ACTIVE_SETTINGS, (Object)new TicketProcessSettings(latestStarts));
        }

        private void checkProcessTransitionsFitToTicketState(OperationChangedTicket ticket, TicketProcess process) {
            TicketVO ticketVO = ticket.createIntermediateTicketVO();
            try {
                ProcessAnalyser.validate(process, ticketVO.isDispatched());
            }
            catch (IllegalArgumentException ee) {
                if (ee instanceof ProcessValidationException && ((ProcessValidationException)ee).getCode() == TicketProcessErrorCodes.DEAD_PATH.getErrorCodeNumber()) {
                    boolean success;
                    try {
                        ProcessAnalyser.validate(process, !ticketVO.isDispatched());
                        success = true;
                    }
                    catch (IllegalArgumentException eee) {
                        success = false;
                    }
                    if (success) {
                        if (ticketVO.isInquiry()) {
                            throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.applyProcess.notpossibleForInquiry", new Object[0]), ee);
                        }
                        throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.applyProcess.notpossibleForTicket", new Object[0]), ee);
                    }
                }
                throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.applyProcess.illegalstate", new Object[0]), ee);
            }
        }
    }
}

