/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal;

import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.logging.EventLog;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;

public enum ProcessEventLog {
    ProcessAdded,
    ProcessChanged,
    ProcessDeleted,
    ProcessUpdateStarted,
    ProcessUpdateFinished;

    private static final EventLog<ProcessEventLog> EVENT_LOG;

    public void log(TicketProcess process) {
        this.log(process, null);
    }

    public void log(TicketProcess process, @Nullable String oldName) {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        String msg = TicketProcessManager.MSG.getMsg(Locale.getDefault(), "eventlog." + this.name(), new Object[]{process.getName()});
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("Name", process.getName());
        if (oldName != null && !Objects.equals(oldName, process.getName())) {
            data.put("Old name", oldName);
            msg = TicketProcessManager.MSG.getMsg(Locale.getDefault(), "eventlog." + this.name() + ".rename", new Object[]{process.getName(), oldName});
        }
        data.put("ID", process.getId().toString());
        EVENT_LOG.log((Enum)this, userAccount, msg, new Json().toJson(data), new Object[]{process.getName()});
    }

    public void log(GUID processId) {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        String msg = TicketProcessManager.MSG.getMsg(Locale.getDefault(), "eventlog." + this.name(), new Object[]{processId.toString()});
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("Name", processId.toString());
        data.put("ID", processId.toString());
        EVENT_LOG.log((Enum)this, userAccount, msg, new Json().toJson(data), new Object[]{"unknown"});
    }

    static {
        EVENT_LOG = EventLog.register((String)"helpdesktemplate");
    }
}

