/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ConditionType;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessCondition;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@JsonData
@Immutable
public class ParallelTicket {
    private GUID id;
    private String name;
    private List<Activity> activities;
    private transient Activity start;
    private GUID startActivityId;
    private List<ProcessCondition<?>> startCondition;
    private boolean deactivated;
    private Long relativeLatestStart;

    private ParallelTicket() {
    }

    public ParallelTicket(GUID id, String name, List<Activity> activities, GUID startActivityId, List<ProcessCondition<?>> startCondition, boolean deactivated, @Nullable Long latestStartRelative) {
        Objects.requireNonNull(id);
        if (StringFunctions.isEmpty((String)name)) {
            throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.parallel.nameIsEmpty", new Object[0]));
        }
        if (startActivityId == null) {
            throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.parallel.noStartActivity", new Object[]{name}));
        }
        Objects.requireNonNull(activities);
        Objects.requireNonNull(startCondition);
        this.name = name;
        this.id = id;
        this.activities = new ArrayList<Activity>(activities);
        this.startActivityId = startActivityId;
        this.startCondition = new ArrayList(startCondition);
        this.deactivated = deactivated;
        this.relativeLatestStart = latestStartRelative;
    }

    public GUID getId() {
        return this.id;
    }

    public List<Activity> getActivities() {
        return Collections.unmodifiableList(this.activities);
    }

    public Activity getStart() {
        return this.start;
    }

    public GUID getStartActivityId() {
        return this.startActivityId;
    }

    public List<ProcessCondition<?>> getStartCondition() {
        return Collections.unmodifiableList(this.startCondition);
    }

    public String getName() {
        return this.name;
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    public Long getRelativeLatestStart() {
        return this.relativeLatestStart;
    }

    void restoreReferences(TicketProcess process) {
        for (Activity a : this.activities) {
            if (a.getId().equals((Object)this.startActivityId)) {
                this.start = a;
            }
            a.restoreReferences(this.activities, process);
        }
        if (this.start == null) {
            throw new IllegalStateException("activities must contain start activity");
        }
        for (int index = 0; index < this.startCondition.size(); ++index) {
            GUID itemId;
            ProcessCondition<?> pc = this.startCondition.get(index);
            if (pc.getType().equals(ConditionType.TICKET_FINISHED.getTypeIdentifier())) {
                itemId = ConditionType.TICKET_FINISHED.convert(pc.getConditionData()).getItemId();
                try {
                    process.getParallelTicket(itemId);
                }
                catch (IllegalStateException ee) {
                    String whereUsed = TicketProcessManager.MSG.getMsg("validation.condition.usedInParalelTicket", new Object[]{this.name});
                    throw new IllegalStateException(TicketProcessManager.MSG.getMsg("validation.condition.autoTransition.ticketNotFound", new Object[]{whereUsed, index + 1, itemId}));
                }
            }
            if (!pc.getType().equals(ConditionType.ACTIVITY_FINISHED.getTypeIdentifier()) && !pc.getType().equals(ConditionType.ACTIVITY_VISITED.getTypeIdentifier()) || process.getActivity(itemId = ConditionType.ACTIVITY_FINISHED.convert(pc.getConditionData()).getItemId()) != null) continue;
            String whereUsed = TicketProcessManager.MSG.getMsg("validation.condition.usedInParalelTicket", new Object[]{this.name});
            throw new IllegalStateException(TicketProcessManager.MSG.getMsg("validation.condition.autoTransition.activityNotFound", new Object[]{whereUsed, index + 1, itemId}));
        }
        Objects.requireNonNull(this.start.getTicketText(), "Start activity must set TicketText");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activities == null ? 0 : this.activities.hashCode());
        result = 31 * result + (this.deactivated ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.relativeLatestStart == null ? 0 : this.relativeLatestStart.hashCode());
        result = 31 * result + (this.startActivityId == null ? 0 : this.startActivityId.hashCode());
        result = 31 * result + (this.startCondition == null ? 0 : this.startCondition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParallelTicket other = (ParallelTicket)obj;
        if (this.activities == null ? other.activities != null : !this.activities.equals(other.activities)) {
            return false;
        }
        if (this.deactivated != other.deactivated) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals((Object)other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.relativeLatestStart == null ? other.relativeLatestStart != null : !this.relativeLatestStart.equals(other.relativeLatestStart)) {
            return false;
        }
        if (this.startActivityId == null ? other.startActivityId != null : !this.startActivityId.equals((Object)other.startActivityId)) {
            return false;
        }
        return !(this.startCondition == null ? other.startCondition != null : !this.startCondition.equals(other.startCondition));
    }
}

