/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.handler;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ProcessDetailsDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ValidateTicketProcessRequest;
import com.inet.helpdesk.plugins.ticketprocess.client.handler.AbstractTicketProcessHandler;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessValidationException;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

public class ValidateTicketProcess
extends AbstractTicketProcessHandler<ValidateTicketProcessRequest, Void> {
    public String getMethodName() {
        return "ticketprocess.validateprocess";
    }

    @Override
    protected boolean hasAccess(ValidateTicketProcessRequest payload) {
        List allPossibleActionsForTicket;
        if (payload.getTicketId() != null && (allPossibleActionsForTicket = TicketManager.getTicketActionChecker().getAllPossibleActionsForTicket(payload.getTicketId().intValue())).stream().anyMatch(a -> a.getId() == -19 || a.getId() == -37)) {
            return true;
        }
        return super.hasAccess(payload);
    }

    @Override
    public Void handle(HttpServletRequest req, HttpServletResponse resp, ValidateTicketProcessRequest payload) throws IOException {
        try {
            ActiveProcess t = ProcessDetailsDescription.to(payload.getProcess());
            t.validate();
        }
        catch (Throwable e) {
            if (e instanceof ProcessValidationException) {
                ProcessValidationException processException = (ProcessValidationException)e;
                Activity activity = processException.getActivity();
                if (activity != null) {
                    throw new ClientMessageException("<a ng-click=\"scrollToActivity('" + String.valueOf(activity.getId()) + "');\" activityid=\"" + String.valueOf(activity.getId()) + "\">" + e.getMessage() + "</a>", true);
                }
                ParallelTicket parallelTicket = processException.getParallelTicket();
                if (parallelTicket != null) {
                    throw new ClientMessageException("<a ng-click=\"scrollToTicket('" + String.valueOf(parallelTicket.getId()) + "');\" parallelticketid=\"" + String.valueOf(parallelTicket.getId()) + "\" highlightsource=\"true\">" + e.getMessage() + "</a>", true);
                }
            }
            if (e instanceof ClientMessageException) {
                throw e;
            }
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)e));
        }
        return null;
    }
}

