/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.handler;

import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.model.general.RelativeOrAbsoluteDate;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.ActionDescription;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererProvider;
import com.inet.helpdesk.plugins.ticketlist.api.editing.FieldEditDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.data.EditTicketProcessRequest;
import com.inet.helpdesk.plugins.ticketprocess.client.data.EditTicketProcessResponse;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ProcessDetailsDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.handler.AbstractTicketProcessHandler;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class EditTicketProcess
extends AbstractTicketProcessHandler<EditTicketProcessRequest, EditTicketProcessResponse> {
    @Override
    protected boolean hasAccess(EditTicketProcessRequest payload) {
        List allPossibleActionsForTicket;
        if (payload.getTicketId() != null && (allPossibleActionsForTicket = TicketManager.getTicketActionChecker().getAllPossibleActionsForTicket(payload.getTicketId().intValue())).stream().anyMatch(a -> a.getId() == -19 || a.getId() == -37)) {
            return true;
        }
        return super.hasAccess(payload);
    }

    @Override
    public EditTicketProcessResponse handle(HttpServletRequest req, HttpServletResponse resp, EditTicketProcessRequest payload) throws IOException {
        TicketProcessManager ticketProcessManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
        ProcessDetailsDescription processDetails = new ProcessDetailsDescription();
        if (payload.getTicketId() != null) {
            int ticketId = payload.getTicketId();
            List allPossibleActionsForTicket = TicketManager.getTicketActionChecker().getAllPossibleActionsForTicket(ticketId);
            if (!allPossibleActionsForTicket.stream().anyMatch(a -> a.getId() == -19 || a.getId() == -37)) {
                throw new AccessDeniedException();
            }
            if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanWriteTicket(ticketId)) {
                throw new AccessDeniedException();
            }
            TicketVO ticket = TicketManager.getReader().getTicket(ticketId);
            if (ticket != null) {
                ActiveProcess process = TicketProcessManager.getActiveProcessOfTicket(ticket);
                if (process == null) {
                    TicketProcess definition;
                    if (payload.getProcessId() != null && (definition = ticketProcessManager.getProcess(payload.getProcessId())) != null) {
                        process = definition.toActiveProcessWithoutModifications();
                    }
                    if (process == null) {
                        throw new ClientMessageException(TicketProcessPlugin.MSG_CLIENT.getMsg("ticketprocess.error.notfound", new Object[0]));
                    }
                }
                processDetails = ProcessDetailsDescription.from(process);
            }
        } else if (payload.getProcessId() != null) {
            TicketProcess process = ticketProcessManager.getProcess(payload.getProcessId());
            if (process == null) {
                throw new ClientMessageException(TicketProcessPlugin.MSG_CLIENT.getMsg("ticketprocess.error.notfound", new Object[0]));
            }
            processDetails = ProcessDetailsDescription.from(process.toActiveProcessWithoutModifications());
        }
        Comparator actionComparator = (a, b) -> a.getDisplayName().compareToIgnoreCase(b.getDisplayName());
        List<ActionDescription> actionsForTransitions = TicketProcessManager.getPossibleActionsForTransition().stream().map(a -> TicketFunctions.convertToActionDescription((ActionVO)a)).sorted(actionComparator).collect(Collectors.toList());
        List<ActionDescription> actionsForAutoTransitions = TicketProcessManager.getActionsWhichCanBeAllowedForAutoTransition().stream().map(id -> (ActionVO)ActionManager.getInstance().get(id.intValue())).filter(a -> a != null).map(a -> TicketFunctions.convertToActionDescription((ActionVO)a)).sorted(actionComparator).collect(Collectors.toList());
        List<ActionDescription> actionsAllowedInActivity = TicketProcessManager.getPossibleActionsWhichCanBeAllowed().stream().map(a -> TicketFunctions.convertToActionDescription((ActionVO)a)).sorted(actionComparator).collect(Collectors.toList());
        List<ActionDescription> defaultAllowedActions = TicketProcessManager.getDefaultAllowedActions().stream().map(a -> TicketFunctions.convertToActionDescription((ActionVO)a)).sorted(actionComparator).collect(Collectors.toList());
        HashMap<String, String> ticketFieldValues = new HashMap<String, String>();
        ArrayList<FieldEditDescription> ticketFields = new ArrayList<FieldEditDescription>();
        List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        for (TicketFieldDefinition definition : fieldDefs) {
            FieldEditDefinition editDefinition = definition.getEditDefinition();
            if (editDefinition == null || !editDefinition.isAvailable(null) && !Tickets.FIELD_OWNER_GUID.getKey().equals(editDefinition.getFieldKey())) continue;
            String displayType = editDefinition.getDisplayType();
            if ("datevalue".equals(displayType) || "dateonlyvalue".equals(displayType)) {
                displayType = "relativeabsolutedatevalue";
                ticketFieldValues.put(editDefinition.getFieldKey(), new Json().toJson((Object)RelativeOrAbsoluteDate.createRelative((long)0L)));
            } else {
                editDefinition.updateCurrentValue(null, currentUserAccountID, ticketFieldValues);
            }
            ticketFields.add(new FieldEditDescription(editDefinition.getFieldKey(), displayType, editDefinition.getDisplayName(), definition.getDescription(), definition.getProperties()));
        }
        ticketFieldValues.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf((Boolean)ApplyActionRendererProvider.DEFAULT_TICKET_PLAINTEXT_REASTEP.get() == false));
        Font defaultFont = TicketTextFunctions.getDefaultFont();
        ticketFieldValues.put(TicketFieldRendererId.fontname.name(), defaultFont.getFamily());
        ticketFieldValues.put(TicketFieldRendererId.fontsize.name(), defaultFont.getSize() + "pt");
        return new EditTicketProcessResponse(processDetails, actionsForTransitions, actionsForAutoTransitions, actionsAllowedInActivity, ticketFields, ticketFieldValues, defaultAllowedActions);
    }

    public String getMethodName() {
        return "ticketprocess.editprocess";
    }
}

