/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.databaseaction;

import com.inet.id.GUID;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.databaseaction.JdbcDatabaseResultAction;
import com.inet.taskplanner.databaseaction.TaskPlannerDatabaseActionServerPlugin;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.PasswordField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JdbcDatabaseResultActionFactory
extends ResultActionFactory<JdbcDatabaseResultAction> {
    public static final String JDBC_URL = "url";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String TABLE = "table";
    public static final String FILE_COLUMN = "filecolumn";
    public static final String IDENTIFIER_COLUMN = "identifiercolumn";
    public static final String IDENTIFIER_VALUE = "identifiervalue";

    public JdbcDatabaseResultActionFactory() {
        super("action.database.jdbc");
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.FILE);
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        String name = TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.name.jdbc", new Object[0]);
        String description = TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.description.jdbc", new Object[0]);
        URL icon = ((Object)((Object)this)).getClass().getResource("/com/inet/taskplanner/databaseaction/taskplanner_databaseaction_32.png");
        String helpkey = null;
        ArrayList<Object> fields = new ArrayList<Object>();
        fields.add(new TextField(JDBC_URL, TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.jdbcurl", new Object[0])));
        fields.add(new TextField(USERNAME, TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.username", new Object[0])));
        fields.add(new PasswordField(PASSWORD, TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.password", new Object[0])));
        fields.add(new TextField(TABLE, TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.table", new Object[0])));
        fields.add(new TextField(FILE_COLUMN, TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.filecolumn", new Object[0])));
        TextField identifierColumnField = new TextField(IDENTIFIER_COLUMN, TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.identifiercolumn", new Object[0]));
        identifierColumnField.setPlaceholder(TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.placeholder.optional", new Object[0]));
        fields.add(identifierColumnField);
        TextField identifierValueField = new TextField(IDENTIFIER_VALUE, TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.identifiervalue", new Object[0]));
        identifierValueField.setPlaceholder(TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.placeholder.optional", new Object[0]));
        fields.add(identifierValueField);
        return new ResultActionInfo(this.getExtensionName(), name, description, icon, helpkey, fields);
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        String jdbcURL = definition.getProperty(JDBC_URL);
        String username = definition.getProperty(USERNAME);
        String decodedPassword = this.decodePassword(definition.getProperty(PASSWORD));
        String table = definition.getProperty(TABLE);
        String fileColumn = definition.getProperty(FILE_COLUMN);
        if (table == null || table.trim().isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.table.empty", new Object[0])});
        }
        if (fileColumn == null || fileColumn.trim().isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.filecolumn.empty", new Object[0])});
        }
        String sql = "SELECT COUNT(*) FROM " + table;
        try (Connection con = DriverManager.getConnection(jdbcURL, username, decodedPassword);
             Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery(sql);){
            if (rs.next()) {
                rs.getInt(1);
            }
        }
        catch (Exception ex) {
            throw new ValidationException(new String[]{ex.getMessage()});
        }
    }

    protected JdbcDatabaseResultAction createInstanceFrom(@Nonnull ResultActionDefinition definition) {
        String jdbcURL = definition.getProperty(JDBC_URL);
        String username = definition.getProperty(USERNAME);
        String decodedPassword = this.decodePassword(definition.getProperty(PASSWORD));
        String table = definition.getProperty(TABLE);
        String fileColumn = definition.getProperty(FILE_COLUMN);
        String identifierColumn = definition.getProperty(IDENTIFIER_COLUMN);
        String identifierValue = definition.getProperty(IDENTIFIER_VALUE);
        if (identifierColumn == null || identifierColumn.trim().isEmpty()) {
            return new JdbcDatabaseResultAction(jdbcURL, username, decodedPassword, table, fileColumn);
        }
        return new JdbcDatabaseResultAction(jdbcURL, username, decodedPassword, table, fileColumn, identifierColumn, identifierValue);
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        String identifierValue;
        ArrayList<SummaryEntry> result = new ArrayList<SummaryEntry>();
        result.add(new SummaryEntry(TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.jdbcurl", new Object[0]), definition.getProperty(JDBC_URL)));
        result.add(new SummaryEntry(TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.table", new Object[0]), definition.getProperty(TABLE)));
        result.add(new SummaryEntry(TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.filecolumn", new Object[0]), definition.getProperty(FILE_COLUMN)));
        String identifierColumn = definition.getProperty(IDENTIFIER_COLUMN);
        if (identifierColumn != null && !identifierColumn.trim().isEmpty()) {
            result.add(new SummaryEntry(TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.identifiercolumn", new Object[0]), identifierColumn));
        }
        if ((identifierValue = definition.getProperty(IDENTIFIER_VALUE)) != null && !identifierValue.trim().isEmpty()) {
            result.add(new SummaryEntry(TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.identifiervalue", new Object[0]), identifierValue));
        }
        return new SummaryInfo(result);
    }

    private String decodePassword(String password) {
        if (password != null && !password.isEmpty()) {
            try {
                password = PasswordField.decodePassword((String)password);
            }
            catch (IOException ex) {
                TaskPlannerServerPlugin.LOGGER.error((Throwable)ex);
            }
        }
        return password;
    }
}

