/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.databaseaction;

import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.result.FileResult;
import com.inet.taskplanner.server.api.result.Result;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.taskplanner.server.api.series.db.DataSourceProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;

public class DataSourceDatabaseResultAction
extends ResultAction {
    private DataSourceProvider dataSourceProvider;
    private String datasource;
    private String table;
    private String fileColumn;
    private String identifierColumn;
    private String identifierValue;

    public DataSourceDatabaseResultAction(DataSourceProvider dataSourceProvider, String datasource, String table, String fileColumn) {
        this.dataSourceProvider = dataSourceProvider;
        this.datasource = datasource;
        this.table = table;
        this.fileColumn = fileColumn;
    }

    public DataSourceDatabaseResultAction(DataSourceProvider dataSourceProvider, String datasource, String table, String fileColumn, String identifierColumn, String identifierValue) {
        this.dataSourceProvider = dataSourceProvider;
        this.datasource = datasource;
        this.table = table;
        this.fileColumn = fileColumn;
        this.identifierColumn = identifierColumn;
        this.identifierValue = identifierValue;
    }

    protected void handle(List<JobResultContainer> resultContainers) throws TaskExecutionException {
        boolean numericIdentifier;
        String sql;
        ArrayList<FileResult> fileResults = new ArrayList<FileResult>();
        for (JobResultContainer container : resultContainers) {
            for (Result result : container.getResults(ResultFlavor.FILE)) {
                try {
                    FileResult fileResult = (FileResult)result;
                    if (fileResult.getFileSize() == 0L) continue;
                    fileResults.add((FileResult)result);
                }
                catch (Exception ex) {
                    TaskPlannerServerPlugin.LOGGER.error((Throwable)ex);
                }
            }
        }
        if (fileResults.isEmpty()) {
            return;
        }
        if (this.identifierColumn != null) {
            sql = String.format("INSERT INTO %s (%s,%s) VALUES (?,?)", this.table, this.fileColumn, this.identifierColumn);
            try {
                Long.valueOf(this.identifierValue);
                numericIdentifier = true;
            }
            catch (Exception ex) {
                numericIdentifier = false;
            }
        } else {
            sql = String.format("INSERT INTO %s (%s) VALUES (?)", this.table, this.fileColumn);
            numericIdentifier = false;
        }
        try (Connection con = this.dataSourceProvider.getConnection(this.datasource);
             PreparedStatement pstm = con.prepareStatement(sql);){
            for (FileResult file : fileResults) {
                pstm.setBinaryStream(1, file.getFileContent());
                if (this.identifierColumn != null) {
                    if (numericIdentifier) {
                        pstm.setLong(2, Long.valueOf(this.identifierValue));
                    } else {
                        pstm.setString(2, this.identifierValue);
                    }
                }
                pstm.executeUpdate();
            }
        }
        catch (Exception ex) {
            throw new TaskExecutionException((Throwable)ex);
        }
    }
}

