/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package com.inet.taskplanner.databaseaction;

import com.inet.classloader.I18nMessages;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.action.ResultActionFactory;

/**
 * Server plugin for Task Planner's Database Actions.<br>
 * This instance registers factories of database actions.
 */
@PluginInfo( //
id = "taskplanner.databaseaction", //
dependencies = "taskplanner", //
optionalDependencies = "datasource", //
packages = "", //
group = "samples", // 
version = "25.10.338", //
icon = "com/inet/taskplanner/databaseaction/taskplanner_databaseaction_48.png", //
flags = "" //
)
public class TaskPlannerDatabaseActionServerPlugin implements ServerPlugin {

    /**
     * Localization of messages
     */
    public static final I18nMessages MSG = new I18nMessages( "com.inet.taskplanner.databaseaction.structure.i18n.ConfigStructure", TaskPlannerDatabaseActionServerPlugin.class );

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {
        // Register your own result action factory implementations
        spm.register( ResultActionFactory.class, new JdbcDatabaseResultActionFactory() );
        spm.register( ResultActionFactory.class, new DataSourceDatabaseResultActionFactory() );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        // nothing to do
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing to do
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing to do
    }
}
