/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.databaseaction;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.databaseaction.DataSourceDatabaseResultAction;
import com.inet.taskplanner.databaseaction.TaskPlannerDatabaseActionServerPlugin;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.taskplanner.server.api.series.db.DataSourceProvider;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataSourceDatabaseResultActionFactory
extends ResultActionFactory<DataSourceDatabaseResultAction> {
    public static final String DATASOURCE = "datasource";
    public static final String TABLE = "table";
    public static final String COLUMN = "column";

    public DataSourceDatabaseResultActionFactory() {
        super("action.database.datasource");
    }

    public boolean isAvailable() {
        return this.getOptionalDataSourceProvider() != null;
    }

    private DataSourceProvider getOptionalDataSourceProvider() {
        return (DataSourceProvider)ServerPluginManager.getInstance().getOptionalInstance(DataSourceProvider.class);
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.FILE);
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        String name = TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.name.datasource", new Object[0]);
        String description = TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.description.datasource", new Object[0]);
        URL icon = ((Object)((Object)this)).getClass().getResource("/com/inet/taskplanner/databaseaction/taskplanner_databaseaction_32.png");
        String helpkey = null;
        ArrayList<Object> fields = new ArrayList<Object>();
        List dataSourceNames = this.getOptionalDataSourceProvider().getDataSourceNames();
        if (!dataSourceNames.isEmpty()) {
            Collections.sort(dataSourceNames);
            ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
            for (String dataSourceName : dataSourceNames) {
                values.add(new LocalizedKey(dataSourceName, dataSourceName));
            }
            SelectField selectField = new SelectField(DATASOURCE, TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.datasource", new Object[0]), values);
            selectField.setValue(((LocalizedKey)values.get(0)).getKey());
            fields.add(selectField);
        }
        fields.add(new TextField(TABLE, TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.table", new Object[0])));
        fields.add(new TextField(COLUMN, TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.column", new Object[0])));
        return new ResultActionInfo(this.getExtensionName(), name, description, icon, helpkey, fields);
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        String datasource = definition.getProperty(DATASOURCE);
        String table = definition.getProperty(TABLE);
        String column = definition.getProperty(COLUMN);
        if (datasource == null || datasource.trim().isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.datasource.empty", new Object[0])});
        }
        if (table == null || table.trim().isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.table.empty", new Object[0])});
        }
        if (column == null || column.trim().isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.column.empty", new Object[0])});
        }
        String sql = "SELECT COUNT(*) FROM " + table;
        try (Connection con = this.getOptionalDataSourceProvider().getConnection(datasource);
             Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery(sql);){
            if (rs.next()) {
                rs.getInt(1);
            }
        }
        catch (Exception ex) {
            throw new ValidationException(new String[]{ex.getMessage()});
        }
    }

    protected DataSourceDatabaseResultAction createInstanceFrom(@Nonnull ResultActionDefinition definition) {
        String datasource = definition.getProperty(DATASOURCE);
        String table = definition.getProperty(TABLE);
        String column = definition.getProperty(COLUMN);
        return new DataSourceDatabaseResultAction(this.getOptionalDataSourceProvider(), datasource, table, column);
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        ArrayList<SummaryEntry> result = new ArrayList<SummaryEntry>();
        result.add(new SummaryEntry(TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.datasource", new Object[0]), definition.getProperty(DATASOURCE)));
        result.add(new SummaryEntry(TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.table", new Object[0]), definition.getProperty(TABLE)));
        result.add(new SummaryEntry(TaskPlannerDatabaseActionServerPlugin.MSG.getMsg("taskplanner.databaseaction.column", new Object[0]), definition.getProperty(COLUMN)));
        return new SummaryInfo(result);
    }
}

