/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.databaseaction;

import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.result.FileResult;
import com.inet.taskplanner.server.api.result.Result;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.taskplanner.server.api.series.db.DataSourceProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;

public class DataSourceDatabaseResultAction
extends ResultAction {
    private DataSourceProvider dataSourceProvider;
    private String datasource;
    private String table;
    private String column;

    public DataSourceDatabaseResultAction(DataSourceProvider dataSourceProvider, String datasource, String table, String column) {
        this.dataSourceProvider = dataSourceProvider;
        this.datasource = datasource;
        this.table = table;
        this.column = column;
    }

    protected void handle(List<JobResultContainer> resultContainers) throws TaskExecutionException {
        ArrayList<FileResult> fileResults = new ArrayList<FileResult>();
        for (JobResultContainer container : resultContainers) {
            for (Result result : container.getResults(ResultFlavor.FILE)) {
                try {
                    FileResult fileResult = (FileResult)result;
                    if (fileResult.getFileSize() == 0L) continue;
                    fileResults.add((FileResult)result);
                }
                catch (Exception ex) {
                    TaskPlannerServerPlugin.LOGGER.error((Throwable)ex);
                }
            }
        }
        if (fileResults.isEmpty()) {
            return;
        }
        String sql = String.format("INSERT INTO %s (%s) VALUES (?)", this.table, this.column);
        try (Connection con = this.dataSourceProvider.getConnection(this.datasource);
             PreparedStatement pstm = con.prepareStatement(sql);){
            for (FileResult file : fileResults) {
                pstm.setBinaryStream(1, file.getFileContent());
                pstm.executeUpdate();
            }
        }
        catch (Exception ex) {
            throw new TaskExecutionException((Throwable)ex);
        }
    }
}

