/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.category;

import com.inet.jfree.data.category.DefaultCategoryDataset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class InetCategoryDataset
extends DefaultCategoryDataset {
    private boolean invertedRows;
    private boolean invertedColumns;
    private Comparator<Object> rowComp;
    private List<Comparable> rows;

    public void setRowComparator(Comparator<Object> comp) {
        this.rowComp = comp;
        this.rows = null;
    }

    public void setInvertedRows(boolean invertedRows) {
        this.invertedRows = invertedRows;
        this.rows = null;
    }

    public boolean getInvertedRows() {
        return this.invertedRows;
    }

    public void setInvertedColumns(boolean invertedColumns) {
        this.invertedColumns = invertedColumns;
    }

    public boolean getInvertedColumns() {
        return this.invertedColumns;
    }

    @Override
    public Comparable getColumnKey(int column) {
        return super.getColumnKey(this.getInternColumnIndex(column));
    }

    @Override
    public int getColumnIndex(Comparable key) {
        return this.getInternColumnIndex(super.getColumnIndex(key));
    }

    @Override
    public List getColumnKeys() {
        if (this.invertedColumns) {
            return Collections.unmodifiableList(InetCategoryDataset.reverseList(super.getColumnKeys()));
        }
        return super.getColumnKeys();
    }

    @Override
    public Comparable getRowKey(int row) {
        return this.getRowKeys().get(row);
    }

    @Override
    public int getRowIndex(Comparable key) {
        return this.getRowKeys().indexOf(key);
    }

    @Override
    public List<Comparable> getRowKeys() {
        if (this.rows == null) {
            List<Object> rowKeys = new ArrayList<Object>(super.getRowKeys());
            if (this.rowComp != null) {
                rowKeys.sort(this.rowComp);
            }
            if (this.invertedRows) {
                rowKeys = InetCategoryDataset.reverseList(rowKeys);
            }
            this.rows = Collections.unmodifiableList(rowKeys);
        }
        return this.rows;
    }

    @Override
    public Number getValue(int row, int column) {
        return super.getValue(super.getRowIndex(this.getRowKey(row)), this.getInternColumnIndex(column));
    }

    @Override
    public void removeRow(int rowIndex) {
        this.removeRow(this.getRowKey(rowIndex));
    }

    @Override
    public void removeRow(Comparable rowKey) {
        super.removeRow(rowKey);
        this.rows = null;
    }

    @Override
    public void removeColumn(int columnIndex) {
        super.removeColumn(this.getInternColumnIndex(columnIndex));
    }

    @Override
    public void removeColumn(Comparable columnKey) {
        super.removeColumn(this.getColumnIndex(columnKey));
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof InetCategoryDataset)) {
                return false;
            }
            InetCategoryDataset that = (InetCategoryDataset)obj;
            if (this.invertedColumns != that.invertedColumns) {
                return false;
            }
            return this.invertedRows == that.invertedRows;
        }
        return false;
    }

    private int getInternColumnIndex(int index) {
        if (this.invertedColumns) {
            return this.getColumnCount() - 1 - index;
        }
        return index;
    }

    private static List reverseList(List list) {
        ArrayList result = new ArrayList(list.size());
        for (int i = list.size() - 1; i > -1; --i) {
            result.add(list.get(i));
        }
        return result;
    }
}

