/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer;

import com.inet.jfree.chart.LegendItem;
import com.inet.jfree.chart.axis.NumberTick;
import com.inet.jfree.chart.axis.ValueAxis;
import com.inet.jfree.chart.plot.DrawingSupplier;
import com.inet.jfree.chart.plot.PlotRenderingInfo;
import com.inet.jfree.chart.plot.PolarPlot;
import com.inet.jfree.chart.renderer.AbstractRenderer;
import com.inet.jfree.chart.renderer.PolarItemRenderer;
import com.inet.jfree.data.xy.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.text.TextUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;

public class DefaultPolarItemRenderer
extends AbstractRenderer
implements PolarItemRenderer {
    private PolarPlot plot;
    private BooleanList seriesFilled = new BooleanList();

    @Override
    public void setPlot(PolarPlot plot) {
        this.plot = plot;
    }

    @Override
    public PolarPlot getPlot() {
        return this.plot;
    }

    @Override
    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier result = null;
        PolarPlot p = this.getPlot();
        if (p != null) {
            result = p.getDrawingSupplier();
        }
        return result;
    }

    public boolean isSeriesFilled(int series) {
        boolean result = false;
        Boolean b = this.seriesFilled.getBoolean(series);
        if (b != null) {
            result = b;
        }
        return result;
    }

    public void setSeriesFilled(int series, boolean filled) {
        this.seriesFilled.setBoolean(series, BooleanUtilities.valueOf((boolean)filled));
    }

    @Override
    public void drawSeries(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info, PolarPlot plot, XYDataset dataset, int seriesIndex) {
        Polygon poly = new Polygon();
        int numPoints = dataset.getItemCount(seriesIndex);
        for (int i = 0; i < numPoints; ++i) {
            double theta = dataset.getXValue(seriesIndex, i);
            double radius = dataset.getYValue(seriesIndex, i);
            Point p = plot.translateValueThetaRadiusToJava2D(theta, radius, dataArea);
            poly.addPoint(p.x, p.y);
        }
        g2.setPaint(this.lookupSeriesPaint(seriesIndex));
        g2.setStroke(this.lookupSeriesStroke(seriesIndex));
        if (this.isSeriesFilled(seriesIndex)) {
            g2.fill(poly);
        } else {
            g2.draw(poly);
        }
    }

    @Override
    public void drawAngularGridLines(Graphics2D g2, PolarPlot plot, List ticks, Rectangle2D dataArea) {
        g2.setFont(plot.getAngleLabelFont());
        g2.setStroke(plot.getAngleGridlineStroke());
        g2.setPaint(plot.getAngleGridlinePaint());
        double axisMin = plot.getAxis().getLowerBound();
        double maxRadius = plot.getMaxRadius();
        Point center = plot.translateValueThetaRadiusToJava2D(axisMin, axisMin, dataArea);
        for (NumberTick tick : ticks) {
            Point p = plot.translateValueThetaRadiusToJava2D(tick.getNumber().doubleValue(), maxRadius, dataArea);
            if (plot.isAngleGridlinesVisible()) {
                g2.setPaint(plot.getAngleGridlinePaint());
                g2.drawLine(center.x, center.y, p.x, p.y);
            }
            if (!plot.isAngleLabelsVisible()) continue;
            int x = p.x;
            int y = p.y;
            g2.setPaint(plot.getAngleLabelPaint());
            TextUtilities.drawAlignedString((String)tick.getText(), (Graphics2D)g2, (float)x, (float)y, (TextAnchor)TextAnchor.CENTER);
        }
    }

    @Override
    public void drawRadialGridLines(Graphics2D g2, PolarPlot plot, ValueAxis radialAxis, List ticks, Rectangle2D dataArea) {
        g2.setFont(radialAxis.getTickLabelFont());
        g2.setPaint(plot.getRadiusGridlinePaint());
        g2.setStroke(plot.getRadiusGridlineStroke());
        double axisMin = radialAxis.getLowerBound();
        Point center = plot.translateValueThetaRadiusToJava2D(axisMin, axisMin, dataArea);
        for (NumberTick tick : ticks) {
            Point p = plot.translateValueThetaRadiusToJava2D(90.0, tick.getNumber().doubleValue(), dataArea);
            int r = p.x - center.x;
            int upperLeftX = center.x - r;
            int upperLeftY = center.y - r;
            int d = 2 * r;
            Ellipse2D.Double ring = new Ellipse2D.Double(upperLeftX, upperLeftY, d, d);
            g2.setPaint(plot.getRadiusGridlinePaint());
            g2.draw(ring);
        }
    }

    @Override
    public LegendItem getLegendItem(int series) {
        XYDataset dataset;
        LegendItem result = null;
        PolarPlot polarPlot = this.getPlot();
        if (polarPlot != null && (dataset = polarPlot.getDataset()) != null) {
            String label;
            String description = label = dataset.getSeriesKey(series).toString();
            Shape shape = this.lookupSeriesShape(series);
            Paint paint = this.lookupSeriesPaint(series);
            Paint outlinePaint = this.lookupSeriesOutlinePaint(series);
            Stroke outlineStroke = this.lookupSeriesOutlineStroke(series);
            result = new LegendItem(label, description, null, null, shape, paint, outlineStroke, outlinePaint);
            result.setDataset(dataset);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultPolarItemRenderer)) {
            return false;
        }
        DefaultPolarItemRenderer that = (DefaultPolarItemRenderer)obj;
        if (!this.seriesFilled.equals((Object)that.seriesFilled)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultPolarItemRenderer clone = (DefaultPolarItemRenderer)super.clone();
        clone.seriesFilled = (BooleanList)this.seriesFilled.clone();
        return clone;
    }
}

