/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.plot;

import com.inet.jfree.chart.labels.StandardPieSectionLabelGenerator;
import com.inet.jfree.data.general.PieDataset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class PieLegendGenerator {
    public static final int FORMAT_TYPE_NONE = 0;
    public static final int FORMAT_TYPE_NUMBER = 1;
    public static final int FORMAT_TYPE_PERCENT = 2;
    public static final int FORMAT_TYPE_BOTH = 3;
    private StandardPieSectionLabelGenerator valueGenerator;
    private StandardPieSectionLabelGenerator numberGenerator;
    private StandardPieSectionLabelGenerator percentGenerator;
    private final int formatType;

    public PieLegendGenerator() {
        this(0, NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance());
    }

    public PieLegendGenerator(int formatType, NumberFormat numberFormat, NumberFormat percentFormat) {
        switch (formatType) {
            case 1: {
                this.numberGenerator = new StandardPieSectionLabelGenerator("{1}", numberFormat, percentFormat);
                break;
            }
            case 2: {
                this.percentGenerator = new StandardPieSectionLabelGenerator("{2}", numberFormat, percentFormat);
                break;
            }
            case 3: {
                this.numberGenerator = new StandardPieSectionLabelGenerator("{1}", numberFormat, percentFormat);
                this.percentGenerator = new StandardPieSectionLabelGenerator("{2}", numberFormat, percentFormat);
                break;
            }
        }
        this.formatType = formatType;
        this.valueGenerator = new StandardPieSectionLabelGenerator("{0}", numberFormat, percentFormat);
    }

    public List generateSectionLabels(PieDataset dataset, Comparable key) {
        ArrayList<String> labels = new ArrayList<String>(3);
        labels.add(this.valueGenerator.generateSectionLabel(dataset, key));
        if (this.formatType != 0) {
            if (this.formatType == 3) {
                labels.add(this.numberGenerator.generateSectionLabel(dataset, key));
                labels.add(this.percentGenerator.generateSectionLabel(dataset, key));
            } else if (this.formatType == 1) {
                labels.add(this.numberGenerator.generateSectionLabel(dataset, key));
            } else if (this.formatType == 2) {
                labels.add(this.percentGenerator.generateSectionLabel(dataset, key));
            }
        }
        return labels;
    }
}

