/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.panel;

import com.inet.jfree.chart.event.OverlayChangeEvent;
import com.inet.jfree.chart.event.OverlayChangeListener;
import javax.swing.event.EventListenerList;

public class AbstractOverlay {
    private transient EventListenerList changeListeners = new EventListenerList();

    public void addChangeListener(OverlayChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.changeListeners.add(OverlayChangeListener.class, listener);
    }

    public void removeChangeListener(OverlayChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.changeListeners.remove(OverlayChangeListener.class, listener);
    }

    public void fireOverlayChanged() {
        OverlayChangeEvent event = new OverlayChangeEvent(this);
        this.notifyListeners(event);
    }

    protected void notifyListeners(OverlayChangeEvent event) {
        Object[] listeners = this.changeListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != OverlayChangeListener.class) continue;
            ((OverlayChangeListener)listeners[i + 1]).overlayChanged(event);
        }
    }
}

