/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.InternalApi;
import com.inet.viewer.PromptValue;
import com.inet.viewer.h;
import com.inet.viewer.i18n.a;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

@InternalApi
public class RealtimeValidationPopup
implements ActionListener,
FocusListener,
DocumentListener,
PopupMenuListener {
    private JComponent bBC;
    private int bBw;
    private boolean bBD;
    private Timer bBE;
    private Popup bBF;
    private JLabel bBG;
    private JPanel bBH;
    private boolean bBI;
    private Point bBJ;
    private JComboBox bBK;
    private boolean bBL;
    private boolean bBM;
    private Class bBN;
    private Constructor bBO;
    private Class[] bBP = new Class[]{String.class};
    private Color bBQ;
    public static final Color POPUP_BGCOLOR_NORMAL = new Color(255, 255, 225);
    public static final Color POPUP_BGCOLOR_ERROR = new Color(1.0f, 0.7f, 0.7f);
    public static final Color POPUP_BGCOLOR_INCOMPLETE = new Color(255, 227, 119);
    public static final Color LAYOUT_ERROR_BACKGROUND = new Color(1.0f, 0.7f, 0.7f);
    private Format bBR;

    private RealtimeValidationPopup(int promptType) {
        this.bBw = promptType;
        this.bBG = new JLabel();
        this.bBH = new JPanel();
        this.bBH.setOpaque(true);
        this.bBH.add(this.bBG);
        this.bBH.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                RealtimeValidationPopup.this.hidePopup();
                e2.consume();
            }
        });
        this.bBH.setBorder(BorderFactory.createBevelBorder(0, Color.GRAY, Color.BLACK));
        this.bBE = new Timer(5000, this);
    }

    public RealtimeValidationPopup(JTextComponent textcomponent, JComboBox surroundingBox, int promptType, boolean isUSformatted) {
        this(promptType);
        this.initFormats();
        if (this.bBR == null) {
            return;
        }
        this.bBL = isUSformatted;
        textcomponent.getDocument().addDocumentListener(this);
        if (surroundingBox != null) {
            surroundingBox.addActionListener(this);
            surroundingBox.addPopupMenuListener(this);
            this.bBK = surroundingBox;
        }
        this.bBC = textcomponent;
        this.bBC.addFocusListener(this);
        this.bBQ = this.bBC.getBackground();
    }

    private void initFormats() {
        this.bBR = null;
        switch (this.bBw % 128) {
            case 6: 
            case 7: {
                this.bBR = this.bBL ? NumberFormat.getInstance(Locale.US) : PromptValue.NUMBERFORMAT;
                break;
            }
            case 9: {
                this.bBR = this.bBL ? DateFormat.getDateInstance(3, Locale.US) : PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                this.bBR = this.bBL ? DateFormat.getDateTimeInstance(3, 2, Locale.US) : PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                this.bBR = this.bBL ? DateFormat.getTimeInstance(2, Locale.US) : PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void NS() {
        if (this.bBC instanceof JPasswordField) {
            return;
        }
        Object object = this.getValue();
        String string = object.toString();
        if (!this.bBC.isEnabled() || !this.bBC.isShowing() || object.toString().length() == 0 || this.bBC instanceof JComboBox && ((JComboBox)this.bBC).isPopupVisible() || (this.bBw % 128 == 6 || this.bBw % 128 == 7) && string.equals("-")) {
            if (!this.bBC.isEnabled()) {
                this.bBC.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
            } else {
                this.bBC.setBackground(POPUP_BGCOLOR_NORMAL);
            }
            this.hidePopup();
            return;
        }
        try {
            Object object2;
            if (object instanceof PromptValue) {
                if (((PromptValue)object).isOnlyDescription()) {
                    this.hidePopup();
                    return;
                }
                object2 = ((PromptValue)object).getDescription();
                if (object2 != null && ((String)object2).length() > 0) {
                    string = ((PromptValue)object).getValueString();
                }
            }
            object2 = null;
            object2 = this.bBR.parseObject(string);
            String string2 = this.getFormatedText(object2);
            if (this.bBM && this.bBN != null) {
                if (this.bBN == Object.class) {
                    this.bBN = String.class;
                }
                this.bBO = this.bBN.getConstructor(this.bBP);
                this.bBO.newInstance(string);
            }
            this.bBD = false;
            if (string2.equals(string)) {
                this.hidePopup();
            } else {
                Point point = this.bBC.getLocationOnScreen();
                point.y += this.bBC.getHeight();
                this.a(string2, POPUP_BGCOLOR_NORMAL, point);
            }
            this.bBC.invalidate();
            this.bBC.setBackground(POPUP_BGCOLOR_NORMAL);
        }
        catch (Exception exception) {
            if (this.a(this.bBR, string)) {
                this.showIncompletePopup();
            }
            this.showErrorPopup();
        }
    }

    public String getFormatedText(Object parsedObject) {
        return this.bBR.format(parsedObject);
    }

    private boolean a(Format format, String string) {
        boolean bl2 = false;
        if (format instanceof h) {
            format = ((h)format).MP();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            String string2 = simpleDateFormat.toPattern();
            SimpleDateFormat simpleDateFormat2 = null;
            String string3 = string2;
            block2: for (int i2 = 1; i2 <= string2.length(); ++i2) {
                for (int i3 = 0; i3 <= string2.length() - i2; ++i3) {
                    string3 = string2.substring(i3, i3 + i2);
                    simpleDateFormat2 = new SimpleDateFormat(string3);
                    try {
                        Date date = simpleDateFormat2.parse(string);
                        String string4 = simpleDateFormat2.format(date);
                        String string5 = string.replaceAll("0", "");
                        String string6 = string4.replaceAll("0", "");
                        if (!string.equals(string4) && !string5.equals(string4) && !string.equals(string6) && !string5.equals(string6)) continue;
                        bl2 = true;
                        continue block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return bl2;
    }

    public void showErrorPopup() {
        Point point = this.bBC.getLocationOnScreen();
        point.y += this.bBC.getHeight();
        this.bBD = true;
        Object object = a.getMsg("prompt.invalid_input");
        object = (String)object + this.NT();
        this.a((String)object, POPUP_BGCOLOR_ERROR, point);
        this.bBC.setBackground(LAYOUT_ERROR_BACKGROUND);
        this.bBC.invalidate();
    }

    public void showIncompletePopup() {
        Point point = this.bBC.getLocationOnScreen();
        point.y += this.bBC.getHeight();
        this.bBD = true;
        Object object = a.getMsg("prompt.incomplete_input");
        object = (String)object + this.NT();
        this.a((String)object, POPUP_BGCOLOR_INCOMPLETE, point);
        this.bBC.setBackground(POPUP_BGCOLOR_INCOMPLETE);
        this.bBC.invalidate();
    }

    private String NT() {
        Format format = switch (this.bBw) {
            case 9 -> PromptValue.DATEFORMAT;
            case 15 -> PromptValue.DATETIMEFORMAT;
            case 10 -> PromptValue.TIMEFORMAT;
            default -> null;
        };
        if (format instanceof SimpleDateFormat) {
            return a.getMsg("prompt.format_must_be", ((SimpleDateFormat)format).toPattern());
        }
        if (this.bBw == 6 || this.bBw == 7) {
            return a.getMsg("prompt.expected_number");
        }
        return "";
    }

    private void a(String string, Color color, Point point) {
        string = this.dW(string);
        this.bBG.setText(string);
        this.bBH.setBackground(color);
        if (!this.bBI) {
            this.bBJ = point;
        } else {
            point = this.bBJ;
        }
        if (this.bBF != null) {
            this.hidePopup();
        }
        this.bBF = PopupFactory.getSharedInstance().getPopup(this.bBC, this.bBH, point.x, point.y);
        this.bBF.show();
        this.bBI = true;
        if (this.bBE.isRunning()) {
            this.bBE.restart();
        } else {
            this.bBE.start();
        }
    }

    private String dW(String object) {
        object = this.bBD ? "<html>" + (String)object + "</html>" : a.getMsg("prompt.interpreted_as", object);
        return object;
    }

    private Object getValue() {
        if (this.bBC instanceof JPasswordField) {
            return new String(((JPasswordField)this.bBC).getPassword());
        }
        if (this.bBC instanceof JTextComponent) {
            String string;
            String string2 = ((JTextComponent)this.bBC).getText();
            if (this.bBK == null) {
                return string2;
            }
            Object object = this.bBK.getSelectedItem();
            if (this.bBC != null && this.bBK.isEditable() && object != null && !(string = object.toString()).equals(string2)) {
                return string2;
            }
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (this.bBC instanceof JComboBox) {
            return ((JComboBox)this.bBC).getSelectedItem();
        }
        return null;
    }

    public void hidePopup() {
        if (this.bBF != null) {
            this.bBF.hide();
        }
        this.bBI = false;
        if (this.bBE.isRunning()) {
            this.bBE.stop();
        }
    }

    public void setCheckClassType(boolean checkClassType, Class classtype) {
        this.bBM = checkClassType;
        this.bBN = classtype;
    }

    public void setPromptType(int promptType) {
        this.bBw = promptType;
        this.initFormats();
    }

    public void unregister() {
        if (this.bBC == null) {
            return;
        }
        if (this.bBC instanceof JTextField) {
            ((JTextField)this.bBC).getDocument().removeDocumentListener(this);
        } else if (this.bBC instanceof JComboBox) {
            ((JComboBox)this.bBC).removeActionListener(this);
            ((JComboBox)this.bBC).removePopupMenuListener(this);
        }
        this.bBC.removeFocusListener(this);
        if (this.bBK != null) {
            this.bBK.removeActionListener(this);
            this.bBK.removePopupMenuListener(this);
        }
        this.bBC.setBackground(this.bBQ);
    }

    public boolean isPopupError() {
        return this.bBD;
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
        this.NS();
    }

    @Override
    public void insertUpdate(DocumentEvent e2) {
        this.NS();
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        this.NS();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() instanceof JComboBox) {
            this.NS();
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.NS();
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.hidePopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        this.hidePopup();
    }

    public void setFormat(Format format) {
        this.bBR = format;
    }
}

