/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.Progress;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.i18n.a;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.annotation.SuppressFBWarnings;

@PublicApi
public class ExportProgress
extends Progress {
    private RenderData byt;
    private final RenderData byu;
    private Properties hr;
    private byte[] byv;
    private int byw;
    private int byx;
    private ArrayList<String> byy;

    public ExportProgress(ReportView parent, RenderData data, Properties exportProps) {
        super(parent, 2);
        this.setIndeterminate(true);
        this.setStatusMessage(null, false);
        this.byu = data;
        this.hr = exportProps;
    }

    ExportProgress(Component parent, ViewerContext viewerContext, RenderData data, Properties exportProps) {
        super(parent, viewerContext, 2);
        this.setStatusMessage(null, false);
        this.byu = data;
        this.hr = exportProps;
    }

    private void setStatusMessage(String message, boolean isError) {
        ReportView reportView = this.getReportView();
        if (reportView != null) {
            reportView.getReportViewer().getViewerContext().showStatusMessage(reportView, message, isError);
        }
    }

    @Override
    public final String getName() {
        return "Export Progress";
    }

    @Override
    public void cancel() {
        this.MO().stop();
        this.setStatus(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only used on client side")
    public void run() {
        this.byy = new ArrayList();
        try {
            File file;
            RenderData renderData = this.MO();
            String string = this.hr.getProperty("export_fmt");
            int n2 = renderData.getExportChunkCount(this.hr);
            this.setIndeterminate(false);
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            this.setTotalProgress(n2);
            String string2 = this.hr.getProperty("file");
            if (string.startsWith("htm")) {
                file = this.W(string, string2);
            } else if (string.startsWith("svg")) {
                file = this.W(string, string2);
            } else if (string.equals("jpg") || string.equals("gif") || string.equals("png") || string.equals("bmp")) {
                file = this.y(string2, n2);
            } else {
                byte[] byArray;
                file = new File(string2);
                this.byy.add(file.getPath());
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                for (int i2 = 1; i2 <= n2 && (byArray = renderData.getNextExportChunk()) != null; ++i2) {
                    fileOutputStream.write(byArray);
                    this.setProgress(i2);
                }
                fileOutputStream.close();
            }
            this.setStatusMessage(a.getMsg("export.finished"), false);
            this.setStatus(2);
            if (this.hr.getProperty("exportInApplication", "false").equals("true") && file != null) {
                this.h(file);
            }
        }
        catch (Throwable throwable) {
            ViewerUtils.printStackTrace(throwable);
            if (this.getStatus() == 3) {
                ViewerUtils.log("Export: Export canceled by user");
                this.setStatusMessage(a.getMsg("export.canceled"), false);
            } else {
                this.showError(throwable);
                this.setStatusMessage(a.getMsg("export.failed"), true);
                this.setStatus(4);
            }
        }
        finally {
            this.NL();
        }
    }

    public ArrayList<String> getFileNames() {
        return this.byy;
    }

    private final void h(File file) {
        try {
            if (ViewerUtils.useDesktopMethod("open", file)) {
                return;
            }
            ViewerUtils.showDocumentOldMethod(file);
        }
        catch (Throwable throwable) {
            this.showError(new ViewerException(a.getMsg("export.inApplicationFailed"), throwable));
        }
    }

    private int g(byte[] byArray, int n2) {
        return (byArray[n2 + 0] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8) + ((byArray[n2 + 2] & 0xFF) << 16) + (byArray[n2 + 3] << 24);
    }

    private boolean G(int n2, boolean bl2) throws ViewerException {
        int n3 = this.byx - this.byw;
        if (n3 < n2) {
            byte[] byArray = this.MO().getNextExportChunk();
            this.setProgress(this.getProgress() + 1);
            if (byArray == null) {
                if (bl2) {
                    throw new ViewerException(a.getMsg("error.export.unexpected_end"));
                }
                return false;
            }
            if (this.byv == null) {
                this.byv = byArray;
                this.byw = 0;
                this.byx = byArray.length;
            } else {
                if (this.byv.length - n3 < byArray.length) {
                    byte[] byArray2 = new byte[n3 + byArray.length];
                    System.arraycopy(this.byv, this.byw, byArray2, 0, n3);
                    this.byv = byArray2;
                } else {
                    System.arraycopy(this.byv, this.byw, this.byv, 0, n3);
                }
                this.byw = 0;
                this.byx = n3;
                System.arraycopy(byArray, 0, this.byv, this.byx, byArray.length);
                this.byx += byArray.length;
            }
        }
        return true;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_OUT"}, justification="Caller must check it")
    private File W(String string, String object) throws IOException {
        this.byw = 0;
        File file = null;
        String string2 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        while (this.byx > this.byw || this.getTotalProgress() > this.getProgress()) {
            int n2;
            FileOutputStream fileOutputStream;
            this.G(4, true);
            int n3 = this.g(this.byv, this.byw);
            if (n3 == -1) break;
            if (n3 > 512) {
                throw new ViewerException(0, a.getMsg("error.export.data_wrong"), string, null, null, null, 0, new String(this.byv, 0, this.byx));
            }
            this.byw += 4;
            this.G(n3, true);
            Object object2 = new String(this.byv, this.byw, n3, "UTF8");
            if (!bl3) {
                var11_11 = this.hr.getProperty("layout");
                if (var11_11 == null) {
                    if (!((String)object).substring(((String)object).lastIndexOf(46)).equals(((String)object2).substring(((String)object2).lastIndexOf(46)))) {
                        object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(46)) + ((String)object).substring(((String)object).lastIndexOf(46));
                    }
                    object = ((String)object).substring(0, ((String)object).lastIndexOf(47) + 1) + (String)object2;
                }
                file = new File((String)object);
                file.getParentFile().mkdirs();
                this.byy.add(file.getPath());
                fileOutputStream = new FileOutputStream(file);
                string2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(46));
                bl3 = true;
            } else {
                StringBuffer stringBuffer = new StringBuffer(((String)object).substring(0, ((String)object).lastIndexOf(47) + 1));
                stringBuffer.append(string2);
                if (!bl2) {
                    this.dQ(stringBuffer.toString());
                    bl2 = true;
                }
                stringBuffer.append('/');
                stringBuffer.append((String)object2);
                var11_11 = stringBuffer.toString();
                this.byy.add(var11_11);
                fileOutputStream = new FileOutputStream(var11_11);
            }
            this.byw += n3;
            this.G(4, true);
            this.byw += 4;
            for (n3 = this.g(this.byv, this.byw); n3 > 0; n3 -= n2) {
                this.G(1, true);
                n2 = Math.min(this.byx - this.byw, n3);
                fileOutputStream.write(this.byv, this.byw, n2);
                this.byw += n2;
            }
            fileOutputStream.close();
        }
        return file;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    private File y(String object, int n2) throws IOException {
        Object object2;
        RenderData renderData = this.MO();
        byte[] byArray = renderData.getNextExportChunk();
        if (byArray.length > 2 && byArray[0] == 80 && byArray[1] == 75 && !((String)object).endsWith(".zip")) {
            object2 = (String)object + ".zip";
            if (new File((String)object2).exists()) {
                int n3 = 1;
                while (new File((String)(object2 = (String)object + "(" + n3++ + ").zip")).exists()) {
                }
            }
            object = object2;
        }
        object2 = new File((String)object);
        this.byy.add(((File)object2).getPath());
        FileOutputStream fileOutputStream = new FileOutputStream((File)object2);
        for (int i2 = 1; i2 <= n2 && byArray != null; ++i2) {
            ((OutputStream)fileOutputStream).write(byArray);
            this.setProgress(1);
            if (i2 >= n2) break;
            byArray = renderData.getNextExportChunk();
        }
        ((OutputStream)fileOutputStream).close();
        return object2;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    private void dQ(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            if (!file.delete()) {
                throw new RuntimeException("\n" + a.getMsg("error.export.cannot_delete") + " " + string);
            }
            file.mkdirs();
        }
    }

    private synchronized RenderData MO() {
        if (this.byt == null) {
            this.byt = this.byu.getCopy();
        }
        return this.byt;
    }
}

