/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.summary;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.report.BaseUtils;
import com.inet.report.Field;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SummaryField;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.rowsource.l;
import com.inet.report.rowsource.m;
import com.inet.report.summary.IAggregatorRunner;
import com.inet.report.summary.Store;
import com.inet.report.summary.aa;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class Aggregator
implements aa {
    private static final ConfigValue<Integer> btq = new ConfigValue(ConfigKey.COMPATIBILITY_LEVEL);
    private final IAggregatorRunner btr;
    private Map<SummaryField, a> bts = new HashMap<SummaryField, a>();
    private static Comparator<Object> btt = new m();
    private final int btu;

    public Aggregator(IAggregatorRunner runner, int rows) {
        this.btr = runner;
        this.btu = rows;
    }

    public void init() {
        for (a a2 : this.bts.values()) {
            a2.init();
        }
    }

    public void reset() {
        for (a a2 : this.bts.values()) {
            a2.reset();
        }
    }

    public void addSummaryField(SummaryField field, int groupChange, int groupReset) throws ReportException {
        if (field == null || field.getField() == null || !field.isUsed()) {
            return;
        }
        a a2 = a.a(field, this, groupChange, groupReset, this.btu);
        this.bts.put(field, a2);
    }

    Object p(Field field) throws ReportException {
        if (field instanceof PromptField) {
            PromptField promptField = (PromptField)field;
            if (promptField.getAllowMultipleValues()) {
                Object[] objectArray = (Object[])promptField.getValue();
                return objectArray[this.btr.getRowPosition() - 1];
            }
            return promptField.getValue();
        }
        return this.btr.getFieldValueByField(false, field);
    }

    @Override
    public void recalculate(int groupChange) throws ReportException, l {
        if (this.btr.isEngineStopped()) {
            throw new l();
        }
        for (a a2 : this.bts.values()) {
            if (!a2.vh()) continue;
            a2.recalculate(groupChange);
        }
    }

    @Override
    public void done(int row) {
        for (a a2 : this.bts.values()) {
            a2.done(row);
        }
    }

    public int size() {
        return this.bts.size();
    }

    public Map<SummaryField, Store> getResults() {
        HashMap<SummaryField, Store> hashMap = new HashMap<SummaryField, Store>(this.bts.size());
        for (a a2 : this.bts.values()) {
            hashMap.put(a2.btv, a2.btw);
        }
        return hashMap;
    }

    private int getRowPosition() {
        return this.btr.getRowPosition() - 1;
    }

    public Store getSummaryResult(SummaryField field) throws ReportException {
        a a2 = this.bts.get(field);
        if (a2 != null) {
            Store store = a2.Ml();
            if (store != null) {
                return store;
            }
            this.btr.runSummary(a2);
            return a2.Ml();
        }
        return null;
    }

    private static abstract class com.inet.report.summary.Aggregator$a
    implements aa {
        private SummaryField btv;
        Store btw;
        com.inet.report.summary.b btx;
        private com.inet.report.summary.a bty;
        private com.inet.report.summary.a btz;
        Field btA;
        Field btB;
        Aggregator btC;
        private a btD = a.btE;

        private com.inet.report.summary.Aggregator$a() {
        }

        public static com.inet.report.summary.Aggregator$a a(SummaryField summaryField, Aggregator aggregator, int n2, int n3, int n4) throws ReportException {
            com.inet.report.summary.Aggregator$a a2;
            if (summaryField.getRunningTotal()) {
                a2 = new d();
                a2.bty = com.inet.report.summary.a.a(aggregator, summaryField.getChangeField(), n2);
                a2.btz = com.inet.report.summary.a.a(aggregator, summaryField.getResetField(), n3);
            } else if (summaryField.getChangeField() != null || summaryField.getGroup() != null) {
                a2 = new b();
                a2.btz = com.inet.report.summary.a.a(aggregator, summaryField.getChangeField(), n2);
            } else {
                a2 = new c();
            }
            a2.btC = aggregator;
            a2.btv = summaryField;
            a2.btA = summaryField.getField();
            a2.btB = summaryField.getField2nd();
            a2.btx = com.inet.report.summary.b.a(summaryField.getSummaryOperation(), summaryField.getSummaryNth(), n4, !summaryField.getRunningTotal(), false, btt);
            boolean bl2 = (Integer)btq.get() <= 8;
            a2.btw = Store.a(summaryField, n4, bl2 ? a2.btx.Mp() : null);
            if (BaseUtils.isParanoid()) {
                BaseUtils.paranoid("### Created Summary State Machine for field '" + summaryField.getName() + "' ###");
                BaseUtils.paranoid("State type is   : " + a2.getClass().getSimpleName());
                BaseUtils.paranoid("ResetEvaluator  : " + String.valueOf(a2.btz));
                BaseUtils.paranoid("ChangeEvaluator : " + String.valueOf(a2.bty));
                BaseUtils.paranoid("Using Store type: " + (a2.btw != null ? a2.btw.getClass().getSimpleName() : null));
                BaseUtils.paranoid("Function type is: " + (a2.btx != null ? a2.btx.getClass().getSimpleName() : null));
            }
            a2.btw.addValue(a2.btx.Mo(), 0);
            return a2;
        }

        public void reset() {
            this.btD = a.btE;
            this.btw.reset();
        }

        @Override
        public void done(int rowID) {
            this.btD = a.btG;
        }

        public void init() {
            if (this.btD == a.btE) {
                this.btD = a.btF;
            }
        }

        public boolean vh() {
            return this.btD == a.btF;
        }

        public Store Ml() throws ReportException {
            if (this.btD == a.btE) {
                return null;
            }
            if (this.btD == a.btF) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.ReadOnSummaryInCaluclation, new Object[0]);
            }
            return this.btw;
        }

        @Override
        public abstract void recalculate(int var1) throws ReportException;

        public boolean jb(int n2) throws ReportException {
            return this.btz != null && this.btz.jd(n2);
        }

        public boolean jc(int n2) throws ReportException {
            return this.bty != null && !this.bty.jd(n2);
        }

        static final class a
        extends Enum<a> {
            public static final /* enum */ a btE = new a();
            public static final /* enum */ a btF = new a();
            public static final /* enum */ a btG = new a();
            private static final /* synthetic */ a[] btH;

            public static a[] values() {
                return (a[])btH.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private static /* synthetic */ a[] Mm() {
                return new a[]{btE, btF, btG};
            }

            static {
                btH = a.Mm();
            }
        }
    }

    private static class c
    extends a {
        private c() {
        }

        @Override
        public void recalculate(int groupChange) throws ReportException {
            this.btx.H(this.btC.p(this.btA), this.btB != null ? this.btC.p(this.btB) : null);
        }

        @Override
        public void done(int rowID) {
            super.done(rowID);
            this.btw.addValue(this.btx.Mo(), rowID);
            this.btx.reset();
        }
    }

    private static class b
    extends a {
        private int btI = 0;

        private b() {
        }

        @Override
        public void recalculate(int groupChange) throws ReportException {
            if (this.jb(groupChange)) {
                this.btw.addValue(this.btx.Mo(), this.btI);
                this.btx.reset();
                this.btI = this.btC.getRowPosition();
            }
            this.btx.H(this.btC.p(this.btA), this.btB != null ? this.btC.p(this.btB) : null);
        }

        @Override
        public void done(int rowID) {
            super.done(rowID);
            if (rowID != this.btI) {
                this.btw.addValue(this.btx.Mo(), this.btI);
            }
            this.btx.reset();
        }

        @Override
        public void reset() {
            super.reset();
            this.btI = 0;
        }
    }

    private static class d
    extends a {
        private d() {
        }

        @Override
        public void recalculate(int groupChange) throws ReportException {
            boolean bl2 = false;
            if (this.jb(groupChange)) {
                this.btx.reset();
                bl2 = true;
            }
            if (this.jc(groupChange)) {
                if (bl2) {
                    this.btw.addValue(this.btx.Mo(), this.btC.getRowPosition());
                }
                return;
            }
            this.btx.H(this.btC.p(this.btA), this.btB != null ? this.btC.p(this.btB) : null);
            this.btw.addValue(this.btx.Mo(), this.btC.getRowPosition());
        }

        @Override
        public void done(int rowID) {
            super.done(rowID);
            this.btw.addValue(this.btx.Mo(), rowID);
            this.btx.reset();
        }
    }
}

