/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.pdf;

import com.inet.http.utils.MimeTypes;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.renderer.doc.AbstractDocumentWriter;
import com.inet.report.renderer.doc.DocumentMetaData;
import com.inet.report.renderer.doc.Layout;
import com.inet.report.renderer.doc.WriterCapabilities;
import com.inet.report.renderer.pdf.PDFConfig;
import com.inet.report.renderer.pdf.e;
import com.inet.report.renderer.pdf.h;
import com.inet.report.renderer.pdf.i;
import com.inet.report.renderer.pdf.k;
import com.inet.report.renderer.pdf.model.ai;
import com.inet.report.renderer.pdf.model.al;
import com.inet.report.renderer.pdf.model.ar;
import com.inet.report.renderer.pdf.model.m;
import com.inet.report.renderer.pdf.model.o;
import com.inet.report.renderer.pdf.model.r;
import com.inet.report.renderer.pdf.model.structure.g;
import com.inet.report.renderer.pdf.sec.a;
import com.inet.report.renderer.pdf.sec.b;
import com.inet.report.renderer.pdf.sec.f;
import com.inet.shared.utils.MemoryStream;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;

public class PDFDocumentWriter
extends AbstractDocumentWriter {
    public static final String NAVIGATION = "navview";
    public static final String NAVIGATION_OUTLINES = "bookmarks";
    public static final String NAVIGATION_THUMBNAILS = "pages";
    public static final String OWNER_PASS = "opass";
    public static final String USER_PASS = "upass";
    public static final String ALG_TYPE = "algtype";
    public static final String ENCRYPT_METADATA = "encryptmeta";
    public static final String USERPROP_PDFA = "pdfa";
    public static final String USERPROP_PDFFASTWEBVIEW = "fastwebview";
    public static final String PDF_STRUCTURE_TREE = "pdftags";
    private boolean aUG = false;
    private boolean aUH;
    private boolean aUI;
    private Date IS;
    private boolean aUJ;
    private MemoryStream CR = null;
    private e aUK;
    private m aTH;
    private i aUL;
    private k aUM;
    private int aUN;
    private h aUO;
    private Properties JH;
    private al aUP;

    public PDFDocumentWriter(PDFConfig config) {
        this.aUK = new e(config);
        this.aTH = this.aUK.Fz();
        this.aUL = new i(this.aUK, this.aTH);
        this.aUM = new k(this.aTH.GG(), this.aUL, this.aTH.GJ().isReplaceMissingChars());
    }

    @Override
    public Layout getLayout() {
        return this.aUL;
    }

    @Override
    public WriterCapabilities getCapabilities() {
        return this.aUM;
    }

    @Override
    public void setUserProperties(Properties props) {
        super.setUserProperties(props);
        this.JH = props;
        boolean bl2 = this.aTH.GJ().isCreateStructure();
        this.k(props);
        if (props != null) {
            String string;
            boolean bl3 = "true".equalsIgnoreCase(props.getProperty(USERPROP_PDFFASTWEBVIEW, "false"));
            this.aTH.GJ().setLinear(bl3);
            if (bl3) {
                this.aUO = new h(this.aTH);
            }
            if ("true".equals(string = props.getProperty(PDF_STRUCTURE_TREE))) {
                bl2 = true;
            } else if ("false".equals(string)) {
                bl2 = false;
            }
        }
        if (bl2) {
            g g2 = new g(this.aTH);
            this.aTH.a(g2);
            this.aUL.a(g2);
        }
    }

    @Override
    public void setMetaData(DocumentMetaData metaData) {
        super.setMetaData(metaData);
        this.aUK.setMetaData(metaData);
        this.aUH = metaData.isClipboardEnabled();
        this.aUJ = metaData.isGroupTreeVisible();
        this.aUI = metaData.isPrintingEnabled();
        this.IS = metaData.getPrintTime();
        this.FD();
        if (this.JH == null) {
            return;
        }
        if (metaData.getProperty("facturx-level") != null) {
            this.aTH.GJ().setPdfa3(true);
        } else {
            String string = this.JH.getProperty(USERPROP_PDFA, "false");
            if ("true".equalsIgnoreCase(string)) {
                if (this.aUG) {
                    BaseUtils.error("Documents which are encrypted or constraint the access to their content can not be exported in PDF/A format");
                } else {
                    this.aTH.GJ().setPDFA(true);
                }
            }
        }
    }

    @Override
    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) throws ReportException {
        super.setPageLayout(width, height, landscape, topMargin, leftMargin, bottomMargin, rightMargin);
        this.aUK.C(width, height, topMargin, leftMargin);
    }

    @Override
    public void startDocument() throws ReportException {
        super.startDocument();
        this.aUK.start();
        this.aUN = 0;
        g g2 = this.aTH.GK();
        if (g2 != null) {
            this.aUK.FA().a(g2.Il());
            DocumentMetaData documentMetaData = this.getMetaData();
            if (documentMetaData != null) {
                Locale locale = documentMetaData.getResourceLocale();
                String string = locale.toString();
                this.aUK.FA().cW(string);
            }
        }
    }

    @Override
    public void startPage() throws ReportException {
        boolean bl2;
        super.startPage();
        boolean bl3 = bl2 = this.CR == null;
        if (!bl2) {
            this.bX(false);
        }
        this.aUP = this.aUL.FN();
        this.CR = new MemoryStream();
        if (this.aUO != null) {
            this.aUO.a(this.aUP);
        } else if (bl2) {
            this.aUK.X(this.CR);
        }
    }

    @Override
    public void endPage() throws ReportException {
        super.endPage();
    }

    private void bX(boolean bl2) throws ReportException {
        if (bl2) {
            this.aUL.FQ();
        }
        this.aUL.endPage();
        if (this.aUO == null) {
            this.aUK.c(this.CR, this.getPages().getPageCount() + 1, this.aUN);
            byte[] byArray = this.CR.toByteArray();
            this.getPages().addPage(byArray);
            this.aUN += byArray.length;
            this.aUP.dispose();
        }
        this.CR = null;
    }

    @Override
    public void endDocument() throws ReportException {
        Object object;
        int n2;
        super.endDocument();
        if (this.CR != null) {
            this.bX(true);
        }
        if (this.aUO != null) {
            n2 = this.aUO.a(this.aUK, this.getPages());
        } else {
            object = new MemoryStream();
            this.aUK.Y((MemoryStream)object);
            byte[] byArray = object.toByteArray();
            this.getPages().addPage(byArray);
            n2 = this.aUN + byArray.length;
        }
        object = this.aUL.FP();
        if (object != null) {
            ((ar)object).a(this.getPages(), n2);
        }
    }

    private void FD() {
        String string;
        boolean bl2 = true;
        if (this.JH != null && (string = this.JH.getProperty(ENCRYPT_METADATA, "true")) != null && string.equalsIgnoreCase("false")) {
            bl2 = false;
        }
        int n2 = a.k(this.aUH, this.aUI);
        String[] stringArray = a.l(this.JH);
        if (stringArray[0] == null) {
            if (!this.aUH || !this.aUI) {
                this.aUG = true;
                stringArray[0] = "DEFAULT_ALG";
            }
        } else {
            this.aUG = true;
        }
        if (this.aUG) {
            byte[] byArray = a.f(this.IS.getTime());
            b b2 = f.a(stringArray[0], stringArray[1], stringArray[2], n2, bl2, this.IS, byArray);
            this.aUK.a(b2, byArray);
        }
    }

    private void k(Properties properties) {
        if (properties != null) {
            String string = properties.getProperty(NAVIGATION, "");
            if (NAVIGATION_OUTLINES.equals(string) || NAVIGATION_THUMBNAILS.equals(string)) {
                BaseUtils.info("PDF Export navigation type: " + string);
                this.aUK.cM(string);
            }
        } else if (BaseUtils.isDebug()) {
            BaseUtils.debug("pdf export: user properties not defined");
        }
    }

    @Override
    public void addAttchment(@Nonnull String fileName, byte @Nonnull [] data) {
        if (!this.aUK.Fz().GJ().isPDFA()) {
            com.inet.report.renderer.pdf.model.k k2 = this.aUK.FA();
            ai ai2 = k2.GE();
            if (ai2 == null) {
                ai2 = new ai(this.aTH);
            }
            String string = MimeTypes.getMimeType((String)fileName).split(";")[0];
            o o2 = new o(this.aTH, data, string, this.IS);
            r r2 = new r(this.aTH, o2, fileName, null);
            ai2.a(r2);
            k2.a(ai2);
        }
    }
}

