/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationMigrator;
import com.inet.config.recovery.RecoveryLauncher;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.http.PluginServlet;
import com.inet.http.RootServletProvider;
import com.inet.http.error.ServletErrorHandlerProvider;
import com.inet.logging.CoreLoggers;
import com.inet.logging.LogManager;
import com.inet.permissions.Permission;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.CoreServerPlugin;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.ConfigHelpProvider;
import com.inet.plugin.help.HelpPage;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.report.StandaloneConfiguration;
import com.inet.report.d;
import com.inet.report.encode.DecoderFactory;
import com.inet.report.permissions.PermissionChecker;
import com.inet.report.plugins.a;
import com.inet.report.plugins.b;
import com.inet.report.plugins.drive.c;
import com.inet.report.plugins.structure.ClearReportsStructureProvider;
import com.inet.report.plugins.structure.ReportingStructureProvider;
import com.inet.report.servlets.ReportPluginServlet;
import com.inet.report.util.RenderDataUtils;
import com.inet.report.util.j;
import com.inet.report.webapi.ReportingWebAPIExtension;
import com.inet.repository.RepositoryResourceParser;
import com.inet.usersandgroups.UsersAndGroups;
import java.net.URL;
import javax.annotation.Nonnull;

@PluginInfo(id="reporting", version="24.10.545", packages="com.inet.report;com.inet.viewer;com.inet.problemfinder;com.inet.report.webapi;com.inet.chart3d", group="reporting;system", flags="core;designer;helpdesk;pdfc", internal="jfreechartCC.jar;jcommon.jar", dependencies="htmlengine", optionalDependencies="webapi.core;repository;theme;drive", icon="com/inet/report/images/crlogo.png")
@InternalApi
public class ReportingServerPlugin
implements CoreServerPlugin,
ServerPlugin {
    public static final String PLUGIN_ID = "reporting";
    public static final I18nMessages MSG = new I18nMessages("com.inet.report.i18n.LanguageResources", ReportingServerPlugin.class);
    private c awF;

    public void preInit(ServerPluginDescription spd) {
        d.aj();
        ConfigurationManager.getInstance().addConfigurationMigrator((ConfigurationMigrator)new b());
    }

    private static boolean vb() {
        String string = ServerPluginManager.getInstance().getCorePluginId();
        return string == null || !string.startsWith("pdfc");
    }

    private static boolean vc() {
        String string = ServerPluginManager.getInstance().getCorePluginId();
        return PLUGIN_ID.equals(string) || string != null && string.equals("designer");
    }

    public void registerHelp(HelpProviderContainer container) {
        boolean bl2 = ReportingServerPlugin.vc();
        if (bl2) {
            container.add((HelpProvider)new HelpProviderImpl("documentation", 4001, new Permission[]{null}){}, new String[0]);
        }
        if (ReportingServerPlugin.vb()) {
            if (ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager")) {
                container.add((HelpProvider)new HelpProviderImpl("usersandgroups", 9210, new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER}){}, new String[0]);
            }
            container.add((HelpProvider)new HelpProviderImpl("javaviewer", 9371, new Permission[]{bl2 ? (Permission)null : Permission.CONFIGURATION}){}, new String[0]);
            container.add((HelpProvider)new ConfigHelpProvider("configuration", 4050, new Permission[]{bl2 ? (Permission)null : Permission.CONFIGURATION}){

                public boolean isVisible(HelpPage helpPage) {
                    if (AbstractStructureProvider.isDesigner() && helpPage.getKey().equalsIgnoreCase("security")) {
                        return false;
                    }
                    return super.isVisible(helpPage);
                }
            }, new String[0]);
            container.add((HelpProvider)new HelpProviderImpl("webapi", 9203, new Permission[]{Permission.valueOfExistingOrCreate((String)"webapi.core")}){}, new String[]{"webapi.core"});
            container.add((HelpProvider)new HelpProviderImpl("drive", 9204, new Permission[]{Permission.valueOfExistingOrCreate((String)"drive")}){}, new String[]{"drive"});
        }
    }

    public void registerExtension(final ServerPluginManager spm) {
        if (ReportingServerPlugin.vc()) {
            CoreLoggers.addLoggers((String[])new String[]{"Reporting", "Config", "Designer", "Task Planner", "Statistics", "Remotegui", "Cache"});
            spm.register(ApplicationDescription.class, (Object)this.getApplicationDescription());
            spm.register(ConfigStructureProvider.class, (Object)new ClearReportsStructureProvider());
            if (spm.isPluginLoaded("remotegui")) {
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.addMessages(new I18nMessages("com.inet.report.plugins.i18n.LanguageResources", (Object)this));
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "remotegui.lib.js", combinedFile));
            }
            com.inet.report.plugins.theme.a.f(spm);
        }
        DecoderFactory.registerDefaultDecoders(spm);
        if (ServerPluginManager.IS_SERVLET_API) {
            this.a(spm);
        }
        if (ReportingServerPlugin.vb()) {
            spm.register(ConfigStructureProvider.class, (Object)new ReportingStructureProvider());
            if (spm.isPluginLoaded("theme")) {
                try {
                    com.inet.report.util.theme.b.f(spm);
                }
                catch (Throwable throwable) {
                    LogManager.getConfigLogger().warn((Object)"Theme resources not registered for htmlviewer.");
                    LogManager.getConfigLogger().warn((Object)throwable);
                }
            }
            RenderDataUtils.registerViewerScriptExtensions(spm);
            spm.runIfPluginLoaded("webapi.core", () -> new Executable(){

                public void execute() {
                    spm.register(WebAPIExtension.class, (Object)new ReportingWebAPIExtension());
                }
            });
            spm.runIfPluginLoaded("repository", () -> new Executable(){

                public void execute() {
                    spm.register(RepositoryResourceParser.class, (Object)new com.inet.report.repository.a());
                }
            });
            spm.runIfPluginLoaded("drive", () -> new Executable(){

                public void execute() {
                    ReportingServerPlugin.this.awF = new c();
                    ReportingServerPlugin.this.awF.registerExtension(spm);
                }
            });
        }
        spm.register(ServletErrorHandlerProvider.class, (Object)new j());
    }

    private void a(final ServerPluginManager serverPluginManager) {
        if (ReportingServerPlugin.vb()) {
            ReportPluginServlet reportPluginServlet = new ReportPluginServlet();
            serverPluginManager.register(PluginServlet.class, (Object)reportPluginServlet);
            serverPluginManager.register(RootServletProvider.class, (Object)new com.inet.report.servlets.d(reportPluginServlet));
        }
        serverPluginManager.register(PluginServlet.class, (Object)new com.inet.report.jsonrpc.a());
        serverPluginManager.runIfPluginLoaded("drive", () -> new Executable(){

            public void execute() {
                serverPluginManager.register(PluginServlet.class, (Object)new com.inet.report.servlets.a());
            }
        });
    }

    public void init(ServerPluginManager spm) {
        if (this.awF != null) {
            this.awF.init(spm);
            this.awF = null;
        }
        PermissionChecker.getInstance();
    }

    public void reset() {
    }

    public void restart() {
    }

    @Nonnull
    public RecoveryLauncher getRecoveryLauncher() {
        return new StandaloneConfiguration();
    }

    public ApplicationDescription getApplicationDescription() {
        return new a();
    }
}

