/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.list;

import com.inet.annotations.InternalApi;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseField;
import com.inet.report.Field;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

@InternalApi
public final class DatabaseFieldList
implements Externalizable,
Cloneable {
    private boolean avY = false;
    private DatabaseField[] avZ;
    private int MS;
    private int awa;

    public DatabaseFieldList() {
        this(10);
    }

    public DatabaseFieldList(Vector v2) {
        this(v2.size());
        v2.copyInto(this.avZ);
        this.MS = v2.size();
    }

    public DatabaseFieldList(DatabaseFieldList o2) {
        this(o2.size());
        System.arraycopy(o2.avZ, 0, this.avZ, 0, o2.MS);
        this.MS = o2.MS;
    }

    public DatabaseFieldList(int capacity) {
        this(capacity, 0);
    }

    public DatabaseFieldList(int capacity, int capacityIncrement) {
        this.avZ = new DatabaseField[capacity];
        this.awa = capacityIncrement;
    }

    public void setAllowDuplicatedEntries(boolean allow) {
        this.avY = allow;
    }

    public final DatabaseField elementAt(int idx) {
        if (idx < this.MS) {
            return this.avZ[idx];
        }
        throw new ArrayIndexOutOfBoundsException(idx);
    }

    public final void setCapacity(int capacity) {
        if (capacity < this.MS) {
            this.MS = capacity;
        }
        if (capacity != this.avZ.length) {
            DatabaseField[] databaseFieldArray = new DatabaseField[capacity];
            System.arraycopy(this.avZ, 0, databaseFieldArray, 0, this.MS);
            this.avZ = databaseFieldArray;
        }
    }

    private final void en(int n2) {
        int n3 = this.avZ.length;
        if (n2 > n3) {
            if (this.awa > 0) {
                while ((n3 += this.awa) < n2) {
                }
            } else {
                if (n3 == 0) {
                    n3 = 1;
                }
                while ((n3 = 2 * n3) < n2) {
                }
            }
        } else if (n3 > 100000 && n3 > 2 * n2) {
            n3 = this.awa > 0 ? n2 + this.awa : n2 * 2;
        }
        int n4 = n3;
        if (n4 != this.avZ.length) {
            this.setCapacity(n4);
        }
    }

    public final void addElement(DatabaseField o2) {
        if (o2 == null) {
            throw new NullPointerException();
        }
        if (this.indexOf(o2) == -1 || this.avY) {
            if (this.MS >= this.avZ.length) {
                this.en(this.MS + 1);
            }
            this.avZ[this.MS] = o2;
            ++this.MS;
        }
    }

    public final void insertElementAt(DatabaseField o2, int index) {
        if (o2 == null) {
            throw new NullPointerException();
        }
        if (index > this.MS) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.en(this.MS + 1);
        System.arraycopy(this.avZ, index, this.avZ, index + 1, this.MS - index);
        this.avZ[index] = o2;
        ++this.MS;
    }

    public final DatabaseField removeElementAt(int idx) {
        DatabaseField databaseField = this.avZ[idx];
        if (idx < this.MS - 1) {
            System.arraycopy(this.avZ, idx + 1, this.avZ, idx, this.MS - idx - 1);
        }
        this.avZ[--this.MS] = null;
        return databaseField;
    }

    public final int size() {
        return this.MS;
    }

    public final void setSize(int size) {
        for (int i2 = size; i2 < this.MS; ++i2) {
            this.avZ[i2] = null;
        }
        this.en(size);
        this.MS = size;
    }

    public final void clear() {
        this.setSize(0);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.MS);
        for (int i2 = 0; i2 < this.MS; ++i2) {
            out.writeObject(this.avZ[i2]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.MS = in.readInt();
        if (this.avZ.length < this.MS) {
            this.avZ = new DatabaseField[this.MS];
        }
        for (int i2 = 0; i2 < this.MS; ++i2) {
            this.avZ[i2] = (DatabaseField)in.readObject();
        }
    }

    public final int indexOf(DatabaseField o2) {
        if (o2 == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.avZ.length; ++i2) {
            if (this.avZ[i2] != o2) continue;
            return i2;
        }
        return this.indexOf(o2.getName());
    }

    public final int indexOf(String fieldName) {
        if (fieldName == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.avZ.length; ++i2) {
            if (!fieldName.equalsIgnoreCase(this.avZ[i2] != null ? this.avZ[i2].getName() : null)) continue;
            return i2;
        }
        return -1;
    }

    public final int indexOfShortName(String fieldName) {
        if (fieldName == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.avZ.length; ++i2) {
            if (!fieldName.equalsIgnoreCase(this.avZ[i2] != null ? this.avZ[i2].getShortName() : null)) continue;
            return i2;
        }
        return -1;
    }

    public final void removeElement(DatabaseField o2) {
        int n2 = this.indexOf(o2);
        if (n2 < 0) {
            return;
        }
        this.removeElementAt(n2);
    }

    public final Vector toVector() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(this.MS);
        for (int i2 = 0; i2 < this.MS; ++i2) {
            vector.addElement(this.avZ[i2]);
        }
        return vector;
    }

    public final boolean contains(DatabaseField o2) {
        return this.indexOf(o2) >= 0;
    }

    public final boolean contains(String fieldName) {
        return this.indexOf(fieldName) >= 0;
    }

    public final DatabaseField get(String fieldName) {
        int n2 = this.indexOf(fieldName);
        return n2 >= 0 ? this.elementAt(n2) : null;
    }

    public final DatabaseField[] toArray() {
        return this.toArray(new DatabaseField[this.MS]);
    }

    public final List<Field> toFieldList() {
        ArrayList<Field> arrayList = new ArrayList<Field>(this.MS);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            arrayList.add(this.elementAt(i2));
        }
        return arrayList;
    }

    public final DatabaseField[] toArray(DatabaseField[] o2) {
        if (o2 == null || o2.length != this.MS) {
            o2 = new DatabaseField[this.MS];
        }
        System.arraycopy(this.avZ, 0, o2, 0, this.MS);
        return o2;
    }

    public final void copyInto(DatabaseField[] o2) {
        if (o2 == null || o2.length != this.MS) {
            throw new RuntimeException();
        }
        System.arraycopy(this.avZ, 0, o2, 0, this.MS);
    }

    public final void addAll(DatabaseFieldList o2) {
        this.en(this.MS + o2.MS);
        for (int i2 = 0; i2 < o2.size(); ++i2) {
            this.addElement(o2.elementAt(i2));
        }
    }

    public final void addAll(DatabaseField[] o2) {
        if (o2 == null) {
            return;
        }
        this.en(this.MS + o2.length);
        for (int i2 = 0; i2 < o2.length; ++i2) {
            this.addElement(o2[i2]);
        }
    }

    public final void setElementAt(DatabaseField o2, int index) {
        if (index >= this.MS) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.avZ[index] = o2;
    }

    public final DatabaseField lastElement() {
        return this.avZ[this.MS - 1];
    }

    public final Object clone() {
        DatabaseFieldList databaseFieldList = null;
        try {
            databaseFieldList = (DatabaseFieldList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
        databaseFieldList.avZ = new DatabaseField[this.avZ.length];
        System.arraycopy(this.avZ, 0, databaseFieldList.avZ, 0, this.MS);
        return databaseFieldList;
    }

    public final boolean isEmpty() {
        return this.MS == 0;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i2 = 0; i2 < this.MS; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(this.avZ[i2]);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public final Object getObjectAt(int i2) {
        return this.elementAt(i2);
    }

    public void log() {
        if (BaseUtils.isDebug()) {
            try {
                for (int i2 = 0; i2 < this.size(); ++i2) {
                    DatabaseField databaseField = this.elementAt(i2);
                    int n2 = databaseField.getValueType();
                    String string = databaseField.getShortName();
                    String string2 = databaseField.getName();
                    String string3 = string;
                    if (string2 != null) {
                        string3 = string2;
                    }
                    BaseUtils.debug("FieldList Column: " + i2 + " name: " + string3 + " type: " + n2);
                }
            }
            catch (Throwable throwable) {
                BaseUtils.info(throwable);
            }
        }
    }
}

