/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula.parser;

import com.inet.report.ReportException;
import com.inet.report.formula.FormulaException;
import com.inet.report.formula.parser.Token;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FormulaParserException
extends FormulaException
implements Iterable<ReportException> {
    private Token aoF;
    private boolean aoG = false;
    private ArrayList<ReportException> aoH;
    private String aoI;

    private FormulaParserException(String msg, int messageId, Token token, boolean insertMarker) {
        super(msg + (String)(token != null ? " Line:" + (token.getRow() + 1) + " Column:" + (token.si() + 1) : ""), messageId);
        this.aoF = token;
        this.aoG = insertMarker;
        this.aoI = msg;
    }

    public static FormulaParserException create(ReportErrorCode reportErrorCode, boolean insertMarker, Token token, Object ... msgParameter) {
        String string = Msg.getMsg(reportErrorCode.name(), msgParameter);
        int n2 = reportErrorCode.getErrorCodeNumber();
        return new FormulaParserException(string, n2, token, insertMarker);
    }

    public static FormulaParserException create(ReportException e2, Token errorToken) {
        if (e2 instanceof FormulaParserException) {
            FormulaParserException formulaParserException = (FormulaParserException)e2;
            if (formulaParserException.getToken() == null) {
                FormulaParserException formulaParserException2 = new FormulaParserException(formulaParserException.aoI, formulaParserException.getErrorCode(), errorToken, formulaParserException.aoG);
                formulaParserException2.initCause(e2);
                e2 = formulaParserException2;
            }
            return (FormulaParserException)e2;
        }
        if (e2.getErrorCode() == 0) {
            return FormulaParserException.create(e2.getMessage(), false, errorToken, 0);
        }
        return FormulaParserException.create(e2.getMessage(), false, errorToken, e2.getErrorCode());
    }

    public static FormulaParserException create(String message, boolean insertMarker, Token token, int id) {
        if (token != null) {
            message = (String)message + " Token:" + token.sj() + " Line:" + token.getRow() + " Col:" + token.si() + " starts at char nr.:" + token.bW();
        }
        return new FormulaParserException((String)message, id, token, insertMarker);
    }

    public void addRecoverableException(ReportException exception) {
        if (exception != null) {
            if (this.aoH == null) {
                this.aoH = new ArrayList();
            }
            this.aoH.add(exception);
        }
    }

    public void addRecoverableExceptionList(List<ReportException> exceptionList) {
        if (exceptionList != null && exceptionList.size() > 0) {
            if (this.aoH == null) {
                this.aoH = new ArrayList();
            }
            this.aoH.addAll(exceptionList);
        }
    }

    public int countInnerExceptions() {
        if (this.aoH != null) {
            return this.aoH.size();
        }
        return 0;
    }

    @Override
    public Iterator<ReportException> iterator() {
        if (this.aoH != null) {
            return this.aoH.iterator();
        }
        return new ArrayList().iterator();
    }

    public Token getToken() {
        return this.aoF;
    }

    public void setToken(Token token) {
        this.aoF = token;
    }

    @Override
    public int getRow() {
        if (this.aoF != null) {
            return this.aoF.getPosition().getLine();
        }
        return super.getRow();
    }

    @Override
    public int getColumn() {
        if (this.aoF != null) {
            return this.aoF.getPosition().getColumn();
        }
        return super.getColumn();
    }

    @Override
    public int getEndRow() {
        if (this.aoF != null) {
            if (this.aoG) {
                return this.aoF.getRow();
            }
            return this.aoF.getPosition().qe();
        }
        return super.getEndRow();
    }

    @Override
    public int getEndColumn() {
        if (this.aoF != null) {
            if (this.aoG) {
                return this.aoF.si();
            }
            return this.aoF.getPosition().getEndColumn();
        }
        return super.getEndColumn();
    }

    @Override
    public int getStartIndex() {
        if (this.aoF != null) {
            return this.aoF.bW();
        }
        return super.getStartIndex();
    }

    @Override
    public int getLength() {
        if (this.aoF != null) {
            if (this.aoG) {
                return 0;
            }
            return this.aoF.getLength();
        }
        return super.getLength();
    }

    @Override
    protected void pT() {
        this.aoF = null;
    }
}

