/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula.debug;

import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FormulaRange;
import com.inet.report.ReportException;
import com.inet.report.SpecialField;
import com.inet.report.bg;
import com.inet.report.formula.Evaluable;
import com.inet.report.formula.a;
import com.inet.report.formula.ast.o;
import com.inet.report.formula.ast.x;
import com.inet.report.formula.ast.y;
import com.inet.report.formula.b;
import com.inet.report.formula.d;
import com.inet.report.formula.debug.FormulaContext;
import com.inet.report.formula.g;
import com.inet.report.formula.j;
import com.inet.report.formula.n;
import com.inet.report.formula.number.c;
import com.inet.report.formula.q;
import com.inet.report.formula.userfunctions.UserFunction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DebugReferences
implements Serializable {
    public static final String ENGINE_META_KEY = "ReferencesTable";
    public static final Object REFERENCE_NOT_SET = new Object();
    private transient d ani;
    private transient Map<ReferencesChangeListener, Object> anj;
    private Map<String, FormulaReference> ank = new HashMap<String, FormulaReference>();
    private Engine anl;

    public DebugReferences(Engine e2) {
        this.anl = e2;
    }

    public void addChangeListener(ReferencesChangeListener listener) {
        if (this.anj == null) {
            this.anj = new WeakHashMap<ReferencesChangeListener, Object>();
        }
        this.anj.put(listener, new Object());
    }

    public void removeChangeListener(ReferencesChangeListener listener) {
        if (this.anj == null) {
            return;
        }
        this.anj.remove(listener);
    }

    private void aM(boolean bl2) {
        if (this.anj == null) {
            return;
        }
        for (ReferencesChangeListener referencesChangeListener : this.anj.keySet()) {
            if (bl2) {
                referencesChangeListener.structureChanged();
                continue;
            }
            referencesChangeListener.valueChanged();
        }
    }

    private d getFormula() {
        if (this.ani == null) {
            this.ani = bg.getFormula(this.anl);
        }
        return this.ani;
    }

    public void update(FormulaContext formula) {
        for (FormulaReference formulaReference : this.ank.values()) {
            formulaReference.anp = false;
        }
        if (formula == null) {
            return;
        }
        try {
            b b2 = this.getFormula().a(formula.getFormula(), formula.isBasic(), formula.getFormulaType(), formula.getNullType(), formula.getDefaultAttribute(), formula.getCurrentField());
            b2.S(true);
            b2.a(formula.getSource());
            if (formula.getSource().isOptimized()) {
                formula.getSource().setFormulaTree(null);
                b2.pn();
                b2.aG(false);
            }
            this.a(b2, formula.getName(), b2.getFormulaTree());
        }
        catch (ReportException reportException) {
            // empty catch block
        }
    }

    protected void a(j j2, String string, Evaluable evaluable) throws ReportException {
        Object object;
        Serializable serializable;
        Object object2;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (evaluable == null) {
            return;
        }
        a<o> a2 = new a<o>(evaluable, o.class);
        boolean bl2 = false;
        while (a2.hasNext()) {
            object2 = a2.oZ();
            if (hashSet.contains(object2)) continue;
            boolean bl3 = object2 instanceof y && ((y)object2).getScope() == 0 || object2 instanceof n;
            bl2 |= this.a((o)object2, bl3, string, j2);
            hashSet.add(object2);
        }
        if (j2 == null || j2.pt()) {
            object2 = new a<n>(evaluable, n.class);
            while (((a)object2).hasNext()) {
                n n2 = (n)((a)object2).oZ();
                if (hashSet.contains(n2)) continue;
                bl2 |= this.a(n2, true, string, j2);
                hashSet.add(n2);
            }
        }
        object2 = new a<com.inet.report.formula.ast.j>(evaluable, com.inet.report.formula.ast.j.class);
        while (((a)object2).hasNext()) {
            com.inet.report.formula.ast.j j3 = ((a)object2).oZ();
            if (!(j3.qy() instanceof Field)) {
                j3.getValueType(j2);
            }
            if (hashSet.contains(serializable = (Field)j3.qy())) continue;
            object = this.m((Field)serializable);
            bl2 |= this.a((Set<Object>)hashSet, (Field)serializable, (String)object);
        }
        a<com.inet.report.formula.ast.n> a3 = new a<com.inet.report.formula.ast.n>(evaluable, com.inet.report.formula.ast.n.class);
        while (a3.hasNext()) {
            serializable = a3.oZ();
            object = this.a((com.inet.report.formula.ast.n)serializable);
            if (object == null || hashSet.contains(object)) continue;
            String string2 = this.m((Field)object);
            bl2 |= this.a(hashSet, (Field)object, string2);
        }
        this.aM(bl2);
    }

    private boolean a(Set<Object> set, Field field, String string) {
        boolean bl2;
        FormulaReference formulaReference = this.ank.get(string);
        boolean bl3 = bl2 = formulaReference == null;
        if (formulaReference != null) {
            Object object = formulaReference.c(null);
            int n2 = formulaReference.getValueType();
            formulaReference.n(field);
            if (formulaReference.valueType == n2 && object != formulaReference.value && object != REFERENCE_NOT_SET) {
                formulaReference.a(object, null);
            }
        } else {
            formulaReference = new FormulaReference();
            formulaReference.n(field);
        }
        formulaReference.anp = true;
        this.ank.put(string, formulaReference);
        set.add(field);
        return bl2;
    }

    void a(x x2, String string, j j2) {
        block4: {
            UserFunction userFunction = j2.pf();
            this.update(userFunction != null ? new FormulaContext(userFunction) : null);
            try {
                this.a(j2, string, ((b)j2).getFormulaTree());
                if (userFunction != null) {
                    this.a(j2, string, userFunction.getFormulaTree());
                }
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isDebug()) break block4;
                BaseUtils.debug(reportException);
            }
        }
        boolean bl2 = false;
        for (x.a a2 : x2.rx()) {
            this.ank.remove(this.a(a2.qj(), true, string));
            bl2 |= this.a(a2.qj(), true, string, j2);
        }
        this.aM(bl2);
    }

    private boolean a(o o2, boolean bl2, String string, j j2) {
        boolean bl3;
        FormulaReference formulaReference;
        String string2;
        block6: {
            string2 = this.a(o2, bl2, string);
            formulaReference = this.ank.get(string2);
            boolean bl4 = bl3 = formulaReference == null;
            if (formulaReference != null) {
                Object object = formulaReference.c(j2);
                boolean bl5 = formulaReference.PR;
                int n2 = formulaReference.getValueType();
                formulaReference.a(o2, j2);
                if (formulaReference.valueType == n2 && bl5) {
                    formulaReference.a(object, j2);
                }
            } else {
                formulaReference = new FormulaReference();
                formulaReference.a(o2, j2);
                if (bl2 && !(o2 instanceof n)) {
                    try {
                        o2.b(j2);
                    }
                    catch (ReportException reportException) {
                        if (!BaseUtils.isDebug()) break block6;
                        BaseUtils.debug(reportException);
                    }
                }
            }
        }
        formulaReference.anp = true;
        this.ank.put(string2, formulaReference);
        return bl3;
    }

    private Field a(com.inet.report.formula.ast.n n2) {
        int n3 = n2.rj();
        try {
            switch (n3) {
                case 1228: {
                    return this.anl.getFields().getSpecialField(6);
                }
                case 1235: {
                    return this.anl.getFields().getSpecialField(18);
                }
                case 1227: {
                    return this.anl.getFields().getSpecialField(17);
                }
                case 1225: {
                    return this.anl.getFields().getSpecialField(7);
                }
                case 1229: {
                    return this.anl.getFields().getSpecialField(8);
                }
                case 1226: {
                    return this.anl.getFields().getSpecialField(9);
                }
                case 1244: {
                    return this.anl.getFields().getSpecialField(4);
                }
                case 1245: {
                    return this.anl.getFields().getSpecialField(5);
                }
                case 1231: {
                    return this.anl.getFields().getSpecialField(13);
                }
                case 1242: {
                    return this.anl.getFields().getSpecialField(2);
                }
                case 1243: {
                    return this.anl.getFields().getSpecialField(3);
                }
                case 1240: {
                    return this.anl.getFields().getSpecialField(0);
                }
                case 1241: {
                    return this.anl.getFields().getSpecialField(1);
                }
                case 1230: {
                    return this.anl.getFields().getSpecialField(12);
                }
                case 1249: {
                    return this.anl.getFields().getSpecialField(15);
                }
                case 1247: {
                    return this.anl.getFields().getSpecialField(11);
                }
                case 1250: {
                    return this.anl.getFields().getSpecialField(16);
                }
                case 1248: {
                    return this.anl.getFields().getSpecialField(14);
                }
                case 1246: {
                    return this.anl.getFields().getSpecialField(10);
                }
            }
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        return null;
    }

    public List<FormulaReference> getReferences() {
        ArrayList<FormulaReference> arrayList = new ArrayList<FormulaReference>(this.ank.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    public FormulaReference getReferenceFor(Evaluable node, String formulaName) {
        Field field;
        if (node instanceof n) {
            return this.ank.get(this.a((n)node, true, formulaName));
        }
        if (node instanceof y) {
            y y2;
            return this.ank.get(this.a(y2, (y2 = (y)node).getScope() == 0, formulaName));
        }
        if (node instanceof com.inet.report.formula.ast.j) {
            return this.ank.get(this.m((Field)((com.inet.report.formula.ast.j)node).qy()));
        }
        if (node instanceof com.inet.report.formula.ast.n && (field = this.a((com.inet.report.formula.ast.n)node)) != null) {
            return this.ank.get(this.m(field));
        }
        return null;
    }

    private String m(Field field) {
        return (switch (field.getType()) {
            case 13 -> REFERENCE_TYPE.formula;
            case 12 -> REFERENCE_TYPE.group;
            case 16 -> REFERENCE_TYPE.prompt;
            case 11 -> REFERENCE_TYPE.summary;
            case 17 -> REFERENCE_TYPE.sqlField;
            case 10 -> REFERENCE_TYPE.special;
            default -> REFERENCE_TYPE.databaseField;
        }).name() + "_##_" + field.getName();
    }

    private String a(o o2, boolean bl2, String string) {
        if (bl2) {
            return String.valueOf((Object)REFERENCE_TYPE.variable) + "_##_" + string + "_##_" + o2.getName();
        }
        return String.valueOf((Object)REFERENCE_TYPE.variable) + "_##_" + o2.getName();
    }

    public static String getValueTypeString(int type) {
        StringBuilder stringBuilder = new StringBuilder();
        if (type == -1) {
            return "UNKNOWN";
        }
        switch (type & 0x7F) {
            case 6: {
                stringBuilder.append("NUMBER");
                break;
            }
            case 7: {
                stringBuilder.append("CURRENCY");
                break;
            }
            case 8: {
                stringBuilder.append("BOOLEAN");
                break;
            }
            case 9: {
                stringBuilder.append("DATE");
                break;
            }
            case 10: {
                stringBuilder.append("TIME");
                break;
            }
            case 11: {
                stringBuilder.append("STRING");
                break;
            }
            case 14: {
                stringBuilder.append("BINARY");
                break;
            }
            case 15: {
                stringBuilder.append("DATETIME");
                break;
            }
            case -10: {
                stringBuilder.append("CURSOR");
                break;
            }
            default: {
                stringBuilder.append("UNKNOWN");
            }
        }
        if ((type & 0x100) != 0) {
            stringBuilder.append(", ARRAY");
        }
        if ((type & 0x80) != 0) {
            stringBuilder.append(", RANGE");
        }
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.defaultWriteObject();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, FormulaReference> entry : this.ank.entrySet()) {
            if (!entry.getValue().anp) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(entry.getValue().getName()).append(" = ").append(entry.getKey());
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : "No active references";
    }

    public static interface ReferencesChangeListener {
        public void valueChanged();

        public void structureChanged();
    }

    public class FormulaReference
    implements Serializable,
    Comparable<FormulaReference> {
        private REFERENCE_TYPE anm;
        private int valueType;
        private int ann;
        private String name;
        private Object value;
        private o ano;
        private boolean anp = true;
        private boolean PR = false;

        private void a(o o2, j j2) {
            this.anm = REFERENCE_TYPE.variable;
            this.valueType = o2.getValueType(j2);
            this.name = o2.getName();
            this.ano = o2;
            this.c(j2);
        }

        private void n(Field field) {
            switch (field.getType()) {
                case 14: {
                    this.anm = REFERENCE_TYPE.databaseField;
                    break;
                }
                case 13: {
                    this.anm = REFERENCE_TYPE.formula;
                    break;
                }
                case 12: {
                    this.anm = REFERENCE_TYPE.group;
                    break;
                }
                case 16: {
                    this.anm = REFERENCE_TYPE.prompt;
                    break;
                }
                case 11: {
                    this.anm = REFERENCE_TYPE.summary;
                    break;
                }
                case 17: {
                    this.anm = REFERENCE_TYPE.sqlField;
                    break;
                }
                case 10: {
                    this.anm = REFERENCE_TYPE.special;
                    this.ann = ((SpecialField)field).getSpecialType();
                }
            }
            this.valueType = field.getValueType();
            this.name = field.getName();
            this.PR = false;
            this.value = (this.valueType & 0x180) != 0 ? new Object[]{new FormulaRange(this.dr(this.valueType), this.dr(this.valueType))} : ((this.valueType & 0x80) != 0 ? new FormulaRange(this.dr(this.valueType), this.dr(this.valueType)) : ((this.valueType & 0x100) != 0 ? new Object[]{this.dr(this.valueType)} : this.dr(this.valueType)));
        }

        private Object dr(int n2) {
            switch (this.valueType & 0x7F) {
                case 8: {
                    return Boolean.TRUE;
                }
                case 14: {
                    return new byte[0];
                }
                case 7: {
                    return c.b(0.0, true);
                }
                case 9: {
                    return new java.util.Date();
                }
                case 15: {
                    return new Timestamp(0L);
                }
                case 6: {
                    return c.b(0.0, false);
                }
                case 1024: {
                    return null;
                }
                case 11: {
                    return "";
                }
                case 10: {
                    return new Date(new java.util.Date().getTime());
                }
            }
            return null;
        }

        public int getValueType() {
            return this.valueType;
        }

        public int getSpecialType() {
            return this.ann;
        }

        public String getValueTypeString() {
            return DebugReferences.getValueTypeString(this.valueType);
        }

        public String getName() {
            return this.name;
        }

        public REFERENCE_TYPE getRefType() {
            return this.anm;
        }

        @Override
        public int compareTo(FormulaReference o2) {
            if (o2.anp != this.anp) {
                return -Boolean.compare(this.anp, o2.anp);
            }
            int n2 = Integer.compare(this.anm.ordinal(), o2.anm.ordinal());
            if (n2 != 0) {
                return n2;
            }
            return this.name.compareTo(o2.name);
        }

        public Object getValue() {
            return this.PR ? this.c(null) : null;
        }

        Object c(j j2) {
            if (this.ano instanceof y) {
                this.value = this.ano.c(j2);
            } else {
                if (j2 == null || this.getRefType() != REFERENCE_TYPE.variable) {
                    return this.PR ? this.value : REFERENCE_NOT_SET;
                }
                if (!this.PR) {
                    q q2 = j2.getLocalVariables();
                    if (q2 == null) {
                        return this.PR ? this.value : null;
                    }
                    y y2 = (y)q2.get(this.ano.getName());
                    if (y2 != null) {
                        this.value = y2.c(j2);
                        this.PR = true;
                    }
                }
            }
            return this.PR ? this.value : REFERENCE_NOT_SET;
        }

        public void setValue(Object value) {
            this.a(value, null);
        }

        void a(Object object, j j2) {
            this.PR = true;
            if (this.ano instanceof y) {
                this.ano.a(object, null);
            } else {
                this.value = object;
                if (j2 == null || this.getRefType() != REFERENCE_TYPE.variable) {
                    return;
                }
                q q2 = j2.getLocalVariables();
                if (q2 == null) {
                    return;
                }
                y y2 = (y)q2.get(this.ano.getName());
                if (y2 != null) {
                    y2.a(object, j2);
                }
            }
        }

        public boolean isUsed() {
            return this.anp;
        }

        public int hashCode() {
            return this.name.hashCode() + this.anm.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FormulaReference)) {
                return false;
            }
            return this.compareTo((FormulaReference)obj) == 0;
        }

        public void parseValue(String value) throws ReportException {
            int n2;
            this.PR = true;
            if (((String)value).length() == 0) {
                this.value = null;
                return;
            }
            int n3 = n2 = this.getValueType();
            switch (n3) {
                case 11: {
                    if (((String)value).startsWith("'") && ((String)value).endsWith("'") && ((String)value).length() >= 2) break;
                    value = "'" + ((String)value).replace("'", "''") + "'";
                    break;
                }
                case 9: 
                case 10: 
                case 15: {
                    value = ((String)value).trim().toLowerCase();
                    if (((String)value).startsWith("#") || ((String)value).startsWith("date") || ((String)value).startsWith("time")) break;
                    value = "#" + (String)value + "#";
                }
            }
            g g2 = DebugReferences.this.getFormula().a((String)value, false, 0, null, null);
            g2.pn();
            int n4 = g2.aG(false);
            if (n4 != n2 && (n2 != 9 || n4 != 15)) {
                BaseUtils.error("Invalid Valuetype! Cannot use formula '" + (String)value + "' as a " + d.getValueTypeString(n2));
            } else {
                this.a(g2.pl(), null);
            }
        }

        public String toString() {
            return "Ref to " + String.valueOf((Object)this.getRefType()) + " \"" + this.getName() + "\", " + (this.isUsed() ? "used" : "unused") + ", value = " + String.valueOf(this.getValue());
        }

        public void reset() {
            this.PR = false;
        }
    }

    public static final class REFERENCE_TYPE
    extends Enum<REFERENCE_TYPE> {
        public static final /* enum */ REFERENCE_TYPE variable = new REFERENCE_TYPE();
        public static final /* enum */ REFERENCE_TYPE databaseField = new REFERENCE_TYPE();
        public static final /* enum */ REFERENCE_TYPE formula = new REFERENCE_TYPE();
        public static final /* enum */ REFERENCE_TYPE group = new REFERENCE_TYPE();
        public static final /* enum */ REFERENCE_TYPE prompt = new REFERENCE_TYPE();
        public static final /* enum */ REFERENCE_TYPE summary = new REFERENCE_TYPE();
        public static final /* enum */ REFERENCE_TYPE sqlField = new REFERENCE_TYPE();
        public static final /* enum */ REFERENCE_TYPE special = new REFERENCE_TYPE();
        private static final /* synthetic */ REFERENCE_TYPE[] anr;

        public static REFERENCE_TYPE[] values() {
            return (REFERENCE_TYPE[])anr.clone();
        }

        public static REFERENCE_TYPE valueOf(String name) {
            return Enum.valueOf(REFERENCE_TYPE.class, name);
        }

        private static /* synthetic */ REFERENCE_TYPE[] rE() {
            return new REFERENCE_TYPE[]{variable, databaseField, formula, group, prompt, summary, sqlField, special};
        }

        static {
            anr = REFERENCE_TYPE.rE();
        }
    }
}

