/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.encode;

import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.report.encode.AbstractDecoder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class GifJpegDecoder
extends AbstractDecoder {
    private double agb = 1.0;
    private double agc = 1.0;
    private String[] agd;

    public GifJpegDecoder() {
    }

    public GifJpegDecoder(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage decodeImage(int w2, int h2) throws IOException {
        BufferedImage bufferedImage;
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream((InputStream)new FastByteArrayInputStream(this.buffer, this.offset, this.length));
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(memoryCacheImageInputStream);
        if (!iterator.hasNext()) {
            return null;
        }
        ImageReader imageReader = iterator.next();
        ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
        imageReader.setInput(memoryCacheImageInputStream, true, true);
        try {
            bufferedImage = imageReader.read(0, imageReadParam);
            this.agd = imageReader.getOriginatingProvider().getFormatNames();
        }
        finally {
            imageReader.dispose();
            memoryCacheImageInputStream.close();
        }
        return bufferedImage;
    }

    @Override
    public double getResolutionScaleX() {
        return this.agb;
    }

    @Override
    public double getResolutionScaleY() {
        return this.agc;
    }

    @Override
    public boolean useOriginal(@Nonnull String exportFormat) {
        if (this.agd != null) {
            String[] stringArray = this.agd;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string;
                switch (string = stringArray[i2]) {
                    case "jpeg": 
                    case "png": 
                    case "gif": {
                        return true;
                    }
                    case "jpeg2000": {
                        return "pdf".equals(exportFormat);
                    }
                }
            }
        }
        return false;
    }

    @Override
    @Nullable
    public String getFormat() {
        String[] stringArray = this.agd;
        return stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
    }
}

