/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database.base;

import com.inet.classloader.LoaderUtils;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseAccess;
import com.inet.report.DatabaseCSV;
import com.inet.report.DatabaseCloudscape;
import com.inet.report.DatabaseDB2;
import com.inet.report.DatabaseExcel;
import com.inet.report.DatabaseHSQL;
import com.inet.report.DatabaseInformix;
import com.inet.report.DatabaseInterbase;
import com.inet.report.DatabaseMariaDB;
import com.inet.report.DatabaseMysql;
import com.inet.report.DatabaseOpenEdge;
import com.inet.report.DatabaseOracle;
import com.inet.report.DatabasePostgreSql;
import com.inet.report.DatabaseSAPDB;
import com.inet.report.DatabaseSmallSQL;
import com.inet.report.DatabaseSqlServer;
import com.inet.report.DatabaseSunopsis;
import com.inet.report.DatabaseSybase;
import com.inet.report.DatabaseVersant;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.config.datasource.DataSourceConfiguration;
import java.sql.Connection;
import java.sql.SQLException;

public class DatabaseFactory {
    private static DatabaseFactory abU = null;

    public static DatabaseFactory getInstance() {
        if (abU == null) {
            abU = DatabaseFactory.mS();
        }
        return abU;
    }

    private static DatabaseFactory mS() {
        DatabaseFactory databaseFactory;
        String string = System.getProperty("extension.databaseFactory");
        if (string == null) {
            return new DatabaseFactory();
        }
        try {
            databaseFactory = (DatabaseFactory)LoaderUtils.classForName((String)string, DatabaseFactory.class).newInstance();
        }
        catch (Exception exception) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("Could not load databaseFactory : " + string);
                BaseUtils.debug(exception);
            }
            databaseFactory = new DatabaseFactory();
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("Using databaseFactory: " + databaseFactory.getClass().getName());
        }
        return databaseFactory;
    }

    public Database createDatabaseClass(Datasource datasource) throws ReportException {
        Database database;
        block12: {
            Object object;
            block11: {
                DataSourceConfiguration dataSourceConfiguration = datasource.getDataSourceConfiguration();
                if (dataSourceConfiguration != null && (object = dataSourceConfiguration.getDatabaseClassname()) != null && ((String)object).trim().length() != 0) {
                    try {
                        return (Database)LoaderUtils.classForName((String)object, (Object)this).newInstance();
                    }
                    catch (Exception exception) {
                        if (!BaseUtils.isDebug()) break block11;
                        BaseUtils.debug("Could not load database class: " + (String)object);
                        BaseUtils.debug(exception);
                    }
                }
            }
            object = datasource.getConnection();
            try {
                database = this.createDatabaseClass((Connection)object);
                if (object == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
                }
            }
            object.close();
        }
        return database;
    }

    public Database createDatabaseClass(Connection con) {
        String string;
        Database database;
        block46: {
            database = null;
            string = "unknown database";
            try {
                block45: {
                    try {
                        string = con.getMetaData().getDatabaseProductName();
                    }
                    catch (Throwable throwable) {
                        if (!BaseUtils.isDebug()) break block45;
                        BaseUtils.debug("DatabaseMetaData did not return info about database product name, caused by: " + throwable.toString());
                    }
                }
                string = string.toLowerCase();
                if (string.contains("oracle") && string.contains("xml")) {
                    database = new DatabaseSunopsis();
                } else if (string.startsWith("oracle")) {
                    database = new DatabaseOracle();
                } else if (string.startsWith("informix")) {
                    database = new DatabaseInformix();
                } else if (string.startsWith("mysql")) {
                    database = new DatabaseMysql();
                } else if (string.equals("mariadb")) {
                    database = new DatabaseMariaDB();
                } else if (string.startsWith("access")) {
                    database = new DatabaseAccess();
                } else if (string.startsWith("versant")) {
                    database = new DatabaseVersant();
                } else if (string.startsWith("microsoft sql server")) {
                    database = new DatabaseSqlServer();
                } else if (string.startsWith("adaptive server") || string.startsWith("sql server") || string.startsWith("sybase")) {
                    database = new DatabaseSybase();
                } else if (string.startsWith("sap db")) {
                    database = new DatabaseSAPDB();
                } else if (string.startsWith("db2") || string.startsWith("qdb2")) {
                    database = new DatabaseDB2();
                } else if (string.startsWith("postgresql")) {
                    database = new DatabasePostgreSql();
                } else if (string.indexOf("derby") != -1) {
                    database = new DatabaseCloudscape();
                } else if (string.startsWith("sunopsis")) {
                    database = new DatabaseSunopsis();
                } else if (string.startsWith("interbase")) {
                    database = new DatabaseInterbase();
                } else if (string.startsWith("excel")) {
                    database = new DatabaseExcel();
                } else if (string.startsWith("smallsql")) {
                    database = new DatabaseSmallSQL();
                } else if (string.startsWith("hsql")) {
                    database = new DatabaseHSQL();
                } else if (string.startsWith("openedge")) {
                    database = new DatabaseOpenEdge();
                }
                if (database != null) break block46;
                boolean bl2 = false;
                try {
                    bl2 = con.getMetaData().usesLocalFilePerTable();
                }
                catch (Exception exception) {
                    BaseUtils.printStackTrace(exception);
                }
                if (bl2) {
                    database = new DatabaseCSV();
                    BaseUtils.info("UseLocalFilePerTable: " + bl2);
                }
            }
            catch (Exception exception) {
                BaseUtils.printStackTrace(exception);
            }
        }
        if (database == null) {
            database = new Database();
            BaseUtils.info("No database class defined for database product:" + string);
        }
        return database;
    }
}

