/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config;

import com.inet.annotations.PublicApi;
import com.inet.config.ConfigKeyParser;
import com.inet.config.LicenseInfo;
import com.inet.config.LicenseManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import java.util.Objects;
import javax.annotation.Nonnull;

@PublicApi
public final class LicenseKeyInfo {
    private static LicenseKeyInfo ZY;
    private LicenseInfo ZZ;

    public LicenseKeyInfo(String licenseKey) {
        if (licenseKey == null) {
            this.ZZ = ConfigKeyParser.getCurrent();
            return;
        }
        this.ZZ = new ConfigKeyParser().getLicenseInfo(licenseKey).getCurrent();
    }

    LicenseKeyInfo(@Nonnull LicenseInfo license) {
        Objects.requireNonNull(license);
        this.ZZ = license;
    }

    @Nonnull
    public static final LicenseKeyInfo getCurrent() {
        if (ZY == null) {
            try {
                if (ZY == null && ServerPluginManager.getInstance().getState() != ServerPluginManager.ServerPluginManagerState.INIT) {
                    Class.forName("com.inet.report.Engine").getConstructor(String.class).newInstance("java");
                }
            }
            catch (Throwable throwable) {
                BaseUtils.error(throwable);
            }
            ZY = new LicenseKeyInfo(ConfigKeyParser.getCurrent());
        }
        return ZY;
    }

    public final boolean isPlus() {
        return this.ZZ.isValid() && Boolean.parseBoolean((String)this.ZZ.getAttributes().get("crplus"));
    }

    public final String getLicenseText() {
        return this.ZZ.getDisplayName();
    }

    public final String getLicensee() {
        return this.ZZ.getLicensee();
    }

    public final boolean isValid() {
        return this.ZZ.isValid();
    }

    public final String getErrorMessage() {
        return this.ZZ.getErrorMessage();
    }

    public final boolean hasExpiredDate() {
        return this.ZZ.hasExpiredDate();
    }

    public final String getWaterMark() {
        return (String)this.ZZ.getAttributes().get("watermark");
    }

    public final boolean isSite() {
        return this.ZZ.isValid() && this.ZZ.getAttributes().get("ip") == null;
    }

    public final LicenseInfo getLicenseInfo() {
        return this.ZZ;
    }

    static {
        LicenseManager.getInstance().addLicenseListener(licenseInfo -> {
            ZY = new LicenseKeyInfo(licenseInfo);
        });
    }
}

